/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.company.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.global.company.CompanyServiceApi;
import com.xforceplus.api.model.CompanyModel;
import com.xforceplus.api.model.CompanyServiceRelModel;
import com.xforceplus.api.model.CompnayResourceSetModel;
import com.xforceplus.api.model.OrgModel;
import com.xforceplus.api.model.ServicePackageModel;
import com.xforceplus.business.company.service.CompanyServicePackageService;
import com.xforceplus.business.excel.ExcelService;
import com.xforceplus.business.excel.QueryParam;
import com.xforceplus.business.excel.writer.ExcelConfigBusinessType;
import com.xforceplus.business.file.controller.vo.ImportFileRespVo;
import com.xforceplus.business.file.service.ExportFileService;
import com.xforceplus.business.file.service.FileService;
import com.xforceplus.business.file.service.ImportFileService;
import com.xforceplus.business.resource.service.ServicePackageService;
import com.xforceplus.business.tenant.service.OrgService;
import com.xforceplus.domain.company.CompanyPackageExportDto;
import com.xforceplus.entity.ExcelFileStore;
import com.xforceplus.entity.OrgStruct;
import com.xforceplus.entity.ServicePackage;
import com.xforceplus.tenant.core.exception.UnknownException;
import com.xforceplus.tenant.security.autoscan.annotation.AuthorizedDefinition;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import io.geewit.core.jackson.view.View;
import io.geewit.web.utils.JsonUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Api(value="\u516c\u53f8\u670d\u52a1\u5305\u76f8\u5173\u63a5\u53e3", description="\u516c\u53f8\u670d\u52a1\u5305\u76f8\u5173\u63a5\u53e3")
@Controller
public class CompanyServiceController
implements CompanyServiceApi {
    private final CompanyServicePackageService companyServicePackageService;
    private final OrgService orgService;
    private final ServicePackageService servicePackageService;
    private final ExcelService excelService;
    private final FileService fileService;
    private final ImportFileService importFileService;
    private final ExportFileService exportFileService;
    Logger logger = LoggerFactory.getLogger(CompanyServiceController.class);

    public CompanyServiceController(CompanyServicePackageService companyServicePackageService, OrgService orgService, ServicePackageService servicePackageService, ExcelService excelService, FileService fileService, ImportFileService importFileService, ExportFileService exportFileService) {
        this.companyServicePackageService = companyServicePackageService;
        this.orgService = orgService;
        this.servicePackageService = servicePackageService;
        this.excelService = excelService;
        this.fileService = fileService;
        this.importFileService = importFileService;
        this.exportFileService = exportFileService;
    }

    @AuthorizedDefinition(resources={"xforce:business:company-service-package:save"})
    @ApiOperation(value="\u7ed1\u5b9a\u516c\u53f8\u548c\u670d\u52a1\u53052.0-7", notes="\u5982\u679c\u670d\u52a1\u5305\u4e0d\u5b58\u5728\u5c31\u7528\u529f\u80fd\u96c6\u5408\u521b\u5efa\u670d\u52a1\u5305")
    @JsonView(value={View.Page.class})
    public ResponseEntity<String> bindCompanyResourceSet(List<CompnayResourceSetModel.Request.CompanyPackageBind> companyPackageBindRequest) {
        this.companyServicePackageService.createServicePackageAndBindCompanyFromResourceSet(companyPackageBindRequest);
        return ResponseEntity.ok((Object)"\u7ed1\u5b9a\u6210\u529f");
    }

    @AuthorizedDefinition(resources={"xforce:business:company-service-package:save"})
    @ApiOperation(value="\u516c\u53f8\u7ed1\u5b9a\u670d\u52a1\u5305")
    @JsonView(value={View.Page.class})
    public ResponseEntity<String> bindPackages(Long tenantId, CompanyModel.Request.BindTaxNumAndPackage bindPackage) {
        this.companyServicePackageService.bindCompanyAndPackage(tenantId, bindPackage);
        return ResponseEntity.ok((Object)"\u7ed1\u5b9a\u6210\u529f");
    }

    @AuthorizedDefinition(resources={"xforce:business:company-service-package:save"})
    @ApiOperation(value="\u516c\u53f8\u7ed1\u5b9a\u670d\u52a1\u5305")
    public ResponseEntity<String> bindCompanyPackages(CompanyModel.Request.BindCompanyPackages bindCompanyPackages) {
        this.logger.info("bindCompanyPackages==={}", (Object)JsonUtils.toJson((Object)bindCompanyPackages));
        if (bindCompanyPackages.getCompanyId() == null && CollectionUtils.isEmpty((Collection)bindCompanyPackages.getCompanyIds())) {
            throw new IllegalArgumentException("\u516c\u53f8id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.companyServicePackageService.bindCompanyPackages(bindCompanyPackages);
        return ResponseEntity.ok((Object)"\u7ed1\u5b9a\u6210\u529f");
    }

    @AuthorizedDefinition(resources={"xforce:business:company-service-package:read"})
    @ApiOperation(value="\u83b7\u53d6\u516c\u53f8\u670d\u52a1\u5305\u8be6\u60c5")
    public ResponseEntity<CompanyModel.Request.CompanyPackageDetail> info(long tenantId, long companyId) {
        OrgModel.Request.Query orgQuery = new OrgModel.Request.Query();
        orgQuery.setTenantId(Long.valueOf(tenantId));
        orgQuery.setCompanyId(Long.valueOf(companyId));
        OrgStruct org = this.orgService.findOne(orgQuery).orElseThrow(() -> new IllegalArgumentException("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u7ec4\u7ec7\u4fe1\u606f"));
        ServicePackageModel.Request.Query packageQuery = new ServicePackageModel.Request.Query();
        packageQuery.setTenantId(Long.valueOf(tenantId));
        packageQuery.setCompanyId(Long.valueOf(companyId));
        packageQuery.setWithExtendParams("resourcesets");
        List<ServicePackage> packages = this.servicePackageService.list(packageQuery, Sort.unsorted());
        CompanyModel.Request.CompanyPackageDetail companyPackageDetail = new CompanyModel.Request.CompanyPackageDetail();
        companyPackageDetail.setCompanyId(companyId);
        companyPackageDetail.setCompanyName(org.getCompanyName());
        companyPackageDetail.setTenantId(tenantId);
        companyPackageDetail.setTenantName(org.getTenantName());
        companyPackageDetail.setPackages(packages);
        return ResponseEntity.ok((Object)companyPackageDetail);
    }

    @AuthorizedDefinition(resources={"xforce:business:company-service-package:save"})
    @ApiOperation(value="\u4fee\u6539\u516c\u53f8\u670d\u52a1\u5305\u72b6\u6001")
    public ResponseEntity<String> changeCompanyServiceStatus(Long companyId, Long tenantId, CompanyModel.Request.ChangeCompanyPackageStatus changePackageStatus) {
        this.companyServicePackageService.changeCompanyServiceStatus(tenantId, companyId, changePackageStatus.getServicePackageIds(), changePackageStatus.getStatus(), changePackageStatus.getOperateReason());
        return ResponseEntity.ok((Object)"\u4fee\u6539\u6210\u529f");
    }

    @AuthorizedDefinition(resources={"xforce:business:company-service-package:save"})
    @ApiOperation(value="\u6839\u636e\u79df\u6237id\u548c\u516c\u53f8id\u6279\u91cf\u4fee\u6539\u516c\u53f8\u670d\u52a1\u5305\u72b6\u6001")
    public ResponseEntity<String> changeStatus(CompanyModel.Request.ChangePackageStatus changePackageStatus) {
        this.companyServicePackageService.changeStatusByTenantIdAndCompanyId(changePackageStatus.getTenantId(), changePackageStatus.getCompanyId(), changePackageStatus.getStatus(), changePackageStatus.getOperateReason());
        return ResponseEntity.ok((Object)"\u4fee\u6539\u6210\u529f");
    }

    @ResponseBody
    @ApiOperation(value="\u89e3\u7ed1\u516c\u53f8\u670d\u52a1\u5305")
    public ResponseEntity<String> delete(long id) {
        this.companyServicePackageService.unbindCompanyPackages(id);
        return ResponseEntity.ok((Object)"\u89e3\u7ed1\u6210\u529f");
    }

    @ResponseBody
    @ApiOperation(value="\u5220\u9664\u516c\u53f8\u670d\u52a1\u5305")
    public ResponseEntity<String> deleteByCompanyIdAndTenantId(Long companyId, Long tenantId) {
        this.companyServicePackageService.deleteByCompanyIdAndTenantId(companyId, tenantId);
        return ResponseEntity.ok();
    }

    @AuthorizedDefinition(resources={"xforce:business:company-service-package:save"})
    @ApiOperation(value="\u5bfc\u5165\u516c\u53f8\u670d\u52a1\u5305excel")
    @RequestMapping(name="\u5bfc\u5165\u516c\u53f8\u670d\u52a1\u5305excel", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/companies/packages/import"}, produces={"application/json"}, method={RequestMethod.POST})
    @ResponseBody
    @Deprecated
    public ResponseEntity batchImport(@RequestParam(value="file") MultipartFile file) {
        return this.excelService.batchImportCompanyPackages(file);
    }

    @AuthorizedDefinition(resources={"xforce:business:company-service-package:read"})
    @Deprecated
    public ResponseEntity export(@RequestBody CompanyServiceRelModel.Request.CompanyPackageExport export) {
        Long fileId;
        if (CollectionUtils.isEmpty((Collection)export.getCompanyIds())) {
            throw new UnknownException("\u672a\u9009\u62e9\u516c\u53f8");
        }
        if (CollectionUtils.isEmpty((Collection)export.getTenantIds())) {
            throw new UnknownException("\u672a\u9009\u62e9\u79df\u6237");
        }
        List<CompanyPackageExportDto> companyPackageExportDtos = this.companyServicePackageService.getExportData(export.getCompanyIds(), export.getTenantIds());
        if (CollectionUtils.isEmpty(companyPackageExportDtos)) {
            throw new UnknownException("\u5bfc\u51fa\u5931\u8d25\uff0c\u6ca1\u6709\u83b7\u53d6\u5230\u516c\u53f8");
        }
        LinkedHashMap<String, String> rules = new LinkedHashMap<String, String>();
        rules.put("tenantCode", "\u79df\u6237\u4ee3\u7801");
        rules.put("taxNum", "\u516c\u53f8\u7a0e\u53f7");
        rules.put("packageCodes", "\u4ea7\u54c1\u670d\u52a1\u5305\u4ee3\u7801");
        rules.put("statusName", "\u72b6\u6001");
        try {
            String json = JSON.toJSONString(companyPackageExportDtos, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
            fileId = this.fileService.exportDataExcel(json, rules, "\u516c\u53f8\u670d\u52a1\u5305\u5bfc\u51fa\u5217\u8868");
        }
        catch (Exception e) {
            this.logger.error("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            throw new UnknownException("\u516c\u53f8\u670d\u52a1\u5305\u5bfc\u51fa\u5931\u8d25");
        }
        return ResponseEntity.ok((Object)fileId);
    }

    @AuthorizedDefinition(resources={"xforce:business:company-service-package:read"})
    @ApiOperation(value="\u516c\u53f8\u670d\u52a1\u5305\u6279\u91cf\u5f02\u6b65\u5bfc\u51fa", notes="\u516c\u53f8\u670d\u52a1\u5305\u6279\u91cf\u5f02\u6b65\u5bfc\u51fa")
    public ResponseEntity batchAsyncExport(@RequestBody CompanyServiceRelModel.Request.CompanyPackageExport export) {
        if (ArrayUtils.isEmpty((Object[])export.getSheets())) {
            throw new UnknownException("\u8bf7\u9009\u62e9SheetName");
        }
        if (CollectionUtils.isEmpty((Collection)export.getCompanyIds())) {
            throw new UnknownException("\u672a\u9009\u62e9\u516c\u53f8");
        }
        if (CollectionUtils.isEmpty((Collection)export.getTenantIds())) {
            throw new UnknownException("\u672a\u9009\u62e9\u79df\u6237");
        }
        QueryParam queryParam = QueryParam.builder().param("P_QUERY", export).build();
        ExcelConfigBusinessType businessType = ExcelConfigBusinessType.COMPANY_PACKAGE_IMPORT;
        ExcelFileStore excelFileStore = this.exportFileService.asyncExcelExport(queryParam.params(), businessType);
        ImportFileRespVo respVo = new ImportFileRespVo();
        respVo.setId(excelFileStore.getId());
        respVo.setBusinessType(businessType.getBusinessName());
        return ResponseEntity.ok((Object)respVo);
    }

    @AuthorizedDefinition(resources={"xforce:business:company-service-package:read"})
    @ApiOperation(value="\u516c\u53f8\u670d\u52a1\u5305\u6279\u91cf\u5bfc\u5165\u4e0a\u4f20")
    @ResponseBody
    @RequestMapping(name="\u516c\u53f8\u670d\u52a1\u5305\u6279\u91cf\u5bfc\u5165\u4e0a\u4f20", value={"/api/global/companypackage/file/excel"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<ImportFileRespVo> uploadExcelFile(@RequestParam(value="file") MultipartFile file) {
        Long tenantId = 0L;
        Long userId = 0L;
        if (null != UserInfoHolder.get()) {
            tenantId = UserInfoHolder.get().getTenantId();
            userId = UserInfoHolder.get().getId();
        }
        String businessTypeName = ExcelConfigBusinessType.COMPANY_PACKAGE_IMPORT.name();
        ExcelFileStore excelFileStore = this.importFileService.createAndSaveFile(file, businessTypeName, userId, tenantId);
        ImportFileRespVo respVo = new ImportFileRespVo();
        respVo.setBusinessType(businessTypeName);
        respVo.setFileId(excelFileStore.getSourceFileId());
        respVo.setId(excelFileStore.getId());
        return ResponseEntity.ok((Object)respVo);
    }
}

