/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.company.controller;

import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.current.company.CompanyTenantRelOperationApi;
import com.xforceplus.api.model.CompanyTenantRelOperationModel;
import com.xforceplus.business.company.service.CompanyTenantRelOperationProcess;
import com.xforceplus.business.company.service.CompanyTenantRelOperationService;
import com.xforceplus.domain.company.CompanyTenantRelOperationDto;
import com.xforceplus.entity.CompanyTenantRelOperation;
import com.xforceplus.tenant.security.autoscan.annotation.AuthorizedDefinition;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import io.geewit.data.jpa.essential.domain.PageableFactory;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Controller;
import org.springframework.validation.annotation.Validated;

@Api(value="\u516c\u53f8\u79df\u6237\u5173\u8054\u9080\u8bf7\u76f8\u5173\u63a5\u53e3", description="\u516c\u53f8\u79df\u6237\u5173\u8054\u9080\u8bf7\u76f8\u5173\u63a5\u53e3")
@Validated
@Controller
public class CompanyTenantRelOperationController
implements CompanyTenantRelOperationApi {
    private static final Logger logger = LoggerFactory.getLogger(CompanyTenantRelOperationController.class);
    private static final Set<String> WITH_EXTEND_PARAM_SET = Stream.of("hostTenantName").collect(Collectors.toSet());
    private final CompanyTenantRelOperationService operationService;
    @Autowired
    private CompanyTenantRelOperationProcess operationProcess;

    public CompanyTenantRelOperationController(CompanyTenantRelOperationService operationService) {
        this.operationService = operationService;
    }

    @ApiOperation(value="\u53d1\u8d77\u9080\u8bf7\u516c\u53f8\u79df\u6237\u5173\u8054")
    @AuthorizedDefinition(resources={"xforce:ucenter:multitanent:relationship:save"})
    public ResponseEntity<CompanyTenantRelOperation> invite(CompanyTenantRelOperationModel.Request.Invitation model) {
        CompanyTenantRelOperation result = this.operationService.invite(model);
        return ResponseEntity.ok((Object)result);
    }

    @ApiOperation(value="\u6211\u9080\u8bf7\u7684\u516c\u53f8\u79df\u6237\u5173\u8054\u9080\u8bf7\u5206\u9875\u5217\u8868")
    @AuthorizedDefinition(resources={"xforce:ucenter:multitanent:read"})
    public ResponseEntity<Page<CompanyTenantRelOperation>> invitedPage(CompanyTenantRelOperationModel.Request.Query query, Pageable pageable) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        Pageable currentPageable = PageableFactory.ofDefaultSort((Pageable)pageable, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}));
        query.setTenantId(authorizedUser.getTenantId());
        query.setOperationType(Integer.valueOf(0));
        if (StringUtils.isNotBlank((CharSequence)query.getWithExtendParams())) {
            Set withExtendParamSet = Stream.of(StringUtils.split((String)query.getWithExtendParams(), (String)",")).collect(Collectors.toSet());
            withExtendParamSet.addAll(withExtendParamSet);
            query.setWithExtendParamSet(withExtendParamSet);
        } else {
            query.setWithExtendParamSet(WITH_EXTEND_PARAM_SET);
        }
        Page<CompanyTenantRelOperation> page = this.operationService.page(query, currentPageable);
        return ResponseEntity.ok(page);
    }

    @ApiOperation(value="\u88ab\u53d6\u6d88\u7684\u6388\u6743\u5206\u9875\u5217\u8868")
    @AuthorizedDefinition(resources={"xforce:ucenter:multitanent:read"})
    public ResponseEntity<Page<CompanyTenantRelOperation>> myCanceledPage(CompanyTenantRelOperationModel.Request.Query query, Pageable pageable) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        Pageable currentPageable = PageableFactory.ofDefaultSort((Pageable)pageable, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}));
        query.setTenantId(authorizedUser.getTenantId());
        query.setOperationType(Integer.valueOf(1));
        if (StringUtils.isNotBlank((CharSequence)query.getWithExtendParams())) {
            Set withExtendParamSet = Stream.of(StringUtils.split((String)query.getWithExtendParams(), (String)",")).collect(Collectors.toSet());
            withExtendParamSet.addAll(withExtendParamSet);
            query.setWithExtendParamSet(withExtendParamSet);
        } else {
            query.setWithExtendParamSet(WITH_EXTEND_PARAM_SET);
        }
        Page<CompanyTenantRelOperation> page = this.operationService.page(query, currentPageable);
        return ResponseEntity.ok(page);
    }

    @ApiOperation(value="\u88ab\u53d6\u6d88\u7684\u5173\u8054\u5206\u9875\u5217\u8868")
    @AuthorizedDefinition(resources={"xforce:ucenter:multitanent:read"})
    public ResponseEntity<Page<CompanyTenantRelOperation>> canceledPage(CompanyTenantRelOperationModel.Request.Query query, Pageable pageable) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        Pageable currentPageable = PageableFactory.ofDefaultSort((Pageable)pageable, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}));
        query.setRelatedTenantId(authorizedUser.getTenantId());
        query.setOperationType(Integer.valueOf(1));
        if (StringUtils.isNotBlank((CharSequence)query.getWithExtendParams())) {
            Set withExtendParamSet = Stream.of(StringUtils.split((String)query.getWithExtendParams(), (String)",")).collect(Collectors.toSet());
            withExtendParamSet.addAll(withExtendParamSet);
            query.setWithExtendParamSet(withExtendParamSet);
        } else {
            query.setWithExtendParamSet(WITH_EXTEND_PARAM_SET);
        }
        Page<CompanyTenantRelOperation> page = this.operationService.page(query, currentPageable);
        return ResponseEntity.ok(page);
    }

    @ApiOperation(value="\u5f85\u5904\u7406\u7684\u516c\u53f8\u79df\u6237\u5173\u8054\u9080\u8bf7\u5206\u9875\u5217\u8868")
    @AuthorizedDefinition(resources={"xforce:ucenter:multitanent:read"})
    public ResponseEntity<Page<CompanyTenantRelOperation>> processingPage(CompanyTenantRelOperationModel.Request.Query query, Pageable pageable) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        query.setRelatedTenantId(authorizedUser.getTenantId());
        if (StringUtils.isNotBlank((CharSequence)query.getWithExtendParams())) {
            Set withExtendParamSet = Stream.of(StringUtils.split((String)query.getWithExtendParams(), (String)",")).collect(Collectors.toSet());
            withExtendParamSet.addAll(withExtendParamSet);
            query.setWithExtendParamSet(withExtendParamSet);
        } else {
            query.setWithExtendParamSet(WITH_EXTEND_PARAM_SET);
        }
        query.setOperationType(Integer.valueOf(0));
        query.setWithoutStatus(Integer.valueOf(CompanyTenantRelOperationDto.Status.CANCELED.value()));
        Pageable currentPageable = PageableFactory.ofDefaultSort((Pageable)pageable, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}));
        Page<CompanyTenantRelOperation> page = this.operationService.page(query, currentPageable);
        return ResponseEntity.ok(page);
    }

    @ApiOperation(value="\u516c\u53f8\u79df\u6237\u5173\u8054\u9080\u8bf7\u4fe1\u606f")
    @AuthorizedDefinition(resources={"xforce:ucenter:multitanent:read"})
    public ResponseEntity<CompanyTenantRelOperation> info(long operationId, String withExtendParams) {
        Set<String> withExtendParamSet;
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        if (StringUtils.isNotBlank((CharSequence)withExtendParams)) {
            withExtendParamSet = Stream.of(StringUtils.split((String)withExtendParams, (String)",")).collect(Collectors.toSet());
            withExtendParamSet.addAll(WITH_EXTEND_PARAM_SET);
        } else {
            withExtendParamSet = WITH_EXTEND_PARAM_SET;
        }
        CompanyTenantRelOperation result = this.operationService.findById(operationId, withExtendParamSet);
        if (!(authorizedUser.getTenantId().equals(result.getCreaterTenantId()) || authorizedUser.getTenantId().equals(result.getRelatedTenantId()) || authorizedUser.getTenantId().equals(result.getTenantId()))) {
            throw new IllegalArgumentException("\u5f53\u524d\u8d26\u6237\u6240\u5728\u79df\u6237\u6ca1\u6709\u67e5\u770b\u8be5\u8bb0\u5f55\u4fe1\u606f\u7684\u6743\u9650");
        }
        return ResponseEntity.ok((Object)result);
    }

    @ApiOperation(value="\u516c\u53f8\u79df\u6237\u5173\u8054\u9080\u8bf7\u63a5\u53d7")
    @AuthorizedDefinition(resources={"xforce:ucenter:multitanent:relationship:save"})
    public ResponseEntity<String> accept(long operationId, String remark) {
        this.operationProcess.accept(operationId, remark);
        return ResponseEntity.ok((Object)"\u9080\u8bf7\u63a5\u53d7\u6210\u529f");
    }

    @ApiOperation(value="\u516c\u53f8\u79df\u6237\u5173\u8054\u9080\u8bf7\u62d2\u7edd")
    @AuthorizedDefinition(resources={"xforce:ucenter:multitanent:relationship:save"})
    public ResponseEntity<String> refuse(long operationId, String remark) {
        this.operationProcess.refuse(operationId, remark);
        return ResponseEntity.ok((Object)"\u9080\u8bf7\u62d2\u7edd\u6210\u529f");
    }

    @ApiOperation(value="\u516c\u53f8\u79df\u6237\u5173\u8054\u9080\u8bf7\u64a4\u9500")
    @AuthorizedDefinition(resources={"xforce:ucenter:multitanent:relationship:save"})
    public ResponseEntity<String> cancel(long operationId) {
        this.operationService.cancel(operationId);
        return ResponseEntity.ok((Object)"\u9080\u8bf7\u64a4\u9500\u6210\u529f");
    }
}

