/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.company.service;

import com.xforceplus.api.model.CompanyApplyModel;
import com.xforceplus.api.model.CompanyModel;
import com.xforceplus.business.company.service.CompanyService;
import com.xforceplus.dao.CompanyApplyDao;
import com.xforceplus.dao.CompanyDao;
import com.xforceplus.dao.OrgStructDao;
import com.xforceplus.dao.TenantDao;
import com.xforceplus.entity.Company;
import com.xforceplus.entity.CompanyApply;
import com.xforceplus.entity.Tenant;
import com.xforceplus.query.CompanyApplyQueryHelper;
import io.geewit.core.utils.reflection.BeanUtils;
import io.geewit.utils.uuid.UUID;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class CompanyApplyService {
    private static final Logger logger = LoggerFactory.getLogger(CompanyApplyService.class);
    private final CompanyApplyDao companyApplyDao;
    private final OrgStructDao orgStructDao;
    private final CompanyDao companyDao;
    private final CompanyService companyService;
    private final TenantDao tenantDao;

    public CompanyApplyService(CompanyApplyDao companyApplyDao, OrgStructDao orgStructDao, CompanyDao companyDao, CompanyService companyService, TenantDao tenantDao) {
        this.companyApplyDao = companyApplyDao;
        this.orgStructDao = orgStructDao;
        this.companyDao = companyDao;
        this.companyService = companyService;
        this.tenantDao = tenantDao;
    }

    public CompanyApply apply(long tenantId, long orgId, CompanyModel.Request.Save model) {
        CompanyApply entity = new CompanyApply();
        BeanUtils.copyProperties((Object)model, (Object)entity, null, (String[])((String[])Stream.of("cquota", "squota", "ceQuota", "juQuota", "seQuota", "vehicleLimit").toArray(String[]::new)));
        if (model.getHostTenantId() != null && model.getHostTenantId() > 0L) {
            entity.setTenantId(model.getHostTenantId());
            entity.setHostTenantId(model.getHostTenantId());
        } else {
            entity.setTenantId(Long.valueOf(tenantId));
            entity.setHostTenantId(Long.valueOf(tenantId));
        }
        entity.setOrgStructId(Long.valueOf(orgId));
        return (CompanyApply)this.companyApplyDao.saveAndFlush((Object)entity);
    }

    public Page<CompanyApply> page(CompanyApplyModel.Request.Query query, Pageable pageable) {
        Specification specification = CompanyApplyQueryHelper.querySpecification((CompanyApplyModel.Request.Query)query);
        Page page = this.companyApplyDao.findAll(specification, pageable);
        return page;
    }

    public Page<CompanyApply> page(Specification<CompanyApply> specification, Pageable pageable) {
        return this.companyApplyDao.findAll(specification, pageable);
    }

    public List<CompanyApply> list(CompanyApplyModel.Request.Query query, Sort sort) {
        Specification specification = CompanyApplyQueryHelper.querySpecification((CompanyApplyModel.Request.Query)query);
        List list = this.companyApplyDao.findAll(specification, sort);
        return list;
    }

    public List<CompanyApply> list(Specification<CompanyApply> specification, Sort sort) {
        return this.companyApplyDao.findAll(specification, sort);
    }

    public CompanyApply findById(long applyId) {
        return (CompanyApply)this.companyApplyDao.findById((Object)applyId).orElseThrow(() -> new IllegalArgumentException("\u672a\u627e\u5230\u516c\u53f8\u7533\u8bf7\u5b9e\u4f53"));
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateStatus(long applicationId, int status) {
        CompanyApply existEntity = this.findById(applicationId);
        existEntity.setStatus(Integer.valueOf(status));
        this.companyApplyDao.saveAndFlush((Object)existEntity);
    }

    public Company initCompany(CompanyApply companyApply, String[] ignoreProperties, String reason, int status) {
        Company company = new Company();
        BeanUtils.copyProperties((Object)companyApply, (Object)company, (String[])ignoreProperties, (String[])((String[])Stream.of("cquota", "squota", "ceQuota", "juQuota", "seQuota", "vehicleLimit").toArray(String[]::new)));
        BeanUtils.copyProperties((Object)companyApply, (Object)company);
        company.setOperateReason(reason);
        if (StringUtils.isBlank((CharSequence)company.getCompanyCode())) {
            String companyCode = UUID.randomUUID().toString();
            company.setCompanyCode(companyCode);
        }
        company.setStatus(Integer.valueOf(status));
        return company;
    }

    @Transactional(rollbackFor={Exception.class})
    public void approve(long applicationId, String reason) {
        Company company;
        CompanyApply companyApply = this.findById(applicationId);
        Long orgId = companyApply.getOrgStructId();
        if (orgId == null || orgId <= 0L) {
            throw new IllegalArgumentException("\u5ba1\u6838\u4fe1\u606f\u4e2d\u7684\u7ec4\u7ec7id\u4e0d\u80fd\u7a7a");
        }
        Long tenantId = companyApply.getTenantId();
        if (tenantId == null || tenantId <= 0L) {
            throw new IllegalArgumentException("\u5ba1\u6838\u4fe1\u606f\u4e2d\u7684\u79df\u6237id\u4e0d\u80fd\u7a7a");
        }
        Tenant tenant = (Tenant)this.tenantDao.findById((Object)tenantId).orElseThrow(() -> new IllegalArgumentException("\u9519\u8bef\u7684\u79df\u6237id(" + tenantId + ")"));
        List existCompanies = this.companyDao.findByTaxNum(companyApply.getTaxNum());
        if (!existCompanies.isEmpty()) {
            company = (Company)existCompanies.stream().findFirst().get();
        } else {
            company = this.initCompany(companyApply, null, reason, 1);
            company.setHostTenantId(tenantId);
            company = (Company)this.companyDao.saveAndFlush((Object)company);
        }
        this.orgStructDao.approve(orgId.longValue(), company.getCompanyId().longValue(), 1, 1);
        this.companyService.saveTenantCompany(tenant, company);
        this.companyApplyDao.deleteById(Long.valueOf(applicationId));
        List companyApplies = this.companyApplyDao.findByTaxNum(company.getTaxNum());
        if (!companyApplies.isEmpty()) {
            for (CompanyApply remainApply : companyApplies) {
                this.orgStructDao.approve(remainApply.getOrgStructId().longValue(), company.getCompanyId().longValue(), 1, 1);
                Tenant existTenant = (Tenant)this.tenantDao.findById((Object)remainApply.getTenantId()).get();
                Company comppany = new Company();
                company.setCompanyName(remainApply.getCompanyName());
                company.setCompanyCode(remainApply.getCompanyCode());
                company.setCompanyId(remainApply.getCompanyId());
                company.setTaxNum(remainApply.getTaxNum());
                this.companyService.saveTenantCompany(existTenant, comppany);
                this.companyApplyDao.deleteById(remainApply.getCompanyApplyId());
            }
        }
    }

    public void isCompanyExists(String companyCode, String taxNum) {
        if (this.companyDao.validateExistCompany(companyCode, taxNum) > 0L) {
            throw new IllegalArgumentException("\u5df2\u7ecf\u6709\u91cd\u590d\u7684\u7a0e\u53f7\u6216\u4ee3\u7801");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void decline(long applicationId, String reason) {
        CompanyApply existEntity = this.findById(applicationId);
        this.companyApplyDao.deleteById(existEntity.getCompanyApplyId());
        if (existEntity.getOrgStructId() != null && existEntity.getOrgStructId() > 0L) {
            this.orgStructDao.deleteById(existEntity.getOrgStructId());
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public CompanyApplyModel.Response.ApplicationProcessResult approve(CompanyApplyModel.Request.ApplicationProcess applicationProcess) {
        return this.processApplications(applicationProcess, 3);
    }

    @Transactional(rollbackFor={Exception.class})
    public CompanyApplyModel.Response.ApplicationProcessResult decline(CompanyApplyModel.Request.ApplicationProcess applicationProcess) {
        return this.processApplications(applicationProcess, 2);
    }

    private CompanyApplyModel.Response.ApplicationProcessResult processApplications(CompanyApplyModel.Request.ApplicationProcess applicationProcess, int status) {
        List applicationIds = applicationProcess.getApplicationIds();
        List existEntities = this.companyApplyDao.findAllById((Iterable)applicationIds);
        int total = applicationIds.size();
        int success = 0;
        for (CompanyApply existEntity : existEntities) {
            if (existEntity.getStatus() != null && existEntity.getStatus() == status) continue;
            existEntity.setStatus(Integer.valueOf(status));
            existEntity.setOperateReason(applicationProcess.getReason());
            try {
                block11: {
                    if (status == 3) {
                        Company company;
                        Long tenantId;
                        Long orgId = existEntity.getOrgStructId();
                        if (orgId == null || orgId <= 0L || (tenantId = existEntity.getTenantId()) == null || tenantId <= 0L) continue;
                        List existCompanies = this.companyDao.findByTaxNum(existEntity.getTaxNum());
                        if (!existCompanies.isEmpty()) {
                            company = (Company)existCompanies.stream().findFirst().get();
                        } else {
                            company = this.initCompany(existEntity, (String[])Stream.of("orgs", "companyNos", "hostTenant", "tenantRels").toArray(String[]::new), applicationProcess.getReason(), 1);
                            company.setHostTenantId(tenantId);
                            company = (Company)this.companyDao.saveAndFlush((Object)company);
                        }
                        try {
                            this.orgStructDao.approve(orgId.longValue(), company.getCompanyId().longValue(), 1, 1);
                            Tenant tenant = (Tenant)this.tenantDao.findById((Object)existEntity.getTenantId()).orElseThrow(() -> new IllegalArgumentException("\u9519\u8bef\u7684\u79df\u6237id(" + existEntity.getTenantId() + ")"));
                            this.companyService.saveTenantCompany(tenant, company);
                            this.companyApplyDao.deleteById(existEntity.getCompanyApplyId());
                            break block11;
                        }
                        catch (Exception e) {
                            logger.warn(e.getMessage(), (Throwable)e);
                            continue;
                        }
                    }
                    if (status == 2 && existEntity.getOrgStructId() != null && existEntity.getOrgStructId() > 0L) {
                        this.orgStructDao.deleteById(existEntity.getOrgStructId());
                    }
                }
                try {
                    this.companyApplyDao.deleteById(existEntity.getCompanyApplyId());
                }
                catch (Exception e) {
                    logger.warn(e.getMessage(), (Throwable)e);
                }
                ++success;
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
        }
        int fail = total - success;
        CompanyApplyModel.Response.ApplicationProcessResult result = new CompanyApplyModel.Response.ApplicationProcessResult();
        result.setSuccess(success);
        result.setFail(fail);
        return result;
    }

    public Optional<CompanyApply> findByTenantIdAndTaxNum(long tenantId, String taxNum) {
        List companyApplyList = this.companyApplyDao.findByTenantIdAndTaxNum(tenantId, taxNum);
        if (CollectionUtils.isEmpty((Collection)companyApplyList)) {
            return Optional.empty();
        }
        return Optional.of(companyApplyList.get(0));
    }
}

