/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.company.service;

import com.xforceplus.api.model.CompanyExtensionModel;
import com.xforceplus.api.model.CompanyModel;
import com.xforceplus.constants.ExtensionStatus;
import com.xforceplus.dao.CompanyDao;
import com.xforceplus.dao.CompanyExtensionDao;
import com.xforceplus.domain.company.CompanyExtensionDto;
import com.xforceplus.entity.CompanyExtension;
import io.geewit.core.utils.reflection.BeanUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.annotation.Validated;

@Validated
@Service
public class CompanyExtensionService {
    private static final Logger log = LoggerFactory.getLogger(CompanyExtensionService.class);
    private static final Logger logger = LoggerFactory.getLogger(CompanyExtensionService.class);
    private static final String AUTH_SWITCH_KEY = "terminal_";
    private static final Integer AUTH_SWITCH_ENABLED = 1;
    @Resource
    private CompanyExtensionDao companyExtensionDao;
    @Resource
    private CompanyDao companyDao;

    private Specification<CompanyExtension> querySpecification(CompanyExtensionModel.Request.Query query, Integer status) {
        return (Specification & Serializable)(root, criteriaQuery, builder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (query.getCompanyId() != null && query.getCompanyId() > 0L) {
                predicates.add(builder.equal((Expression)root.get("companyId"), (Object)query.getCompanyId()));
            }
            if (StringUtils.isNotBlank((CharSequence)query.getExtensionKey())) {
                predicates.add(builder.equal((Expression)root.get("extensionKey"), (Object)query.getExtensionKey()));
            }
            if (StringUtils.isNotBlank((CharSequence)query.getExtensionValue())) {
                predicates.add(builder.equal((Expression)root.get("extensionValue"), (Object)query.getExtensionValue()));
            }
            if (status != null && status > 0) {
                predicates.add(builder.equal((Expression)root.get("status"), (Object)status));
            }
            if (!predicates.isEmpty()) {
                criteriaQuery.where((Predicate[])predicates.stream().toArray(Predicate[]::new));
            }
            return criteriaQuery.getRestriction();
        };
    }

    public Page<CompanyExtension> page(CompanyExtensionModel.Request.Query query, Pageable pageable) {
        Specification<CompanyExtension> specification = this.querySpecification(query, ExtensionStatus.ENABLE);
        return this.companyExtensionDao.findAll(specification, pageable);
    }

    public List<CompanyExtension> list(CompanyExtensionModel.Request.Query query, Sort sort) {
        Specification<CompanyExtension> specification = this.querySpecification(query, ExtensionStatus.ENABLE);
        return this.companyExtensionDao.findAll(specification, sort);
    }

    @Transactional(rollbackFor={Exception.class})
    public CompanyExtension save(CompanyExtensionDto companyExtensionDto) {
        List list = this.companyExtensionDao.findByCompanyIdAndKey(companyExtensionDto.getCompanyId().longValue(), companyExtensionDto.getExtensionKey());
        if (CollectionUtils.isEmpty((Collection)list)) {
            CompanyExtension entity = new CompanyExtension();
            BeanUtils.copyProperties((Object)companyExtensionDto, (Object)entity);
            entity.setStatus(ExtensionStatus.ENABLE);
            entity.setCreateTime(new Date());
            entity.setUpdateTime(new Date());
            return (CompanyExtension)this.companyExtensionDao.saveAndFlush((Object)entity);
        }
        CompanyExtension entity = (CompanyExtension)list.get(0);
        entity.setExtensionValue(companyExtensionDto.getExtensionValue());
        entity.setStatus(ExtensionStatus.ENABLE);
        entity.setUpdateTime(new Date());
        return (CompanyExtension)this.companyExtensionDao.saveAndFlush((Object)entity);
    }

    @Transactional(rollbackFor={Exception.class})
    public Set<CompanyExtension> batchSave(long companyId, List<CompanyModel.Request.Extension> extensions, boolean isOverwrite) {
        if (companyId <= 0L || CollectionUtils.isEmpty(extensions)) {
            return null;
        }
        List<CompanyExtension> existExtensions = this.findByComapnyId(companyId);
        Set<CompanyExtension> savingExtensions = extensions.stream().filter(Objects::nonNull).map(extension -> {
            CompanyExtension savingExtension;
            List exists = this.companyExtensionDao.findByCompanyIdAndKey(companyId, extension.getExtensionKey());
            if (CollectionUtils.isEmpty((Collection)exists)) {
                savingExtension = new CompanyExtension();
                savingExtension.setCompanyId(Long.valueOf(companyId));
                savingExtension.setExtensionKey(extension.getExtensionKey());
            } else {
                savingExtension = (CompanyExtension)exists.get(0);
            }
            savingExtension.setExtensionValue(extension.getExtensionValue());
            return savingExtension;
        }).collect(Collectors.toSet());
        if (!savingExtensions.isEmpty()) {
            savingExtensions.forEach(arg_0 -> ((CompanyExtensionDao)this.companyExtensionDao).saveAndFlush(arg_0));
        }
        HashSet<CompanyExtension> result = new HashSet<CompanyExtension>(savingExtensions);
        result.addAll(existExtensions);
        if (isOverwrite) {
            existExtensions.stream().filter(existExtension -> extensions.stream().noneMatch(extension -> extension.getExtensionKey().equals(existExtension.getExtensionKey()))).forEach(extension -> {
                logger.info("deleting CompanyExtension record, {}", extension);
                try {
                    this.companyExtensionDao.deleteById(extension.getCompanyExtensionId());
                }
                catch (Exception e) {
                    logger.warn(e.getMessage(), (Throwable)e);
                }
            });
        } else {
            result.addAll(existExtensions);
        }
        return result;
    }

    public List<CompanyExtension> findByComapnyId(long companyId) {
        CompanyExtensionModel.Request.Query query = new CompanyExtensionModel.Request.Query();
        query.setCompanyId(Long.valueOf(companyId));
        Specification<CompanyExtension> specification = this.querySpecification(query, null);
        return this.companyExtensionDao.findAll(specification, Sort.unsorted());
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteByCompanyId(long companyId) {
        this.companyExtensionDao.deleteByCompanyId(companyId);
    }

    @Transactional(rollbackFor={Exception.class})
    public Boolean setTerminalSwitch(Long tenantId, Long companyId, Integer terminalSwitch) {
        List<CompanyExtension> extensionList = this.findByComapnyId(companyId);
        String key = AUTH_SWITCH_KEY + tenantId;
        CompanyExtension companyExtension = new CompanyExtension();
        if (CollectionUtils.isEmpty(extensionList)) {
            companyExtension = this.buildCompanyExtention(companyId, tenantId, key, String.valueOf(terminalSwitch));
        } else {
            Optional<CompanyExtension> companyExtensionOptional = extensionList.stream().filter(item -> item.getExtensionKey().equals(key) && item.getStatus().equals(1)).findAny();
            if (companyExtensionOptional.isPresent()) {
                companyExtension = companyExtensionOptional.get();
                companyExtension.setExtensionValue(String.valueOf(terminalSwitch));
                companyExtension.setStatus(Integer.valueOf(1));
            } else {
                companyExtension = this.buildCompanyExtention(companyId, tenantId, key, String.valueOf(terminalSwitch));
            }
        }
        log.info("companyId {} tenantId {} \u7aef\u9274\u6743\u5f00\u5173\u53d8\u66f4\u4e3a{}", new Object[]{companyId, tenantId, terminalSwitch});
        this.companyExtensionDao.saveAndFlush((Object)companyExtension);
        return true;
    }

    @Transactional(rollbackFor={Exception.class})
    public Integer getCompanyTerminalSwitch(Long tenantId, Long companyId) {
        String key = AUTH_SWITCH_KEY + tenantId;
        List<CompanyExtension> extensionList = this.findByComapnyId(companyId);
        if (CollectionUtils.isEmpty(extensionList)) {
            this.addDefaultTerminalSwitch(companyId, tenantId, key, String.valueOf(AUTH_SWITCH_ENABLED));
            log.info("companyId {} tenantId {} \u6ca1\u6709\u516c\u53f8\u6269\u5c55\u4fe1\u606f\uff0c\u7cfb\u7edf\u9ed8\u8ba4\u6dfb\u52a0\u7ec8\u7aef\u9274\u6743\u5f00\u5173\u5e76\u8bbe\u7f6e\u4e3a\u5f00", (Object)companyId, (Object)tenantId);
            return AUTH_SWITCH_ENABLED;
        }
        Optional<CompanyExtension> companyExtensionOptional = extensionList.stream().filter(item -> item.getExtensionKey().equals(key) && item.getStatus().equals(1)).findAny();
        if (companyExtensionOptional.isPresent()) {
            return Integer.parseInt(companyExtensionOptional.get().getExtensionValue());
        }
        log.info("companyId {} tenantId {} \u6ca1\u6709\u8bbe\u7f6e\u7ec8\u7aef\u9274\u6743\u5f00\u5173\uff0c\u7cfb\u7edf\u9ed8\u8ba4\u6dfb\u52a0\u5f00\u5173\u5e76\u8bbe\u7f6e\u4e3a\u5f00", (Object)companyId, (Object)tenantId);
        this.addDefaultTerminalSwitch(companyId, tenantId, key, String.valueOf(AUTH_SWITCH_ENABLED));
        return AUTH_SWITCH_ENABLED;
    }

    private CompanyExtension buildCompanyExtention(Long companyId, Long tenantId, String key, String value) {
        CompanyExtension companyExtension = new CompanyExtension();
        companyExtension.setCompanyId(companyId);
        companyExtension.setExtensionKey(key);
        companyExtension.setExtensionValue(value);
        companyExtension.setStatus(ExtensionStatus.ENABLE);
        return companyExtension;
    }

    private void addDefaultTerminalSwitch(Long companyId, Long tenantId, String key, String value) {
        CompanyExtension companyExtension = this.buildCompanyExtention(companyId, tenantId, key, value);
        this.companyExtensionDao.saveAndFlush((Object)companyExtension);
    }

    public Boolean setTerminalAuthByTaxNum(String taxNum, Long tenantId, Integer terminalAuth) {
        Optional optionalLong = this.companyDao.findIdByTaxNum(taxNum);
        if (optionalLong.isPresent()) {
            Long companyId = (Long)optionalLong.get();
            List<CompanyExtension> extensionList = this.findByComapnyId(companyId);
            String key = AUTH_SWITCH_KEY + tenantId;
            Optional<CompanyExtension> companyExtensionOptional = extensionList.stream().filter(item -> item.getExtensionKey().equals(key) && item.getStatus().equals(1)).findFirst();
            CompanyExtension companyExtension = new CompanyExtension();
            if (companyExtensionOptional.isPresent()) {
                companyExtension = companyExtensionOptional.get();
                companyExtension.setExtensionValue(String.valueOf(terminalAuth));
            } else {
                companyExtension = this.buildCompanyExtention(companyId, tenantId, key, String.valueOf(terminalAuth));
            }
            this.companyExtensionDao.saveAndFlush((Object)companyExtension);
            return true;
        }
        logger.warn("\u7a0e\u53f7{}\u5bf9\u5e94\u7684\u516c\u53f8\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u8bbe\u7f6e\u7ec8\u7aef\u9274\u6743", (Object)taxNum);
        return false;
    }
}

