/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.company.service;

import com.xforceplus.api.model.CompanyTenantRelModel;
import com.xforceplus.business.company.service.CompanyService;
import com.xforceplus.business.company.service.CompanyTenantRelOperationService;
import com.xforceplus.dao.CompanyDao;
import com.xforceplus.dao.CompanyTenantRelDao;
import com.xforceplus.dao.OrgStructDao;
import com.xforceplus.dao.OrgUserRelDao;
import com.xforceplus.dao.TenantCompanyRelDao;
import com.xforceplus.entity.Company;
import com.xforceplus.entity.CompanyTenantRel;
import com.xforceplus.entity.OrgStruct;
import com.xforceplus.query.CompanyTenantRelQueryHelper;
import io.geewit.data.jpa.essential.domain.EntityGraphs;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class CompanyProcess {
    private final CompanyTenantRelOperationService companyTenantRelOperationService;
    private final CompanyService companyService;
    private final CompanyDao companyDao;
    private final OrgStructDao orgStructDao;
    private final CompanyTenantRelDao companyTenantRelDao;
    private final OrgUserRelDao orgUserRelDao;
    private final TenantCompanyRelDao tenantCompanyRelDao;

    public CompanyProcess(CompanyTenantRelOperationService companyTenantRelOperationService, CompanyService companyService, CompanyDao companyDao, OrgStructDao orgStructDao, CompanyTenantRelDao companyTenantRelDao, OrgUserRelDao orgUserRelDao, TenantCompanyRelDao tenantCompanyRelDao) {
        this.companyTenantRelOperationService = companyTenantRelOperationService;
        this.companyService = companyService;
        this.companyDao = companyDao;
        this.orgStructDao = orgStructDao;
        this.companyTenantRelDao = companyTenantRelDao;
        this.orgUserRelDao = orgUserRelDao;
        this.tenantCompanyRelDao = tenantCompanyRelDao;
    }

    @Transactional(rollbackFor={Exception.class})
    public void removeTenant(Long companyId, Long tenantId) {
        OrgStruct orgStruct;
        Company company = this.companyService.findById(companyId);
        List orgStructs = this.orgStructDao.findByCompanyId(companyId.longValue());
        if (CollectionUtils.isEmpty((Collection)orgStructs)) {
            throw new IllegalArgumentException("\u516c\u53f8\u6ca1\u6709\u5bf9\u5e94\u7684\u7ec4\u7ec7\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        if (orgStructs.stream().noneMatch(o -> o.getTenantId().equals(tenantId))) {
            throw new IllegalArgumentException("\u5f53\u524d\u516c\u53f8\u4e0e\u79df\u6237\u6ca1\u6709\u5efa\u7acb\u6240\u5c5e\u5173\u7cfb\uff01");
        }
        if (orgStructs.size() == 1) {
            orgStruct = (OrgStruct)orgStructs.get(0);
            company.setHostTenantId(null);
            this.companyDao.saveAndFlush((Object)company);
        } else {
            if (tenantId.equals(company.getHostTenantId())) {
                throw new IllegalArgumentException("\u516c\u53f8\u4e3a\u591a\u79df\u6237\uff0c\u4e0d\u80fd\u76f4\u63a5\u79fb\u9664\u4e0e\u201c\u6240\u5c5e\u79df\u6237\u201c\u7684\u5173\u7cfb\uff01");
            }
            orgStruct = orgStructs.stream().filter(o -> o.getTenantId().equals(tenantId)).findFirst().orElseThrow(() -> new IllegalArgumentException("\u6ca1\u6709\u6bd4\u914d\u79df\u6237id(" + tenantId + ")\u7684\u7ec4\u7ec7"));
        }
        List childes = this.orgStructDao.findChildesByParentId(orgStruct.getOrgId());
        if (!CollectionUtils.isEmpty((Collection)childes)) {
            throw new IllegalArgumentException("\u516c\u53f8\u5bf9\u5e94\u7684\u7ec4\u7ec7\u5b58\u5728\u5b50\u7ec4\u7ec7\uff0c\u8bf7\u5904\u7406\uff01");
        }
        List orgUserRels = this.orgUserRelDao.findByOrgId(orgStruct.getOrgId().longValue());
        if (!CollectionUtils.isEmpty((Collection)orgUserRels)) {
            throw new IllegalArgumentException("\u516c\u53f8\u5bf9\u5e94\u7684\u7ec4\u7ec7\u5b58\u5728\u5173\u8054\u4eba\u5458\uff0c\u8bf7\u5904\u7406\uff01");
        }
        CompanyTenantRelModel.Request.Query companyTenantRelQuery = new CompanyTenantRelModel.Request.Query();
        companyTenantRelQuery.setCompanyId(companyId);
        List companyTenantRels = this.companyTenantRelDao.findAll(CompanyTenantRelQueryHelper.querySpecification((CompanyTenantRelModel.Request.Query)companyTenantRelQuery), EntityGraphs.named((String)"CompanyTenantRel.graph"));
        Optional<CompanyTenantRel> optionalCompanyTenantRel = companyTenantRels.stream().filter(r -> r.getRelatedTenantId().equals(tenantId)).findFirst();
        if (optionalCompanyTenantRel.isPresent()) {
            this.companyTenantRelDao.deleteById(optionalCompanyTenantRel.get().getId());
            this.companyTenantRelOperationService.saveUnrelateOperation(company, optionalCompanyTenantRel.get());
        }
        this.tenantCompanyRelDao.deleteByTenantIdAndCompanyId(orgStruct.getTenantId().longValue(), companyId.longValue());
        this.orgStructDao.delete((Object)orgStruct);
    }
}

