/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.company.service;

import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.model.CompanyModel;
import com.xforceplus.api.model.OrgModel;
import com.xforceplus.api.model.TenantModel;
import com.xforceplus.business.company.dto.CompanyTaxwareDto;
import com.xforceplus.business.company.dto.LimitInfo;
import com.xforceplus.business.company.dto.TenantCompany;
import com.xforceplus.business.company.service.CompanyExtensionService;
import com.xforceplus.business.file.service.FileService;
import com.xforceplus.business.log.service.LogService;
import com.xforceplus.business.messagebus.CompanyPubService;
import com.xforceplus.business.messagebus.OrgPubService;
import com.xforceplus.constants.BusinessTypeEnum;
import com.xforceplus.dao.CompanyDao;
import com.xforceplus.dao.CompanyServiceRelDao;
import com.xforceplus.dao.CompanyTenantRelAuditDao;
import com.xforceplus.dao.CompanyTenantRelDao;
import com.xforceplus.dao.OrgCompanynoDao;
import com.xforceplus.dao.OrgStructDao;
import com.xforceplus.dao.OrgUserRelDao;
import com.xforceplus.dao.RoleDao;
import com.xforceplus.dao.RoleUserRelDao;
import com.xforceplus.dao.ServicePackageDao;
import com.xforceplus.dao.TenantCompanyRelDao;
import com.xforceplus.dao.TenantDao;
import com.xforceplus.dao.UserDao;
import com.xforceplus.domain.company.CompanyConfigurationDto;
import com.xforceplus.domain.company.CompanyDto;
import com.xforceplus.domain.company.CompanyPackage;
import com.xforceplus.domain.company.Relation;
import com.xforceplus.domain.log.SystemLogDTO;
import com.xforceplus.dto.company.CompanyServicePackageDTO;
import com.xforceplus.dto.org.CompanyTenantDto;
import com.xforceplus.entity.Company;
import com.xforceplus.entity.CompanyExtension;
import com.xforceplus.entity.CompanyServiceRel;
import com.xforceplus.entity.CompanyTenantRel;
import com.xforceplus.entity.OrgCompanyRel;
import com.xforceplus.entity.OrgStruct;
import com.xforceplus.entity.OrgUserRel;
import com.xforceplus.entity.Role;
import com.xforceplus.entity.RoleUserRel;
import com.xforceplus.entity.Tenant;
import com.xforceplus.entity.TenantCompanyRel;
import com.xforceplus.entity.User;
import com.xforceplus.enums.ActionCodeEnum;
import com.xforceplus.query.CompanyQueryHelper;
import com.xforceplus.query.OrgQueryHelper;
import com.xforceplus.query.TenantQueryHelper;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.utils.RandomUtils;
import com.xforceplus.utils.excel.ExcelUtils;
import com.xforceplus.utils.excel.exception.ImportException;
import io.geewit.core.utils.reflection.BeanUtils;
import io.geewit.data.jpa.envers.domain.ComparedRevision;
import io.geewit.data.jpa.essential.domain.EntityGraphs;
import io.geewit.utils.uuid.UUID;
import io.geewit.web.utils.JsonUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.validation.Validator;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.history.RevisionSort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class CompanyService {
    private static final Logger logger = LoggerFactory.getLogger(CompanyService.class);
    private final CompanyDao companyDao;
    private final CompanyServiceRelDao companyServiceRelDao;
    private final TenantCompanyRelDao tenantCompanyRelDao;
    private final TenantDao tenantDao;
    private final ServicePackageDao servicePackageDao;
    private final OrgCompanynoDao orgCompanynoDao;
    private final Validator validator;
    private final FileService fileService;
    private final OrgStructDao orgStructDao;
    private final UserDao userDao;
    private final RoleDao roleDao;
    private final RoleUserRelDao roleUserRelDao;
    private final OrgUserRelDao orgUserRelDao;
    private final int MAX_LENT = 64;
    private final CompanyExtensionService companyExtensionService;
    private final CompanyPubService companyPubService;
    private final OrgPubService orgPubService;
    private final CompanyTenantRelDao companyTenantRelDao;
    private final CompanyTenantRelDao relDao;
    private final CompanyTenantRelAuditDao relAuditDao;
    private final LogService logService;
    private final JdbcTemplate jdbcTemplate;
    private static final String ADD_TENANT_COMPANY_REL = "bind";
    private static final String DELETE_TENANT_COMPANY_REL = "unbind";
    private static final String NORMAL_TAX_PAYER = "NormalTaxPayer";
    private static final String SMALL_TAX_PAYER = "SmallTaxPayer";

    public CompanyService(CompanyDao companyDao, CompanyServiceRelDao companyServiceRelDao, TenantCompanyRelDao tenantCompanyRelDao, TenantDao tenantDao, ServicePackageDao servicePackageDao, OrgCompanynoDao orgCompanynoDao, Validator validator, FileService fileService, OrgStructDao orgStructDao, UserDao userDao, RoleDao roleDao, RoleUserRelDao roleUserRelDao, OrgUserRelDao orgUserRelDao, CompanyExtensionService companyExtensionService, CompanyPubService companyPubService, OrgPubService orgPubService, CompanyTenantRelDao companyTenantRelDao, CompanyTenantRelDao relDao, CompanyTenantRelAuditDao relAuditDao, LogService logService, JdbcTemplate jdbcTemplate) {
        this.companyDao = companyDao;
        this.companyServiceRelDao = companyServiceRelDao;
        this.tenantCompanyRelDao = tenantCompanyRelDao;
        this.tenantDao = tenantDao;
        this.servicePackageDao = servicePackageDao;
        this.orgCompanynoDao = orgCompanynoDao;
        this.validator = validator;
        this.fileService = fileService;
        this.orgStructDao = orgStructDao;
        this.userDao = userDao;
        this.roleDao = roleDao;
        this.roleUserRelDao = roleUserRelDao;
        this.orgUserRelDao = orgUserRelDao;
        this.companyExtensionService = companyExtensionService;
        this.companyPubService = companyPubService;
        this.orgPubService = orgPubService;
        this.companyTenantRelDao = companyTenantRelDao;
        this.relDao = relDao;
        this.relAuditDao = relAuditDao;
        this.logService = logService;
        this.jdbcTemplate = jdbcTemplate;
    }

    public Page<Company> page(CompanyModel.Request.Query query, Pageable pageable) {
        boolean enableTenant;
        Page page;
        if (query.getMultipleTenants() != null) {
            Page tuples = this.companyDao.findTuples(query, pageable);
            List contents = tuples.getContent().stream().map(tuple -> {
                Company company = (Company)tuple.get("company", Company.class);
                return company;
            }).collect(Collectors.toList());
            page = new PageImpl(contents, pageable, tuples.getTotalElements());
        } else {
            Specification specification = CompanyQueryHelper.querySpecification((CompanyModel.Request.Query)query);
            page = this.companyDao.findAll(specification, pageable, EntityGraphs.named((String)"Company.graph"));
        }
        boolean bl = enableTenant = query.getTenantId() != null && query.getTenantId() > 0L;
        if (StringUtils.isNotBlank((CharSequence)query.getWithExtendParams()) || enableTenant) {
            Object[] withExtendParamArray = StringUtils.split((String)query.getWithExtendParams(), (String)",");
            boolean enableExtensions = false;
            boolean enableRelations = false;
            boolean enableHostOrgs = false;
            boolean enableTenants = false;
            if (ArrayUtils.isNotEmpty((Object[])withExtendParamArray)) {
                for (Object withExtendParam : withExtendParamArray) {
                    withExtendParam = ((String)withExtendParam).trim();
                    if (!enableExtensions && "extensions".equalsIgnoreCase((String)withExtendParam)) {
                        enableExtensions = true;
                        continue;
                    }
                    if (!enableRelations && "relations".equalsIgnoreCase((String)withExtendParam)) {
                        enableRelations = true;
                        continue;
                    }
                    if (!enableHostOrgs && "hostOrgs".equalsIgnoreCase((String)withExtendParam)) {
                        enableHostOrgs = true;
                        continue;
                    }
                    if (enableTenants || !"tenants".equalsIgnoreCase((String)withExtendParam)) continue;
                    enableTenants = true;
                }
            }
            if (enableExtensions || enableRelations || enableHostOrgs || enableTenants || enableTenant) {
                Tenant tenant = null;
                if (enableTenant) {
                    tenant = this.tenantDao.findById((Object)query.getTenantId()).orElse(null);
                }
                for (Company company : page) {
                    if (enableExtensions) {
                        this.fillCompanyExtentions((CompanyDto)company);
                    }
                    if (enableRelations) {
                        this.fillCompanyRelations(company);
                    }
                    if (enableHostOrgs) {
                        this.fillHostOrgs((CompanyDto)company);
                    }
                    if (enableTenants) {
                        this.fillTenants(company);
                    }
                    if (!enableTenant) continue;
                    this.fillTenant(company, tenant);
                }
            }
        }
        return page;
    }

    public Page<Company> page(Specification<Company> specification, Pageable pageable) {
        return this.companyDao.findAll(specification, pageable);
    }

    public List<Company> list(CompanyModel.Request.Query query, Sort sort) {
        Specification specification = CompanyQueryHelper.querySpecification((CompanyModel.Request.Query)query);
        List list = this.companyDao.findAll(specification, sort);
        return list;
    }

    public List<Company> findByTaxNum(String taxNum) {
        CompanyModel.Request.Query query = new CompanyModel.Request.Query();
        query.setTaxNum(taxNum);
        query.setStatus(Integer.valueOf(1));
        Specification specification = CompanyQueryHelper.querySpecification((CompanyModel.Request.Query)query);
        List companies = this.companyDao.findAll(specification);
        if (!companies.isEmpty()) {
            Company company = (Company)companies.get(0);
            this.fillTenants(company);
            return Stream.of(company).collect(Collectors.toList());
        }
        return new ArrayList<Company>();
    }

    private void fillHostOrgs(CompanyDto company) {
        if (company.getHostTenantId() != null && company.getHostTenantId() > 0L && company.getCompanyId() != null && company.getCompanyId() > 0L) {
            OrgModel.Request.Query query = new OrgModel.Request.Query();
            query.setCompanyId(company.getCompanyId());
            query.setTenantId(company.getHostTenantId());
            query.setStatus(Integer.valueOf(1));
            List hostOrgEntities = this.orgStructDao.findAll(OrgQueryHelper.querySpecification((OrgModel.Request.Query)query));
            ArrayList<OrgStruct> hostOrgs = new ArrayList<OrgStruct>(hostOrgEntities.size());
            for (OrgStruct hostOrgEntity : hostOrgEntities) {
                OrgStruct hostOrg = new OrgStruct();
                BeanUtils.copyProperties((Object)hostOrgEntity, (Object)hostOrg, (String[])((String[])Stream.of("company", "tenant", "packages", "orgUserRels", "orgCompanyRels").toArray(String[]::new)));
                hostOrgs.add(hostOrg);
            }
            company.setHostOrgs(hostOrgs);
        }
    }

    private void fillCompany(Company company, Set<String> withExtendParams) {
        if (company == null) {
            return;
        }
        if (withExtendParams == null || withExtendParams.isEmpty()) {
            return;
        }
        boolean enableExtensions = false;
        boolean enableRelations = false;
        boolean enableHostOrgs = false;
        boolean enableTenants = false;
        for (String withExtendParam : withExtendParams) {
            withExtendParam = withExtendParam.trim();
            if (!enableExtensions && "extensions".equalsIgnoreCase(withExtendParam)) {
                enableExtensions = true;
                continue;
            }
            if (!enableRelations && "relations".equalsIgnoreCase(withExtendParam)) {
                enableRelations = true;
                continue;
            }
            if (!enableHostOrgs && "hostOrgs".equalsIgnoreCase(withExtendParam)) {
                enableHostOrgs = true;
                continue;
            }
            if (enableTenants || !"tenants".equalsIgnoreCase(withExtendParam)) continue;
            enableTenants = true;
        }
        if (enableExtensions) {
            this.fillCompanyExtentions((CompanyDto)company);
        }
        if (enableRelations) {
            this.fillCompanyRelations(company);
        }
        if (enableHostOrgs) {
            this.fillHostOrgs((CompanyDto)company);
        }
        if (enableTenants) {
            this.fillTenants(company);
        }
    }

    private void fillTenants(Company company) {
        if (company == null) {
            return;
        }
        TenantModel.Request.Query tenantQuery = new TenantModel.Request.Query();
        tenantQuery.setCompanyId(company.getCompanyId());
        tenantQuery.setStatus(Integer.valueOf(1));
        Specification tenantSpecification = TenantQueryHelper.querySpecification((TenantModel.Request.Query)tenantQuery);
        List tenants = this.tenantDao.findAll(tenantSpecification);
        company.setTenants(tenants.stream().filter(Objects::nonNull).collect(Collectors.toList()));
    }

    private void fillCompanyExtentions(CompanyDto company) {
        if (company == null) {
            return;
        }
        List<CompanyExtension> extensions = this.companyExtensionService.findByComapnyId(company.getCompanyId());
        if (!CollectionUtils.isEmpty(extensions)) {
            List extensionDtos = extensions.stream().filter(Objects::nonNull).collect(Collectors.toList());
            company.setExtensions(extensionDtos);
        }
    }

    private void fillCompanyRelations(Company company) {
        if (company == null || company.getCompanyId() == null || company.getCompanyId() == 0L) {
            return;
        }
        OrgModel.Request.Query orgQuery = new OrgModel.Request.Query();
        orgQuery.setCompanyId(company.getCompanyId());
        orgQuery.setStatus(Integer.valueOf(1));
        Specification orgSpecification = OrgQueryHelper.querySpecification((OrgModel.Request.Query)orgQuery);
        List orgs = this.orgStructDao.findAll(orgSpecification);
        if (orgs == null || orgs.isEmpty()) {
            return;
        }
        Object[] tenantIdArray = (Long[])orgs.stream().map(OrgStruct::getTenantId).toArray(Long[]::new);
        if (ArrayUtils.isEmpty((Object[])tenantIdArray)) {
            return;
        }
        TenantModel.Request.Query tenantQuery = new TenantModel.Request.Query();
        tenantQuery.setTenantIds((Long[])tenantIdArray);
        tenantQuery.setStatus(Integer.valueOf(1));
        Specification tenantSpecification = TenantQueryHelper.querySpecification((TenantModel.Request.Query)tenantQuery);
        List tenants = this.tenantDao.findAll(tenantSpecification);
        HashSet<Long> tenantIds = new HashSet<Long>();
        HashSet<Long> relatedTenantIds = new HashSet<Long>();
        HashSet<Relation> relations = new HashSet<Relation>();
        List rels = company.getTenantId() != null && company.getTenantId() > 0L ? this.companyTenantRelDao.findCompanyIdAndRelatedTenantId(company.getCompanyId().longValue(), company.getTenantId().longValue()) : this.companyTenantRelDao.findByCompanyId(company.getCompanyId().longValue());
        for (CompanyTenantRel rel : rels) {
            tenantIds.add(rel.getTenantId());
            relatedTenantIds.add(rel.getRelatedTenantId());
            Relation relation = new Relation();
            relation.setTenantId(rel.getRelatedTenantId());
            Tenant tenant = tenants.stream().filter(t -> t.getTenantId().equals(relation.getTenantId())).findAny().orElse(null);
            if (tenant == null) continue;
            relation.setTenantName(tenant.getTenantName());
            relation.setTenantCode(tenant.getTenantCode());
            Set relatedOrgs = orgs.stream().filter(o -> o.getTenantId().equals(relation.getTenantId())).collect(Collectors.toSet());
            relation.setOrgs(relatedOrgs);
            relations.add(relation);
        }
        company.setRelations(relations);
    }

    private void fillTenant(Company company, Tenant tenant) {
        company.setTenantId(tenant.getTenantId());
        company.setTenantName(tenant.getTenantName());
        company.setTenantCode(tenant.getTenantCode());
    }

    public List<Company> list(Specification<Company> specification, Sort sort) {
        return this.companyDao.findAll(specification, sort);
    }

    public Optional<Company> findOne(CompanyModel.Request.Query query) {
        Specification specification = CompanyQueryHelper.queryOneSpecification((CompanyModel.Request.Query)query);
        return this.companyDao.findOne(specification);
    }

    public Optional<Company> findOneByTaxNum(String taxNum) {
        if (StringUtils.isBlank((CharSequence)taxNum)) {
            throw new IllegalArgumentException("\u516c\u53f8\u7a0e\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List list = this.companyDao.findByTaxNum(taxNum);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Optional.empty();
        }
        return Optional.of(list.get(0));
    }

    public List<Company> findListByTaxNum(String taxNum) {
        return this.companyDao.findByTaxNum(taxNum);
    }

    public List<Company> findList(CompanyModel.Request.Query query) {
        Specification specification = CompanyQueryHelper.queryOneSpecification((CompanyModel.Request.Query)query);
        return this.companyDao.findAll(specification);
    }

    @Transactional(rollbackFor={Exception.class})
    public Company create(CompanyModel.Request.Save model) {
        this.checkExtensions(model.getExtensions());
        Company company = this.save(model, false);
        return company;
    }

    @Transactional(rollbackFor={Exception.class})
    public <C extends CompanyModel.Request.Save> Company update(long companyId, C model) {
        this.checkExtensions(model.getExtensions());
        model.setCompanyId(Long.valueOf(companyId));
        boolean isOverwrite = true;
        Company company = this.save(model, isOverwrite);
        Set<CompanyExtension> extensions = this.companyExtensionService.batchSave(company.getCompanyId(), model.getExtensions(), isOverwrite);
        if (!CollectionUtils.isEmpty(extensions)) {
            company.setExtensions(new ArrayList<CompanyExtension>(extensions));
        }
        return company;
    }

    @Transactional(rollbackFor={Exception.class})
    public <C extends CompanyModel.Request.Save> Company save(C model, boolean isOverwrite) {
        this.checkExtensions(model.getExtensions());
        Optional<Company> optionalCompany = Optional.empty();
        if (model.getCompanyId() != null && model.getCompanyId() > 0L) {
            optionalCompany = this.companyDao.findById((Object)model.getCompanyId());
        }
        if (!optionalCompany.isPresent() && StringUtils.isNotBlank((CharSequence)model.getTaxNum())) {
            optionalCompany = this.findCompanyByTaxNum(model.getTaxNum());
        }
        Company companyEntity = null;
        if (optionalCompany.isPresent()) {
            if (isOverwrite) {
                if (StringUtils.isBlank((CharSequence)model.getCompanyName())) {
                    model.setCompanyName(null);
                }
                if (StringUtils.isBlank((CharSequence)model.getCompanyCode())) {
                    model.setCompanyCode(null);
                }
                if (StringUtils.isBlank((CharSequence)model.getTaxNum())) {
                    model.setTaxNum(null);
                }
            }
            companyEntity = optionalCompany.get();
        } else {
            logger.info("\u672a\u6839\u636e\u53c2\u6570, companyId = {}, companyCode = {}, taxNum = {}, companyName = {}, \u67e5\u5230\u5b9e\u4f53", new Object[]{model.getCompanyId(), model.getCompanyCode(), model.getTaxNum(), model.getCompanyName()});
            companyEntity = new Company();
        }
        BeanUtils.copyProperties(model, (Object)companyEntity, (String[])((String[])Stream.of("companyId", "orgs", "tenants", "companyNos", "hostTenantId").toArray(String[]::new)), (String[])((String[])Stream.of("cquota", "squota", "ceQuota", "juQuota", "seQuota", "vehicleLimit", "hostTenantId").toArray(String[]::new)));
        if (companyEntity.getHostTenantId() == null && model.getHostTenantId() != null) {
            companyEntity.setHostTenantId(model.getHostTenantId());
        }
        companyEntity = this.saveAndFlush(companyEntity);
        this.companyExtensionService.batchSave(companyEntity.getCompanyId(), model.getExtensions(), isOverwrite);
        return companyEntity;
    }

    protected Optional<Company> findCompanyByTaxNum(String taxNum) {
        List<Company> companies = this.findListByTaxNum(taxNum);
        if (CollectionUtils.isEmpty(companies)) {
            return Optional.empty();
        }
        if (companies.size() > 1) {
            String message = "\u5df2\u5b58\u57282\u4e2a\u516c\u53f8\u7a0e\u53f7(" + taxNum + ")\u7684\u516c\u53f8";
            logger.warn(message);
            throw new IllegalArgumentException(message);
        }
        return Optional.of(companies.get(0));
    }

    public Company findByTenantIdAndId(long tenantId, long companyId) {
        CompanyModel.Request.Query query = new CompanyModel.Request.Query();
        query.setTenantId(Long.valueOf(tenantId));
        query.setCompanyId(Long.valueOf(companyId));
        return this.findOne(query).orElseThrow(() -> new IllegalArgumentException("\u79df\u6237(" + tenantId + ")\u4e0b, \u672a\u627e\u5230\u516c\u53f8(" + companyId + ") !"));
    }

    public Company findById(long companyId) {
        Company company = (Company)this.companyDao.findById((Object)companyId).orElseThrow(() -> new IllegalArgumentException("\u672a\u627e\u5230\u516c\u53f8\u5b9e\u4f53(" + companyId + ")"));
        return company;
    }

    public Company findByIdAndStatusAndRevisionDate(long companyId, Integer status, Date revisionDate, Set<String> withExtendParams) {
        Company company = (Company)this.companyDao.findById((Object)companyId).orElseThrow(() -> new IllegalArgumentException("\u672a\u627e\u5230\u516c\u53f8\u5b9e\u4f53(" + companyId + ")"));
        if (revisionDate != null) {
            try {
                Company historyCompany = (Company)this.companyDao.findRevisionByLastUpdateTime((Object)companyId, revisionDate);
                if (historyCompany != null) {
                    BeanUtils.copyProperties((Object)historyCompany, (Object)company, (String[])((String[])Stream.of("orgs", "companyNos", "hostTenant", "tenantRels").toArray(String[]::new)));
                }
            }
            catch (Exception e) {
                logger.warn(e.getMessage());
            }
        }
        this.fillCompany(company, withExtendParams);
        return company;
    }

    public Page<Company> page(long tenantId, CompanyModel.Request.Query query, Pageable pageable) {
        query.setTenantId(Long.valueOf(tenantId));
        return this.page(query, pageable);
    }

    public List<Company> list(long tenantId, CompanyModel.Request.Query query, Sort sort) {
        query.setTenantId(Long.valueOf(tenantId));
        return this.list(query, sort);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteById(long companyId) {
        Company company = this.findById(companyId);
        this.companyDao.deleteById(company.getCompanyId());
        this.companyExtensionService.deleteByCompanyId(company.getCompanyId());
    }

    @Transactional(readOnly=true, rollbackFor={RuntimeException.class})
    public Page<CompanyPackage> packagesByQuery(CompanyModel.Request.CompanyPackageQuery query, Pageable pageable) {
        Page page = this.companyDao.findPackages(query, pageable);
        Set companyIds = page.getContent().stream().map(CompanyPackage::getCompanyId).collect(Collectors.toSet());
        List companyServicePackageDTOs = !CollectionUtils.isEmpty(companyIds) ? this.companyDao.findCompanyServicePackageByCompanyIds(companyIds) : Collections.emptyList();
        Map companyPackageNameMap = companyServicePackageDTOs.stream().collect(Collectors.groupingBy(CompanyServicePackageDTO::getCompanyId, Collectors.mapping(CompanyServicePackageDTO::getServicePackageName, Collectors.toSet())));
        for (CompanyPackage companyPackage : page) {
            if (!companyPackageNameMap.containsKey(companyPackage.getCompanyId())) continue;
            Set packageNames = companyPackageNameMap.get(companyPackage.getCompanyId());
            companyPackage.setPackageNames(new ArrayList(packageNames));
        }
        return page;
    }

    private void validateCompany(long companyId, String companyCode, String taxNum) {
        long count = this.companyDao.validateExistCompany(companyId, companyCode, taxNum);
        if (count > 0L) {
            throw new IllegalArgumentException("\u5df2\u7ecf\u6709\u91cd\u590d\u7684\u7a0e\u53f7\u6216\u516c\u53f8\u540d\u79f0\u6216\u4ee3\u7801");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public Company update(long tenantId, long companyId, CompanyModel.Request.Save model) {
        this.checkExtensions(model.getExtensions());
        CompanyModel.Request.Query query = new CompanyModel.Request.Query();
        query.setTenantId(Long.valueOf(tenantId));
        query.setCompanyId(Long.valueOf(companyId));
        Optional<Company> companyOptional = this.findOne(query);
        if (!companyOptional.isPresent()) {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u516c\u53f8\u5b9e\u4f53tenantId:" + tenantId + ",companyId:" + companyId);
        }
        this.validateCompany(companyId, model.getCompanyCode(), model.getTaxNum());
        Company existModel = companyOptional.get();
        if (StringUtils.isBlank((CharSequence)model.getCompanyName())) {
            model.setCompanyName(null);
        }
        if (StringUtils.isBlank((CharSequence)model.getCompanyCode())) {
            model.setCompanyCode(null);
        }
        if (StringUtils.isBlank((CharSequence)model.getTaxNum())) {
            model.setTaxNum(null);
        }
        BeanUtils.copyProperties((Object)model, (Object)existModel);
        existModel = this.saveAndFlush(existModel);
        this.companyExtensionService.batchSave(companyId, model.getExtensions(), true);
        return existModel;
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateStatus(long companyId, int status) {
        Company company = this.findById(companyId);
        company.setStatus(Integer.valueOf(status));
        this.saveAndFlush(company);
    }

    @Transactional(rollbackFor={Exception.class})
    public void bindPackages(long tenantId, long companyId, CompanyModel.Request.BindPackages bindPackage) {
        if (bindPackage == null) {
            String message = "\u8bf7\u6c42\u53c2\u6570\u9519\u8bef, bindPackage == null";
            logger.warn(message);
            throw new IllegalArgumentException(message);
        }
        List packageIds = bindPackage.getPackageIds();
        if (packageIds == null) {
            String message = "\u8bf7\u6c42\u53c2\u6570\u9519\u8bef, packageIds == null";
            logger.warn(message);
            throw new IllegalArgumentException(message);
        }
        CompanyModel.Request.Query query = new CompanyModel.Request.Query();
        query.setTenantId(Long.valueOf(tenantId));
        query.setCompanyId(Long.valueOf(companyId));
        Company existEntity = this.findOne(query).orElseThrow(() -> new IllegalArgumentException("\u672a\u627e\u5230\u516c\u53f8(tenantId: " + tenantId + ",companyId:" + companyId + ")\u5b9e\u4f53"));
        Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, builder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            predicates.add(builder.equal((Expression)root.get("tenantId"), (Object)tenantId));
            predicates.add(builder.equal((Expression)root.get("companyId"), (Object)existEntity.getCompanyId()));
            if (!predicates.isEmpty()) {
                criteriaQuery.where((Expression)builder.and(predicates.toArray(new Predicate[0])));
            }
            return criteriaQuery.getRestriction();
        };
        List existRels = this.companyServiceRelDao.findAll((Specification)specification, Sort.unsorted());
        HashSet errors = new HashSet();
        Set<CompanyServiceRel> insertingRels = packageIds.stream().filter(Objects::nonNull).filter(packageId -> existRels.stream().map(CompanyServiceRel::getServicePackageId).noneMatch(relPackageId -> relPackageId.equals(packageId))).map(packageId -> {
            Optional servicePackageOptional = this.servicePackageDao.findById(packageId);
            if (servicePackageOptional.isPresent()) {
                CompanyServiceRel rel = new CompanyServiceRel();
                rel.setTenantId(Long.valueOf(tenantId));
                rel.setCompanyId(Long.valueOf(companyId));
                rel.setServicePackageId(packageId);
                rel.setStatus(Integer.valueOf(1));
                rel.setOperateReason("");
                rel.setRemarks("");
                return rel;
            }
            errors.add("\u4e0d\u5b58\u5728\u670d\u52a1\u5305(" + packageId + ")");
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        if (!errors.isEmpty()) {
            throw new IllegalArgumentException(errors.stream().collect(Collectors.joining(",")));
        }
        if (!insertingRels.isEmpty()) {
            insertingRels.forEach(arg_0 -> ((CompanyServiceRelDao)this.companyServiceRelDao).saveAndFlush(arg_0));
        }
        if (bindPackage.isOverwrite()) {
            existRels.stream().filter(Objects::nonNull).filter(existRel -> packageIds.stream().noneMatch(packageId -> packageId != null && packageId.equals(existRel.getServicePackageId()))).forEach(existRel -> {
                logger.info("\u5220\u9664\u516c\u53f8\u670d\u52a1\u5305, companyId = {}, servicePackageId = {}", (Object)existRel.getCompanyId(), (Object)existRel.getServicePackageId());
                try {
                    this.companyServiceRelDao.deleteById(existRel.getId());
                }
                catch (Exception e) {
                    logger.warn(e.getMessage(), (Throwable)e);
                }
            });
        }
    }

    @Deprecated
    @Transactional(rollbackFor={Exception.class})
    public TenantCompanyRel saveTenantCompany(Tenant tenant, Company company) {
        TenantCompanyRel tenantCompanyRel;
        Optional tenantCompanyRelOptional = this.tenantCompanyRelDao.findOne((Specification & Serializable)(root, criteriaQuery, builder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            predicates.add(builder.equal((Expression)root.get("tenantId"), (Object)tenant.getTenantId()));
            predicates.add(builder.equal((Expression)root.get("companyId"), (Object)company.getCompanyId()));
            criteriaQuery.where((Predicate[])predicates.stream().toArray(Predicate[]::new));
            return criteriaQuery.getRestriction();
        });
        if (tenantCompanyRelOptional.isPresent()) {
            tenantCompanyRel = (TenantCompanyRel)tenantCompanyRelOptional.get();
        } else {
            tenantCompanyRel = new TenantCompanyRel();
            tenantCompanyRel.setTenantId(tenant.getTenantId());
            tenantCompanyRel.setCompanyId(company.getCompanyId());
            tenantCompanyRel = (TenantCompanyRel)this.tenantCompanyRelDao.saveAndFlush((Object)tenantCompanyRel);
            this.companyPubService.sendTenantCompanyRelMsg(ADD_TENANT_COMPANY_REL, company, tenant);
        }
        return tenantCompanyRel;
    }

    public ResponseEntity<Long> batchImportConfiguration(MultipartFile file) {
        String template = "companyConfiguration.json";
        List<CompanyConfigurationDto> list = ExcelUtils.list(file, template, CompanyConfigurationDto.class);
        int success = 0;
        int fail = 0;
        ArrayList<String> errorMsg = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            CompanyConfigurationDto companyConfigurationDomain = list.get(i);
            try {
                ExcelUtils.validField(companyConfigurationDomain, this.validator);
                this.saveConfigurationImport(companyConfigurationDomain);
                ++success;
                continue;
            }
            catch (ImportException e) {
                ++fail;
                for (String msg : e.getMsgError()) {
                    String message = "\u5bfc\u5165\u7b2c " + (i + 1) + " \u884c\u5931\u8d25," + msg;
                    logger.warn(message);
                    errorMsg.add(message);
                }
            }
        }
        ResponseEntity restResponse = new ResponseEntity();
        restResponse.setCode("1");
        if (!CollectionUtils.isEmpty(errorMsg)) {
            Long fileId = this.fileService.uploadMsgExcel(errorMsg);
            restResponse.setResult((Object)fileId);
            restResponse.setCode(null == fileId ? "1" : "0");
        }
        restResponse.setMessage("\u5bfc\u5165\u6210\u529f " + success + " \u6761, \u5bfc\u5165\u5931\u8d25 " + fail + " \u6761");
        return restResponse;
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveConfigurationImport(CompanyConfigurationDto companyConfigurationDto) throws ImportException {
        Company company = this.getByTaxNum(companyConfigurationDto.getCompanyTax());
        if (company == null) {
            throw new ImportException(Stream.of("\u7a0e\u53f7\u3010" + companyConfigurationDto.getCompanyTax() + "\u3011\u5bf9\u5e94\u516c\u53f8\u4e0d\u5b58\u5728").collect(Collectors.toList()));
        }
        int traditionAuthenFlag = Integer.parseInt(companyConfigurationDto.getTraditionAuthenFlag());
        int inspectionChannelFlag = Integer.parseInt(companyConfigurationDto.getInspectionServiceFlag());
        int speedInspectionChannelFlag = Integer.parseInt(companyConfigurationDto.getSpeedInspectionChannelFlag());
        if (inspectionChannelFlag == 0 && speedInspectionChannelFlag == 1) {
            throw new ImportException(Stream.of("\u672a\u5f00\u542f\u67e5\u9a8c\u670d\u52a1\uff0c\u65e0\u6cd5\u5f00\u5176\u6781\u901f\u67e5\u9a8c\u901a\u9053").collect(Collectors.toList()));
        }
        company.setTraditionAuthenFlag(Integer.valueOf(traditionAuthenFlag));
        company.setInspectionServiceFlag(Integer.valueOf(inspectionChannelFlag));
        company.setSpeedInspectionChannelFlag(Integer.valueOf(speedInspectionChannelFlag));
        this.saveAndFlush(company);
    }

    public Company getByTaxNum(String taxNum) {
        CompanyModel.Request.Query query = new CompanyModel.Request.Query();
        query.setTaxNum(taxNum);
        Optional<Company> optionalCompany = this.findOne(query);
        return optionalCompany.orElse(null);
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveCompanyNos(long orgId, Set<String> companyNos, boolean isOverwrite) {
        if (CollectionUtils.isEmpty(companyNos)) {
            if (companyNos != null && isOverwrite) {
                logger.info("companyNos is empty, isOverwrite = true, clean all and return");
                this.orgCompanynoDao.deleteByOrgId(orgId);
            } else {
                logger.info("companyNos == null, isOverwrite = false, return");
            }
            return;
        }
        List existRels = this.orgCompanynoDao.findByOrgId(orgId);
        Set<OrgCompanyRel> insertingRels = companyNos.stream().filter(companyNo -> existRels.stream().map(OrgCompanyRel::getCompanyNo).filter(StringUtils::isNotBlank).noneMatch(companyNo::equals)).map(companyNo -> {
            OrgCompanyRel rel = new OrgCompanyRel();
            rel.setOrgStructId(Long.valueOf(orgId));
            rel.setCompanyNo(companyNo);
            return rel;
        }).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(insertingRels)) {
            insertingRels.forEach(arg_0 -> ((OrgCompanynoDao)this.orgCompanynoDao).saveAndFlush(arg_0));
        }
        if (isOverwrite) {
            existRels.stream().filter(rel -> companyNos.stream().filter(Objects::nonNull).noneMatch(companyNo -> companyNo.equals(rel.getCompanyNo()))).forEach(rel -> {
                try {
                    this.orgCompanynoDao.deleteById(rel.getId());
                }
                catch (Exception e) {
                    logger.warn(e.getMessage(), (Throwable)e);
                }
            });
        }
    }

    @Async(value="threadPoolExecutor")
    public void fixTenantCompanies() {
        List fixingCompanies = this.companyDao.findFixingCompanies();
        if (fixingCompanies.isEmpty()) {
            return;
        }
        fixingCompanies.stream().filter(Objects::nonNull).forEach(org -> {
            logger.debug("org: {}", (Object)JsonUtils.toJson((Object)org));
            TenantCompanyRel rel = new TenantCompanyRel();
            rel.setTenantId(Long.valueOf(((BigInteger)org.get("tenant_id")).longValue()));
            rel.setCompanyId(Long.valueOf(((BigInteger)org.get("company_id")).longValue()));
            this.tenantCompanyRelDao.saveAndFlush((Object)rel);
            Optional tenantOptional = this.tenantDao.findById((Object)rel.getTenantId());
            Optional companyOptional = this.companyDao.findById((Object)rel.getCompanyId());
            this.companyPubService.sendTenantCompanyRelMsg(ADD_TENANT_COMPANY_REL, (Company)companyOptional.get(), (Tenant)tenantOptional.get());
        });
    }

    private void checkExtensions(List<CompanyModel.Request.Extension> extensions) {
        if (CollectionUtils.isEmpty(extensions)) {
            return;
        }
        int maxExtnesion = 10;
        if (extensions.size() > maxExtnesion) {
            throw new IllegalArgumentException("\u6269\u5c55\u6807\u7b7e\u4e2a\u6570\u4e0d\u80fd\u8d85\u8fc7\u3010" + maxExtnesion + "\u3011");
        }
        boolean checkResult = extensions.stream().anyMatch(p -> StringUtils.isBlank((CharSequence)p.getExtensionKey()) || StringUtils.isBlank((CharSequence)p.getExtensionValue()));
        if (checkResult) {
            throw new IllegalArgumentException("\u6269\u5c55\u6807\u7b7e\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3011");
        }
        checkResult = extensions.stream().anyMatch(p -> p.getExtensionKey().length() > 64 || p.getExtensionValue().length() > 64);
        if (checkResult) {
            throw new IllegalArgumentException("\u6269\u5c55\u6807\u7b7e\u6700\u5927\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7\u301064\u3011");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public Company saveAndFlush(Company company) {
        if (company.getCompanyId() != null) {
            this.orgStructDao.updateOrgNameByCompanyId(company.getCompanyId(), company.getCompanyName());
        }
        Company saveObj = (Company)this.companyDao.saveAndFlush((Object)company);
        this.companyPubService.pub(saveObj.getCompanyId());
        return saveObj;
    }

    @Deprecated
    private void updateOrgName(Company company) {
        if (company != null && company.getCompanyId() != null) {
            Long userId = 0L;
            if (UserInfoHolder.get() != null) {
                userId = UserInfoHolder.get().getId();
            }
            String sql = "update sys_org_struct so inner join bss_company bc on bc.company_id = so.company_id  set so.org_name  = ? ,  so.update_time = current_timestamp, so.update_user_id = ?   where so.company_id = ?  and so.org_name = bc.company_name and  bc.company_name!= ? ";
            int updateCount = this.jdbcTemplate.update(sql, new Object[]{company.getCompanyName(), userId, company.getCompanyId(), company.getCompanyName()});
            logger.warn("\u66f4\u65b0\u516c\u53f8\uff1a{}, \u6279\u91cf\u66f4\u65b0\u7ec4\u7ec7\u540d\u79f0\u6570\u91cf\uff1a{}", (Object)company.getCompanyId(), (Object)updateCount);
        }
    }

    public Company info(long companyId, Set<String> withExtendParams) {
        Company company = this.findById(companyId);
        this.fillCompany(company, withExtendParams);
        return company;
    }

    public Company currentInfo(long companyId, Integer status, Date revisionDate, Set<String> withExtendParams) {
        Company company = this.findByIdAndStatusAndRevisionDate(companyId, status, revisionDate, withExtendParams);
        this.fillCompany(company, withExtendParams);
        return company;
    }

    public Page<CompanyPackage> currentPackagesByQuery(CompanyModel.Request.CompanyPackageQuery query, Pageable pageable) {
        IAuthorizedUser authorizedUser = UserInfoHolder.get();
        query.setTenantId(authorizedUser.getTenantId());
        return this.packagesByQuery(query, pageable);
    }

    public Map<Long, TenantCompany> findTenantCompanyAll() {
        List companyList = this.tenantCompanyRelDao.findTenantCommpanyRelAll();
        if (CollectionUtils.isEmpty((Collection)companyList)) {
            return Collections.emptyMap();
        }
        HashMap<Long, TenantCompany> tenantCompanyMap = new HashMap<Long, TenantCompany>(companyList.size());
        for (Object[] objects : companyList) {
            TenantCompany tenantCompany = new TenantCompany();
            tenantCompany.setTenantName(String.valueOf(objects[1]));
            tenantCompany.setTenantCode(String.valueOf(objects[0]));
            tenantCompany.setCompanyId(Long.valueOf(objects[2].toString()));
            tenantCompanyMap.put(tenantCompany.getCompanyId(), tenantCompany);
        }
        return tenantCompanyMap;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteOrgComRelById(long orgCompanyNumberRelId) {
        this.orgCompanynoDao.deleteById(Long.valueOf(orgCompanyNumberRelId));
    }

    public Page<ComparedRevision<Company, String>> findCompanyHistories(long companyId, Pageable pageable) {
        pageable = PageRequest.of((int)pageable.getPageNumber(), (int)pageable.getPageSize(), (Sort)pageable.getSort().and((Sort)RevisionSort.desc()));
        Page page = this.companyDao.findComparedRevisions((Object)companyId, pageable);
        return page;
    }

    public Company revisionInfo(long tenantId, long companyId, Date revision, Set<String> withExtendParams) {
        Company company = this.findByTenantIdAndId(tenantId, companyId);
        if (revision != null) {
            try {
                Company historyCompany = (Company)this.companyDao.findRevisionByLastUpdateTime((Object)companyId, revision);
                if (historyCompany != null) {
                    BeanUtils.copyProperties((Object)historyCompany, (Object)company, (String[])((String[])Stream.of("orgs", "companyNos", "hostTenant", "tenantRels").toArray(String[]::new)));
                }
            }
            catch (Exception e) {
                logger.warn(e.getMessage());
            }
        }
        Tenant tenant = (Tenant)this.tenantDao.findById((Object)tenantId).orElseThrow(() -> new IllegalArgumentException("\u975e\u6cd5\u7684\u79df\u6237id(" + tenantId + ")"));
        this.fillTenant(company, tenant);
        this.fillCompany(company, withExtendParams);
        return company;
    }

    public boolean existInHistory(String taxNum, String companyName, Date effectiveDate) {
        long count = effectiveDate == null ? this.companyDao.countAuditByTaxNumAndCompanyName(taxNum, companyName) : this.companyDao.countAuditByTaxNumAndCompanyNameAndEffectiveDate(taxNum, companyName, effectiveDate);
        return count > 0L;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean updateAuditEffective(long companyId, long revision, boolean effective) {
        return this.companyDao.updateAuditEffective(companyId, revision, effective) > 0;
    }

    @Transactional(rollbackFor={Exception.class})
    public synchronized Map<String, Object> move(CompanyModel.Request.Move move) {
        List oldTenantIds;
        String batchId = UUID.randomUUID().toString();
        SystemLogDTO systemLogDTO = new SystemLogDTO().batchId(batchId).businessType(BusinessTypeEnum.COMPANY_MOVE_TENANT.name());
        Long companyId = move.getCompanyId();
        Long newTenantId = move.getTenantId();
        HashMap<String, Object> result = new HashMap<String, Object>();
        Company company = this.findById(companyId);
        Tenant tenant = (Tenant)this.tenantDao.findById((Object)newTenantId).orElseThrow(() -> new IllegalArgumentException("\u672a\u627e\u5230\u79df\u6237\u5b9e\u4f53(" + newTenantId + ")"));
        List tenantCompanyRels = this.tenantCompanyRelDao.findByCompanyId(companyId.longValue());
        if (CollectionUtils.isEmpty((Collection)tenantCompanyRels)) {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u5f53\u524d\u516c\u53f8\u5bf9\u5e94\u79df\u6237");
        }
        if (tenantCompanyRels.size() > 1) {
            List ortherCompanyIds = tenantCompanyRels.stream().filter(rel -> !rel.getCompanyId().equals(companyId)).map(TenantCompanyRel::getCompanyId).collect(Collectors.toList());
            throw new IllegalArgumentException("\u53ea\u80fd\u8fc1\u79fb\u72ec\u7acb\u79df\u6237\u7684\u516c\u53f8\uff0c\u5f53\u524d\u516c\u53f8\u5bf9\u5e94\u79df\u6237\u4e0b\u5b58\u5728\u5176\u4ed6\u516c\u53f8(" + ortherCompanyIds + "), \u8bf7\u786e\u8ba4!");
        }
        Long oldTenantId = null;
        List oldCompanyOrgs = this.orgStructDao.findByCompanyId(companyId.longValue());
        if (!CollectionUtils.isEmpty((Collection)oldCompanyOrgs)) {
            oldTenantId = ((OrgStruct)oldCompanyOrgs.get(0)).getTenantId();
            if (newTenantId.equals(oldTenantId)) {
                throw new IllegalArgumentException("\u5f53\u524d\u516c\u53f8\u79df\u6237\u4e0e\u76ee\u6807\u79df\u6237\u4e00\u81f4");
            }
            List oldOrgs = this.orgStructDao.findByTenantId(oldTenantId.longValue());
            if ((oldOrgs = oldOrgs.stream().filter(orgStruct -> null != orgStruct.getParentId() && 0L != orgStruct.getParentId()).collect(Collectors.toList())).size() > 1) {
                List ortherOrgIds = oldOrgs.stream().filter(org -> null != org.getCompanyId()).filter(org -> !org.getCompanyId().equals(companyId)).map(OrgStruct::getOrgId).collect(Collectors.toList());
                throw new IllegalArgumentException("\u53ea\u80fd\u8fc1\u79fb\u72ec\u7acb\u79df\u6237\u7684\u516c\u53f8\uff0c\u5f53\u524d\u516c\u53f8\u5bf9\u5e94\u79df\u6237\u4e0b\u5b58\u5728\u5176\u4ed6\u7ec4\u7ec7(" + ortherOrgIds + "), \u8bf7\u786e\u8ba4!");
            }
        }
        if (!oldTenantId.equals((oldTenantIds = tenantCompanyRels.stream().map(rel -> rel.getTenantId()).collect(Collectors.toList())).get(0))) {
            throw new IllegalArgumentException("\u516c\u53f8\u5bf9\u5e94\u7ec4\u7ec7\u79df\u6237id(" + oldTenantIds.get(0) + ")\u4e0e\u516c\u53f8\u5bf9\u5e94\u79df\u6237id(" + oldTenantId + ")\u4e0d\u4e00\u81f4");
        }
        if (newTenantId.equals(oldTenantId)) {
            throw new IllegalArgumentException("\u5f53\u524d\u516c\u53f8\u79df\u6237\u4e0e\u79fb\u52a8\u79df\u6237\u4e00\u81f4");
        }
        List users = this.userDao.findByTenantId(oldTenantId.longValue());
        List repeUsers = this.userDao.findByAccountIdIn((Collection)users.stream().map(User::getAccountId).collect(Collectors.toList()));
        List errorUsers = repeUsers.stream().filter(user -> user.getTenantId().equals(newTenantId)).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(errorUsers)) {
            throw new IllegalArgumentException("\u7528\u6237(" + errorUsers.stream().map(User::getId).collect(Collectors.toList()) + ")\u5df2\u5b58\u5728\u76ee\u6807\u79df\u6237\uff0c\u8bf7\u786e\u8ba4");
        }
        ArrayList<Pair> logList = new ArrayList<Pair>();
        for (TenantCompanyRel rel2 : tenantCompanyRels) {
            Tenant oldTenant = (Tenant)this.tenantDao.findById((Object)rel2.getTenantId()).get();
            TenantCompanyRel old2 = new TenantCompanyRel();
            BeanUtils.copyProperties((Object)rel2, (Object)old2);
            rel2.setTenantId(newTenantId);
            TenantCompanyRel ret = (TenantCompanyRel)this.tenantCompanyRelDao.saveAndFlush((Object)rel2);
            Pair pair = Pair.of((Object)old2, (Object)ret);
            logList.add(pair);
            this.companyPubService.sendTenantCompanyRelMsg(DELETE_TENANT_COMPANY_REL, company, oldTenant);
            this.companyPubService.sendTenantCompanyRelMsg(ADD_TENANT_COMPANY_REL, company, tenant);
        }
        List rootOrgs = this.orgStructDao.findRootsByTenantId(newTenantId.longValue());
        if (CollectionUtils.isEmpty((Collection)rootOrgs)) {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u6839\u7ec4\u7ec7\u5b9e\u4f53(" + newTenantId + ")");
        }
        OrgStruct rootOrg = (OrgStruct)rootOrgs.get(0);
        OrgModel.Request.Query query = new OrgModel.Request.Query();
        query.setCompanyId(companyId);
        query.setTenantId(oldTenantId);
        query.setStatus(Integer.valueOf(1));
        List orgStructs = this.orgStructDao.findAll(OrgQueryHelper.querySpecification((OrgModel.Request.Query)query));
        orgStructs.forEach(org -> {
            OrgStruct old = new OrgStruct();
            BeanUtils.copyProperties((Object)org, (Object)old);
            org.setTenantId(newTenantId);
            org.setParentId((Serializable)rootOrg.getOrgId());
            OrgStruct ret = (OrgStruct)this.orgStructDao.saveAndFlush(org);
            this.orgPubService.sendOrgMsg("save", ret);
            Pair pair = Pair.of((Object)old, (Object)ret);
            logList.add(pair);
        });
        List companyServiceRels = this.companyServiceRelDao.findByTenantIdEqualsAndCompanyIdEquals(oldTenantId.longValue(), companyId.longValue());
        ArrayList companyPackageIds = new ArrayList();
        companyServiceRels.forEach(old -> {
            CompanyServiceRel newObj = new CompanyServiceRel();
            BeanUtils.copyProperties((Object)old, (Object)newObj);
            newObj.setTenantId(newTenantId);
            companyPackageIds.add(old.getId());
            Pair pair = Pair.of((Object)old, (Object)newObj);
            logList.add(pair);
        });
        if (!CollectionUtils.isEmpty(companyPackageIds)) {
            this.companyServiceRelDao.batchUpdateTenant(companyPackageIds, newTenantId.longValue());
        }
        ArrayList userIds = new ArrayList();
        users.forEach(old -> {
            User newObj = new User();
            BeanUtils.copyProperties((Object)old, (Object)newObj);
            newObj.setTenantId(newTenantId);
            userIds.add(old.getId());
            Pair pair = Pair.of((Object)old, (Object)newObj);
            logList.add(pair);
        });
        if (!CollectionUtils.isEmpty(userIds)) {
            this.userDao.batchUpdateTenant(userIds, newTenantId);
        }
        List orgUserRels = this.orgUserRelDao.findByTenantId(oldTenantId.longValue());
        ArrayList orgUserRelIds = new ArrayList();
        orgUserRels.forEach(old -> {
            OrgUserRel newObj = new OrgUserRel();
            BeanUtils.copyProperties((Object)old, (Object)newObj);
            newObj.setTenantId(newTenantId);
            orgUserRelIds.add(old.getId());
            Pair pair = Pair.of((Object)old, (Object)newObj);
            logList.add(pair);
        });
        if (!CollectionUtils.isEmpty(orgUserRelIds)) {
            this.orgUserRelDao.batchUpdateTenant(orgUserRelIds, newTenantId);
        }
        company.setHostTenantId(newTenantId);
        this.companyDao.saveAndFlush((Object)company);
        if (move.isMoveRole()) {
            List roles = this.roleDao.findByTenantId(oldTenantId.longValue());
            ArrayList roleIds = new ArrayList();
            ArrayList updateRoles = new ArrayList();
            String suffix = RandomUtils.getRandomNum(6);
            roles.forEach(role -> {
                Role old = new Role();
                BeanUtils.copyProperties((Object)role, (Object)old);
                role.setName(role.getName() + "_" + "copy" + suffix);
                role.setCode(role.getCode() + "_" + "copy" + suffix);
                role.setTenantId(newTenantId);
                roleIds.add(role.getId());
                updateRoles.add(role);
                Pair pair = Pair.of((Object)old, (Object)role);
                logList.add(pair);
            });
            if (!CollectionUtils.isEmpty(updateRoles)) {
                this.roleDao.saveAll(updateRoles);
            }
            List roleUserRels = this.roleUserRelDao.findByTenantId(oldTenantId.longValue());
            ArrayList roleUserRelIds = new ArrayList();
            roleUserRels.forEach(old -> {
                RoleUserRel newObj = new RoleUserRel();
                if (1L == old.getRoleId()) {
                    this.roleUserRelDao.delete(old);
                    Pair pair = Pair.of((Object)old, (Object)newObj);
                    logList.add(pair);
                } else {
                    BeanUtils.copyProperties((Object)old, (Object)newObj);
                    newObj.setTenantId(newTenantId);
                    roleUserRelIds.add(old.getId());
                    Pair pair = Pair.of((Object)old, (Object)newObj);
                    logList.add(pair);
                }
            });
            if (!CollectionUtils.isEmpty(roleUserRelIds)) {
                this.roleUserRelDao.batchUpdateTenant(roleUserRelIds, newTenantId);
            }
            result.put("sys_role", roleIds);
            result.put("sys_role_user_rel", roleUserRelIds);
        } else {
            List roleUserRels = this.roleUserRelDao.findByTenantId(oldTenantId.longValue());
            roleUserRels.forEach(rel -> {
                this.roleUserRelDao.delete(rel);
                RoleUserRel newObj = new RoleUserRel();
                Pair pair = Pair.of((Object)rel, (Object)newObj);
                logList.add(pair);
            });
        }
        systemLogDTO.setActionCode(ActionCodeEnum.U);
        this.logService.insertLogBatch(logList, systemLogDTO);
        result.put("oldTenantId", oldTenantId);
        result.put("newTenantId", newTenantId);
        result.put("bss_tenant_company_rel", tenantCompanyRels.stream().map(rel -> rel.getId()).collect(Collectors.toList()));
        result.put("sys_org_struct", orgStructs.stream().map(rel -> rel.getOrgId()).collect(Collectors.toList()));
        result.put("bss_company_service_rel", companyPackageIds);
        result.put("sys_user", userIds);
        result.put("sys_org_user_rel", orgUserRelIds);
        result.put("batchId", batchId);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public synchronized Map<String, Object> moveAll(CompanyModel.Request.Move move) {
        String batchId = UUID.randomUUID().toString();
        SystemLogDTO systemLogDTO = new SystemLogDTO().batchId(batchId).businessType(BusinessTypeEnum.COMPANY_MOVE_TENANT.name());
        Long companyId = move.getCompanyId();
        Long newTenantId = move.getTenantId();
        HashMap<String, Object> result = new HashMap<String, Object>();
        Company company = this.findById(companyId);
        Tenant tenant = (Tenant)this.tenantDao.findById((Object)newTenantId).orElseThrow(() -> new IllegalArgumentException("\u672a\u627e\u5230\u79df\u6237\u5b9e\u4f53(" + newTenantId + ")"));
        List tenantCompanyRels = this.tenantCompanyRelDao.findByCompanyId(companyId.longValue());
        if (CollectionUtils.isEmpty((Collection)tenantCompanyRels)) {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u5f53\u524d\u516c\u53f8\u5bf9\u5e94\u79df\u6237");
        }
        Long oldTenantId = null;
        List oldCompanyOrgs = this.orgStructDao.findByCompanyId(companyId.longValue());
        if (!CollectionUtils.isEmpty((Collection)oldCompanyOrgs) && newTenantId.equals(oldTenantId = ((OrgStruct)oldCompanyOrgs.get(0)).getTenantId())) {
            throw new IllegalArgumentException("\u5f53\u524d\u516c\u53f8\u79df\u6237\u4e0e\u76ee\u6807\u79df\u6237\u4e00\u81f4");
        }
        List oldTenantIds = tenantCompanyRels.stream().map(rel -> rel.getTenantId()).collect(Collectors.toList());
        if (!oldTenantId.equals(oldTenantIds.get(0))) {
            throw new IllegalArgumentException("\u516c\u53f8\u5bf9\u5e94\u7ec4\u7ec7\u79df\u6237id(" + oldTenantIds.get(0) + ")\u4e0e\u516c\u53f8\u5bf9\u5e94\u79df\u6237id(" + oldTenantId + ")\u4e0d\u4e00\u81f4");
        }
        if (newTenantId.equals(oldTenantId)) {
            throw new IllegalArgumentException("\u5f53\u524d\u516c\u53f8\u79df\u6237\u4e0e\u79fb\u52a8\u79df\u6237\u4e00\u81f4");
        }
        List users = this.userDao.findByTenantId(oldTenantId.longValue());
        List repeUsers = this.userDao.findByAccountIdIn((Collection)users.stream().map(User::getAccountId).collect(Collectors.toList()));
        List errorUsers = repeUsers.stream().filter(user -> user.getTenantId().equals(newTenantId)).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(errorUsers)) {
            throw new IllegalArgumentException("\u7528\u6237(" + errorUsers.stream().map(User::getId).collect(Collectors.toList()) + ")\u5df2\u5b58\u5728\u76ee\u6807\u79df\u6237\uff0c\u8bf7\u786e\u8ba4");
        }
        ArrayList<Pair> logList = new ArrayList<Pair>();
        for (TenantCompanyRel rel2 : tenantCompanyRels) {
            TenantCompanyRel old2 = new TenantCompanyRel();
            Tenant oldTenant = (Tenant)this.tenantDao.findById((Object)rel2.getTenantId()).get();
            BeanUtils.copyProperties((Object)rel2, (Object)old2);
            rel2.setTenantId(newTenantId);
            TenantCompanyRel ret = (TenantCompanyRel)this.tenantCompanyRelDao.saveAndFlush((Object)rel2);
            Pair pair = Pair.of((Object)old2, (Object)ret);
            logList.add(pair);
            this.companyPubService.sendTenantCompanyRelMsg(DELETE_TENANT_COMPANY_REL, company, oldTenant);
            this.companyPubService.sendTenantCompanyRelMsg(ADD_TENANT_COMPANY_REL, company, tenant);
        }
        List rootOrgs = this.orgStructDao.findRootsByTenantId(newTenantId.longValue());
        if (CollectionUtils.isEmpty((Collection)rootOrgs)) {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u6839\u7ec4\u7ec7\u5b9e\u4f53(" + newTenantId + ")");
        }
        OrgStruct rootOrg = (OrgStruct)rootOrgs.get(0);
        OrgModel.Request.Query query = new OrgModel.Request.Query();
        query.setCompanyId(companyId);
        query.setTenantId(oldTenantId);
        query.setStatus(Integer.valueOf(1));
        List orgStructs = this.orgStructDao.findAll(OrgQueryHelper.querySpecification((OrgModel.Request.Query)query));
        orgStructs.forEach(org -> {
            OrgStruct old = new OrgStruct();
            BeanUtils.copyProperties((Object)org, (Object)old);
            org.setTenantId(newTenantId);
            org.setParentId((Serializable)rootOrg.getOrgId());
            OrgStruct ret = (OrgStruct)this.orgStructDao.saveAndFlush(org);
            this.orgPubService.sendOrgMsg("save", ret);
            Pair pair = Pair.of((Object)old, (Object)ret);
            logList.add(pair);
        });
        List companyServiceRels = this.companyServiceRelDao.findByTenantIdEqualsAndCompanyIdEquals(oldTenantId.longValue(), companyId.longValue());
        ArrayList companyPackageIds = new ArrayList();
        companyServiceRels.forEach(old -> {
            CompanyServiceRel newObj = new CompanyServiceRel();
            BeanUtils.copyProperties((Object)old, (Object)newObj);
            newObj.setTenantId(newTenantId);
            companyPackageIds.add(old.getId());
            Pair pair = Pair.of((Object)old, (Object)newObj);
            logList.add(pair);
        });
        if (!CollectionUtils.isEmpty(companyPackageIds)) {
            this.companyServiceRelDao.batchUpdateTenant(companyPackageIds, newTenantId.longValue());
        }
        ArrayList userIds = new ArrayList();
        users.forEach(old -> {
            User newObj = new User();
            BeanUtils.copyProperties((Object)old, (Object)newObj);
            newObj.setTenantId(newTenantId);
            userIds.add(old.getId());
            Pair pair = Pair.of((Object)old, (Object)newObj);
            logList.add(pair);
        });
        if (!CollectionUtils.isEmpty(userIds)) {
            this.userDao.batchUpdateTenant(userIds, newTenantId);
        }
        List roles = this.roleDao.findByTenantId(oldTenantId.longValue());
        ArrayList roleIds = new ArrayList();
        roles.forEach(old -> {
            Role newObj = new Role();
            BeanUtils.copyProperties((Object)old, (Object)newObj);
            newObj.setTenantId(newTenantId);
            roleIds.add(old.getId());
            Pair pair = Pair.of((Object)old, (Object)newObj);
            logList.add(pair);
        });
        if (!CollectionUtils.isEmpty(roleIds)) {
            this.roleDao.batchUpdateTenant(roleIds, newTenantId);
        }
        List roleUserRels = this.roleUserRelDao.findByTenantId(oldTenantId.longValue());
        ArrayList roleUserRelIds = new ArrayList();
        roleUserRels.forEach(old -> {
            RoleUserRel newObj = new RoleUserRel();
            BeanUtils.copyProperties((Object)old, (Object)newObj);
            newObj.setTenantId(newTenantId);
            roleUserRelIds.add(old.getId());
            Pair pair = Pair.of((Object)old, (Object)newObj);
            logList.add(pair);
        });
        if (!CollectionUtils.isEmpty(roleUserRelIds)) {
            this.roleUserRelDao.batchUpdateTenant(roleUserRelIds, newTenantId);
        }
        List orgUserRels = this.orgUserRelDao.findByTenantId(oldTenantId.longValue());
        ArrayList orgUserRelIds = new ArrayList();
        orgUserRels.forEach(old -> {
            OrgUserRel newObj = new OrgUserRel();
            BeanUtils.copyProperties((Object)old, (Object)newObj);
            newObj.setTenantId(newTenantId);
            orgUserRelIds.add(old.getId());
            Pair pair = Pair.of((Object)old, (Object)newObj);
            logList.add(pair);
        });
        if (!CollectionUtils.isEmpty(orgUserRelIds)) {
            this.orgUserRelDao.batchUpdateTenant(orgUserRelIds, newTenantId);
        }
        systemLogDTO.setActionCode(ActionCodeEnum.U);
        this.logService.insertLogBatch(logList, systemLogDTO);
        result.put("oldTenantId", oldTenantId);
        result.put("newTenantId", newTenantId);
        result.put("bss_tenant_company_rel", tenantCompanyRels.stream().map(rel -> rel.getId()).collect(Collectors.toList()));
        result.put("sys_org_struct", orgStructs.stream().map(rel -> rel.getOrgId()).collect(Collectors.toList()));
        result.put("bss_company_service_rel", companyPackageIds);
        result.put("sys_user", userIds);
        result.put("sys_role", roleIds);
        result.put("sys_role_user_rel", roleUserRelIds);
        result.put("sys_org_user_rel", orgUserRelIds);
        return result;
    }

    public Optional<Long> findIdByTaxNum(String taxNum) {
        return this.companyDao.findIdByTaxNum(taxNum);
    }

    public List<Company> findByIds(List<Long> ids) {
        return this.companyDao.findByIds(ids);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateCompanyName(Long tenantId, CompanyModel.Request.CompanyName companyName) {
        Company company = this.findByTenantIdAndId(tenantId, companyName.getCompanyId());
        if (companyName.getCompanyName().equals(company.getCompanyName())) {
            throw new IllegalArgumentException("\u66f4\u65b0\u516c\u53f8\u540d\u79f0\u4e0e\u539f\u540d\u79f0\u4e00\u81f4!");
        }
        company.setCompanyName(companyName.getCompanyName());
        this.saveAndFlush(company);
    }

    public CompanyModel.Response.CompanyInfo findCompanyInfoByCompanyId(long companyId) {
        Company company = this.findById(companyId);
        CompanyModel.Response.CompanyInfo companyInfo = new CompanyModel.Response.CompanyInfo();
        companyInfo.setHasRelations(Boolean.valueOf(false));
        if (company.getHostTenantId() != null && company.getHostTenantId() > 0L) {
            Optional hostTenantOptional;
            Tenant hostTenant = company.getHostTenant();
            if ((hostTenant == null || hostTenant.getCreateTime() == null) && (hostTenantOptional = this.tenantDao.findById((Object)company.getHostTenantId())).isPresent()) {
                hostTenant = (Tenant)hostTenantOptional.get();
            }
            if (hostTenant != null && hostTenant.getTenantName() != null) {
                companyInfo.setHostTenantId(hostTenant.getTenantId());
                companyInfo.setHostTenantName(hostTenant.getTenantName());
            }
        }
        List companyTenants = this.orgStructDao.findTenantInfoByCompanyId(companyId);
        ArrayList<CompanyModel.Response.RelInfo> infos = new ArrayList<CompanyModel.Response.RelInfo>();
        this.fillRelInfos(companyInfo, infos, companyTenants);
        return companyInfo;
    }

    private void fillRelInfos(CompanyModel.Response.CompanyInfo companyInfo, List<CompanyModel.Response.RelInfo> infos, Collection<CompanyTenantDto> companyTenants) {
        if (companyTenants != null && !companyTenants.isEmpty()) {
            List hostRels = null;
            for (final CompanyTenantDto companyTenant : companyTenants) {
                CompanyModel.Response.RelInfo info = new CompanyModel.Response.RelInfo();
                info.setTenantId(companyTenant.getTenantId());
                info.setTenantCode(companyTenant.getTenantCode());
                info.setTenantName(companyTenant.getTenantName());
                info.setRelatedType(companyTenant.getTenantId().equals(companyInfo.getHostTenantId()) ? 1 : 2);
                ArrayList<CompanyModel.Response.RelItem> items = new ArrayList<CompanyModel.Response.RelItem>();
                if (hostRels == null) {
                    hostRels = this.relDao.findAll((Specification)new Specification<CompanyTenantRel>(){

                        public Predicate toPredicate(Root<CompanyTenantRel> root, CriteriaQuery<?> query, CriteriaBuilder builder) {
                            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
                            predicates.add(builder.equal((Expression)root.get("companyId"), (Object)companyTenant.getCompanyId()));
                            if (!predicates.isEmpty()) {
                                query.where((Predicate[])predicates.stream().toArray(Predicate[]::new));
                            }
                            return query.getRestriction();
                        }
                    }, EntityGraphs.named((String)"CompanyTenantRel.graph"));
                }
                this.fillRelItems(companyInfo, info, items, hostRels);
                infos.add(info);
            }
        }
        companyInfo.setInfos(infos);
    }

    private void fillRelItems(CompanyModel.Response.CompanyInfo companyInfo, CompanyModel.Response.RelInfo relInfo, List<CompanyModel.Response.RelItem> items, Collection<CompanyTenantRel> rels) {
        List hostRels;
        if (rels != null && !rels.isEmpty() && (hostRels = rels.stream().filter(r -> r.getTenantId().equals(relInfo.getTenantId())).collect(Collectors.toList())) != null && !hostRels.isEmpty()) {
            companyInfo.setHasRelations(Boolean.valueOf(true));
            for (CompanyTenantRel rel : hostRels) {
                CompanyModel.Response.RelItem item = new CompanyModel.Response.RelItem();
                item.setTenantId(rel.getTenantId());
                item.setTenantCode(rel.getTenantCode());
                item.setTenantName(rel.getTenantName());
                item.setRelatedTenantId(rel.getRelatedTenantId());
                item.setRelatedTenantCode(rel.getRelatedTenantCode());
                item.setRelatedTenantName(rel.getRelatedTenantName());
                item.setRelatedCompanyId(rel.getRelatedCompanyId());
                item.setRelatedCompanyName(rel.getRelatedCompanyName());
                item.setRelatedCompanyCode(rel.getRelatedCompanyCode());
                item.setRelatedTaxNum(rel.getRelatedTaxNum());
                item.setSwitches(rel.getSwitches().intValue());
                item.setInvoiceStartDate(rel.getInvoiceStartDate());
                item.setStatementStartDate(rel.getStatementStartDate());
                item.setCreateTime(rel.getCreateTime());
                items.add(item);
            }
        }
        relInfo.setItems(items);
    }

    @Transactional(rollbackFor={Exception.class})
    public void changeHostTenant(Long companyId, Long tenantId) {
        Company company = this.findById(companyId);
        List orgs = this.orgStructDao.findIdByTenantIdAndCompanyId(tenantId.longValue(), companyId.longValue());
        if (CollectionUtils.isEmpty((Collection)orgs)) {
            throw new IllegalArgumentException("\u5f53\u524d\u516c\u53f8\u4e0e\u79df\u6237\u6ca1\u6709\u5efa\u7acb\u6240\u5c5e\u5173\u7cfb\uff01");
        }
        List rels = this.relDao.findByCompanyId(companyId.longValue());
        if (!CollectionUtils.isEmpty((Collection)rels)) {
            throw new IllegalArgumentException("\u8be5\u516c\u53f8\u5f00\u901a\u4e86\u591a\u79df\u6237\u5171\u4eab\u4e1a\u52a1\uff0c\u4e0d\u53ef\u6267\u884c\u6240\u5c5e\u79df\u6237\u7684\u53d8\u66f4\u64cd\u4f5c\uff01");
        }
        company.setHostTenantId(tenantId);
        this.companyDao.saveAndFlush((Object)company);
    }

    public Map<Long, Boolean> validateCompanyPackagesWereBoundByRole(long tenantId, long companyId, Set<Long> packageIds) {
        List existPackageIds = this.companyServiceRelDao.findPackageIdsByTenantIdAndCompanyId(tenantId, companyId, packageIds);
        Set deletingPackageIds = packageIds.stream().filter(id -> existPackageIds.stream().noneMatch(existId -> id.equals(existId))).collect(Collectors.toSet());
        List pairs = this.companyServiceRelDao.countCompanyPackagesWereBoundByRole(tenantId, companyId, deletingPackageIds);
        Map<Long, Boolean> validation = pairs.stream().collect(Collectors.toMap(pair -> ((BigInteger)pair.get("packageId")).longValue(), pair -> ((BigInteger)pair.get("cnt")).longValue() > 0L));
        for (Map.Entry<Long, Boolean> entry : validation.entrySet()) {
            boolean exist = existPackageIds.stream().anyMatch(id -> ((Long)entry.getKey()).equals(id));
            entry.setValue(exist && entry.getValue() != false);
        }
        return validation;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean handleTaxwareMessage(CompanyTaxwareDto companyTaxwareDto) {
        Integer taxPayerType;
        if (companyTaxwareDto == null) {
            logger.warn("cannot handle empty data");
            return true;
        }
        String taxNo = companyTaxwareDto.getTaxCode();
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            logger.warn("cannot handle message without taxNo");
            return true;
        }
        Company company = this.getByTaxNum(taxNo);
        if (company == null) {
            logger.warn("cannot handle taxNo {}, not exist in user center", (Object)taxNo);
            return true;
        }
        String natureTaxPayer = companyTaxwareDto.getNatureTaxPayer();
        if (StringUtils.isBlank((CharSequence)natureTaxPayer)) {
            logger.warn("cannot handle message without natureTaxPayer");
        }
        if ((taxPayerType = company.getTaxpayerQualificationType()) == null) {
            if (NORMAL_TAX_PAYER.equalsIgnoreCase(natureTaxPayer)) {
                company.setTaxpayerQualificationType(Integer.valueOf(1));
            } else if (SMALL_TAX_PAYER.equalsIgnoreCase(natureTaxPayer)) {
                company.setTaxpayerQualificationType(Integer.valueOf(2));
            }
        } else {
            switch (natureTaxPayer) {
                case "NormalTaxPayer": {
                    if (taxPayerType == 1) break;
                    company.setTaxpayerQualificationType(Integer.valueOf(1));
                    break;
                }
                case "SmallTaxPayer": {
                    if (taxPayerType == 2) break;
                    company.setTaxpayerQualificationType(Integer.valueOf(2));
                    break;
                }
                default: {
                    logger.warn("illegal taxPayer type [{}] in message", (Object)natureTaxPayer);
                }
            }
        }
        List<LimitInfo> list = companyTaxwareDto.getLimitInfoList();
        list.forEach(element -> {
            String invoiceType = element.getInvoiceType();
            BigDecimal limit = element.getSingleAmountLimit();
            if (limit == null) {
                return;
            }
            switch (invoiceType) {
                case "c": {
                    if (company.getCquota() != null && company.getCquota().equals(limit)) break;
                    company.setCquota(limit);
                    break;
                }
                case "ce": {
                    if (company.getCeQuota() != null && company.getCeQuota().equals(limit)) break;
                    company.setCeQuota(limit);
                    break;
                }
                case "s": {
                    if (company.getSquota() != null && company.getSquota().equals(limit)) break;
                    company.setSquota(limit);
                    break;
                }
                case "se": {
                    if (company.getSeQuota() != null && company.getSeQuota().equals(limit)) break;
                    company.setSeQuota(limit);
                    break;
                }
                case "v": {
                    if (company.getVehicleLimit() != null && company.getVehicleLimit().equals(limit)) break;
                    company.setVehicleLimit(limit);
                    break;
                }
                case "ju": {
                    if (company.getJuQuota() != null && company.getJuQuota().equals(limit)) break;
                    company.setJuQuota(limit);
                    break;
                }
                case "vs": {
                    logger.warn("current not supported invoice type");
                    break;
                }
                default: {
                    logger.warn("illegal invoice type:{}", (Object)invoiceType);
                }
            }
        });
        try {
            this.saveAndFlush(company);
            return true;
        }
        catch (Exception exception) {
            logger.error("error saving company:{}", (Object)exception.getMessage());
            return false;
        }
    }
}

