/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.company.service;

import com.google.common.collect.Sets;
import com.xforceplus.api.model.CompanyModel;
import com.xforceplus.api.model.CompanyServiceRelModel;
import com.xforceplus.api.model.CompnayResourceSetModel;
import com.xforceplus.api.model.TenantModel;
import com.xforceplus.business.company.service.CompanyService;
import com.xforceplus.business.excel.company.CompanyPackageDTO;
import com.xforceplus.business.messagebus.CompanyServicePackagePubService;
import com.xforceplus.dao.CompanyDao;
import com.xforceplus.dao.CompanyServiceRelDao;
import com.xforceplus.dao.OrgStructDao;
import com.xforceplus.dao.ServicePackageDao;
import com.xforceplus.dao.TenantDao;
import com.xforceplus.dao.impl.BatchServiceDaoImpl;
import com.xforceplus.domain.company.CompanyPackageExportDto;
import com.xforceplus.entity.Company;
import com.xforceplus.entity.CompanyServiceRel;
import com.xforceplus.entity.OrgStruct;
import com.xforceplus.entity.ServicePackage;
import com.xforceplus.entity.ServiceResourcesetRel;
import com.xforceplus.entity.Tenant;
import com.xforceplus.query.CompanyQueryHelper;
import com.xforceplus.query.CompanyServiceRelQueryHelper;
import com.xforceplus.query.TenantQueryHelper;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import io.geewit.core.utils.reflection.BeanUtils;
import io.geewit.data.jpa.essential.domain.EntityGraphs;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CompanyServicePackageService {
    private static final Logger logger = LoggerFactory.getLogger(CompanyServicePackageService.class);
    @Autowired
    private CompanyServiceRelDao companyServiceRelDao;
    @Autowired
    private ServicePackageDao servicePackageDao;
    @Autowired
    private OrgStructDao orgStructDao;
    @Autowired
    private CompanyService companyService;
    @Autowired
    private BatchServiceDaoImpl batchServiceDaoImpl;
    @Autowired
    private CompanyServicePackagePubService companyServicePackagePubService;
    @Autowired
    private TenantDao tenantDao;
    @Autowired
    private CompanyDao companyDao;

    @Transactional(rollbackFor={Exception.class})
    public void bindCompanyAndPackage(Long tenantId, CompanyModel.Request.BindTaxNumAndPackage bindPackage) {
        if (StringUtils.isBlank((CharSequence)bindPackage.getTaxNum())) {
            throw new IllegalArgumentException("\u7a0e\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CompanyModel.Request.Query query = new CompanyModel.Request.Query();
        query.setTaxNum(bindPackage.getTaxNum());
        List<Company> companies = this.companyService.list(query, Sort.unsorted());
        if (CollectionUtils.isEmpty(companies)) {
            throw new IllegalArgumentException("\u516c\u53f8\u7a0e\u53f7(" + bindPackage.getTaxNum() + ")\u4e0d\u5b58\u5728");
        }
        Long companyId = companies.stream().map(Company::getCompanyId).filter(Objects::nonNull).findFirst().orElseThrow(() -> new IllegalArgumentException("\u4e0d\u5b58\u5728companyId"));
        this.companyService.bindPackages(tenantId, companyId, (CompanyModel.Request.BindPackages)bindPackage);
    }

    @Transactional(rollbackFor={Exception.class})
    public void createServicePackageAndBindCompanyFromResourceSet(List<CompnayResourceSetModel.Request.CompanyPackageBind> companyPackageBindRequest) {
        List tenantIds = companyPackageBindRequest.stream().map(CompnayResourceSetModel.Request.CompanyPackageBind::getTenantId).filter(Objects::nonNull).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(tenantIds) || companyPackageBindRequest.size() != tenantIds.size()) {
            throw new IllegalArgumentException("\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List resourcesetIds = companyPackageBindRequest.stream().map(CompnayResourceSetModel.Request.CompanyPackageBind::getResourceSetId).filter(Objects::nonNull).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(resourcesetIds) || companyPackageBindRequest.size() != resourcesetIds.size()) {
            throw new IllegalArgumentException("\u529f\u80fd\u96c6id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long servicePackageId = this.createServicePackage(companyPackageBindRequest);
        this.bindServicePackageAndCompany(servicePackageId, companyPackageBindRequest);
    }

    private void bindServicePackageAndCompany(Long servicePackageId, List<CompnayResourceSetModel.Request.CompanyPackageBind> binds) {
        Long tenantId = binds.get(0).getTenantId();
        List companies = this.orgStructDao.findCompaniesByTenantId(tenantId.longValue());
        if (CollectionUtils.isEmpty((Collection)companies)) {
            return;
        }
        this.batchServiceDaoImpl.deleteCompanyPackageByPackageIdAndTenantId(servicePackageId, tenantId);
        List companyServices = companies.stream().map(bind -> {
            Long companyId = bind.getCompanyId();
            CompanyServiceRel companyServiceRel = new CompanyServiceRel();
            companyServiceRel.setCompanyId(companyId);
            companyServiceRel.setServicePackageId(servicePackageId);
            companyServiceRel.setRemarks("\u6570\u636e\u8fc1\u79fb\u81ea\u52a8\u7ed1\u5b9a");
            companyServiceRel.setTenantId(tenantId);
            companyServiceRel.setStatus(Integer.valueOf(1));
            companyServiceRel.setOperateReason("\u6570\u636e\u8fc1\u79fb\u81ea\u52a8\u7ed1\u5b9a" + tenantId);
            return companyServiceRel;
        }).collect(Collectors.toList());
        companyServices = this.companyServiceRelDao.saveAllAndFlush(companyServices);
        this.companyServiceRelDao.flush();
    }

    private Long createServicePackage(List<CompnayResourceSetModel.Request.CompanyPackageBind> companyPackageBinds) {
        Long servicePackageId;
        ServicePackage servicePackage;
        String newPackageName = "\u8fc1\u79fb\u9ed8\u8ba4\u670d\u52a1\u5305-" + companyPackageBinds.get(0).getTenantId();
        List servicePackages = this.companyServiceRelDao.findByTenantId(companyPackageBinds.get(0).getTenantId().longValue());
        Optional<ServicePackage> optionalServicePackage = servicePackages.stream().filter(p -> p.getServicePackageName().equals(newPackageName)).findFirst();
        if (optionalServicePackage.isPresent()) {
            servicePackage = optionalServicePackage.get();
            this.batchServiceDaoImpl.deletePackageRelResourcesetByPackageId(optionalServicePackage.get().getServicePackageId());
            servicePackageId = servicePackage.getServicePackageId();
        } else {
            servicePackage = new ServicePackage();
            servicePackage.setAppId(companyPackageBinds.get(0).getAppId());
            servicePackage.setStatus(Integer.valueOf(1));
            servicePackage.setServicePackageName(newPackageName);
            ServicePackage entity = (ServicePackage)this.servicePackageDao.saveAndFlush((Object)servicePackage);
            servicePackageId = entity.getServicePackageId();
        }
        if (CollectionUtils.isNotEmpty(companyPackageBinds)) {
            Long finalServicePackageId = servicePackageId;
            List serviceResourcesetRels = companyPackageBinds.stream().map(bind -> {
                ServiceResourcesetRel serviceResourcesetRel = new ServiceResourcesetRel();
                serviceResourcesetRel.setResourcesetId(bind.getResourceSetId());
                serviceResourcesetRel.setServicePackageId(finalServicePackageId);
                return serviceResourcesetRel;
            }).collect(Collectors.toList());
            try {
                this.batchServiceDaoImpl.saveList(serviceResourcesetRels);
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), (Throwable)e);
                logger.error("\u63d2\u5165\u6570\u636e\u5f02\u5e38{}", (Object)companyPackageBinds.get(0).getTenantId());
            }
        }
        return servicePackageId;
    }

    @Transactional(rollbackFor={Exception.class})
    public void changeStatusByTenantIdAndCompanyId(long tenantId, long companyId, int status, String reason) {
        this.companyServiceRelDao.changeStatusByTenantIdAndCompanyId(tenantId, companyId, status, reason);
    }

    @Transactional(rollbackFor={Exception.class})
    public void changeCompanyServiceStatus(long tenantId, long companyId, List<Long> servicePackageIds, int status, String reason) {
        List rels = this.companyServiceRelDao.findRelsByTenantIdAndCompanyIdAndPackageIds(tenantId, companyId, servicePackageIds);
        rels.forEach(rel -> {
            rel.setStatus(Integer.valueOf(status));
            rel.setOperateReason(reason);
            this.companyServiceRelDao.saveAndFlush(rel);
        });
    }

    public List<CompanyServiceRel> findList(long tenantId, long companyId) {
        Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, builder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (tenantId > 0L && companyId > 0L) {
                predicates.add(builder.equal((Expression)root.get("tenantId"), (Object)tenantId));
                predicates.add(builder.equal((Expression)root.get("companyId"), (Object)companyId));
            }
            if (predicates.isEmpty()) {
                throw new IllegalArgumentException("\u7f3a\u5c11\u67e5\u8be2\u53c2\u6570");
            }
            criteriaQuery.where((Predicate[])predicates.stream().toArray(Predicate[]::new));
            return criteriaQuery.getRestriction();
        };
        List rels = this.companyServiceRelDao.findAll((Specification)specification);
        return rels;
    }

    @Transactional(rollbackFor={Exception.class})
    public void bindCompanyPackages(CompanyModel.Request.BindCompanyPackages bindCompanyPackages) {
        List companyIds;
        if (bindCompanyPackages == null) {
            String message = "\u7f3a\u5c11\u53c2\u6570 bindCompanyPackages";
            logger.info(message);
            throw new IllegalArgumentException(message);
        }
        Tenant tenant = (Tenant)this.tenantDao.findById((Object)bindCompanyPackages.getTenantId()).orElseThrow(() -> new IllegalArgumentException("\u672a\u67e5\u5230\u5bf9\u5e94\u7684\u79df\u6237(" + bindCompanyPackages.getTenantId() + ")"));
        CompanyServiceRelModel.Response.TenantModel tenantModel = new CompanyServiceRelModel.Response.TenantModel();
        BeanUtils.copyProperties((Object)tenant, (Object)tenantModel);
        List packageIds = bindCompanyPackages.getPackageIds();
        if (packageIds == null) {
            String message = "packageId\u662f\u5fc5\u586b\u5b57\u6bb5";
            logger.info(message);
            throw new IllegalArgumentException(message);
        }
        logger.info("packageIds = " + packageIds.stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.joining(",")));
        List list = companyIds = bindCompanyPackages.getCompanyIds() != null ? bindCompanyPackages.getCompanyIds() : new ArrayList();
        if (bindCompanyPackages.getCompanyId() != null && bindCompanyPackages.getCompanyId() > 0L) {
            companyIds.add(bindCompanyPackages.getCompanyId());
        }
        CompanyModel.Request.Query query = new CompanyModel.Request.Query();
        query.setTenantId(tenant.getTenantId());
        query.setCompanyIds(companyIds.toArray(new Long[0]));
        List companies = this.companyDao.findAll(CompanyQueryHelper.querySpecification((CompanyModel.Request.Query)query));
        logger.info("companyIds = " + packageIds.stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.joining(",")));
        if (companies.isEmpty()) {
            String message = "\u6ca1\u6709\u6548\u7684companyId";
            logger.info(message);
            throw new IllegalArgumentException(message);
        }
        List availableCompanyIds = companies.stream().map(Company::getCompanyId).collect(Collectors.toList());
        Set unavailableCompanyIds = companyIds.stream().filter(companyId -> !availableCompanyIds.contains(companyId)).collect(Collectors.toSet());
        if (!unavailableCompanyIds.isEmpty()) {
            String message = unavailableCompanyIds.stream().map(Object::toString).collect(Collectors.joining(",", "[", "]"));
            message = message + "\u4e0d\u662f\u6709\u6548\u7684\u516c\u53f8id";
            logger.info(message);
            throw new IllegalArgumentException(message);
        }
        Map<Long, Company> companyMap = companies.stream().collect(Collectors.toMap(Company::getCompanyId, Function.identity(), (key1, key2) -> key1));
        bindCompanyPackages.setCompanyIds(availableCompanyIds);
        List<CompanyServiceRel> rels = this.findCompanyServiceRelsByTenantIdAndCompanyIds(bindCompanyPackages.getTenantId(), companyIds);
        IAuthorizedUser iAuthorizedUser = UserInfoHolder.get();
        HashSet<CompanyServiceRel> insertingRels = new HashSet<CompanyServiceRel>();
        ArrayList<CompanyServiceRelModel.Response.CompanyServiceModel> pubRels = new ArrayList<CompanyServiceRelModel.Response.CompanyServiceModel>();
        HashMap<Long, ServicePackage> servicePackageMap = new HashMap<Long, ServicePackage>();
        HashSet errors = new HashSet();
        bindCompanyPackages.getCompanyIds().forEach(companyId -> packageIds.stream().filter(Objects::nonNull).filter(packageId -> rels.stream().noneMatch(companyServiceRel -> companyServiceRel.getServicePackageId().equals(packageId) && companyId.equals(companyServiceRel.getCompanyId()))).forEach(servicePackageId -> {
            Optional packageOptional = this.servicePackageDao.findById(servicePackageId);
            if (packageOptional.isPresent()) {
                servicePackageMap.put(((ServicePackage)packageOptional.get()).getServicePackageId(), (ServicePackage)packageOptional.get());
                CompanyServiceRel rel = new CompanyServiceRel();
                rel.setServicePackageId(servicePackageId);
                rel.setCompanyId(companyId);
                rel.setTenantId(Long.valueOf(bindCompanyPackages.getTenantId()));
                if (bindCompanyPackages.getStatus() != null) {
                    rel.setStatus(bindCompanyPackages.getStatus());
                } else {
                    rel.setStatus(Integer.valueOf(1));
                }
                rel.setRemarks("");
                rel.setOperateReason("");
                if (iAuthorizedUser != null) {
                    rel.setCreateUserName(iAuthorizedUser.getUsername());
                }
                insertingRels.add(rel);
            } else {
                errors.add("\u4e0d\u5b58\u5728\u670d\u52a1\u5305(" + servicePackageId + ")");
            }
        }));
        if (!errors.isEmpty()) {
            throw new IllegalArgumentException(errors.stream().collect(Collectors.joining(",")));
        }
        if (CollectionUtils.isNotEmpty(insertingRels)) {
            if (!CollectionUtils.isEmpty(insertingRels)) {
                this.companyServiceRelDao.saveAllAndFlush(insertingRels);
            }
            List<CompanyServiceRelModel.Response.CompanyServiceModel> insertPubs = this.companyServicePackagePubService.buildCompanyServiceMessage(servicePackageMap, companyMap, insertingRels, "I");
            pubRels.addAll(insertPubs);
        }
        if (bindCompanyPackages.isOverwrite()) {
            ArrayList deleteIds = new ArrayList();
            HashSet<CompanyServiceRel> deleteRels = new HashSet<CompanyServiceRel>();
            rels.stream().filter(rel -> !packageIds.contains(rel.getServicePackageId())).forEach(rel -> {
                this.companyServiceRelDao.deleteById(rel.getId());
                deleteIds.add(rel.getId());
                deleteRels.add((CompanyServiceRel)rel);
                Optional packageOptional = this.servicePackageDao.findById((Object)rel.getServicePackageId());
                if (packageOptional.isPresent()) {
                    servicePackageMap.put(((ServicePackage)packageOptional.get()).getServicePackageId(), (ServicePackage)packageOptional.get());
                }
            });
            if (CollectionUtils.isNotEmpty(deleteIds)) {
                List<CompanyServiceRelModel.Response.CompanyServiceModel> deletePubs = this.companyServicePackagePubService.buildCompanyServiceMessage(servicePackageMap, companyMap, deleteRels, "D");
                pubRels.addAll(deletePubs);
            }
        }
        if (CollectionUtils.isEmpty(pubRels)) {
            logger.info("\u516c\u53f8\u670d\u52a1\u5305\u6ca1\u6709\u53d8\u66f4\uff0c\u4e0d\u8fdb\u884cpub");
            return;
        }
        String channelIdStr = null == bindCompanyPackages.getChannelId() ? "" : bindCompanyPackages.getChannelId().toString();
        this.companyServicePackagePubService.sendMessage(channelIdStr, tenantModel, pubRels);
    }

    private List<CompanyServiceRel> findCompanyServiceRelsByTenantIdAndCompanyIds(Long tenantId, Collection<Long> companyIds) {
        if (tenantId == null || tenantId == 0L || CollectionUtils.isEmpty(companyIds)) {
            return new ArrayList<CompanyServiceRel>();
        }
        Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, builder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            predicates.add(builder.equal((Expression)root.get("tenantId"), (Object)tenantId));
            if (!CollectionUtils.isEmpty((Collection)companyIds)) {
                if (companyIds.size() == 1) {
                    predicates.add(builder.equal((Expression)root.get("companyId"), companyIds.stream().findFirst().get()));
                } else {
                    predicates.add(root.get("companyId").in(new HashSet(companyIds)));
                }
            }
            if (predicates.isEmpty()) {
                throw new IllegalArgumentException("\u7f3a\u5c11\u67e5\u8be2\u53c2\u6570");
            }
            criteriaQuery.where((Predicate[])predicates.stream().toArray(Predicate[]::new));
            return criteriaQuery.getRestriction();
        };
        List rels = this.companyServiceRelDao.findAll((Specification)specification);
        logger.info("exist CompanyServiceRels.size = " + rels.size());
        return rels;
    }

    @Transactional(rollbackFor={Exception.class})
    public void unbindCompanyPackages(long id) {
        CompanyServiceRel companyServiceRel = (CompanyServiceRel)this.companyServiceRelDao.findById((Serializable)Long.valueOf(id), EntityGraphs.named((String)"CompanyServiceRel.graph")).orElseThrow(() -> new IllegalArgumentException("\u672a\u627e\u5230\u516c\u53f8\u670d\u52a1\u5305(" + id + ")"));
        this.companyServiceRelDao.deleteById(Long.valueOf(id));
        this.pub(companyServiceRel);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteByCompanyIdAndTenantId(Long companyId, Long tenantId) {
        CompanyServiceRelModel.Request.Query query = new CompanyServiceRelModel.Request.Query();
        query.setTenantId(tenantId);
        query.setCompanyId(companyId);
        List companyServiceRels = this.companyServiceRelDao.findAll(CompanyServiceRelQueryHelper.querySpecification((CompanyServiceRelModel.Request.Query)query), EntityGraphs.named((String)"CompanyServiceRel.graph"));
        if (CollectionUtils.isNotEmpty((Collection)companyServiceRels)) {
            for (CompanyServiceRel companyServiceRel : companyServiceRels) {
                this.companyServiceRelDao.delete((Object)companyServiceRel);
                this.pub(companyServiceRel);
            }
        }
    }

    private void pub(CompanyServiceRel companyServiceRel) {
        CompanyServiceRelModel.Response.TenantModel tenantModel = new CompanyServiceRelModel.Response.TenantModel();
        Tenant tenant = companyServiceRel.getTenant();
        if (tenant == null || tenant.getCreateTime() == null) {
            tenant = (Tenant)this.tenantDao.getById((Object)companyServiceRel.getTenantId());
        }
        BeanUtils.copyProperties((Object)tenant, (Object)tenantModel);
        Company company = companyServiceRel.getCompany();
        if (company == null || company.getTaxNum() == null) {
            company = (Company)this.companyDao.getById((Object)companyServiceRel.getCompanyId());
        }
        HashMap<Long, Company> companyMap = new HashMap<Long, Company>(1);
        companyMap.put(companyServiceRel.getCompanyId(), company);
        ServicePackage servicePackage = companyServiceRel.getServicePackage();
        if (servicePackage == null || servicePackage.getCreateTime() == null) {
            servicePackage = (ServicePackage)this.servicePackageDao.getById((Object)companyServiceRel.getServicePackageId());
        }
        HashMap<Long, ServicePackage> servicePackageMap = new HashMap<Long, ServicePackage>(1);
        servicePackageMap.put(companyServiceRel.getServicePackageId(), servicePackage);
        HashSet relSet = Sets.newHashSet((Object[])new CompanyServiceRel[]{companyServiceRel});
        List<CompanyServiceRelModel.Response.CompanyServiceModel> delData = this.companyServicePackagePubService.buildCompanyServiceMessage(servicePackageMap, companyMap, relSet, "D");
        this.companyServicePackagePubService.sendMessage(null, tenantModel, delData);
    }

    @Transactional(rollbackFor={Exception.class})
    public void bindCompanyAndPackage(String tenantCode, String taxNum, String servicePackageCode, Integer status, boolean overwrite) {
        String[] servicePackageCodeList;
        TenantModel.Request.Query tenantQuery = new TenantModel.Request.Query();
        tenantQuery.setTenantCode(tenantCode);
        Specification tenantSpecification = TenantQueryHelper.queryOneSpecification((TenantModel.Request.Query)tenantQuery);
        Tenant tenant = (Tenant)this.tenantDao.findOne(tenantSpecification).orElseThrow(() -> new IllegalArgumentException("\u672a\u67e5\u5230\u5bf9\u5e94\u7684\u79df\u6237"));
        CompanyModel.Request.Query companyQuery = new CompanyModel.Request.Query();
        companyQuery.setTaxNum(taxNum);
        Specification companySpecification = CompanyQueryHelper.queryOneSpecification((CompanyModel.Request.Query)companyQuery);
        Company company = (Company)this.companyDao.findOne(companySpecification).orElseThrow(() -> new IllegalArgumentException("\u672a\u67e5\u5230\u5bf9\u5e94\u7684\u516c\u53f8"));
        boolean tenantCompanyRel = company.getOrgs().stream().map(OrgStruct::getTenantId).anyMatch(tid -> tid.equals(tenant.getTenantId()));
        if (!tenantCompanyRel) {
            throw new IllegalArgumentException("\u5f53\u524d\u79df\u6237\u672a\u548c\u516c\u53f8\u5efa\u7acb\u5173\u8054\uff0c\u65e0\u6cd5\u7ed1\u5b9a");
        }
        List companyServiceRels = this.companyServiceRelDao.findByTenantIdEqualsAndCompanyIdEquals(tenant.getTenantId().longValue(), company.getCompanyId().longValue());
        if (CollectionUtils.isNotEmpty((Collection)companyServiceRels) && overwrite) {
            this.companyServiceRelDao.deleteAll((Iterable)companyServiceRels);
        }
        if ((servicePackageCodeList = servicePackageCode.split("/")) == null || servicePackageCodeList.length <= 0) {
            String message = "\u670d\u52a1\u5305code\u4e3a\u7a7a\u3002";
            logger.info(message);
            throw new IllegalArgumentException(message);
        }
        ArrayList servicePackageArrayList = new ArrayList();
        for (String item : servicePackageCodeList) {
            List servicePackages = this.servicePackageDao.findServicePackagesByServicePackageCodeEqualsAndStatusEquals(item, 1);
            if (CollectionUtils.isEmpty((Collection)servicePackages)) {
                String message = "\u672a\u627e\u5230\u5bf9\u5e94\u670d\u52a1\u5305\u3002" + item;
                logger.info(message);
                throw new IllegalArgumentException(message);
            }
            if (servicePackages.size() > 1) {
                String message = "\u8be5\u670d\u52a1\u5305code\u5bf9\u5e94\u591a\u4e2a\u670d\u52a1\u5305\u3002" + item;
                logger.info(message);
                throw new IllegalArgumentException(message);
            }
            servicePackageArrayList.add(servicePackages.get(0));
        }
        Map<String, CompanyServiceRel> existRels = companyServiceRels.stream().collect(Collectors.toMap(k -> (k.getServicePackageId() + "_" + k.getCompanyId() + "_" + k.getTenantId()).toString(), part -> part));
        HashMap<Long, ServicePackage> servicePackageMap = new HashMap<Long, ServicePackage>();
        HashMap<Long, Company> companyMap = new HashMap<Long, Company>();
        HashSet<CompanyServiceRel> saveSet = new HashSet<CompanyServiceRel>();
        for (ServicePackage servicePackage : servicePackageArrayList) {
            if (!overwrite && org.springframework.util.CollectionUtils.isEmpty(existRels) && null != existRels.get(servicePackage.getServicePackageId() + "_" + company.getCompanyId() + "_" + tenant.getTenantId())) continue;
            CompanyServiceRel rel = new CompanyServiceRel();
            rel.setServicePackageId(servicePackage.getServicePackageId());
            rel.setCompanyId(company.getCompanyId());
            rel.setTenantId(tenant.getTenantId());
            if (status != null) {
                rel.setStatus(status);
            } else {
                rel.setStatus(Integer.valueOf(1));
            }
            rel.setRemarks("excel\u5bfc\u5165");
            rel.setOperateReason("");
            rel = (CompanyServiceRel)this.companyServiceRelDao.saveAndFlush((Object)rel);
            saveSet.add(rel);
            servicePackageMap.put(servicePackage.getServicePackageId(), servicePackage);
            companyMap.put(company.getCompanyId(), company);
        }
        CompanyServiceRelModel.Response.TenantModel tenantModel = new CompanyServiceRelModel.Response.TenantModel();
        BeanUtils.copyProperties((Object)tenant, (Object)tenantModel);
        List<CompanyServiceRelModel.Response.CompanyServiceModel> pubRels = this.companyServicePackagePubService.buildCompanyServiceMessage(servicePackageMap, companyMap, saveSet, "I");
        this.companyServicePackagePubService.sendMessage(null, tenantModel, pubRels);
    }

    public List<CompanyPackageExportDto> getExportData(List<Long> companyIds, List<Long> tenantIds) {
        ArrayList<CompanyPackageExportDto> companyPackageExportDtos = new ArrayList<CompanyPackageExportDto>();
        for (int i = 0; i < companyIds.size(); ++i) {
            Company company = this.companyService.findById(companyIds.get(i));
            Optional optionalTenant = this.tenantDao.findById((Object)tenantIds.get(i));
            if (!optionalTenant.isPresent()) continue;
            Tenant tenant = (Tenant)optionalTenant.get();
            CompanyPackageExportDto dto = new CompanyPackageExportDto();
            dto.setTaxNum(company.getTaxNum());
            dto.setTenantCode(tenant.getTenantCode());
            CompanyServiceRelModel.Request.Query query = new CompanyServiceRelModel.Request.Query();
            query.setTenantId(tenant.getTenantId());
            query.setCompanyId(company.getCompanyId());
            List companyServiceRels = this.companyServiceRelDao.findAll(CompanyServiceRelQueryHelper.querySpecification((CompanyServiceRelModel.Request.Query)query), EntityGraphs.named((String)"CompanyServiceRel.graph.service-package"));
            if (CollectionUtils.isNotEmpty((Collection)companyServiceRels)) {
                if (1 == ((CompanyServiceRel)companyServiceRels.get(0)).getStatus()) {
                    dto.setStatusName("\u542f\u7528");
                } else if (0 == ((CompanyServiceRel)companyServiceRels.get(0)).getStatus()) {
                    dto.setStatusName("\u505c\u7528");
                }
                dto.setPackageCodes(companyServiceRels.stream().map(CompanyServiceRel::getServicePackage).map(ServicePackage::getServicePackageCode).collect(Collectors.joining("/")));
            }
            companyPackageExportDtos.add(dto);
        }
        return companyPackageExportDtos;
    }

    public List<CompanyPackageDTO> getBatchExportData(List<Long> companyIds, List<Long> tenantIds) {
        ArrayList<CompanyPackageDTO> companyPackageDTOList = new ArrayList<CompanyPackageDTO>();
        for (int i = 0; i < companyIds.size(); ++i) {
            Company company = this.companyService.findById(companyIds.get(i));
            Optional optionalTenant = this.tenantDao.findById((Object)tenantIds.get(i));
            if (!optionalTenant.isPresent()) continue;
            Tenant tenant = (Tenant)optionalTenant.get();
            CompanyServiceRelModel.Request.Query query = new CompanyServiceRelModel.Request.Query();
            query.setTenantId(tenant.getTenantId());
            query.setCompanyId(company.getCompanyId());
            List companyServiceRels = this.companyServiceRelDao.findAll(CompanyServiceRelQueryHelper.querySpecification((CompanyServiceRelModel.Request.Query)query), EntityGraphs.named((String)"CompanyServiceRel.graph.service-package"));
            if (!CollectionUtils.isNotEmpty((Collection)companyServiceRels)) continue;
            String statusName = 1 == ((CompanyServiceRel)companyServiceRels.get(0)).getStatus() ? "\u542f\u7528" : "\u505c\u7528";
            companyServiceRels.stream().map(CompanyServiceRel::getServicePackage).forEach(servicePackage -> {
                CompanyPackageDTO dto = new CompanyPackageDTO();
                dto.setStatusName(statusName);
                dto.setTaxNum(company.getTaxNum());
                dto.setTenantName(tenant.getTenantName());
                dto.setTenantCode(tenant.getTenantCode());
                dto.setCompanyName(company.getCompanyName());
                dto.setPackageCode(servicePackage.getServicePackageCode());
                dto.setPackageName(servicePackage.getServicePackageName());
                companyPackageDTOList.add(dto);
            });
        }
        return companyPackageDTOList;
    }
}

