/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.company.service.impl;

import com.xforceplus.api.model.CompanyModel;
import com.xforceplus.business.company.service.CompanyService;
import com.xforceplus.business.excel.BusinessType;
import com.xforceplus.business.excel.SimpleExcelWriter;
import com.xforceplus.business.excel.company.CompanyConfigDTO;
import com.xforceplus.business.excel.reader.Context;
import com.xforceplus.business.excel.writer.ExcelConfigBusinessType;
import com.xforceplus.business.service.ExcelWriteService;
import com.xforceplus.entity.Company;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class CompanyConfigExcelExportServiceImpl
implements ExcelWriteService {
    private final CompanyService companyService;

    public CompanyConfigExcelExportServiceImpl(CompanyService companyService) {
        this.companyService = companyService;
    }

    @Override
    public BusinessType getBusinessType() {
        return ExcelConfigBusinessType.COMPANY_CONFIG_EXCEL_FILE;
    }

    @Override
    public void write(Context context) {
        CompanyModel.Request.Query query = context.getParam("P_QUERY", CompanyModel.Request.Query.class);
        Sort sort = context.getParam("P_SORT", Sort.class);
        List<String> sheetNames = Arrays.asList(query.getSheets());
        SimpleExcelWriter simpleExcelWriter = context.getSimpleExcelWriter();
        Integer maxPageSize = context.getMaxPageSize();
        for (String sheetName : sheetNames) {
            Page<Company> page;
            if (!"\u670d\u52a1\u914d\u7f6e".equals(sheetName)) continue;
            PageRequest pageable = PageRequest.of((int)0, (int)1000, (Sort)sort.and(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"})));
            do {
                page = this.companyService.page(query, (Pageable)pageable);
                Page configPageDTO = page.map(e -> {
                    CompanyConfigDTO dto = new CompanyConfigDTO();
                    dto.setCompanyName(e.getCompanyName());
                    dto.setCompanyTax(StringUtils.trimToEmpty((String)e.getTaxNum()));
                    dto.setInspectionServiceFlag(String.valueOf(e.getInspectionServiceFlag()));
                    dto.setTraditionAuthenFlag(String.valueOf(e.getTraditionAuthenFlag()));
                    dto.setSpeedInspectionChannelFlag(String.valueOf(e.getSpeedInspectionChannelFlag()));
                    return dto;
                });
                simpleExcelWriter.fill(sheetName, configPageDTO.getContent());
                pageable = pageable.next();
            } while (page.hasNext() && page.getNumber() < maxPageSize);
            simpleExcelWriter.param("SUCCESS_SIZE", this.calcSuccessSize(page));
        }
    }
}

