/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.company.service.impl;

import com.alibaba.excel.event.AnalysisEventListener;
import com.xforceplus.business.company.service.CompanyService;
import com.xforceplus.business.enums.ActionTypeEnum;
import com.xforceplus.business.excel.BusinessType;
import com.xforceplus.business.excel.ExcelSheet;
import com.xforceplus.business.excel.company.CompanyConfigDTO;
import com.xforceplus.business.excel.reader.Context;
import com.xforceplus.business.excel.reader.MessageRow;
import com.xforceplus.business.excel.reader.SimpleDataReadListener;
import com.xforceplus.business.excel.writer.ExcelConfigBusinessType;
import com.xforceplus.business.service.ExcelReaderService;
import com.xforceplus.domain.company.CompanyConfigurationDto;
import com.xforceplus.utils.excel.exception.ImportException;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CompanyConfigImportServiceImpl
implements ExcelReaderService {
    @Autowired
    private CompanyService companyService;

    @Override
    public BusinessType getBusinessType() {
        return ExcelConfigBusinessType.COMPANY_CONFIG_EXCEL_FILE;
    }

    @Override
    public Context importExcel(Context context) {
        List<ExcelSheet> sheets = context.getExcelBook().getExcelSheets();
        for (ExcelSheet sheet : sheets) {
            MessageRow messageRows = new MessageRow(sheet.getSheetName());
            AnalysisEventListener excelDataListener = SimpleDataReadListener.listener(context, rows -> this.saveCompanyConfigData(messageRows, context, (List<CompanyConfigDTO>)rows));
            context.getSimpleExcelReader().read(CompanyConfigDTO.class, excelDataListener);
        }
        return context;
    }

    public void saveCompanyConfigData(MessageRow messageRows, Context context, List<CompanyConfigDTO> list) {
        for (CompanyConfigDTO companyConfigDTO : list) {
            try {
                if (!companyConfigDTO.getValidatedStatus().booleanValue()) {
                    messageRows.fail(companyConfigDTO.getRowIndex(), companyConfigDTO.getValidatedMessage());
                    continue;
                }
                if (ActionTypeEnum.UPDATE.getActionCode().equals(companyConfigDTO.getAction())) {
                    CompanyConfigurationDto dto = new CompanyConfigurationDto();
                    BeanUtils.copyProperties((Object)companyConfigDTO, (Object)dto);
                    this.companyService.saveConfigurationImport(dto);
                    messageRows.success(companyConfigDTO.getRowIndex());
                    continue;
                }
                messageRows.fail(companyConfigDTO.getRowIndex(), "\u64cd\u4f5c\u65b9\u5f0f\u975e\u6cd5");
            }
            catch (ImportException ex) {
                messageRows.fail(companyConfigDTO.getRowIndex(), ex.getMessage());
            }
        }
        context.messageRow(messageRows.getSheetName(), messageRows);
    }
}

