/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.company.service.impl;

import com.alibaba.excel.event.AnalysisEventListener;
import com.xforceplus.business.company.service.CompanyServicePackageService;
import com.xforceplus.business.enums.ActionTypeEnum;
import com.xforceplus.business.excel.BusinessType;
import com.xforceplus.business.excel.ExcelSheet;
import com.xforceplus.business.excel.company.CompanyPackageDTO;
import com.xforceplus.business.excel.reader.Context;
import com.xforceplus.business.excel.reader.MessageRow;
import com.xforceplus.business.excel.reader.SimpleDataReadListener;
import com.xforceplus.business.excel.writer.ExcelConfigBusinessType;
import com.xforceplus.business.service.ExcelReaderService;
import com.xforceplus.business.tenant.service.TenantService;
import com.xforceplus.dao.CompanyServiceRelDao;
import com.xforceplus.entity.CompanyServiceRel;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CompanyPackageImportServiceImpl
implements ExcelReaderService {
    private static final Logger log = LoggerFactory.getLogger(CompanyPackageImportServiceImpl.class);
    @Autowired
    protected TenantService tenantService;
    @Autowired
    private CompanyServicePackageService companyServicePackageService;
    @Autowired
    private CompanyServiceRelDao companyServiceRelDao;

    @Override
    public BusinessType getBusinessType() {
        return ExcelConfigBusinessType.COMPANY_PACKAGE_IMPORT;
    }

    @Override
    public Context importExcel(Context context) {
        List<ExcelSheet> sheets = context.getExcelBook().getExcelSheets();
        for (ExcelSheet sheet : sheets) {
            MessageRow messageRows = new MessageRow(sheet.getSheetName());
            AnalysisEventListener excelDataListener = SimpleDataReadListener.listener(context, rows -> this.saveCompanyPackageData(messageRows, context, (List<CompanyPackageDTO>)rows));
            context.getSimpleExcelReader().read(CompanyPackageDTO.class, excelDataListener);
        }
        return context;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveCompanyPackageData(MessageRow messageRows, Context context, List<CompanyPackageDTO> list) {
        Iterator<CompanyPackageDTO> iterator = list.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                context.messageRow(messageRows.getSheetName(), messageRows);
                return;
            }
            CompanyPackageDTO e = iterator.next();
            try {
                block12: {
                    if (!e.getValidatedStatus().booleanValue()) {
                        messageRows.fail(e.getRowIndex(), e.getValidatedMessage());
                        continue;
                    }
                    if (ActionTypeEnum.BIND.getActionCode().equals(e.getAction())) {
                        List companyServiceRel = this.companyServiceRelDao.findByTenantCodeAndTaxNumAndPackageCode(e.getTenantCode(), e.getTaxNum(), e.getPackageCode());
                        if (!CollectionUtils.isEmpty((Collection)companyServiceRel)) {
                            messageRows.fail(e.getRowIndex(), "\u8bb0\u5f55\u5df2\u5b58\u5728\uff0c\u8df3\u8fc7\u4e0d\u5904\u7406");
                            continue;
                        }
                        this.companyServicePackageService.bindCompanyAndPackage(e.getTenantCode(), e.getTaxNum(), e.getPackageCode(), 1, false);
                    } else {
                        if (ActionTypeEnum.UNBIND.getActionCode().equals(e.getAction())) {
                            List companyServiceRels = this.companyServiceRelDao.findByTenantCodeAndTaxNumAndPackageCode(e.getTenantCode(), e.getTaxNum(), e.getPackageCode());
                            if (!CollectionUtils.isEmpty((Collection)companyServiceRels)) {
                                for (CompanyServiceRel companyServiceRel : companyServiceRels) {
                                    this.companyServicePackageService.unbindCompanyPackages(companyServiceRel.getId());
                                }
                                break block12;
                            } else {
                                messageRows.fail(e.getRowIndex(), "\u975e\u6cd5\u7684\u79df\u6237\u4ee3\u7801\u6216\u8005\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u6216\u8005\u4ea7\u54c1\u670d\u52a1\u5305\u4ee3\u7801");
                                continue;
                            }
                        }
                        messageRows.fail(e.getRowIndex(), "\u64cd\u4f5c\u65b9\u5f0f\u975e\u6cd5");
                    }
                }
                messageRows.success(e.getRowIndex());
            }
            catch (Exception ex) {
                messageRows.fail(e.getRowIndex(), ex.getMessage());
                continue;
            }
            break;
        }
    }
}

