/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.company.service.impl;

import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.fastjson.JSON;
import com.xforceplus.business.company.service.CompanyService;
import com.xforceplus.business.excel.BusinessType;
import com.xforceplus.business.excel.ExcelSheet;
import com.xforceplus.business.excel.company.CompanyUpdateImportDto;
import com.xforceplus.business.excel.reader.Context;
import com.xforceplus.business.excel.reader.MessageRow;
import com.xforceplus.business.excel.reader.SimpleDataReadListener;
import com.xforceplus.business.excel.writer.ExcelConfigBusinessType;
import com.xforceplus.business.service.ExcelReaderService;
import com.xforceplus.entity.Company;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CompanyUpdateImportServiceImpl
implements ExcelReaderService {
    public static final String ACTION_COMPANY_NAME = "\u516c\u53f8\u540d\u79f0";
    public static final String ACTION_TAX_NUM = "\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801";
    public static final List<String> ACTION_LISTS = Arrays.asList("\u516c\u53f8\u540d\u79f0", "\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801");
    private static final Logger logger = LoggerFactory.getLogger(CompanyUpdateImportServiceImpl.class);
    @Resource
    private CompanyService companyService;

    @Override
    public BusinessType getBusinessType() {
        return ExcelConfigBusinessType.COMPANY_NAME_TAX_NUM_IMPORT;
    }

    @Override
    public Context importExcel(Context context) {
        List<ExcelSheet> sheets = context.getExcelBook().getExcelSheets();
        for (ExcelSheet sheet : sheets) {
            MessageRow messageRows = new MessageRow(sheet.getSheetName());
            AnalysisEventListener excelDataListener = SimpleDataReadListener.listener(context, rows -> this.saveData(messageRows, context, (List<CompanyUpdateImportDto>)rows));
            context.getSimpleExcelReader().read(CompanyUpdateImportDto.class, excelDataListener);
        }
        return context;
    }

    public void saveData(MessageRow messageRows, Context context, List<CompanyUpdateImportDto> list) {
        logger.info("list:{}", (Object)JSON.toJSONString(list));
        for (CompanyUpdateImportDto e : list) {
            block8: {
                logger.info("e:{}", (Object)JSON.toJSONString((Object)e));
                if (!e.getValidatedStatus().booleanValue()) {
                    messageRows.fail(e.getRowIndex(), e.getValidatedMessage());
                    continue;
                }
                try {
                    boolean result;
                    if (ACTION_COMPANY_NAME.equals(e.getAction())) {
                        result = this.updateCompanyNameByTaxNum(messageRows, e);
                        if (!result) {
                            continue;
                        }
                    } else {
                        result = this.updateCompanyTaxNumByTaxNum(messageRows, e);
                        if (!result) {
                        }
                    }
                    break block8;
                }
                catch (Exception ex) {
                    messageRows.fail(e.getRowIndex(), e.getAction() + "\u5931\u8d25");
                }
                continue;
            }
            messageRows.success(e.getRowIndex());
        }
        context.messageRow(messageRows.getSheetName(), messageRows);
    }

    private boolean updateCompanyTaxNumByTaxNum(MessageRow messageRows, CompanyUpdateImportDto dto) {
        String taxNum = StringUtils.trimToEmpty((String)dto.getTaxNum());
        String oldTaxNum = StringUtils.trimToEmpty((String)dto.getOldTaxNum());
        if (StringUtils.isBlank((CharSequence)taxNum)) {
            messageRows.fail(dto.getRowIndex(), "\u66f4\u65b0\u540e\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (taxNum.equals(oldTaxNum)) {
            messageRows.fail(dto.getRowIndex(), "\u539f\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0e\u66f4\u65b0\u540e\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u76f8\u7b49\uff0c\u4e0d\u80fd\u66f4\u65b0");
            return false;
        }
        Optional<Company> optional = this.findByTaxNum(oldTaxNum);
        if (!optional.isPresent()) {
            messageRows.fail(dto.getRowIndex(), "\u516c\u53f8\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e3a\uff1a\u3010" + oldTaxNum + "\u3011\u5bf9\u5e94\u516c\u53f8\u4e0d\u5b58\u5728");
            return false;
        }
        String companyName = StringUtils.trimToEmpty((String)dto.getCompanyName());
        Company company = optional.get();
        company.setTaxNum(taxNum);
        this.companyService.saveAndFlush(company);
        return true;
    }

    private boolean updateCompanyNameByTaxNum(MessageRow messageRows, CompanyUpdateImportDto dto) {
        if (StringUtils.isBlank((CharSequence)dto.getOldCompanyName())) {
            messageRows.fail(dto.getRowIndex(), "\u539f\u516c\u53f8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (StringUtils.isBlank((CharSequence)dto.getCompanyName())) {
            messageRows.fail(dto.getRowIndex(), "\u66f4\u65b0\u540e\u516c\u53f8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (dto.getOldCompanyName().equals(dto.getCompanyName())) {
            messageRows.fail(dto.getRowIndex(), "\u539f\u516c\u53f8\u540d\u79f0\u4e0e\u66f4\u65b0\u540e\u516c\u53f8\u540d\u79f0\u76f8\u7b49\uff0c\u4e0d\u80fd\u66f4\u65b0");
            return false;
        }
        String taxNum = StringUtils.trimToEmpty((String)dto.getOldTaxNum());
        Optional<Company> optional = this.findByTaxNum(taxNum);
        if (!optional.isPresent()) {
            messageRows.fail(dto.getRowIndex(), "\u516c\u53f8\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e3a\uff1a\u3010" + taxNum + "\u3011\u5bf9\u5e94\u516c\u53f8\u4e0d\u5b58\u5728");
            return false;
        }
        String companyName = StringUtils.trimToEmpty((String)dto.getCompanyName());
        Company company = optional.get();
        company.setCompanyName(companyName);
        this.companyService.saveAndFlush(company);
        return true;
    }

    private Optional<Company> findByTaxNum(String taxNum) {
        List<Company> companies = this.companyService.findListByTaxNum(taxNum);
        if (CollectionUtils.isEmpty(companies)) {
            return Optional.empty();
        }
        return Optional.of(companies.get(0));
    }
}

