/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.conf.controller;

import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.api.common.Uri;
import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.model.PrivacyAgreementModel;
import com.xforceplus.business.conf.service.PrivacyAgreementService;
import com.xforceplus.domain.validation.ValidationGroup;
import com.xforceplus.entity.PrivacyAgreement;
import io.geewit.core.jackson.view.View;
import io.geewit.data.jpa.essential.domain.PageableFactory;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
public class PrivacyAgreementController
implements Uri {
    private final PrivacyAgreementService privacyAgreementService;

    public PrivacyAgreementController(PrivacyAgreementService privacyAgreementService) {
        this.privacyAgreementService = privacyAgreementService;
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6307\u5b9a\u9690\u79c1\u534f\u8bae")
    @GetMapping(value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/privacy-agreements"})
    public ResponseEntity<Page<PrivacyAgreement>> page(@SpringQueryMap PrivacyAgreementModel.Request.Query query, Pageable pageable) {
        Pageable currentPageable = PageableFactory.ofDefaultSort((Pageable)pageable, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}));
        Page<PrivacyAgreement> page = this.privacyAgreementService.page(query, currentPageable);
        return ResponseEntity.ok(page);
    }

    @ApiOperation(value="\u67e5\u8be2\u6307\u5b9a\u9690\u79c1\u534f\u8bae")
    @GetMapping(value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/privacy-agreements/{id}"})
    public ResponseEntity<PrivacyAgreement> getPrivacyAgreement(@PathVariable(value="id") long id) {
        PrivacyAgreement privacyAgreement = this.privacyAgreementService.get(id);
        privacyAgreement.sortProtocols();
        return ResponseEntity.ok((Object)privacyAgreement);
    }

    @ApiOperation(value="\u65b0\u589e\u9690\u79c1\u534f\u8bae")
    @PostMapping(value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/privacy-agreements"})
    public ResponseEntity<PrivacyAgreement> addPrivacyAgreement(@RequestBody @Validated(value={ValidationGroup.OnCreate.class}) PrivacyAgreementModel.Request.Save model) {
        PrivacyAgreement privacyAgreement = this.privacyAgreementService.add(model);
        return ResponseEntity.ok((Object)privacyAgreement);
    }

    @ApiOperation(value="\u4fee\u6539\u9690\u79c1\u534f\u8bae")
    @PutMapping(value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/privacy-agreements/{id}"})
    public ResponseEntity<PrivacyAgreement> updatePrivacyAgreement(@PathVariable(value="id") long id, @RequestBody @Validated(value={ValidationGroup.OnUpdate.class}) PrivacyAgreementModel.Request.Save model) {
        model.setId(Long.valueOf(id));
        PrivacyAgreement result = this.privacyAgreementService.update(model);
        return ResponseEntity.ok((Object)result);
    }

    @ApiOperation(value="\u542f\u7528\u9690\u79c1\u534f\u8bae")
    @PutMapping(value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/privacy-agreements/{id}/enable"})
    public ResponseEntity<PrivacyAgreement> enable(@PathVariable(value="id") long id) {
        PrivacyAgreement result = this.privacyAgreementService.enable(id);
        return ResponseEntity.ok((Object)result);
    }

    @ApiOperation(value="\u7981\u7528\u9690\u79c1\u534f\u8bae")
    @PutMapping(value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/privacy-agreements/{id}/disable"})
    public ResponseEntity<PrivacyAgreement> disable(@PathVariable(value="id") long id) {
        PrivacyAgreement result = this.privacyAgreementService.disable(id);
        return ResponseEntity.ok((Object)result);
    }

    @ApiOperation(value="\u522a\u9664\u9690\u79c1\u534f\u8bae")
    @DeleteMapping(value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/privacy-agreements/{id}"})
    public ResponseEntity<String> deletePrivacyAgreement(@PathVariable(value="id") long id) {
        this.privacyAgreementService.delete(id);
        return ResponseEntity.ok();
    }

    @ApiOperation(value="\u67e5\u8be2\u6700\u65b0\u7248\u672c\u9690\u79c1\u534f\u8bae")
    @JsonView(value={View.class})
    @GetMapping(value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/privacy-agreements/latest"})
    public ResponseEntity<PrivacyAgreement> getLatestPrivacyAgreement(@RequestParam(value="companyType", required=false, defaultValue="1") Integer companyType) {
        PrivacyAgreement privacyAgreement = this.privacyAgreementService.getLatest(companyType);
        return ResponseEntity.ok((Object)privacyAgreement);
    }

    @ApiOperation(value="\u63d0\u5347\u9690\u79c1\u534f\u8bae\u8be6\u60c5\u5e8f\u53f7")
    @PutMapping(value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/privacy-agreements/protocols/{protocolId}/sort-up"})
    public ResponseEntity<String> sortUpProtocols(@PathVariable(value="protocolId") long protocolId) {
        this.privacyAgreementService.sortProtocols(protocolId, Sort.Direction.ASC);
        return ResponseEntity.ok();
    }

    @ApiOperation(value="\u964d\u4f4e\u9690\u79c1\u534f\u8bae\u8be6\u60c5\u5e8f\u53f7")
    @PutMapping(value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/privacy-agreements/protocols/{protocolId}/sort-down"})
    public ResponseEntity<String> sortDownProtocols(@PathVariable(value="protocolId") long protocolId) {
        this.privacyAgreementService.sortProtocols(protocolId, Sort.Direction.DESC);
        return ResponseEntity.ok();
    }
}

