/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.conf.controller;

import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.api.common.Uri;
import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.model.SysEnumModel;
import com.xforceplus.business.conf.service.SysEnumService;
import com.xforceplus.domain.validation.ValidationGroup;
import com.xforceplus.entity.SysEnum;
import io.geewit.core.jackson.view.View;
import io.geewit.data.jpa.essential.domain.PageableFactory;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
public class SysEnumController
implements Uri {
    private SysEnumService sysEnumService;

    public SysEnumController(SysEnumService sysEnumService) {
        this.sysEnumService = sysEnumService;
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u679a\u4e3e\u503c\u4fe1\u606f")
    @JsonView(value={View.class})
    @GetMapping(value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/sys-enum/page"})
    public ResponseEntity<Page<SysEnum>> page(@SpringQueryMap SysEnumModel.Query query, Pageable pageable) {
        Pageable currentPageable = PageableFactory.ofDefaultSort((Pageable)pageable, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}));
        Page<SysEnum> page = this.sysEnumService.page(query, currentPageable);
        return ResponseEntity.ok(page);
    }

    @ApiOperation(value="\u67e5\u8be2\u4e00\u7ec4\u679a\u4e3e\u503c\u4fe1\u606f")
    @GetMapping(value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/sys-enum/enum-group"})
    @JsonView(value={View.class})
    public ResponseEntity<List<SysEnum>> getEnumGroup(@RequestParam(value="enumGroupName", required=true) String enumGroupName) {
        List<SysEnum> enumList = this.sysEnumService.getByEnumGroupName(enumGroupName);
        return ResponseEntity.ok(enumList);
    }

    @ApiOperation(value="\u522a\u9664\u4e00\u7ec4\u679a\u4e3e\u503c")
    @DeleteMapping(value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/sys-enum/enum-group"})
    public ResponseEntity<String> deleteByGroupName(@RequestParam(value="enumGroupName", required=true) String enumGroupName) {
        this.sysEnumService.deleteByGroupName(enumGroupName);
        return ResponseEntity.ok();
    }

    @ApiOperation(value="\u5220\u9664\u5355\u4e2a\u679a\u4e3e\u503c\u4fe1\u606f")
    @DeleteMapping(value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/sys-enum/enum-item/{id}"})
    public ResponseEntity<String> deleteSysEnum(@PathVariable(value="id") long id) {
        this.sysEnumService.delete(id);
        return ResponseEntity.ok();
    }

    @ApiOperation(value="\u65b0\u589e\u679a\u4e3e\u503c\u4fe1\u606f")
    @PostMapping(value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/sys-enum/enum-item"})
    public ResponseEntity<SysEnum> addSysEnum(@RequestBody @Validated(value={ValidationGroup.OnCreate.class}) SysEnumModel.Save model) {
        SysEnum sysEnum = this.sysEnumService.add(model);
        return ResponseEntity.ok((Object)sysEnum);
    }

    @ApiOperation(value="\u66f4\u65b0\u679a\u4e3e\u503c\u4fe1\u606f")
    @PutMapping(value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/sys-enum/enum-item"})
    public ResponseEntity<SysEnum> updateSysEnum(@RequestBody @Validated(value={ValidationGroup.OnCreate.class}) SysEnumModel.Update model) {
        SysEnum sysEnum = this.sysEnumService.update(model);
        return ResponseEntity.ok((Object)sysEnum);
    }
}

