/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.conf.service;

import com.xforceplus.api.model.PrivacyAgreementModel;
import com.xforceplus.dao.PrivacyAgreementDao;
import com.xforceplus.dao.PrivacyAgreementProtocolDao;
import com.xforceplus.domain.conf.PrivacyAgreementDto;
import com.xforceplus.entity.PrivacyAgreement;
import com.xforceplus.entity.PrivacyAgreementProtocol;
import com.xforceplus.query.PrivacyAgreementQueryHelper;
import io.geewit.data.jpa.essential.domain.EntityGraphs;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PrivacyAgreementService {
    private static final Logger log = LoggerFactory.getLogger(PrivacyAgreementService.class);
    private static final Integer ENABLE = 1;
    private static final Integer DISABLE = 0;
    private final PrivacyAgreementDao privacyAgreementDao;
    private final PrivacyAgreementProtocolDao privacyAgreementProtocolDao;

    public PrivacyAgreementService(PrivacyAgreementDao privacyAgreementDao, PrivacyAgreementProtocolDao privacyAgreementProtocolDao) {
        this.privacyAgreementDao = privacyAgreementDao;
        this.privacyAgreementProtocolDao = privacyAgreementProtocolDao;
    }

    public Page<PrivacyAgreement> page(PrivacyAgreementModel.Request.Query query, Pageable pageable) {
        return this.privacyAgreementDao.findAll(PrivacyAgreementQueryHelper.querySpecification((PrivacyAgreementModel.Request.Query)query), pageable);
    }

    @Transactional(rollbackFor={Exception.class})
    public PrivacyAgreement add(PrivacyAgreementModel.Request.Save model) {
        PrivacyAgreementModel.Request.Query query = new PrivacyAgreementModel.Request.Query();
        query.setVersion(model.getVersion());
        List privacyAgreements = this.privacyAgreementDao.findAll(PrivacyAgreementQueryHelper.querySpecification((PrivacyAgreementModel.Request.Query)query), EntityGraphs.named((String)"PrivacyAgreement.graph"));
        Optional<PrivacyAgreement> existPrivacyAgreementOptional = privacyAgreements.stream().filter(Objects::nonNull).findFirst();
        if (existPrivacyAgreementOptional.isPresent()) {
            throw new IllegalArgumentException("\u5df2\u5b58\u5728\u7248\u672c\u4e3a:" + model.getVersion() + "\u7684\u9690\u79c1\u534f\u8bae");
        }
        PrivacyAgreement privacyAgreement = new PrivacyAgreement();
        privacyAgreement.setContent(model.getContent());
        privacyAgreement.setVersion(model.getVersion());
        privacyAgreement.setCompanyType((Integer)ObjectUtils.defaultIfNull((Object)model.getCompanyType(), (Object)1));
        privacyAgreement.setStatus((Integer)ObjectUtils.defaultIfNull((Object)model.getStatus(), (Object)1));
        privacyAgreement = (PrivacyAgreement)this.privacyAgreementDao.saveAndFlush((Object)privacyAgreement);
        if (model.getProtocols() != null && !model.getProtocols().isEmpty()) {
            Long privacyAgreementId = privacyAgreement.getId();
            List protocols = model.getProtocols().stream().map(protocolModel -> {
                PrivacyAgreementProtocol agreementProtocol = new PrivacyAgreementProtocol();
                agreementProtocol.setAgreementId(privacyAgreementId);
                agreementProtocol.setTitle(protocolModel.getTitle());
                agreementProtocol.setUrl(protocolModel.getUrl());
                return agreementProtocol;
            }).collect(Collectors.toList());
            privacyAgreement.setProtocols(protocols);
            privacyAgreement.arrangeProtocolsOrdinal();
            this.privacyAgreementProtocolDao.saveAllAndFlush(protocols);
        }
        return privacyAgreement;
    }

    public PrivacyAgreement get(long id) {
        return (PrivacyAgreement)this.privacyAgreementDao.findById((Serializable)Long.valueOf(id), EntityGraphs.named((String)"PrivacyAgreement.graph")).orElseThrow(() -> new IllegalArgumentException("\u65e0\u6cd5\u627e\u5230\u8be5\u4fe1\u606f(" + id + ")"));
    }

    @Transactional(rollbackFor={Exception.class})
    public PrivacyAgreement update(PrivacyAgreementModel.Request.Save model) {
        PrivacyAgreement existEntity = (PrivacyAgreement)this.privacyAgreementDao.findById((Serializable)model.getId(), EntityGraphs.named((String)"PrivacyAgreement.graph")).orElseThrow(() -> new IllegalArgumentException("\u65e0\u6cd5\u627e\u5230\u8be5\u4fe1\u606f(" + model.getId() + ")"));
        if (StringUtils.isNotBlank((CharSequence)model.getVersion()) && !model.getVersion().equals(existEntity.getVersion())) {
            PrivacyAgreementModel.Request.Query query = new PrivacyAgreementModel.Request.Query();
            query.setVersion(model.getVersion());
            long count = this.privacyAgreementDao.count(PrivacyAgreementQueryHelper.querySpecification((PrivacyAgreementModel.Request.Query)query));
            if (count > 0L) {
                throw new IllegalArgumentException("\u8be5version(" + model.getVersion() + ")\u7684\u9690\u79c1\u534f\u8bae\u5df2\u5b58\u5728");
            }
            existEntity.setVersion(model.getVersion());
        }
        if (StringUtils.isNotBlank((CharSequence)model.getContent())) {
            existEntity.setContent(model.getContent());
        }
        if (model.getCompanyType() != null && model.getCompanyType() > 0) {
            existEntity.setCompanyType(model.getCompanyType());
        }
        if (model.getStatus() != null) {
            existEntity.setStatus(model.getStatus());
        }
        existEntity = (PrivacyAgreement)this.privacyAgreementDao.saveAndFlush((Object)existEntity);
        if (model.getProtocols() != null && !model.getProtocols().isEmpty()) {
            this.privacyAgreementProtocolDao.deleteByAgreementId(existEntity.getId().longValue());
            ArrayList<PrivacyAgreementProtocol> protocols = new ArrayList<PrivacyAgreementProtocol>(model.getProtocols().size());
            List protocolModels = model.getProtocols();
            for (PrivacyAgreementModel.Request.ProtocolSave protocolModel : protocolModels) {
                PrivacyAgreementProtocol agreementProtocol = new PrivacyAgreementProtocol();
                agreementProtocol.setAgreementId(existEntity.getId());
                agreementProtocol.setTitle(protocolModel.getTitle());
                agreementProtocol.setUrl(protocolModel.getUrl());
                protocols.add(agreementProtocol);
            }
            existEntity.setProtocols(protocols);
            existEntity.arrangeProtocolsOrdinal();
            this.privacyAgreementProtocolDao.saveAllAndFlush(protocols);
        }
        return existEntity;
    }

    @Transactional(rollbackFor={Exception.class})
    public PrivacyAgreement enable(long id) {
        PrivacyAgreement existEntity = (PrivacyAgreement)this.privacyAgreementDao.findById((Object)id).orElseThrow(() -> new IllegalArgumentException("\u65e0\u6cd5\u627e\u5230\u8be5\u4fe1\u606f(" + id + ")"));
        existEntity.setStatus(ENABLE);
        return (PrivacyAgreement)this.privacyAgreementDao.saveAndFlush((Object)existEntity);
    }

    @Transactional(rollbackFor={Exception.class})
    public PrivacyAgreement disable(Long id) {
        PrivacyAgreement existEntity = (PrivacyAgreement)this.privacyAgreementDao.findById((Object)id).orElseThrow(() -> new IllegalArgumentException("\u65e0\u6cd5\u627e\u5230\u8be5\u4fe1\u606f(" + id + ")"));
        existEntity.setStatus(DISABLE);
        return (PrivacyAgreement)this.privacyAgreementDao.saveAndFlush((Object)existEntity);
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(Long id) {
        PrivacyAgreement existEntity = (PrivacyAgreement)this.privacyAgreementDao.findById((Object)id).orElseThrow(() -> new IllegalArgumentException("\u65e0\u6cd5\u627e\u5230\u8be5\u4fe1\u606f(" + id + ")"));
        this.privacyAgreementDao.deleteById(existEntity.getId());
        this.privacyAgreementProtocolDao.deleteByAgreementId(existEntity.getId().longValue());
    }

    public PrivacyAgreement getLatest(Integer companyType) {
        Optional privacyAgreementOptional = this.privacyAgreementDao.findFirstByStatusAndCompanyTypeOrderByCreateTimeDesc(1, companyType.intValue());
        if (privacyAgreementOptional.isPresent()) {
            PrivacyAgreement privacyAgreement = (PrivacyAgreement)privacyAgreementOptional.get();
            List protocols = this.privacyAgreementProtocolDao.findByAgreementId(privacyAgreement.getId().longValue());
            privacyAgreement.setProtocols(protocols);
            privacyAgreement.sortProtocols();
            return privacyAgreement;
        }
        throw new IllegalArgumentException("\u6c92\u6709\u627e\u5230\u6709\u6548\u7684\u4fe1\u606f\uff01");
    }

    @Transactional(rollbackFor={Exception.class})
    public void sortProtocols(long protocolId, Sort.Direction direction) {
        if (direction == null) {
            return;
        }
        Long agreementId = this.privacyAgreementProtocolDao.findAgreementIdById(protocolId);
        if (agreementId == null) {
            throw new IllegalArgumentException("\u9690\u79c1\u534f\u8bae\u8be6\u60c5(" + protocolId + ")\u4e0d\u5b58\u5728agreementId\u7684");
        }
        List protocols = this.privacyAgreementProtocolDao.findByAgreementId(agreementId.longValue());
        PrivacyAgreementProtocol protocol = protocols.stream().filter(p -> p.getId().equals(protocolId)).findFirst().orElseThrow(() -> new IllegalArgumentException("\u4e0d\u5b58\u5728id(" + protocolId + ")\u7684\u9690\u79c1\u534f\u8bae\u8be6\u60c5"));
        PrivacyAgreementDto.sortProtocols((List)protocols);
        PrivacyAgreementDto.arrangeProtocolsOrdinal((List)protocols);
        int ordinal = (Integer)ObjectUtils.defaultIfNull((Object)protocol.getOrdinal(), (Object)1);
        if (ordinal >= protocols.size()) {
            this.privacyAgreementProtocolDao.updateOrdinalById(protocol.getId().longValue(), ordinal);
        } else {
            int anotherOrdinal = direction.isAscending() ? ordinal - 1 : ordinal + 1;
            if (anotherOrdinal > 0 && anotherOrdinal <= protocols.size()) {
                this.privacyAgreementProtocolDao.updateOrdinalById(protocol.getId().longValue(), anotherOrdinal);
            }
            protocols.stream().filter(p -> p.getOrdinal().equals(anotherOrdinal)).findFirst().ifPresent(anotherProtocol -> this.privacyAgreementProtocolDao.updateOrdinalById(anotherProtocol.getId().longValue(), ordinal));
        }
    }
}

