/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.conf.service;

import com.xforceplus.api.model.SysEnumModel;
import com.xforceplus.dao.SysEnumDao;
import com.xforceplus.entity.SysEnum;
import com.xforceplus.query.SysEnumQueryHelper;
import io.geewit.core.utils.reflection.BeanUtils;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class SysEnumService {
    private final SysEnumDao sysEnumDao;

    public SysEnumService(SysEnumDao sysEnumDao) {
        this.sysEnumDao = sysEnumDao;
    }

    public List<SysEnum> getByEnumGroupName(String enumGroupName) {
        return this.sysEnumDao.findByEnumGroupName(enumGroupName);
    }

    public Page<SysEnum> page(SysEnumModel.Query query, Pageable pageable) {
        Page page = this.sysEnumDao.findAll(SysEnumQueryHelper.querySpecification((SysEnumModel.Query)query), pageable);
        return page;
    }

    public SysEnum add(SysEnumModel.Save model) {
        SysEnumModel.Query query = new SysEnumModel.Query();
        query.setEnumGroupName(model.getEnumGroupName());
        query.setEnumName(model.getEnumName());
        List sysEnumList = this.sysEnumDao.findAll(SysEnumQueryHelper.querySpecification((SysEnumModel.Query)query));
        if (CollectionUtils.isNotEmpty((Collection)sysEnumList)) {
            throw new IllegalArgumentException("\u4fe1\u606f\u5df2\u7ecf\u5b58\u5728:" + model.getEnumGroupName());
        }
        SysEnum sys = new SysEnum();
        sys.setEnumGroupName(model.getEnumGroupName());
        sys.setEnumName(model.getEnumName());
        sys.setEnumValue(model.getEnumValue());
        sys.setEnumSeq(model.getEnumSeq());
        sys.setEnumType(model.getEnumType());
        return (SysEnum)this.sysEnumDao.saveAndFlush((Object)sys);
    }

    public SysEnum update(SysEnumModel.Update model) {
        Optional sysEnumOptional = this.sysEnumDao.findById((Object)model.getId());
        if (!sysEnumOptional.isPresent()) {
            throw new IllegalArgumentException("\u4fe1\u606f\u4e0d\u5b58\u5728:" + model.getEnumGroupName());
        }
        SysEnum existEntity = (SysEnum)sysEnumOptional.get();
        BeanUtils.copyProperties((Object)model, (Object)existEntity);
        return (SysEnum)this.sysEnumDao.saveAndFlush((Object)existEntity);
    }

    public void deleteByGroupName(String enumGroupName) {
        SysEnumModel.Query query = new SysEnumModel.Query();
        query.setEnumGroupName(enumGroupName);
        List sysEnumList = this.sysEnumDao.findAll(SysEnumQueryHelper.querySpecification((SysEnumModel.Query)query));
        if (CollectionUtils.isEmpty((Collection)sysEnumList)) {
            throw new IllegalArgumentException("\u4fe1\u606f\u4e0d\u5b58\u5728:" + enumGroupName);
        }
        sysEnumList.stream().forEach(arg_0 -> ((SysEnumDao)this.sysEnumDao).delete(arg_0));
    }

    public void delete(long id) {
        Optional sysEnumOptional = this.sysEnumDao.findById((Object)id);
        if (!sysEnumOptional.isPresent()) {
            throw new IllegalArgumentException("\u4fe1\u606f\u4e0d\u5b58\u5728:" + id);
        }
        this.sysEnumDao.deleteById((Object)id);
    }
}

