/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.excel;

import com.xforceplus.business.excel.file.ExcelFileDTO;
import com.xforceplus.business.excel.reader.Context;
import com.xforceplus.dao.ExcelFileStoreDao;
import com.xforceplus.entity.ExcelFileStore;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import java.util.Date;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public class AbstractExcelProcess {
    private static final Logger log = LoggerFactory.getLogger(AbstractExcelProcess.class);
    protected ExcelFileStoreDao excelFileStoreDao;

    public AbstractExcelProcess(ExcelFileStoreDao excelFileStoreDao) {
        this.excelFileStoreDao = excelFileStoreDao;
    }

    protected void beforeSet(Context context) {
        UserInfoHolder.put((IAuthorizedUser)context.getAuthorizedUser());
    }

    protected void beforeUpdate(ExcelFileDTO fileDTO) {
        Optional importFileOptional = this.excelFileStoreDao.findById((Object)fileDTO.getId());
        if (!importFileOptional.isPresent()) {
            log.warn("\u6ca1\u6709\u627e\u5230\u6570\u636e:ImportFileDTO-id:{}", (Object)fileDTO.getId());
            return;
        }
        ExcelFileStore excelFileStore = (ExcelFileStore)importFileOptional.get();
        excelFileStore.setBeginDate(fileDTO.getBeginDate());
        excelFileStore.setStatus(fileDTO.getStatus());
        excelFileStore.setReadTime(fileDTO.getReadTime());
        this.excelFileStoreDao.saveAndFlush((Object)excelFileStore);
    }

    @Transactional(rollbackFor={Exception.class})
    public void afterUpdate(ExcelFileDTO fileDTO) {
        Optional importFileOptional = this.excelFileStoreDao.findById((Object)fileDTO.getId());
        if (!importFileOptional.isPresent()) {
            log.warn("\u6ca1\u6709\u627e\u5230\u6570\u636e:ImportFileDTO-id:{}", (Object)fileDTO.getId());
            return;
        }
        ExcelFileStore excelFileStore = (ExcelFileStore)importFileOptional.get();
        excelFileStore.setStatus(fileDTO.getStatus());
        excelFileStore.setEndDate(fileDTO.getEndDate());
        excelFileStore.setTargetFileId(fileDTO.getTargetFileId());
        excelFileStore.setEndDate(new Date());
        excelFileStore.setCostTime(fileDTO.getCostTime());
        excelFileStore.setTotalSize(fileDTO.getTotalSize());
        excelFileStore.setSuccessSize(fileDTO.getSuccessSize());
        excelFileStore.setResultState(fileDTO.getResultState());
        excelFileStore.setStatus(Integer.valueOf(3));
        if (StringUtils.isNotBlank((CharSequence)fileDTO.getTargetFileName())) {
            excelFileStore.setTargetFileName(fileDTO.getTargetFileName());
        }
        excelFileStore.setMessage(fileDTO.getMessage());
        this.excelFileStoreDao.saveAndFlush((Object)excelFileStore);
    }

    protected Long costTime(Date beginDate, Date endDate) {
        Long costTime = 0L;
        if (beginDate != null && endDate != null) {
            costTime = endDate.getTime() - beginDate.getTime();
        }
        return costTime;
    }

    protected void clear() {
        UserInfoHolder.clearContext();
    }
}

