/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.excel;

import java.text.MessageFormat;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="excel.file.download")
public class ExcelConfig
implements ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(ExcelConfig.class);
    private static ExcelConfig excelConfig;
    @Value(value="${excel.file.download.url}")
    private String url;
    @Value(value="${xforce.tenant.service.url.prefix:/api}")
    private String pathPrefix;
    @Value(value="${xforce.tenant.service.api.version}")
    private String apiVersion;
    @Value(value="${excel.notice.appId:1}")
    private Long appId;
    private String httpUrl;
    @Value(value="${excel.export.limit.max.size:5000}")
    private Integer limitMaxSize;
    @Value(value="${excel.max.rerun.read.time:3}")
    private Integer maxRerunReadTime;
    private int expiredDay = 3;
    private ApplicationContext applicationContext;

    public static Integer getMaxRerunReadTime() {
        return ExcelConfig.excelConfig.maxRerunReadTime;
    }

    public static Integer getLimitMaxSize() {
        return ExcelConfig.excelConfig.limitMaxSize;
    }

    public static String getDownloadUrl() {
        return ExcelConfig.excelConfig.httpUrl;
    }

    public static int getExpiredDay() {
        return ExcelConfig.excelConfig.expiredDay;
    }

    public static Long getAppId() {
        return ExcelConfig.excelConfig.appId;
    }

    @PostConstruct
    public void init() {
        excelConfig = this;
        try {
            if (StringUtils.isBlank((CharSequence)this.apiVersion)) {
                this.apiVersion = "";
            }
            ExcelConfig.excelConfig.httpUrl = MessageFormat.format(this.url, this.pathPrefix, this.apiVersion);
            ExcelConfig.excelConfig.httpUrl = StringUtils.lowerCase((String)ExcelConfig.excelConfig.httpUrl);
            logger.info("excelConfig.httpUrl:{}", (Object)this.httpUrl);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e.getCause());
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

