/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.excel;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.model.AccountModel;
import com.xforceplus.api.model.CompanyModel;
import com.xforceplus.api.model.OrgModel;
import com.xforceplus.api.model.RoleModel;
import com.xforceplus.api.model.UserModel;
import com.xforceplus.business.account.service.AccountService;
import com.xforceplus.business.company.service.CompanyServicePackageService;
import com.xforceplus.business.file.service.FileService;
import com.xforceplus.business.tenant.service.OrgService;
import com.xforceplus.business.tenant.service.RoleService;
import com.xforceplus.business.tenant.service.UserService;
import com.xforceplus.dao.TenantDao;
import com.xforceplus.domain.account.AccountType;
import com.xforceplus.domain.device.InvoiceType;
import com.xforceplus.entity.Account;
import com.xforceplus.entity.OrgStruct;
import com.xforceplus.entity.Role;
import com.xforceplus.entity.User;
import com.xforceplus.tenant.security.core.domain.OrgType;
import com.xforceplus.utils.RegExUtil;
import com.xforceplus.utils.excel.ExcelUtils;
import com.xforceplus.utils.excel.exception.ImportException;
import io.geewit.core.exception.ProcessedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import javax.validation.Validator;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ExcelService {
    private static final Logger logger = LoggerFactory.getLogger(ExcelService.class);
    private final OrgService orgService;
    private final TenantDao tenantDao;
    private final CompanyServicePackageService companyServicePackageService;
    private final RoleService roleService;
    private final AccountService accountService;
    private final UserService userService;
    private final Validator validator;
    private final FileService fileService;

    public ExcelService(OrgService orgService, TenantDao tenantDao, Validator validator, CompanyServicePackageService companyServicePackageService, RoleService roleService, AccountService accountService, UserService userService, FileService fileService) {
        this.orgService = orgService;
        this.tenantDao = tenantDao;
        this.validator = validator;
        this.companyServicePackageService = companyServicePackageService;
        this.roleService = roleService;
        this.accountService = accountService;
        this.userService = userService;
        this.fileService = fileService;
    }

    public ResponseEntity batchImportCompanies(MultipartFile file) {
        String template = "companyExcelCovertJson.json";
        List<CompanyModel.Request.Import> companies = ExcelUtils.list(file, template, CompanyModel.Request.Import.class);
        ArrayList<String> errMsg = new ArrayList<String>();
        HashSet tenantIds = Sets.newHashSet();
        int success = 0;
        int fail = 0;
        int index = 1;
        for (CompanyModel.Request.Import anImport : companies) {
            ArrayList<String> innerError = new ArrayList<String>();
            try {
                ++index;
                List<String> errorMessages = ExcelUtils.checkField(anImport, this.validator);
                if (!errorMessages.isEmpty()) {
                    for (String errorMessage : errorMessages) {
                        innerError.add("\u7b2c" + index + "\u884c\uff0c" + errorMessage);
                    }
                } else {
                    Long tenantId = this.tenantDao.findTenantIdByTenantCode(anImport.getTenantCode());
                    if (tenantId == null) {
                        innerError.add("\u7b2c" + index + "\u884c\uff0c\u79df\u6237code(" + anImport.getTenantName() + ")\u627e\u4e0d\u5230\u5bf9\u5e94\u79df\u6237");
                        continue;
                    }
                    anImport.setTenantId(tenantId.longValue());
                    tenantIds.add(tenantId);
                }
                this.orgService.saveCompany(anImport.getTenantId(), anImport);
                ++success;
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), (Throwable)e);
                ++fail;
                innerError.add(e.getMessage());
            }
            if (innerError.size() <= 0) continue;
            errMsg.add(((Object)innerError).toString());
        }
        ResponseEntity restResponse = new ResponseEntity();
        if (success > 0) {
            restResponse.setCode("1");
            restResponse.setMessage("\u5bfc\u5165\u6210\u529f " + success + " \u6761");
        } else {
            restResponse.setCode("0");
        }
        if (fail > 0) {
            Long fileId = this.fileService.uploadMsgExcel(errMsg);
            restResponse.setResult((Object)fileId);
            restResponse.setMessage("\u5bfc\u5165\u6210\u529f " + success + " \u6761, \u5bfc\u5165\u5931\u8d25 " + fail + " \u6761");
        }
        return restResponse;
    }

    public ResponseEntity batchImportCompanyPackages(MultipartFile file) {
        String template = "companyServicePackageExcelCovertJson.json";
        List<CompanyModel.Request.CompanyServicePackageExcel> companyServicePackages = ExcelUtils.list(file, template, CompanyModel.Request.CompanyServicePackageExcel.class);
        int success = 0;
        int fail = 0;
        int index = 1;
        ArrayList<String> errorMsg = new ArrayList<String>();
        for (CompanyModel.Request.CompanyServicePackageExcel companyServicePackageExcel : companyServicePackages) {
            try {
                List<String> errors = ExcelUtils.checkField(companyServicePackageExcel, this.validator);
                if (CollectionUtils.isEmpty(errors)) {
                    this.companyServicePackageService.bindCompanyAndPackage(companyServicePackageExcel.getTenantCode(), companyServicePackageExcel.getTaxNum(), companyServicePackageExcel.getServicePackageCode(), companyServicePackageExcel.getStatus(), false);
                } else {
                    int finalIndex = index;
                    errors = errors.stream().map(p -> "\u7b2c" + finalIndex + "\u884c\u6570\u636e" + p).collect(Collectors.toList());
                    errorMsg.addAll(errors);
                    ++fail;
                }
                ++success;
            }
            catch (Exception e) {
                ++fail;
                String message = "\u5bfc\u5165\u7b2c " + index + " \u884c\u5931\u8d25," + e.getMessage();
                logger.warn(message, (Throwable)e);
                errorMsg.add(message);
            }
            ++index;
        }
        ResponseEntity restResponse = new ResponseEntity();
        if (success > 0) {
            restResponse.setCode("1");
            restResponse.setMessage("\u5bfc\u5165\u6210\u529f " + success + " \u6761");
        } else {
            restResponse.setCode("0");
        }
        if (fail > 0) {
            Long fileId = this.fileService.uploadMsgExcel(errorMsg);
            restResponse.setResult((Object)fileId);
            restResponse.setMessage("\u5bfc\u5165\u6210\u529f " + success + " \u6761, \u5bfc\u5165\u5931\u8d25 " + fail + " \u6761");
        }
        return restResponse;
    }

    public ResponseEntity<Long> batchImportRoles(Long tenantId, MultipartFile file) {
        String template = "roleExcelCovertJson.json";
        List<RoleModel.Request.RoleImportExcel> roleImportExcelList = ExcelUtils.list(file, template, RoleModel.Request.RoleImportExcel.class);
        int success = 0;
        int fail = 0;
        int index = 1;
        ArrayList<String> errorMsg = new ArrayList<String>();
        for (RoleModel.Request.RoleImportExcel roleImport : roleImportExcelList) {
            try {
                ExcelUtils.validField(roleImport, this.validator);
                RoleModel.Request.Query query = new RoleModel.Request.Query();
                query.setRoleCode(roleImport.getRoles().replaceAll("/", ";"));
                query.setTenantId(tenantId);
                query.setType(Integer.valueOf(0));
                List<Role> roleList = this.roleService.list(query, Sort.unsorted());
                if (CollectionUtils.isEmpty(roleList)) {
                    ++fail;
                    errorMsg.add("\u5bfc\u5165\u7b2c " + index + " \u884c\u5931\u8d25,\u5f53\u524d\u89d2\u8272\u4e0d\u5b58\u5728");
                    continue;
                }
                HashSet<Role> roles = new HashSet<Role>(roleList);
                String accountName = roleImport.getAccount();
                AccountModel.Request.Query accQuery = new AccountModel.Request.Query();
                if (accountName.contains("@")) {
                    accQuery.setEmail(accountName);
                } else if (RegExUtil.checkMobile((String)accountName)) {
                    accQuery.setTelPhone(accountName);
                } else {
                    accQuery.setUsername(accountName);
                }
                List<Account> accounts = this.accountService.list(accQuery, Sort.unsorted());
                if (CollectionUtils.isEmpty(accounts)) {
                    ++fail;
                    errorMsg.add("\u5bfc\u5165\u7b2c " + index + " \u884c\u5931\u8d25,\u5f53\u524d\u8d26\u53f7\u4e0d\u5b58\u5728");
                    continue;
                }
                UserModel.Request.Query userQuery = new UserModel.Request.Query();
                userQuery.setAccountId(accounts.get(0).getAccountId());
                userQuery.setTenantId(tenantId);
                List<User> userList = this.userService.list(userQuery, Sort.unsorted());
                if (CollectionUtils.isEmpty(userList)) {
                    ++fail;
                    errorMsg.add("\u5bfc\u5165\u7b2c " + index + " \u884c\u5931\u8d25,\u5f53\u524d\u7528\u6237\u4e0d\u5b58\u5728");
                    continue;
                }
                HashSet<User> users = new HashSet<User>(userList);
                RoleModel.Request.BindUsers bindUsers = new RoleModel.Request.BindUsers();
                bindUsers.setOverwrite(true);
                bindUsers.setUserIds(users.stream().map(User::getId).collect(Collectors.toList()));
                for (User user : users) {
                    this.userService.bindRoles(user, null, roles.stream().map(Role::getId).collect(Collectors.toSet()), null, null, null, true, false, true);
                }
                this.userService.commitBindUserRoles();
                UserService.removeCachedRoleOrgUserRelsThreadLocal();
                ++success;
            }
            catch (Exception e) {
                ++fail;
                String message = "\u5bfc\u5165\u7b2c " + index + " \u884c\u5931\u8d25," + e.getMessage();
                logger.warn(message, (Throwable)e);
                errorMsg.add(message);
            }
            ++index;
        }
        Long fileId = this.fileService.uploadMsgExcel(errorMsg);
        ResponseEntity restResponse = new ResponseEntity();
        restResponse.setCode(null == fileId ? "1" : "0");
        restResponse.setResult((Object)fileId);
        restResponse.setMessage("\u5bfc\u5165\u6210\u529f " + success + " \u6761, \u5bfc\u5165\u5931\u8d25 " + fail + " \u6761");
        return restResponse;
    }

    public ResponseEntity batchImportUsers(Long tenantId, MultipartFile file) {
        String template = "user_batch_import.json";
        List<UserModel.Request.UserImportExcel> userImportExcelList = ExcelUtils.list(file, template, UserModel.Request.UserImportExcel.class);
        int success = 0;
        int fail = 0;
        int index = 1;
        ArrayList<String> errorMsg = new ArrayList<String>();
        for (UserModel.Request.UserImportExcel userImport : userImportExcelList) {
            try {
                ExcelUtils.validField(userImport, this.validator);
                this.saveUserFromExcel(userImport, tenantId);
                ++success;
            }
            catch (Exception e) {
                ++fail;
                String message = "\u5bfc\u5165\u7b2c " + index + " \u884c\u5931\u8d25," + e.getMessage();
                logger.error(message, (Throwable)e);
                errorMsg.add(message);
            }
            ++index;
        }
        Long fileId = this.fileService.uploadMsgExcel(errorMsg);
        ResponseEntity restResponse = new ResponseEntity();
        restResponse.setCode(null == fileId ? "1" : "0");
        restResponse.setResult((Object)fileId);
        restResponse.setMessage("\u5bfc\u5165\u6210\u529f " + success + " \u6761, \u5bfc\u5165\u5931\u8d25 " + fail + " \u6761");
        return restResponse;
    }

    private void saveUserFromExcel(UserModel.Request.UserImportExcel userImport, Long tenantId) throws ImportException {
        ArrayList<String> errorMsg = new ArrayList<String>();
        if (this.validInvoiceType(userImport.getInvoiceType())) {
            errorMsg.add("\u53d1\u7968\u7c7b\u578b\u4e0d\u6b63\u786e");
            throw new ImportException(errorMsg);
        }
        userImport.setTicketOpeningTerminal(userImport.getTicketOpeningTerminal().replaceAll("/", ","));
        userImport.setInvoiceType(userImport.getInvoiceType().replaceAll("/", ","));
        if (!StringUtils.isBlank((CharSequence)userImport.getStatus()) && !this.checkUserStatus(userImport.getStatus())) {
            errorMsg.add("\u7528\u6237\u72b6\u6001\u4e0d\u6b63\u786e");
            throw new ImportException(errorMsg);
        }
        List<Object> orgStructList = Lists.newArrayList();
        if (!StringUtils.isBlank((CharSequence)userImport.getUserOrgs()) && CollectionUtils.isEmpty((Collection)(orgStructList = this.validOrgsExist(tenantId, userImport.getUserOrgs())))) {
            errorMsg.add("\u4e0d\u5b58\u5728\u7684\u7ec4\u7ec7code");
            throw new ImportException(errorMsg);
        }
        Optional tenant = this.tenantDao.findById((Object)tenantId);
        if (!tenant.isPresent()) {
            errorMsg.add("\u4e0d\u5b58\u5728\u7684\u79df\u6237");
            throw new ImportException(errorMsg);
        }
        UserModel.Request.Create userModel = new UserModel.Request.Create();
        userModel.setType(AccountType.PHONE_EMAIL);
        AccountModel.Request.Create accountModel = new AccountModel.Request.Create();
        BeanUtils.copyProperties((Object)userImport, (Object)userModel);
        BeanUtils.copyProperties((Object)userImport, (Object)accountModel);
        accountModel.setTelPhone(userImport.getUserPhone());
        userModel.setStatus(StringUtils.isBlank((CharSequence)userImport.getStatus()) ? null : Integer.valueOf(Integer.parseInt(userImport.getStatus())));
        accountModel.setUsername(userImport.getAccountNum());
        accountModel.setChangePasswordFlag(!StringUtils.isBlank((CharSequence)userImport.getChangePasswordFlag()) && Boolean.parseBoolean(userImport.getChangePasswordFlag()));
        if (userImport.getAccountNum().contains("@")) {
            accountModel.setEmail(userImport.getAccountNum());
            userModel.setUserEmailAddr(userImport.getAccountNum());
            accountModel.setTelPhone(null);
        } else if (RegExUtil.checkMobile((String)userImport.getAccountNum())) {
            accountModel.setTelPhone(userImport.getAccountNum());
            accountModel.setEmail(null);
        } else {
            accountModel.setUsername(userImport.getAccountNum());
            accountModel.setEmail(null);
            accountModel.setTelPhone(null);
            userModel.setType(AccountType.OTHER);
        }
        if (userImport.getUserSex().contains("\u7537")) {
            userModel.setUserSex(Integer.valueOf(0));
        } else {
            userModel.setUserSex(Integer.valueOf(1));
        }
        Set orgCodes = orgStructList.stream().map(OrgStruct::getOrgCode).collect(Collectors.toSet());
        userModel.setOrgCodes(orgCodes);
        userModel.setAccount(accountModel);
        userModel.setTenantId(tenantId);
        this.userService.save(userModel, true, true, true, true, true, false);
    }

    private List<OrgStruct> validOrgsExist(long tenantId, String orgsStr) {
        return this.orgService.findByTenantIdAndOrgCode(tenantId, orgsStr.replaceAll("/", ";"));
    }

    private boolean validInvoiceType(String invoiceType) {
        if (StringUtils.isBlank((CharSequence)invoiceType)) {
            return true;
        }
        List invoiceTypeList = InvoiceType.toList();
        String[] invoiceTypes = invoiceType.split("/");
        return Arrays.stream(invoiceTypes).anyMatch(item -> !invoiceTypeList.contains(item));
    }

    private boolean checkUserStatus(String userStatus) {
        HashSet statusSet = Sets.newHashSet((Object[])new String[]{"0", "1", "2", "3"});
        return statusSet.contains(userStatus);
    }

    public ResponseEntity processExcel(Long tenantId, MultipartFile file) {
        OrgModel.Request.ExcelModel currentOrg;
        List<OrgModel.Request.ExcelModel> excelModels;
        HashMap<String, OrgStruct> currentSaveOrgs = new HashMap<String, OrgStruct>();
        String template = "orgExcelCovertJson.json";
        int success = 0;
        int fail = 0;
        int i = 0;
        ArrayList<String> errorMsg = new ArrayList<String>();
        try {
            excelModels = ExcelUtils.list(file, template, OrgModel.Request.ExcelModel.class);
        }
        catch (ProcessedException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException("\u5bfc\u5165\u53c2\u6570\u89e3\u6790\u5f02\u5e38");
        }
        int size = excelModels.size();
        if (CollectionUtils.isEmpty(excelModels) || size > 1000) {
            throw new IllegalArgumentException("\u5bfc\u5165\u6570\u636e\u4e3a\u7a7a\u6216\u8005\u5927\u4e8e1000\u6761");
        }
        while (i < size && (currentOrg = excelModels.get(i)) != null) {
            ++i;
            if (currentSaveOrgs.containsKey(currentOrg.getOrgCode())) {
                ++success;
                continue;
            }
            try {
                this.processOrgs(tenantId, currentSaveOrgs, currentOrg, excelModels);
                ++success;
            }
            catch (ImportException e) {
                ++fail;
                for (String msg : e.getMsgError()) {
                    errorMsg.add("\u5bfc\u5165\u7b2c " + i + " \u884c\u5931\u8d25," + msg);
                }
            }
            catch (Exception e) {
                ++fail;
                logger.error("\u5bfc\u5165\u7b2c " + i + " \u884c\u5931\u8d25," + e.getMessage(), (Throwable)e);
                logger.error("-----------------------------&&**-----------------------------");
                errorMsg.add("\u5bfc\u5165\u7b2c " + i + " \u884c\u5931\u8d25," + e.getMessage());
            }
        }
        ResponseEntity restResponse = new ResponseEntity();
        if (fail > 0) {
            logger.warn(StringUtils.join((Object[])new List[]{errorMsg}), (Object)",");
            Long fileId = this.fileService.uploadMsgExcel(errorMsg);
            restResponse.setResult((Object)fileId);
            restResponse.setCode("0");
            restResponse.setMessage("\u5bfc\u5165\u6210\u529f " + success + " \u6761, \u5bfc\u5165\u5931\u8d25 " + fail + " \u6761");
        } else {
            if (success > 0) {
                restResponse.setMessage("\u5bfc\u5165\u6210\u529f " + success + " \u6761");
            }
            restResponse.setCode("1");
        }
        return restResponse;
    }

    private void processOrgs(Long tenantId, Map<String, OrgStruct> currentSaveOrgs, OrgModel.Request.ExcelModel org, List<OrgModel.Request.ExcelModel> excelModels) throws ImportException {
        if (currentSaveOrgs.containsKey(org.getOrgCode())) {
            return;
        }
        OrgModel.Request.ExcelModel curOrg = org;
        Stack<OrgModel.Request.ExcelModel> models = new Stack<OrgModel.Request.ExcelModel>();
        OrgStruct parentOrg = null;
        while (null == parentOrg) {
            if (StringUtils.isBlank((CharSequence)curOrg.getParentOrgCode()) || StringUtils.isBlank((CharSequence)curOrg.getOrgCode())) {
                throw new ImportException(Lists.newArrayList((Object[])new String[]{"\u5f53\u524d\u7ec4\u7ec7\u7684\u4ee3\u7801\u548c\u7236\u7ec4\u7ec7\u4ee3\u7801\u4e3a\u7a7a!"}));
            }
            if (OrgType.GROUP.value() == curOrg.getOrgType().intValue()) {
                curOrg.setOrgType(Integer.valueOf(OrgType.NORMAL.value()));
            }
            if (curOrg.getOrgType() > 2 || curOrg.getOrgType() < 0) {
                throw new ImportException(Lists.newArrayList((Object[])new String[]{"\u7ec4\u7ec7\u7c7b\u578b\u4e0d\u6b63\u786e!"}));
            }
            models.add(curOrg);
            parentOrg = this.orgService.findParentOrgType(tenantId, curOrg);
            if (null != parentOrg || null != (curOrg = this.orgService.findParentOrgInModels(org, excelModels))) continue;
            throw new ImportException(Lists.newArrayList((Object[])new String[]{"\u5f53\u524d\u7ec4\u7ec7\u7684\u7236\u7ec4\u7ec7\u4e0d\u5b58\u5728!"}));
        }
        do {
            OrgModel.Request.ExcelModel excelOrg = (OrgModel.Request.ExcelModel)models.pop();
            OrgStruct innerParentOrg = this.orgService.findParentOrgType(tenantId, curOrg);
            this.orgService.saveSingle(tenantId, currentSaveOrgs, excelOrg, innerParentOrg);
        } while (!models.isEmpty());
    }
}

