/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.excel;

import com.xforceplus.business.excel.reader.ExcelReaderUtils;
import com.xforceplus.business.excel.writer.ExcelWriteUtils;
import com.xforceplus.business.service.ExcelReaderService;
import com.xforceplus.business.service.ExcelWriteService;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.CollectionUtils;

@Configuration
public class ExcelServiceConfiguration
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(ExcelServiceConfiguration.class);
    private final ApplicationContext applicationContext;

    public ExcelServiceConfiguration(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void destroy() throws Exception {
        ExcelReaderUtils.clear();
        ExcelWriteUtils.clear();
    }

    public void afterPropertiesSet() throws Exception {
        Map beans = this.applicationContext.getBeansOfType(ExcelReaderService.class);
        if (CollectionUtils.isEmpty((Map)beans)) {
            return;
        }
        for (Map.Entry entry : beans.entrySet()) {
            ExcelReaderUtils.put(((ExcelReaderService)entry.getValue()).getBusinessType(), (ExcelReaderService)entry.getValue());
            ExcelReaderUtils.putHeader(((ExcelReaderService)entry.getValue()).getBusinessType(), ((ExcelReaderService)entry.getValue()).getSheetHeaderNumber());
        }
        Map writeServiceMap = this.applicationContext.getBeansOfType(ExcelWriteService.class);
        if (CollectionUtils.isEmpty((Map)writeServiceMap)) {
            return;
        }
        for (Map.Entry entry : writeServiceMap.entrySet()) {
            ExcelWriteUtils.put(((ExcelWriteService)entry.getValue()).getBusinessType(), (ExcelWriteService)entry.getValue());
        }
    }
}

