/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.excel.reader;

import com.xforceplus.business.excel.BusinessType;
import com.xforceplus.business.service.ExcelReaderService;
import java.util.HashMap;
import java.util.Map;

public class ExcelReaderUtils {
    private static final Map<BusinessType, ExcelReaderService> EXCEL_READER_SERVICE_HASH_MAP = new HashMap<BusinessType, ExcelReaderService>();
    private static final Map<BusinessType, Map<String, Integer>> SHEET_HEADER_MAP = new HashMap<BusinessType, Map<String, Integer>>();

    private ExcelReaderUtils() {
    }

    public static ExcelReaderService getExcelReader(BusinessType businessType) {
        if (EXCEL_READER_SERVICE_HASH_MAP.containsKey(businessType)) {
            return EXCEL_READER_SERVICE_HASH_MAP.get(businessType);
        }
        return null;
    }

    public static void put(BusinessType businessType, ExcelReaderService readerService) {
        EXCEL_READER_SERVICE_HASH_MAP.put(businessType, readerService);
    }

    public static void clear() {
        EXCEL_READER_SERVICE_HASH_MAP.clear();
    }

    public static void putHeader(BusinessType businessType, Map<String, Integer> headerMap) {
        SHEET_HEADER_MAP.put(businessType, headerMap);
    }

    public static Map<String, Integer> getHeaderNum(BusinessType businessType) {
        return SHEET_HEADER_MAP.get(businessType);
    }
}

