/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.excel.reader;

import com.alibaba.excel.exception.ExcelAnalysisException;
import com.xforceplus.business.excel.ExcelBook;
import com.xforceplus.business.excel.ExcelConfig;
import com.xforceplus.business.excel.ExcelHandler;
import com.xforceplus.business.excel.MessageExcelWriterHandler;
import com.xforceplus.business.notice.dto.NoticeMessage;
import com.xforceplus.business.notice.service.NoticeService;
import com.xforceplus.utils.StrUtils;
import io.geewit.web.utils.SpringContextUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageExcelReaderHandler
implements ExcelHandler {
    private static final Logger logger = LoggerFactory.getLogger(MessageExcelWriterHandler.class);
    private NoticeService noticeService = (NoticeService)SpringContextUtil.getBean(NoticeService.class);

    @Override
    public void before(ExcelBook excelBook) {
        logger.info("{}\u53d1\u9001\u6d88\u606f\u901a\u77e5", (Object)excelBook.getName());
        String noticeKey = "IMP_START";
        Object[] params = new Object[]{excelBook.getName()};
        if (excelBook.getException() != null) {
            logger.error(excelBook.getException().getMessage(), excelBook.getException().getCause());
            noticeKey = "IMP_EXCEPTION";
            params = new Object[]{excelBook.getName(), excelBook.getException().getMessage()};
        }
        this.sendNoticeMessage(excelBook, noticeKey, params);
    }

    @Override
    public void after(ExcelBook excelBook) {
        logger.info("{}\u53d1\u9001\u6d88\u606f\u901a\u77e5", (Object)excelBook.getName());
        String noticeKey = "IMP_SUCCESS";
        String successSize = this.dataSize(excelBook, "SUCCESS_SIZE");
        String failSize = this.dataSize(excelBook, "FAIL_SIZE");
        String totalSize = this.dataSize(excelBook, "TOTAL_SIZE");
        String downloadUrl = ExcelConfig.getDownloadUrl();
        logger.info("\u53d1\u9001\u6d88\u606f\u901a\u77e5-after,downloadUrl:{}", (Object)downloadUrl);
        Object[] params = new Object[]{excelBook.getName(), totalSize, successSize, downloadUrl + excelBook.getTargetFileId(), String.valueOf(excelBook.getTargetFileId())};
        Integer resultState = this.getResultState(excelBook, "RESULT_STATE");
        Exception e = excelBook.getException();
        if (e != null) {
            String message = e.getMessage();
            logger.error(message, e.getCause());
            noticeKey = "IMP_EXCEPTION";
            if (e instanceof ExcelAnalysisException) {
                String messageZh = "Excel\u89e3\u6790 \u6570\u636e\u8f6c\u6362\u5931\u8d25\u4e3a:\"" + StrUtils.matcherZh(e.getMessage(), " ") + "\"";
                params = new Object[]{excelBook.getName(), messageZh};
            } else {
                if (StringUtils.isNotEmpty((CharSequence)message)) {
                    message = StrUtils.matcherZh(message, " ");
                }
                if (StringUtils.isBlank((CharSequence)message)) {
                    message = "\u7cfb\u7edf\u53d1\u751f\u9519\u8bef\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u6216\u8054\u7cfb\u8fd0\u8425\u4eba\u5458";
                }
                params = new Object[]{excelBook.getName(), message};
            }
        } else if (2 == resultState) {
            noticeKey = "IMP_PART_SUCCESS";
            params = new Object[]{excelBook.getName(), totalSize, successSize, failSize, downloadUrl + excelBook.getTargetFileId(), String.valueOf(excelBook.getTargetFileId())};
        } else if (3 == resultState) {
            noticeKey = "IMP_FAILED=";
            params = new Object[]{excelBook.getName(), totalSize, failSize, downloadUrl + excelBook.getTargetFileId(), String.valueOf(excelBook.getTargetFileId())};
        }
        this.sendNoticeMessage(excelBook, noticeKey, params);
    }

    protected void sendNoticeMessage(ExcelBook excelBook, String noticeKey, Object[] params) {
        try {
            NoticeMessage noticeMessage = NoticeMessage.builder().userId(excelBook.getUserId()).tenantId(excelBook.getTenantId()).key(noticeKey).params(params).build();
            this.sendNotice(noticeMessage);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public Integer getResultState(ExcelBook excelBook, String key) {
        Integer state = -1;
        try {
            state = Integer.parseInt(excelBook.getParams().get(key).toString());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return state;
    }

    private String dataSize(ExcelBook excelBook, String key) {
        if (excelBook.getParams().containsKey(key)) {
            return String.valueOf(excelBook.getParams().get(key));
        }
        return String.valueOf(0);
    }

    protected void sendNotice(NoticeMessage noticeMessage) {
        this.noticeService.sendExcelProcessNotice(noticeMessage.getExcelProcessNotice());
    }
}

