/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.excel.reader;

import com.google.api.client.repackaged.com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MessageRow {
    public static final String SUCCESS = "\u6210\u529f";
    public static final String FAIL = "\u5931\u8d25";
    private String sheetName;
    private Map<Integer, Row> rows;

    public MessageRow(String sheetName) {
        this.sheetName = sheetName;
        this.rows = new HashMap<Integer, Row>();
    }

    public MessageRow fail(Integer index, String message) {
        this.row(index, FAIL, message);
        return this;
    }

    public void putAll(Map<Integer, Row> rows) {
        this.rows.putAll(rows);
    }

    public Map<Integer, Row> getRows() {
        return this.rows;
    }

    public MessageRow success(Integer index) {
        this.row(index, SUCCESS, "");
        return this;
    }

    private synchronized void row(Integer index, String status, String message) {
        Row row = this.rows.containsKey(index) ? this.rows.get(index) : new Row();
        row.setIndex(index);
        row.setStatus(status);
        row.setMessage(message);
        this.rows.put(index, row);
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public String toString() {
        return "MessageRow(sheetName=" + this.getSheetName() + ", rows=" + this.getRows() + ")";
    }

    public class Row {
        private Integer index = 0;
        private List<String> messages = new ArrayList<String>();
        private String status;

        private Row() {
        }

        public Integer getIndex() {
            return this.index;
        }

        public void setIndex(Integer index) {
            this.index = index;
        }

        public String getMessage() {
            Collections.sort(this.messages);
            return Joiner.on((String)";").skipNulls().join(this.messages);
        }

        public void setMessage(String message) {
            this.messages.add(message);
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String toString() {
            return "MessageRow.Row(index=" + this.getIndex() + ", messages=" + this.messages + ", status=" + this.getStatus() + ")";
        }
    }
}

