/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.externalservice.base;

import com.xforceplus.business.externalservice.terminal.TerminalApi;
import com.xforceplus.tenant.security.client.feign.service.ClientService;
import com.xforceplus.tenant.security.client.feign.utils.FeignUtils;
import feign.Client;
import feign.Feign;
import feign.RequestInterceptor;
import feign.okhttp.OkHttpClient;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.core.io.ResourceLoader;
import org.springframework.stereotype.Component;

@AutoConfigureAfter(name={"tenantFeignConfiguration"})
@Component
public class AbstractRemoteService {
    private static final Logger log = LoggerFactory.getLogger(AbstractRemoteService.class);
    @Value(value="${remote.url.terminal-service}")
    protected String terminalServiceUrl;
    @Autowired
    @Qualifier(value="tenantOkHttpClient")
    protected okhttp3.OkHttpClient okHttpClient;
    protected TerminalApi terminalApi;
    @Autowired
    private ResourceLoader resourceLoader;
    @Autowired(required=false)
    @Qualifier(value="tenantTokenRequestInterceptor")
    private RequestInterceptor requestInterceptor;
    @Autowired(required=false)
    private ClientService clientService;

    protected OkHttpClient client() {
        OkHttpClient client = new OkHttpClient(this.okHttpClient);
        return client;
    }

    @PostConstruct
    public void init() {
        this.terminalApi = this.initTerminalApi();
    }

    private TerminalApi initTerminalApi() {
        Feign.Builder builder = FeignUtils.of((Client)this.client(), (ResourceLoader)this.resourceLoader, (ClientService)this.clientService);
        if (this.requestInterceptor != null) {
            builder.requestInterceptor(this.requestInterceptor);
        }
        return (TerminalApi)builder.target(TerminalApi.class, this.terminalServiceUrl);
    }
}

