/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.externalservice.terminal;

import com.xforceplus.business.externalservice.base.AbstractRemoteService;
import com.xforceplus.business.externalservice.terminal.model.MsConfigDeviceQueryRequest;
import com.xforceplus.business.externalservice.terminal.model.MsConfigTemialQueryRequest;
import com.xforceplus.business.externalservice.terminal.model.MsDeviceInfo;
import com.xforceplus.business.externalservice.terminal.model.MsDeviceQueryInfo;
import com.xforceplus.business.externalservice.terminal.model.MsPageInfo;
import com.xforceplus.business.externalservice.terminal.model.MsQueryDeviceResponse;
import com.xforceplus.business.externalservice.terminal.model.MsQueryTerminalResponse;
import com.xforceplus.business.externalservice.terminal.model.MsTerminalQueryInfo;
import com.xforceplus.business.externalservice.terminal.model.MsTerminalQueryResponseInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TerminalApiServiceImpl
extends AbstractRemoteService {
    private static final Logger log = LoggerFactory.getLogger(TerminalApiServiceImpl.class);
    private static final int DEVICE_PAGE_SIZE = 2000;

    public Map<String, MsTerminalQueryResponseInfo> getTerminalMap(List<String> terminalList) {
        HashSet<String> terminalSet = new HashSet<String>(terminalList);
        List partitionList = ListUtils.partition(new ArrayList<String>(terminalSet), (int)2000);
        HashMap<String, MsTerminalQueryResponseInfo> terminalQueryResponseInfoMap = new HashMap<String, MsTerminalQueryResponseInfo>(terminalSet.size());
        for (List tempList : partitionList) {
            MsConfigTemialQueryRequest queryRequest = new MsConfigTemialQueryRequest();
            MsPageInfo pageInfo = new MsPageInfo();
            pageInfo.setPageNo(1);
            pageInfo.setPageSize(tempList.size());
            queryRequest.setPageInfo(pageInfo);
            MsTerminalQueryInfo queryInfo = new MsTerminalQueryInfo();
            queryInfo.setTerminalUns(tempList);
            queryRequest.setTerminalInfo(queryInfo);
            MsQueryTerminalResponse response = null;
            try {
                response = this.terminalApi.getTerminalList(queryRequest);
            }
            catch (Exception e) {
                log.error("GetTerminalDetailError:{}", (Object)e.getMessage());
            }
            if (response != null && response.getCode() == 1) {
                List<MsTerminalQueryResponseInfo> terminalResponseList;
                if (response.getResult() == null || (terminalResponseList = response.getResult().getTerminals()) == null) continue;
                terminalQueryResponseInfoMap.putAll(terminalResponseList.stream().collect(Collectors.toMap(MsTerminalQueryResponseInfo::getTerminalUn, item -> item)));
                continue;
            }
            log.error("GetTerminalDetailError:{}", (Object)response);
        }
        return terminalQueryResponseInfoMap;
    }

    public Map<String, MsDeviceInfo> getDeviceMap(List<String> deviceList) {
        HashSet<String> deviceSet = new HashSet<String>(deviceList);
        HashMap<String, MsDeviceInfo> deviceQueryResponseInfoMap = new HashMap<String, MsDeviceInfo>(deviceSet.size());
        List partitionList = ListUtils.partition(new ArrayList<String>(deviceSet), (int)2000);
        for (List tempList : partitionList) {
            MsConfigDeviceQueryRequest queryRequest = new MsConfigDeviceQueryRequest();
            MsPageInfo pageInfo = new MsPageInfo();
            pageInfo.setPageNo(1);
            pageInfo.setPageSize(tempList.size());
            queryRequest.setPageInfo(pageInfo);
            MsDeviceQueryInfo queryInfo = new MsDeviceQueryInfo();
            queryInfo.setDeviceUns(tempList);
            queryRequest.setQueryInfo(queryInfo);
            MsQueryDeviceResponse response = this.terminalApi.getDeviceList(queryRequest);
            if (response != null && response.getCode() == 1) {
                List<MsDeviceInfo> deviceResponseList;
                if (response.getResult() == null || (deviceResponseList = response.getResult().getDevices()) == null) continue;
                deviceQueryResponseInfoMap.putAll(deviceResponseList.stream().collect(Collectors.toMap(MsDeviceInfo::getDeviceUn, item -> item)));
                continue;
            }
            log.error("GetDeviceDetailError:{}", (Object)response);
        }
        return deviceQueryResponseInfoMap;
    }
}

