/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.file.service;

import com.alibaba.excel.support.ExcelTypeEnum;
import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import com.google.common.eventbus.SubscriberExceptionContext;
import com.google.common.eventbus.SubscriberExceptionHandler;
import com.xforceplus.business.excel.BusinessType;
import com.xforceplus.business.excel.ExcelFile;
import com.xforceplus.business.excel.ExcelProcess;
import com.xforceplus.business.excel.file.ExcelFileDTO;
import com.xforceplus.business.excel.reader.Context;
import com.xforceplus.business.excel.reader.ExcelReaderUtils;
import com.xforceplus.business.excel.writer.ExcelConfigBusinessType;
import com.xforceplus.config.ThreadPoolConfig;
import com.xforceplus.dao.ExcelFileStoreDao;
import com.xforceplus.entity.ExcelFileStore;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.utils.FileUtils;
import com.xforceplus.utils.filetransfer.FileTransferUtilsService;
import io.geewit.web.utils.JsonUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.poifs.filesystem.FileMagic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ImportFileService
implements InitializingBean,
DisposableBean {
    public static final String ID = "id";
    public static final String EXCEL_IMPORT_PROCESS_EVENT_BUS = "ExcelImportProcessEventBus";
    public static final String ASYNC_EXCEL_IMPORT_PROCESS_EVENT_BUS = "ExcelImportProcessEventBus";
    public static final String FILE_SIZE_M = "M";
    private static final Logger log = LoggerFactory.getLogger(ImportFileService.class);
    private final ExcelFileStoreDao excelFileStoreDao;
    private final ExcelProcess excelImportProcess;
    private final FileTransferUtilsService fileTransferUtilsService;
    @Value(value="${excel.import.file.size:20}")
    private Integer excelFileSize;
    private AsyncEventBus asyncEventBus;
    private ThreadPoolExecutor threadPoolExecutor;
    public static final int MAX_NAME_LENGTH = 512;

    public ImportFileService(ExcelFileStoreDao excelFileStoreDao, @Qualifier(value="excelImportProcess") ExcelProcess excelImportProcess, FileTransferUtilsService fileTransferUtilsService) {
        this.excelFileStoreDao = excelFileStoreDao;
        this.excelImportProcess = excelImportProcess;
        this.fileTransferUtilsService = fileTransferUtilsService;
    }

    public void destroy() throws Exception {
        this.threadPoolExecutor.shutdown();
    }

    public void afterPropertiesSet() throws Exception {
        this.threadPoolExecutor = ThreadPoolConfig.config().name("excel-import-pool-").build();
        SubscriberExceptionHandlerImpl subscriberExceptionHandler = new SubscriberExceptionHandlerImpl();
        this.asyncEventBus = new AsyncEventBus((Executor)this.threadPoolExecutor, (SubscriberExceptionHandler)subscriberExceptionHandler);
        this.asyncEventBus.register((Object)new AsyncExcelProcessListener());
    }

    protected BusinessType isBusinessType(String businessType) {
        ExcelConfigBusinessType importBusinessType;
        if (StringUtils.isEmpty((CharSequence)(businessType = StringUtils.trimToEmpty((String)businessType).toUpperCase()))) {
            throw new IllegalArgumentException("\u60a8\u672c\u6b21\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20");
        }
        try {
            importBusinessType = ExcelConfigBusinessType.valueOf(businessType);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u4e1a\u52a1\u7c7b\u578b\u4e0d\u6b63\u786e\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20");
        }
        return importBusinessType;
    }

    /*
     * Exception decompiling
     */
    protected Long uploadToFileServer(MultipartFile file, String sourceFilePath, Long tenantId, Long userId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Boolean checkExcelFile(MultipartFile file) {
        if (null == file) {
            log.error("\u4e0a\u4f20\u6587\u4ef6\u4e0d\u5b58\u5728");
            throw new IllegalArgumentException("\u60a8\u672c\u6b21\u4e0a\u4f20\u7684\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u786e\u5b9a\u540e\u91cd\u65b0\u4e0a\u4f20");
        }
        String filenName = file.getOriginalFilename();
        if (StringUtils.length((CharSequence)filenName) > 512) {
            throw new IllegalArgumentException("\u6587\u4ef6\u540d\u957f\u5ea6\u987b\u5728512\u5b57\u7b26\u4e4b\u5185");
        }
        if (!StringUtils.endsWith((CharSequence)filenName, (CharSequence)ExcelTypeEnum.XLS.getValue()) && !StringUtils.endsWith((CharSequence)filenName, (CharSequence)ExcelTypeEnum.XLSX.getValue())) {
            throw new IllegalArgumentException("\u60a8\u4e0a\u4f20\u7684\u6587\u4ef6\u7c7b\u578b\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u4e0b\u8f7d\u6a21\u677f\u6587\u4ef6");
        }
        boolean sizeFlag = FileUtils.checkFileSize(file.getSize(), this.excelFileSize, FILE_SIZE_M);
        if (!sizeFlag) {
            log.warn("\u7528\u6237\u4e0aExcel\u6587\u4ef6\u5728\u4e8e20M");
            throw new IllegalArgumentException("\u4e0a\u4f20\u7684Excel\u6587\u4ef6\u4e0d\u5f97\u5927\u4e8e20M");
        }
        if (!this.isExcelFile(file).booleanValue()) {
            log.warn("\u7528\u6237\u4e0a\u4f20\u7684\u975e2007\u7248\u7684Excel\u6587\u4ef6");
            throw new IllegalArgumentException("\u60a8\u4e0a\u4f20\u7684\u6587\u4ef6\u7c7b\u578b\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u4e0b\u8f7d\u6a21\u677f\u6587\u4ef6");
        }
        return Boolean.TRUE;
    }

    private Boolean isExcelFile(MultipartFile file) {
        Boolean result = Boolean.FALSE;
        try (InputStream is = file.getInputStream();){
            FileMagic fileMagic = FileMagic.valueOf((InputStream)is);
            if (Objects.equals(fileMagic, FileMagic.OOXML)) {
                result = Boolean.TRUE;
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException("\u60a8\u4e0a\u4f20\u7684\u6587\u4ef6\u7c7b\u578b\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u4e0b\u8f7d\u6a21\u677f\u6587\u4ef6");
        }
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public ExcelFileStore createAndSaveFile(MultipartFile file, String businessType, Long userId, Long tenantId) {
        return this.createAndSaveFile(file, businessType, userId, tenantId, null);
    }

    @Transactional(rollbackFor={Exception.class})
    public ExcelFileStore createAndSaveFile(MultipartFile file, String businessType, Long userId, Long tenantId, Object params) {
        businessType = StringUtils.trimToEmpty((String)businessType).toUpperCase();
        log.info("businessType:{}", (Object)businessType);
        BusinessType importBusinessType = this.isBusinessType(businessType);
        return this.create(file, importBusinessType, userId, tenantId, params);
    }

    @Transactional(rollbackFor={Exception.class})
    public ExcelFileStore create(MultipartFile file, BusinessType businessType, Long userId, Long tenantId) {
        return this.create(file, businessType, userId, tenantId, null);
    }

    @Transactional(rollbackFor={Exception.class})
    public ExcelFileStore create(MultipartFile file, BusinessType businessType, Long userId, Long tenantId, Object params) {
        this.checkExcelFile(file);
        String sourceFilePath = ExcelFile.createExcelFilePath();
        Long sourceFileId = this.uploadToFileServer(file, sourceFilePath, tenantId, userId);
        log.info("fileName:{},sourceFileId:{}", (Object)file.getOriginalFilename(), (Object)sourceFileId);
        ExcelFileDTO excelFileDTO = new ExcelFileDTO();
        excelFileDTO.setBusinessType(businessType.getName());
        excelFileDTO.setTenantId(tenantId);
        excelFileDTO.setUserId(userId);
        excelFileDTO.setSourceFileId(sourceFileId);
        excelFileDTO.setSourceFilePath(sourceFilePath);
        excelFileDTO.setSourceFileName(file.getOriginalFilename());
        excelFileDTO.setStatus(1);
        excelFileDTO.setResultState(0);
        excelFileDTO.setReadTime(0);
        excelFileDTO.setExcelFileType(1);
        excelFileDTO.setCreateTime(new Date());
        if (null != params) {
            excelFileDTO.setParams(JsonUtils.toJson((Object)params));
        }
        excelFileDTO.setBatchSize(businessType.batchSize());
        return this.create(excelFileDTO, businessType);
    }

    @Transactional(rollbackFor={Exception.class})
    public ExcelFileStore create(ExcelFileDTO excelFileDTO, BusinessType importBusinessType) {
        ExcelFileStore excelFileStore = new ExcelFileStore();
        BeanUtils.copyProperties((Object)excelFileDTO, (Object)excelFileStore, (String[])new String[]{ID});
        excelFileStore.setStatus(Integer.valueOf(2));
        this.excelFileStoreDao.saveAndFlush((Object)excelFileStore);
        BeanUtils.copyProperties((Object)excelFileStore, (Object)excelFileDTO);
        this.asyncExcelProcess(excelFileDTO, importBusinessType);
        return excelFileStore;
    }

    private void asyncExcelProcess(ExcelFileDTO excelFileDTO, BusinessType businessType) {
        if (log.isDebugEnabled()) {
            log.debug("importBusinessType:{},importFileDTO:{}", (Object)JSON.toJSONString((Object)businessType), (Object)JSON.toJSONString((Object)excelFileDTO));
        }
        Map params = Collections.emptyMap();
        if (StringUtils.isNotBlank((CharSequence)excelFileDTO.getParams())) {
            params = (Map)JsonUtils.fromJson((String)excelFileDTO.getParams(), (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        Map<String, Integer> headerMap = ExcelReaderUtils.getHeaderNum(businessType);
        Context context = Context.builder().businessType(businessType).fileDTO(excelFileDTO).sourceFilePath(excelFileDTO.getSourceFilePath()).authorizedUser(UserInfoHolder.get()).params(params).sheetHeaderMap(headerMap).build();
        try {
            this.asyncEventBus.post((Object)context);
        }
        catch (Exception e) {
            log.error("asyncExcelProcess:" + e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException("\u5bfc\u5165\u6570\u636e\u5931\u8d25\uff0c\u5f53\u524d\u670d\u52a1\u5668\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
    }

    public void rerun(ExcelFileDTO excelFileDTO) {
        ExcelConfigBusinessType businessType = null;
        try {
            businessType = ExcelConfigBusinessType.valueOf(excelFileDTO.getBusinessType());
        }
        catch (Exception ex) {
            log.warn(ex.getMessage(), (Throwable)ex);
        }
        this.asyncExcelProcess(excelFileDTO, businessType);
    }

    protected class ExcelProcessListener {
        protected ExcelProcessListener() {
        }

        @Subscribe
        public void doProcess(Context context) {
            ImportFileService.this.excelImportProcess.process(context);
        }
    }

    protected class AsyncExcelProcessListener {
        protected AsyncExcelProcessListener() {
        }

        @Subscribe
        public void doProcess(Context context) {
            ImportFileService.this.excelImportProcess.process(context);
        }
    }

    protected class SubscriberExceptionHandlerImpl
    implements SubscriberExceptionHandler {
        protected SubscriberExceptionHandlerImpl() {
        }

        public void handleException(Throwable exception, SubscriberExceptionContext context) {
            log.error(exception.getMessage(), exception);
            log.error("context:{}", (Object)JSON.toJSONString((Object)context));
        }
    }
}

