/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.id.controller;

import com.google.common.base.Splitter;
import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.global.IdGeneratorApi;
import io.geewit.data.jpa.essential.id.SnowflakeGenerator;
import io.swagger.annotations.Api;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;

@Api(value="id\u76f8\u5173\u63a5\u53e3", tags={"id\u76f8\u5173\u63a5\u53e3"})
@Controller
public class IdGeneratorController
implements IdGeneratorApi {
    private static final Logger logger = LoggerFactory.getLogger(IdGeneratorController.class);
    private static final int QUANTITY = 100;

    public ResponseEntity<List<Long>> generate(int quantity, String entityName) {
        if (quantity == 0) {
            quantity = 1;
        }
        logger.info("quantity = " + quantity);
        if (quantity > 100) {
            throw new IllegalArgumentException("quantity \u975e\u6cd5!");
        }
        ArrayList<Long> ids = new ArrayList<Long>(quantity);
        for (int i = 0; i < quantity; ++i) {
            long id = SnowflakeGenerator.id((String)entityName);
            logger.info("id = " + id);
            ids.add(i, id);
        }
        return ResponseEntity.ok(ids);
    }

    public ResponseEntity<Map<String, List<Long>>> generateIdMap(int quantity, String entityNames) {
        if (quantity == 0) {
            quantity = 1;
        }
        logger.info("quantity = " + quantity);
        if (quantity > 100) {
            throw new IllegalArgumentException("quantity \u975e\u6cd5!");
        }
        List entityNameList = Splitter.on((String)",").trimResults().splitToList((CharSequence)entityNames);
        if (entityNameList == null || entityNameList.isEmpty()) {
            throw new IllegalArgumentException("entity name \u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashMap idMap = new HashMap(entityNameList.size());
        for (String entityName : entityNameList) {
            ArrayList<Long> ids = new ArrayList<Long>(quantity);
            for (int i = 0; i < quantity; ++i) {
                long id = SnowflakeGenerator.id((String)entityName);
                logger.info("id = " + id);
                ids.add(i, id);
            }
            idMap.put(entityName, ids);
        }
        return ResponseEntity.ok(idMap);
    }
}

