/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.message.controller;

import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.global.message.MessageApi;
import com.xforceplus.business.message.service.MessageService;
import com.xforceplus.tenant.security.autoscan.annotation.AuthorizedDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class MessageController
implements MessageApi {
    private static final Logger log = LoggerFactory.getLogger(MessageController.class);
    @Autowired
    private MessageService messageService;

    @AuthorizedDefinition(authentication=false)
    public ResponseEntity<String> sendAuthCode(String phoneOrEmail, Integer type) {
        String msgId;
        log.info("\u53d1\u9001\u9a8c\u8bc1\u7801: phoneOrEmail = {}, type = {}", (Object)phoneOrEmail, (Object)type);
        if (type == 0) {
            msgId = this.messageService.sendAuthSmsCode(phoneOrEmail);
        } else if (type == 1) {
            msgId = this.messageService.sendAuthEmailCode(phoneOrEmail);
        } else {
            throw new IllegalArgumentException(String.format("type = [%s] \u4e0d\u652f\u6301", type));
        }
        return ResponseEntity.ok((Object)msgId);
    }

    @AuthorizedDefinition(authentication=false)
    public ResponseEntity<Boolean> checkAuthCode(String msgId, String captcha, String phoneOrEmail, Integer type) {
        boolean result;
        log.info("\u9a8c\u8bc1\u9a8c\u8bc1\u7801: phoneOrEmail = {}, type = {}, msgId = {}, captcha = {}", new Object[]{phoneOrEmail, type, msgId, captcha});
        if (type == 0) {
            result = this.messageService.checkAuthSmsCode(captcha, phoneOrEmail, msgId);
        } else if (type == 1) {
            result = this.messageService.checkAuthEmailCode(captcha, phoneOrEmail, msgId);
        } else {
            throw new IllegalArgumentException(String.format("type = [%s] \u4e0d\u652f\u6301", type));
        }
        return ResponseEntity.ok((Object)result);
    }
}

