/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.messagebus.bus;

import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import com.google.common.eventbus.SubscriberExceptionHandler;
import com.xforceplus.business.messagebus.bus.MessageBusService;
import com.xforceplus.business.pub.dto.PubContext;
import com.xforceplus.business.pub.service.SubscriberExceptionHandlerImpl;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class MessageBusAsyncService
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(MessageBusAsyncService.class);
    public static final String ASYNC_MESSAGE_EVENT_BUS = "ASYNC_MESSAGE_EVENT_BUS";
    @Autowired(required=false)
    private MessageBusService messageBusService;
    private AsyncEventBus asyncEventBus;
    @Autowired
    private ThreadPoolExecutor threadPoolExecutor;

    public void destroy() throws Exception {
    }

    public void afterPropertiesSet() throws Exception {
        SubscriberExceptionHandlerImpl subscriberExceptionHandler = new SubscriberExceptionHandlerImpl();
        this.asyncEventBus = new AsyncEventBus((Executor)this.threadPoolExecutor, (SubscriberExceptionHandler)subscriberExceptionHandler);
        this.asyncEventBus.register((Object)new AsyncPubSubProcessListener());
    }

    @Async(value="threadPoolExecutor")
    public void send(PubContext pubContext) {
        if (this.messageBusService == null) {
            log.warn("messageBusService enable:{}", (Object)false);
        }
        this.asyncEventBus.post((Object)pubContext);
    }

    public void sendMessage(String code, Map<String, String> tagkvs, String content) {
        PubContext pubContext = PubContext.builder().code(code).param(tagkvs).content(content).build();
        try {
            this.send(pubContext);
        }
        catch (Exception e) {
            log.error("xforce.message.bus.error,requestName={}", (Object)code, (Object)e);
        }
    }

    protected class AsyncPubSubProcessListener {
        protected AsyncPubSubProcessListener() {
        }

        @Subscribe
        public void doProcess(PubContext context) {
            try {
                String messagePubResponse = MessageBusAsyncService.this.messageBusService.sendMessage(context.getCode(), context.getContent(), context.getParam());
                log.info("code:{},messagePubResponse:{}", (Object)context.getCode(), (Object)messagePubResponse);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

