/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.messagebus.impl;

import com.xforceplus.business.account.dto.AccountPubDTO;
import com.xforceplus.business.messagebus.AccountPubSubService;
import com.xforceplus.business.messagebus.bus.MessageBusAsyncService;
import com.xforceplus.entity.Account;
import io.geewit.web.utils.JsonUtils;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class AccountPubSubServiceImpl
implements AccountPubSubService {
    private static final Logger log = LoggerFactory.getLogger(AccountPubSubServiceImpl.class);
    public static final String PARAM_CHANNEL = "channel";
    public static final String CHANNEL_DEFAULT_VALUE = "ALL";
    @Value(value="${xforce.pub.account:xforce.tenant.account}")
    private String code;
    private final MessageBusAsyncService messageBusAsyncService;

    @Override
    @Async(value="threadPoolExecutor")
    public void publish(Account account) {
        if (StringUtils.isEmpty((CharSequence)this.code)) {
            log.warn("AccountPubDTO pubCode\u4e3a\u7a7a\uff0c\u6682\u4e0d\u53d1\u6d88\u606f");
            return;
        }
        if (account == null) {
            log.warn("\u8d26\u4fe1\u606f\u4e3a\u7a7a\uff0c\u4e0d\u6267\u884c\u8d26\u6237\u6d88\u606f\u53d1\u9001");
            return;
        }
        log.info("account:{}", (Object)account.toString());
        AccountPubDTO pubDTO = new AccountPubDTO();
        pubDTO.setAccountId(account.getAccountId());
        pubDTO.setEmail((String)StringUtils.defaultIfEmpty((CharSequence)account.getEmail(), (CharSequence)""));
        pubDTO.setTelPhone((String)StringUtils.defaultIfEmpty((CharSequence)account.getTelPhone(), (CharSequence)""));
        pubDTO.setUsername((String)StringUtils.defaultIfEmpty((CharSequence)account.getUsername(), (CharSequence)""));
        pubDTO.setChannel(CHANNEL_DEFAULT_VALUE);
        log.info("AccountPubDTO:{}", (Object)pubDTO);
        HashMap<String, String> tagkvs = new HashMap<String, String>();
        tagkvs.put("businessNo", account.getAccountId().toString());
        tagkvs.put(PARAM_CHANNEL, pubDTO.getChannel());
        String content = JsonUtils.toJson((Object)pubDTO);
        this.messageBusAsyncService.sendMessage(this.code, tagkvs, content);
    }

    public AccountPubSubServiceImpl(MessageBusAsyncService messageBusAsyncService) {
        this.messageBusAsyncService = messageBusAsyncService;
    }
}

