/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.messagebus.impl;

import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import com.xforceplus.business.company.dto.TenantCompanyRelPubDTO;
import com.xforceplus.business.company.service.CompanyExtensionService;
import com.xforceplus.business.messagebus.CompanyPubService;
import com.xforceplus.business.messagebus.bus.MessageBusAsyncService;
import com.xforceplus.business.pub.service.PubSubAsyncService;
import com.xforceplus.business.tenant.service.OrgUserService;
import com.xforceplus.dao.CompanyDao;
import com.xforceplus.dao.OrgCompanynoDao;
import com.xforceplus.dao.OrgStructDao;
import com.xforceplus.dao.TenantCompanyRelDao;
import com.xforceplus.entity.Company;
import com.xforceplus.entity.CompanyExtension;
import com.xforceplus.entity.OrgCompanyRel;
import com.xforceplus.entity.OrgStruct;
import com.xforceplus.entity.Tenant;
import com.xforceplus.json.ExtensionView;
import io.geewit.web.utils.JsonUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CompanyPubServiceImpl
implements InitializingBean,
DisposableBean,
CompanyPubService {
    private static final Logger logger = LoggerFactory.getLogger(OrgUserService.class);
    private static final String EVENT_BUS_COMPANY_PUB = "EVENT_BUS_COMPANY_PUB";
    @Autowired
    private CompanyDao companyDao;
    @Autowired
    private OrgStructDao orgStructDao;
    @Autowired
    private TenantCompanyRelDao tenantCompanyRelDao;
    @Autowired
    private OrgCompanynoDao orgCompanynoDao;
    @Autowired
    private CompanyExtensionService companyExtensionService;
    @Value(value="${xforce.pub.company:xforce.tenant.company}")
    private String companyPubCode;
    @Value(value="${xforce.pub.tenantcompanyrel:tenant_company_rel}")
    private String tenantCompanyRel;
    @Autowired(required=false)
    private MessageBusAsyncService messageBusAsyncService;
    @Autowired(required=false)
    private PubSubAsyncService pubSubAsyncService;
    private AsyncEventBus asyncEventBus;
    @Value(value="${company.pub.interval:1000}")
    private Long companyPubInterval;
    @Autowired
    private ThreadPoolExecutor threadPoolExecutor;

    public void destroy() {
        this.threadPoolExecutor.shutdown();
    }

    public void afterPropertiesSet() {
        this.asyncEventBus = new AsyncEventBus((Executor)this.threadPoolExecutor, (exception, context) -> logger.error(exception.getMessage(), exception));
        this.asyncEventBus.register((Object)new AsyncProcessListener());
    }

    @Override
    public void pub(Long companyId) {
        logger.info("\u5f02\u6b65company pub,companyId={}", (Object)companyId);
        Context context = Context.builder().companyId(companyId).build();
        try {
            this.asyncEventBus.post((Object)context);
        }
        catch (Exception e) {
            String message = "\u516c\u53f8\u4fe1\u606fpub\u5931\u8d25\uff0c\u5f53\u524d\u670d\u52a1\u5668\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5";
            logger.error(message, (Throwable)e);
            throw new IllegalArgumentException(message);
        }
    }

    public void pubMsg(Long companyId) {
        List<CompanyExtension> extensions;
        try {
            Thread.sleep(this.companyPubInterval);
        }
        catch (InterruptedException e) {
            logger.error("error", (Throwable)e);
        }
        if (null == this.pubSubAsyncService) {
            logger.info("pubsubService == null, pubsub.enable=false");
            return;
        }
        if (null == this.messageBusAsyncService) {
            logger.info("messageBusAsyncService == null, pubsub.enable=false");
            return;
        }
        Optional optionalCompany = this.companyDao.findById((Object)companyId);
        if (!optionalCompany.isPresent()) {
            logger.info("company pub error\uff0ccompany is null companyId={}", (Object)companyId);
            return;
        }
        Company company = (Company)optionalCompany.get();
        List tenants = this.tenantCompanyRelDao.findTenantsByCompanyId(companyId.longValue());
        if (CollectionUtils.isEmpty((Collection)tenants)) {
            logger.info("company pub error\uff0ctenant is null companyId={}", (Object)companyId);
            return;
        }
        Tenant tenant = (Tenant)tenants.get(0);
        logger.info("company pub companyId={}", (Object)companyId);
        List orgList = this.orgStructDao.findByCompanyId(companyId.longValue());
        OrgStruct org = null;
        if (!CollectionUtils.isEmpty((Collection)orgList)) {
            org = (OrgStruct)orgList.get(0);
        }
        List companyNos = null;
        if (null != org) {
            companyNos = this.orgCompanynoDao.findByOrgId(org.getOrgId().longValue());
            company.setCompanyNos(companyNos.stream().map(OrgCompanyRel::getCompanyNo).collect(Collectors.toList()));
        }
        if (!CollectionUtils.isEmpty(extensions = this.companyExtensionService.findByComapnyId(companyId))) {
            List extensionDtos = extensions.stream().filter(Objects::nonNull).collect(Collectors.toList());
            company.setExtensions(extensionDtos);
        }
        HashMap<String, String> tagkvs = new HashMap<String, String>();
        tagkvs.put("requestName", this.companyPubCode);
        tagkvs.put("tenantId", tenant.getTenantId().toString());
        tagkvs.put("businessNo", companyId + "");
        String content = JsonUtils.toJson((Object)company, ExtensionView.Extension.class);
        logger.info("company pub saveObj = {}", (Object)content);
        this.messageBusAsyncService.sendMessage(this.companyPubCode, tagkvs, content);
        this.pubSubAsyncService.sendMessage(this.companyPubCode, tagkvs, content);
    }

    @Override
    public void sendTenantCompanyRelMsg(String operation, Company company, Tenant tenant) {
        TenantCompanyRelPubDTO tenantCompanyRelPubDTO = new TenantCompanyRelPubDTO();
        tenantCompanyRelPubDTO.setOperation(operation);
        tenantCompanyRelPubDTO.setTenantId(tenant.getTenantId());
        tenantCompanyRelPubDTO.setTenantCode(tenant.getTenantCode());
        tenantCompanyRelPubDTO.setTenantName(tenant.getTenantName());
        tenantCompanyRelPubDTO.setCompanyId(company.getCompanyId());
        tenantCompanyRelPubDTO.setCompanyCode(company.getCompanyCode());
        tenantCompanyRelPubDTO.setCompanyName(company.getCompanyName());
        tenantCompanyRelPubDTO.setTaxNum(company.getTaxNum());
        HashMap<String, String> tagkvs = new HashMap<String, String>();
        tagkvs.put("requestName", this.tenantCompanyRel);
        tagkvs.put("businessNo", tenantCompanyRelPubDTO.getCompanyId() + "_" + tenantCompanyRelPubDTO.getTenantId());
        tagkvs.put("tenantId", String.valueOf(tenant.getTenantId()));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantId", tenant.getTenantId());
        map.put("tenantCompanyRel", tenantCompanyRelPubDTO);
        String content = JsonUtils.toJson(map);
        this.messageBusAsyncService.sendMessage(this.tenantCompanyRel, tagkvs, content);
    }

    protected class AsyncProcessListener {
        protected AsyncProcessListener() {
        }

        @Subscribe
        public void doProcess(Context context) {
            logger.info("AsyncProcessListener.doProcess.company.pub,context.companyId = {}", (Object)context.companyId);
            CompanyPubServiceImpl.this.pubMsg(context.companyId);
        }
    }

    static class Context {
        private Long companyId;

        Context(Long companyId) {
            this.companyId = companyId;
        }

        public static ContextBuilder builder() {
            return new ContextBuilder();
        }

        public static class ContextBuilder {
            private Long companyId;

            ContextBuilder() {
            }

            public ContextBuilder companyId(Long companyId) {
                this.companyId = companyId;
                return this;
            }

            public Context build() {
                return new Context(this.companyId);
            }

            public String toString() {
                return "CompanyPubServiceImpl.Context.ContextBuilder(companyId=" + this.companyId + ")";
            }
        }
    }
}

