/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.messagebus.impl;

import com.xforceplus.api.model.CompanyServiceRelModel;
import com.xforceplus.business.messagebus.CompanyServicePackagePubService;
import com.xforceplus.business.messagebus.bus.MessageBusAsyncService;
import com.xforceplus.business.pub.service.PubSubAsyncService;
import com.xforceplus.entity.Company;
import com.xforceplus.entity.CompanyServiceRel;
import com.xforceplus.entity.ServicePackage;
import io.geewit.core.utils.reflection.BeanUtils;
import io.geewit.web.utils.JsonUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CompanyServicePackagePubServiceImpl
implements CompanyServicePackagePubService {
    private static final Logger log = LoggerFactory.getLogger(CompanyServicePackagePubServiceImpl.class);
    private final MessageBusAsyncService messageBusAsyncService;
    @Resource
    private PubSubAsyncService pubSubAsyncService;
    @Value(value="${xforce.pub.companyService:xforce.tenant.companyService}")
    private String companyServicePubCode;
    @Value(value="${xforce.pub.companyService.v1:tenant_company_service}")
    private String companyServicePubCodeV1;

    public CompanyServicePackagePubServiceImpl(MessageBusAsyncService messageBusAsyncService) {
        this.messageBusAsyncService = messageBusAsyncService;
    }

    @Override
    public void sendMessage(String channelId, CompanyServiceRelModel.Response.TenantModel tenantModel, List<CompanyServiceRelModel.Response.CompanyServiceModel> companyServiceModels) {
        if (null == this.messageBusAsyncService) {
            log.info("pubsub.enable=false,messageBusService={}", (Object)this.messageBusAsyncService);
            return;
        }
        HashMap<String, String> tagkvs = new HashMap<String, String>();
        tagkvs.put("requestName", this.companyServicePubCode);
        tagkvs.put("channelId", channelId);
        tagkvs.put("businessNo", tenantModel.getTenantId().toString());
        tagkvs.put("tenantId", tenantModel.getTenantId().toString());
        HashMap<String, Object> contentMap = new HashMap<String, Object>();
        contentMap.put("tenant", tenantModel);
        contentMap.put("companyServices", companyServiceModels);
        String content = JsonUtils.toJson(contentMap);
        log.debug("company.pub.content:{}", (Object)content);
        this.pubSubAsyncService.sendMessage(this.companyServicePubCodeV1, tagkvs, content);
        this.messageBusAsyncService.sendMessage(this.companyServicePubCode, tagkvs, content);
    }

    @Override
    public List<CompanyServiceRelModel.Response.CompanyServiceModel> buildCompanyServiceMessage(Map<Long, ServicePackage> servicePackageMap, Map<Long, Company> companyMap, Set<CompanyServiceRel> resl, String operation) {
        ArrayList<CompanyServiceRelModel.Response.CompanyServiceModel> pubModels = new ArrayList<CompanyServiceRelModel.Response.CompanyServiceModel>();
        for (CompanyServiceRel rel : resl) {
            CompanyServiceRelModel.Response.CompanyServiceModel model = new CompanyServiceRelModel.Response.CompanyServiceModel();
            model.setStatus(rel.getStatus());
            model.setId(rel.getId());
            model.setOperation(operation);
            CompanyServiceRelModel.Response.ServicePackageModel servicePackageModel = new CompanyServiceRelModel.Response.ServicePackageModel();
            ServicePackage servicePackage = servicePackageMap.get(rel.getServicePackageId());
            BeanUtils.copyProperties((Object)servicePackage, (Object)servicePackageModel);
            model.setServicePackageModel(servicePackageModel);
            Company company = companyMap.get(rel.getCompanyId());
            CompanyServiceRelModel.Response.CompanyModel companyModel = new CompanyServiceRelModel.Response.CompanyModel();
            BeanUtils.copyProperties((Object)company, (Object)companyModel);
            model.setCompanyModel(companyModel);
            pubModels.add(model);
        }
        return pubModels;
    }
}

