/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.messagebus.impl;

import com.xforceplus.business.messagebus.OrgPubService;
import com.xforceplus.business.messagebus.bus.MessageBusAsyncService;
import com.xforceplus.entity.OrgStruct;
import io.geewit.web.utils.JsonUtils;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class OrgPubServiceImpl
implements OrgPubService {
    private static final Logger log = Logger.getLogger(OrgPubServiceImpl.class);
    @Value(value="${xforce.pub.orgInfo:uc_org_info}")
    private String orgInfoTopic;
    private final MessageBusAsyncService messageBusAsyncService;

    @Override
    public void sendOrgMsg(String operation, OrgStruct orgStruct) {
        HashMap<String, String> tagkvs = new HashMap<String, String>();
        tagkvs.put("requestName", this.orgInfoTopic);
        tagkvs.put("tenantId", String.valueOf(orgStruct.getTenantId()));
        tagkvs.put("businessNo", orgStruct.getOrgId() + "");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantId", orgStruct.getTenantId());
        map.put("org", orgStruct);
        map.put("operation", operation);
        String content = JsonUtils.toJson(map);
        this.messageBusAsyncService.sendMessage(this.orgInfoTopic, tagkvs, content);
    }

    public OrgPubServiceImpl(MessageBusAsyncService messageBusAsyncService) {
        this.messageBusAsyncService = messageBusAsyncService;
    }
}

