/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.notice.service;

import com.xforcecloud.noification.model.BaseResponse;
import com.xforcecloud.noification.model.MessageInfo;
import com.xforcecloud.noification.model.QueryType;
import com.xforcecloud.noification.model.Scope;
import com.xforceplus.business.excel.ExcelConfig;
import com.xforceplus.business.notice.entity.ExcelProcessNotice;
import com.xforceplus.feign.tenant.message.MessageClient;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NoticeService {
    private static final Logger log = LoggerFactory.getLogger(NoticeService.class);
    private static final Integer MESSAGE_TYPE = 1;
    private static final String SUCCESS_CODE = "MSGCZZ0000";
    @Autowired
    private MessageClient messageClient;

    public void sendExcelProcessNotice(ExcelProcessNotice excelProcessNotice) {
        log.info("sendExcelProcessNotice:{}", (Object)excelProcessNotice);
        MessageInfo messageInfo = new MessageInfo();
        BeanUtils.copyProperties((Object)excelProcessNotice, (Object)messageInfo);
        messageInfo.setScope(Scope.SINGLE);
        messageInfo.setType(MESSAGE_TYPE);
        ArrayList<Long> receiverList = new ArrayList<Long>();
        receiverList.add(excelProcessNotice.getSenderId());
        messageInfo.setReceiverIds(receiverList);
        BaseResponse response = this.messageClient.sendMessage(ExcelConfig.getAppId(), Long.valueOf(excelProcessNotice.getTenantId()), messageInfo);
        if (response == null || !SUCCESS_CODE.equals(response.getCode())) {
            log.error("sendExcelProcessNotice_exception,  response\uff1a{}", (Object)response);
            throw new IllegalArgumentException("SendNoticeError");
        }
        log.info("sendExcelProcessNotice_success, response:{}", (Object)response);
    }

    public BaseResponse getMessage(Long tenantId) {
        QueryType queryType = QueryType.SINGLE;
        int pageNo = 1;
        int pageSize = 10;
        BaseResponse baseResponse = this.messageClient.queryMessages(ExcelConfig.getAppId().longValue(), tenantId.longValue(), queryType, null, null, pageNo, pageSize);
        log.debug("getMessage:{}", (Object)baseResponse);
        return baseResponse;
    }
}

