/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.org.virtual.controller;

import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.current.org.virtual.OrgVirtualNodeApi;
import com.xforceplus.api.model.OrgVirtualNodeModel;
import com.xforceplus.business.common.controller.AbstractController;
import com.xforceplus.business.excel.QueryParam;
import com.xforceplus.business.excel.writer.ExcelConfigBusinessType;
import com.xforceplus.business.file.controller.vo.ImportFileRespVo;
import com.xforceplus.business.file.service.ExportFileService;
import com.xforceplus.business.file.service.ImportFileService;
import com.xforceplus.business.org.virtual.service.OrgVirtualNodeService;
import com.xforceplus.domain.orgVirtual.OrgVirtualTreeNode;
import com.xforceplus.entity.ExcelFileStore;
import com.xforceplus.entity.OrgVirtualNode;
import com.xforceplus.entity.OrgVirtualNodeUserRel;
import com.xforceplus.entity.User;
import com.xforceplus.tenant.security.autoscan.annotation.AuthorizedDefinition;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import io.geewit.data.jpa.essential.domain.PageableFactory;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Api(value="\u865a\u62df\u7ec4\u7ec7\u6811")
@Controller
public class OrgVirtualNodeController
extends AbstractController
implements OrgVirtualNodeApi,
com.xforceplus.api.tenant.org.virtual.OrgVirtualNodeApi {
    private static final Logger log = LoggerFactory.getLogger(OrgVirtualNodeController.class);
    private final OrgVirtualNodeService orgVirtualNodeService;
    private final ImportFileService importFileService;
    private final ExportFileService exportFileService;

    public OrgVirtualNodeController(OrgVirtualNodeService orgVirtualNodeService, ImportFileService importFileService, ExportFileService exportFileService) {
        this.orgVirtualNodeService = orgVirtualNodeService;
        this.importFileService = importFileService;
        this.exportFileService = exportFileService;
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:org-virtual:node:read"})
    public ResponseEntity<Page<OrgVirtualNode>> currentPage(Long typeId, OrgVirtualNodeModel.Request.Query query, Pageable pageable) {
        Pageable currentPageable = PageableFactory.ofDefaultSort((Pageable)pageable, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}));
        query.setTypeId(typeId);
        query.setTenantId(UserInfoHolder.currentUser().getTenantId());
        Page<OrgVirtualNode> page = this.orgVirtualNodeService.page(query, currentPageable);
        return ResponseEntity.ok(page);
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:org-virtual:node:read"})
    public ResponseEntity<OrgVirtualTreeNode> currentTree(Long typeId) {
        Long tenantId = UserInfoHolder.currentUser().getTenantId();
        OrgVirtualTreeNode node = this.orgVirtualNodeService.tree(typeId, tenantId);
        return ResponseEntity.ok((Object)node);
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:org-virtual:node:save"})
    public ResponseEntity<OrgVirtualNode> currentCreate(Long typeId, Long orgVirtualId) {
        Long tenantId = UserInfoHolder.currentUser().getTenantId();
        OrgVirtualNode result = this.orgVirtualNodeService.currentCreate(typeId, tenantId, orgVirtualId);
        return ResponseEntity.ok((Object)result);
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:org-virtual:node:save"})
    public ResponseEntity<OrgVirtualNode> currentAppend(OrgVirtualNodeModel.Request.Append append) {
        Long tenantId = UserInfoHolder.currentUser().getTenantId();
        append.setTenantId(tenantId);
        OrgVirtualNode result = this.orgVirtualNodeService.currentAppend(append);
        return ResponseEntity.ok((Object)result);
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:org-virtual:node:save"})
    public ResponseEntity<String> currentDelete(Long id) {
        Long tenantId = UserInfoHolder.currentUser().getTenantId();
        this.orgVirtualNodeService.currentDelete(tenantId, id);
        return ResponseEntity.ok();
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:org-virtual:node:read"})
    public ResponseEntity<Page> currentBindedTrees(Long nodeId, OrgVirtualNodeModel.Request.BindedUsers query, Pageable pageable) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        long tenantId = authorizedUser.getTenantId();
        query.setTenantId(Long.valueOf(tenantId));
        query.setOrgVirtualNodeId(nodeId);
        Pageable currentPageable = PageableFactory.ofDefaultSort((Pageable)pageable, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}));
        Page<OrgVirtualNodeUserRel> result = this.orgVirtualNodeService.currentBindedTrees(query, currentPageable);
        return ResponseEntity.ok(result);
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:org-virtual:node:user:save"})
    public ResponseEntity<String> currentBindTrees(Long nodeId, OrgVirtualNodeModel.Request.BindUsers bindUsers) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        long tenantId = authorizedUser.getTenantId();
        this.orgVirtualNodeService.bindUsers(tenantId, nodeId, bindUsers);
        return ResponseEntity.ok((Object)"\u7ed1\u5b9a\u6210\u529f");
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:org-virtual:node:user:save"})
    public ResponseEntity<String> currentUnbindTrees(Long nodeId, OrgVirtualNodeModel.Request.UnbindUsers unbindUsers) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        long tenantId = authorizedUser.getTenantId();
        this.orgVirtualNodeService.unbindUsers(tenantId, nodeId, unbindUsers);
        return ResponseEntity.ok((Object)"\u53cd\u7ed1\u5b9a\u6210\u529f");
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:org-virtual:node:user:save"})
    public ResponseEntity<String> currentUpdateUserScope(Long nodeId, OrgVirtualNodeModel.Request.UsersScope usersScope) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        long tenantId = authorizedUser.getTenantId();
        this.orgVirtualNodeService.updateControlScope(tenantId, nodeId, usersScope);
        return ResponseEntity.ok();
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:org-virtual:node:admininfo:save"})
    public ResponseEntity<String> bindAdminInfoToNode(Long nodeId, OrgVirtualNodeModel.Request.BindAdminInfo bindAdminInfo) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        long tenantId = authorizedUser.getTenantId();
        this.orgVirtualNodeService.bindAdminInfo(tenantId, nodeId, bindAdminInfo);
        return ResponseEntity.ok();
    }

    public ResponseEntity<String> markMainOrg(Long nodeId, OrgVirtualNodeModel.Request.BindUsers bindUsers) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        long tenantId = authorizedUser.getTenantId();
        this.orgVirtualNodeService.markUserMainOrg(tenantId, nodeId, bindUsers);
        return ResponseEntity.ok();
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:org-virtual:node:read"})
    @ResponseBody
    @ApiOperation(value="\u4e1a\u52a1\u7ec4\u7ec7\u6811\u5f02\u6b65\u5bfc\u51fa", notes="\u4e1a\u52a1\u7ec4\u7ec7\u6811\u5f02\u6b65\u5bfc\u51fa")
    @RequestMapping(name="\u4e1a\u52a1\u7ec4\u7ec7\u6811\u5f02\u6b65\u5bfc\u51fa", value={"${xforce.tenant.service.url.prefix:/api}/current${xforce.tenant.service.version:}/org-virtuals-node/export"}, method={RequestMethod.POST})
    public ResponseEntity<ImportFileRespVo> exportCompanyConfig(@ApiParam(value="request") @RequestBody OrgVirtualNodeModel.Request.ExcelExportQuery query) {
        if (ArrayUtils.isEmpty((Object[])query.getSheets())) {
            throw new IllegalArgumentException("\u8bf7\u9009\u62e9SheetName");
        }
        QueryParam queryParam = QueryParam.builder().param("P_QUERY", query).build();
        ExcelFileStore excelFileStore = this.exportFileService.asyncExcelExport(queryParam.params(), ExcelConfigBusinessType.ORG_VIRTUAL_NODE_CONFIG_EXCEL_FILE);
        ImportFileRespVo respVo = new ImportFileRespVo();
        respVo.setId(excelFileStore.getId());
        respVo.setBusinessType(ExcelConfigBusinessType.ORG_VIRTUAL_NODE_CONFIG_EXCEL_FILE.getBusinessName());
        return ResponseEntity.ok((Object)respVo);
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:org-virtual:node:save"})
    @ApiOperation(value="\u4e1a\u52a1\u7ec4\u7ec7\u6811\u5bfc\u5165excel")
    @ResponseBody
    @RequestMapping(name="\u4e1a\u52a1\u7ec4\u7ec7\u6811\u5bfc\u5165excel", value={"${xforce.tenant.service.url.prefix:/api}/current${xforce.tenant.service.version:}/org-virtuals-node/import"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<ImportFileRespVo> batchImportBind(@RequestParam(value="file") MultipartFile file, @RequestParam(name="typeId") Long typeId) {
        Long tenantId = UserInfoHolder.get().getTenantId();
        Long userId = UserInfoHolder.get().getId();
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("typeId", typeId);
        String businessType = ExcelConfigBusinessType.ORG_VIRTUAL_NODE_IMPORT.name();
        ExcelFileStore excelFileStore = this.importFileService.createAndSaveFile(file, businessType, userId, tenantId, params);
        ImportFileRespVo respVo = new ImportFileRespVo();
        respVo.setBusinessType(businessType);
        respVo.setFileId(excelFileStore.getSourceFileId());
        respVo.setId(excelFileStore.getId());
        return ResponseEntity.ok((Object)respVo);
    }

    public ResponseEntity<OrgVirtualNode> tenantCreate(String tenantKey, Boolean byTenantCode, Long typeId, Long orgVirtualId) {
        long tenantId = super.toTenantId(tenantKey, byTenantCode);
        OrgVirtualNode result = this.orgVirtualNodeService.currentCreate(typeId, tenantId, orgVirtualId);
        return ResponseEntity.ok((Object)result);
    }

    public ResponseEntity<OrgVirtualNode> tenantAppend(String tenantKey, Boolean byTenantCode, OrgVirtualNodeModel.Request.Append append) {
        long tenantId = super.toTenantId(tenantKey, byTenantCode);
        append.setTenantId(Long.valueOf(tenantId));
        OrgVirtualNode result = this.orgVirtualNodeService.currentAppend(append);
        return ResponseEntity.ok((Object)result);
    }

    public ResponseEntity<String> batchBindUserAndAdmin(Long typeId, Long nodeId, String tenantKey, Boolean byTenantCode, @Valid OrgVirtualNodeModel.Request.BindAdminInfo bindAdminInfo) {
        long tenantId = super.toTenantId(tenantKey, byTenantCode);
        OrgVirtualNodeModel.Request.BindUsers bindUsers = new OrgVirtualNodeModel.Request.BindUsers();
        List userIds = bindAdminInfo.getAdmins().stream().filter(Objects::nonNull).map(OrgVirtualNodeModel.Request.AdminInfo::getUserId).distinct().collect(Collectors.toList());
        bindUsers.setUserIds(userIds);
        this.orgVirtualNodeService.bindUsers(tenantId, nodeId, bindUsers);
        if (CollectionUtils.isEmpty((Collection)bindAdminInfo.getAdmins())) {
            return ResponseEntity.ok();
        }
        this.orgVirtualNodeService.bindAdminInfo(tenantId, nodeId, bindAdminInfo);
        return ResponseEntity.ok();
    }

    public ResponseEntity<List<User>> queryUserInfoOfNode(String tenantKey, Boolean byTenantCode, Long virtualNodeId, Boolean isNodeId, Long typeId, Integer adminFlag) {
        long tenantId = super.toTenantId(tenantKey, byTenantCode);
        OrgVirtualNodeModel.Request.BindedUsers query = new OrgVirtualNodeModel.Request.BindedUsers();
        query.setOrgVirtualNodeId(virtualNodeId);
        query.setTenantId(Long.valueOf(tenantId));
        List<User> result = this.orgVirtualNodeService.currentBindedAdminInfo(query, adminFlag, isNodeId, typeId);
        return ResponseEntity.ok(result);
    }

    public ResponseEntity<Page<OrgVirtualNode>> tenantVirtualTreePage(Long typeId, OrgVirtualNodeModel.Request.Query query, Pageable pageable, String tenantKey, Boolean byTenantCode) {
        long tenantId = super.toTenantId(tenantKey, byTenantCode);
        Pageable currentPageable = PageableFactory.ofDefaultSort((Pageable)pageable, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}));
        query.setTypeId(typeId);
        query.setTenantId(Long.valueOf(tenantId));
        Page<OrgVirtualNode> page = this.orgVirtualNodeService.page(query, currentPageable);
        return ResponseEntity.ok(page);
    }

    public ResponseEntity<String> tenantDelete(String tenantKey, Long id, Long typeId, Long userId, Boolean byTenantCode, Integer operationType) {
        long tenantId = super.toTenantId(tenantKey, byTenantCode);
        this.orgVirtualNodeService.tenantDelete(tenantId, id, typeId, userId, operationType);
        return ResponseEntity.ok((Object)"\u5220\u9664\u6210\u529f");
    }
}

