/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.org.virtual.controller;

import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.current.org.virtual.OrgVirtualOrgStructRelApi;
import com.xforceplus.api.model.OrgVirtualOrgStructRelModel;
import com.xforceplus.business.common.controller.AbstractController;
import com.xforceplus.business.excel.QueryParam;
import com.xforceplus.business.excel.writer.ExcelConfigBusinessType;
import com.xforceplus.business.file.controller.vo.ImportFileRespVo;
import com.xforceplus.business.file.service.ExportFileService;
import com.xforceplus.business.file.service.ImportFileService;
import com.xforceplus.business.org.virtual.service.OrgVirtualOrgStructService;
import com.xforceplus.entity.ExcelFileStore;
import com.xforceplus.entity.OrgVirtualOrgStructRel;
import com.xforceplus.tenant.security.autoscan.annotation.AuthorizedDefinition;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import io.geewit.data.jpa.essential.domain.PageableFactory;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Api(value="\u865a\u62df\u7ec4\u7ec7\u884c\u653f\u7ec4\u7ec7\u5173\u8054\u63a7\u5236\u5668")
@Controller
public class OrgVirtualOrgStructRelController
extends AbstractController
implements OrgVirtualOrgStructRelApi,
com.xforceplus.api.tenant.org.virtual.OrgVirtualOrgStructRelApi {
    private static final Logger log = LoggerFactory.getLogger(OrgVirtualOrgStructRelController.class);
    @Autowired
    private OrgVirtualOrgStructService orgVirtualOrgStructService;
    @Autowired
    private ExportFileService exportFileService;
    @Autowired
    private ImportFileService importFileService;

    @ResponseBody
    @AuthorizedDefinition(resources={"xforce:ucenter:org-virtual:org:save"})
    @ApiOperation(value="\u4e1a\u52a1\u7ec4\u7ec7\u5173\u8054\u884c\u653f\u7ec4\u7ec7\u6279\u91cf\u5bfc\u51faexcel", notes="\u4e1a\u52a1\u7ec4\u7ec7\u5173\u8054\u884c\u653f\u7ec4\u7ec7\u6279\u91cf\u5bfc\u51faexcel")
    @RequestMapping(name="\u4e1a\u52a1\u7ec4\u7ec7\u5173\u8054\u884c\u653f\u7ec4\u7ec7\u6279\u91cf\u5bfc\u51faexcel", value={"${xforce.tenant.service.url.prefix:/api}/current${xforce.tenant.service.version:}/orgvirtual-orgstructs/orgvirtual-orgstructs/export"}, method={RequestMethod.POST})
    public ResponseEntity<ImportFileRespVo> batchExportBind(@ApiParam(value="request") @RequestBody OrgVirtualOrgStructRelModel.Request.ExcelExportQuery query) {
        if (ArrayUtils.isEmpty((Object[])query.getSheets())) {
            throw new IllegalArgumentException("\u8bf7\u9009\u62e9SheetName");
        }
        QueryParam queryParam = QueryParam.builder().param("P_QUERY", query).build();
        ExcelFileStore excelFileStore = this.exportFileService.asyncExcelExport(queryParam.params(), ExcelConfigBusinessType.ORG_VIRTUAL_ORG_STRUCT_CONFIG_EXCEL_FILE);
        ImportFileRespVo respVo = new ImportFileRespVo();
        respVo.setId(excelFileStore.getId());
        respVo.setBusinessType(ExcelConfigBusinessType.ORG_VIRTUAL_ORG_STRUCT_CONFIG_EXCEL_FILE.getBusinessName());
        return ResponseEntity.ok((Object)respVo);
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:org-virtual:org:save"})
    @ApiOperation(value="\u4e1a\u52a1\u7ec4\u7ec7\u5173\u8054\u884c\u653f\u7ec4\u7ec7\u6279\u91cf\u5bfc\u5165excel")
    @ResponseBody
    @RequestMapping(name="\u4e1a\u52a1\u7ec4\u7ec7\u5173\u8054\u884c\u653f\u7ec4\u7ec7\u6279\u91cf\u5bfc\u5165excel", value={"${xforce.tenant.service.url.prefix:/api}/current${xforce.tenant.service.version:}/orgvirtual-orgstructs/orgvirtual-orgstructs/import"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<ImportFileRespVo> batchImportBind(@RequestParam(value="file") MultipartFile file) {
        IAuthorizedUser currentUser = UserInfoHolder.currentUser();
        Long tenantId = currentUser.getTenantId();
        Long userId = currentUser.getId();
        String businessType = ExcelConfigBusinessType.ORG_VIRTUAL_ORG_STRUCT_CONFIG_EXCEL_FILE.name();
        ExcelFileStore excelFileStore = this.importFileService.createAndSaveFile(file, businessType, userId, tenantId);
        ImportFileRespVo respVo = new ImportFileRespVo();
        respVo.setBusinessType(businessType);
        respVo.setFileId(excelFileStore.getSourceFileId());
        respVo.setId(excelFileStore.getId());
        return ResponseEntity.ok((Object)respVo);
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:org-virtual:org:read"})
    @ApiOperation(value="\u5f53\u524d\u79df\u6237\u4e0b\u4e1a\u52a1\u7ec4\u7ec7\u5173\u8054\u7684\u884c\u653f\u7ec4\u7ec7\u5206\u9875\u67e5\u8be2")
    public ResponseEntity<Page<OrgVirtualOrgStructRel>> page(OrgVirtualOrgStructRelModel.Request.Query query, Pageable pageable) {
        Pageable currentPageable = PageableFactory.ofDefaultSort((Pageable)pageable, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}));
        query.setTenantId(UserInfoHolder.currentUser().getTenantId());
        Page<OrgVirtualOrgStructRel> page = this.orgVirtualOrgStructService.page(query, currentPageable);
        return ResponseEntity.ok(page);
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:org-virtual:org:save"})
    @ApiOperation(value="\u5f53\u524d\u79df\u6237\u4e0b\u4e1a\u52a1\u7ec4\u7ec7\u589e\u52a0\u884c\u653f\u7ec4\u7ec7\u5173\u8054")
    public ResponseEntity<Boolean> relate(@RequestBody OrgVirtualOrgStructRelModel.Request.Relate model) {
        model.setTenantId(UserInfoHolder.currentUser().getTenantId());
        return ResponseEntity.ok((Object)this.orgVirtualOrgStructService.relate(model));
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:org-virtual:org:read"})
    @ApiOperation(value="\u6307\u5b9a\u79df\u6237\u4e0b\u4e1a\u52a1\u7ec4\u7ec7\u5173\u8054\u7684\u884c\u653f\u7ec4\u7ec7\u5206\u9875\u67e5\u8be2")
    public ResponseEntity<Page<OrgVirtualOrgStructRel>> page(@PathVariable(value="tenantKey") String tenantKey, OrgVirtualOrgStructRelModel.Request.Query query, Pageable pageable) {
        Pageable currentPageable = PageableFactory.ofDefaultSort((Pageable)pageable, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}));
        Long tenantId = super.toTenant(tenantKey).getTenantId();
        query.setTenantId(tenantId);
        Page<OrgVirtualOrgStructRel> page = this.orgVirtualOrgStructService.page(query, currentPageable);
        return ResponseEntity.ok(page);
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:org-virtual:org:save"})
    @ApiOperation(value="\u6307\u5b9a\u79df\u6237\u4e0b\u4e1a\u52a1\u7ec4\u7ec7\u589e\u52a0\u884c\u653f\u7ec4\u7ec7\u5173\u8054")
    public ResponseEntity<Boolean> relate(@PathVariable(value="tenantKey") String tenantKey, @RequestBody OrgVirtualOrgStructRelModel.Request.Relate model) {
        Long tenantId = super.toTenant(tenantKey).getTenantId();
        model.setTenantId(tenantId);
        return ResponseEntity.ok((Object)this.orgVirtualOrgStructService.relate(model));
    }
}

