/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.org.virtual.service;

import com.xforceplus.api.model.OrgVirtualModel;
import com.xforceplus.business.excel.BusinessType;
import com.xforceplus.business.excel.SimpleExcelWriter;
import com.xforceplus.business.excel.reader.Context;
import com.xforceplus.business.excel.writer.ExcelConfigBusinessType;
import com.xforceplus.business.org.virtual.service.OrgVirtualService;
import com.xforceplus.business.service.ExcelWriteService;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class OrgVirtualExcelExportServiceImpl
implements ExcelWriteService {
    private final OrgVirtualService orgVirtualService;

    public OrgVirtualExcelExportServiceImpl(OrgVirtualService orgVirtualService) {
        this.orgVirtualService = orgVirtualService;
    }

    @Override
    public BusinessType getBusinessType() {
        return ExcelConfigBusinessType.ORG_VIRTUAL_CONFIG_EXCEL_FILE;
    }

    @Override
    public void write(Context context) {
        OrgVirtualModel.Request.ExcelExportQuery query = context.getParam("P_QUERY", OrgVirtualModel.Request.ExcelExportQuery.class);
        Long tenantId = context.getFileDTO().getTenantId();
        SimpleExcelWriter simpleExcelWriter = context.getSimpleExcelWriter();
        query.setTenantId(tenantId);
        for (String sheetName : query.getSheets()) {
            if (!"\u4e1a\u52a1\u7ec4\u7ec7".equals(sheetName)) continue;
            List<OrgVirtualModel.Response.ExcelExportModel> list = this.orgVirtualService.listToExcel(query);
            simpleExcelWriter.fill(sheetName, list);
        }
    }
}

