/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.org.virtual.service;

import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.fastjson.JSON;
import com.xforceplus.business.excel.BusinessType;
import com.xforceplus.business.excel.ExcelSheet;
import com.xforceplus.business.excel.reader.Context;
import com.xforceplus.business.excel.reader.MessageRow;
import com.xforceplus.business.excel.reader.SimpleDataReadListener;
import com.xforceplus.business.excel.writer.ExcelConfigBusinessType;
import com.xforceplus.business.org.virtual.dto.OrgVirtualImportDto;
import com.xforceplus.business.org.virtual.service.OrgVirtualService;
import com.xforceplus.business.service.ExcelReaderService;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OrgVirtualImportServiceImpl
implements ExcelReaderService {
    public static final String ACTION_CREATE = "\u65b0\u5efa";
    public static final String ACTION_UPDATE = "\u4fee\u6539";
    public static final List<String> ACTION_LISTS = Arrays.asList("\u65b0\u5efa", "\u4fee\u6539");
    private static final Logger logger = LoggerFactory.getLogger(OrgVirtualImportServiceImpl.class);
    @Resource
    private OrgVirtualService orgVirtualService;

    @Override
    public BusinessType getBusinessType() {
        return ExcelConfigBusinessType.ORG_VIRTUAL_IMPORT;
    }

    @Override
    public Context importExcel(Context context) {
        List<ExcelSheet> sheets = context.getExcelBook().getExcelSheets();
        for (ExcelSheet sheet : sheets) {
            MessageRow messageRows = new MessageRow(sheet.getSheetName());
            AnalysisEventListener excelDataListener = SimpleDataReadListener.listener(context, rows -> this.saveData(messageRows, context, (List<OrgVirtualImportDto>)rows));
            context.getSimpleExcelReader().read(OrgVirtualImportDto.class, excelDataListener);
        }
        return context;
    }

    public void saveData(MessageRow messageRows, Context context, List<OrgVirtualImportDto> list) {
        if (logger.isDebugEnabled()) {
            logger.debug("list:{}", (Object)JSON.toJSONString(list));
        }
        for (OrgVirtualImportDto dto : list) {
            if (logger.isDebugEnabled()) {
                logger.debug("dto:{}", (Object)JSON.toJSONString((Object)dto));
            }
            String msg = this.orgVirtualService.importSave(dto, context.getFileDTO().getTenantId());
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{msg})) {
                messageRows.fail(dto.getRowIndex(), msg);
                continue;
            }
            messageRows.success(dto.getRowIndex());
        }
        context.messageRow(messageRows.getSheetName(), messageRows);
    }
}

