/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.org.virtual.service;

import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.fastjson.JSON;
import com.xforceplus.business.excel.BusinessType;
import com.xforceplus.business.excel.ExcelSheet;
import com.xforceplus.business.excel.reader.Context;
import com.xforceplus.business.excel.reader.MessageRow;
import com.xforceplus.business.excel.reader.SimpleDataReadListener;
import com.xforceplus.business.excel.writer.ExcelConfigBusinessType;
import com.xforceplus.business.org.virtual.dto.OrgVirtualNodeImportDto;
import com.xforceplus.business.org.virtual.dto.OrgVirtualNodeRelUserImportDto;
import com.xforceplus.business.org.virtual.service.OrgVirtualNodeService;
import com.xforceplus.business.org.virtual.service.OrgVirtualNodeUserService;
import com.xforceplus.business.service.ExcelReaderService;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OrgVirtualNodeImportServiceImpl
implements ExcelReaderService {
    public static final String TREE_ACTION_CREATE = "\u65b0\u5efa";
    public static final String TREE_ACTION_DELETE = "\u5220\u9664";
    public static final String TREE_BIND_USER_ACTION_CREATE = "\u7ed1\u5b9a";
    public static final String TREE_BIND_USER_ACTION_DELLETE = "\u89e3\u7ed1";
    public static final String TREE_BIND_USER_CONTRO_FLAG_CURRENT = "\u5f53\u524d\u7ec4\u7ec7";
    public static final String TREE_BIND_USER_CONTRO_FLAG_SUB = "\u5f53\u524d\u7ec4\u7ec7\u53ca\u4e0b\u7ea7\u7ec4\u7ec7";
    public static final String TREE_BIND_USER_ADMIN_FLAG_YES = "1";
    public static final List<String> ACTION_LISTS = Arrays.asList("\u65b0\u5efa", "\u5220\u9664");
    private static final Logger logger = LoggerFactory.getLogger(OrgVirtualNodeImportServiceImpl.class);
    @Resource
    private OrgVirtualNodeService orgVirtualNodeService;
    @Resource
    private OrgVirtualNodeUserService orgVirtualNodeUserService;

    @Override
    public BusinessType getBusinessType() {
        return ExcelConfigBusinessType.ORG_VIRTUAL_NODE_IMPORT;
    }

    @Override
    public Context importExcel(Context context) {
        List<ExcelSheet> sheets = context.getExcelBook().getExcelSheets();
        for (ExcelSheet sheet : sheets) {
            AnalysisEventListener excelDataListener;
            MessageRow messageRows = new MessageRow(sheet.getSheetName());
            String sheetName = sheet.getSheetName();
            if ("\u4e1a\u52a1\u7ec4\u7ec7\u6811".equals(sheetName)) {
                excelDataListener = SimpleDataReadListener.listener(context, rows -> this.saveData(messageRows, context, (List<OrgVirtualNodeImportDto>)rows));
                context.getSimpleExcelReader().read(OrgVirtualNodeImportDto.class, excelDataListener, sheetName);
                continue;
            }
            if (!"\u5173\u8054\u4eba\u5458".equals(sheetName)) continue;
            excelDataListener = SimpleDataReadListener.listener(context, rows -> this.saveDataRel(messageRows, context, (List<OrgVirtualNodeRelUserImportDto>)rows));
            context.getSimpleExcelReader().read(OrgVirtualNodeRelUserImportDto.class, excelDataListener, sheetName);
        }
        return context;
    }

    public void saveData(MessageRow messageRows, Context context, List<OrgVirtualNodeImportDto> list) {
        Long typeId;
        if (logger.isDebugEnabled()) {
            logger.debug("list:{}", (Object)JSON.toJSONString(list));
        }
        if (null == (typeId = Long.valueOf(context.getParams().get("typeId").toString()))) {
            logger.warn("\u83b7\u53d6\u53c2\u6570typeId\u5931\u8d25");
            return;
        }
        for (OrgVirtualNodeImportDto dto : list) {
            if (logger.isDebugEnabled()) {
                logger.debug("dto:{}", (Object)JSON.toJSONString((Object)dto));
            }
            if (!dto.getValidatedStatus().booleanValue()) {
                messageRows.fail(dto.getRowIndex(), dto.getValidatedMessage());
                continue;
            }
            String msg = this.orgVirtualNodeService.importSave(dto, context.getFileDTO().getTenantId(), typeId);
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{msg})) {
                messageRows.fail(dto.getRowIndex(), msg);
                continue;
            }
            messageRows.success(dto.getRowIndex());
        }
        context.messageRow(messageRows.getSheetName(), messageRows);
    }

    public void saveDataRel(MessageRow messageRows, Context context, List<OrgVirtualNodeRelUserImportDto> list) {
        Long typeId;
        if (logger.isDebugEnabled()) {
            logger.debug("list:{}", (Object)JSON.toJSONString(list));
        }
        if (null == (typeId = Long.valueOf(context.getParams().get("typeId").toString()))) {
            logger.warn("\u83b7\u53d6\u53c2\u6570typeId\u5931\u8d25");
            return;
        }
        for (OrgVirtualNodeRelUserImportDto dto : list) {
            if (logger.isDebugEnabled()) {
                logger.debug("dto:{}", (Object)JSON.toJSONString((Object)dto));
            }
            if (!dto.getValidatedStatus().booleanValue()) {
                messageRows.fail(dto.getRowIndex(), dto.getValidatedMessage());
                continue;
            }
            String msg = this.orgVirtualNodeUserService.importSave(dto, context.getFileDTO().getTenantId(), typeId);
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{msg})) {
                messageRows.fail(dto.getRowIndex(), msg);
                continue;
            }
            messageRows.success(dto.getRowIndex());
        }
        context.messageRow(messageRows.getSheetName(), messageRows);
    }
}

