/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.org.virtual.service;

import com.xforceplus.api.model.OrgVirtualModel;
import com.xforceplus.api.model.OrgVirtualNodeModel;
import com.xforceplus.api.model.TreeModel;
import com.xforceplus.business.excel.ExcelValidator;
import com.xforceplus.business.org.virtual.dto.OrgVirtualNodeImportDto;
import com.xforceplus.business.org.virtual.service.AsyncOrgVirtualNodeUserService;
import com.xforceplus.business.org.virtual.service.OrgVirtualNodeTypeService;
import com.xforceplus.business.org.virtual.service.OrgVirtualService;
import com.xforceplus.constants.OperationType;
import com.xforceplus.dao.OrgVirtualDao;
import com.xforceplus.dao.OrgVirtualNodeDao;
import com.xforceplus.dao.OrgVirtualUserRelDao;
import com.xforceplus.dao.UserDao;
import com.xforceplus.domain.orgVirtual.OrgVirtualTreeNode;
import com.xforceplus.entity.OrgVirtual;
import com.xforceplus.entity.OrgVirtualNode;
import com.xforceplus.entity.OrgVirtualNodeUserRel;
import com.xforceplus.entity.User;
import com.xforceplus.query.OrgVirtualNodeUserRelQueryHelper;
import com.xforceplus.query.OrgVirtualTreeQueryHelper;
import com.xforceplus.utils.StringHelp;
import io.geewit.data.jpa.essential.domain.EntityGraphs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class OrgVirtualNodeService {
    private static final Logger log = LoggerFactory.getLogger(OrgVirtualNodeService.class);
    private final OrgVirtualNodeDao orgVirtualNodeDao;
    private final OrgVirtualService orgVirtualService;
    private final OrgVirtualUserRelDao orgVirtualUserRelDao;
    private final UserDao userDao;
    private final OrgVirtualNodeTypeService orgVirtualNodeTypeService;
    private final AsyncOrgVirtualNodeUserService asyncOrgVirtualNodeUserService;
    private final OrgVirtualDao orgVirtualDao;

    public OrgVirtualNodeService(OrgVirtualNodeDao orgVirtualNodeDao, OrgVirtualService orgVirtualService, OrgVirtualUserRelDao orgVirtualUserRelDao, UserDao userDao, OrgVirtualNodeTypeService orgVirtualNodeTypeService, AsyncOrgVirtualNodeUserService asyncOrgVirtualNodeUserService, OrgVirtualDao orgVirtualDao) {
        this.orgVirtualNodeDao = orgVirtualNodeDao;
        this.orgVirtualService = orgVirtualService;
        this.orgVirtualUserRelDao = orgVirtualUserRelDao;
        this.userDao = userDao;
        this.orgVirtualNodeTypeService = orgVirtualNodeTypeService;
        this.asyncOrgVirtualNodeUserService = asyncOrgVirtualNodeUserService;
        this.orgVirtualDao = orgVirtualDao;
    }

    public Page<OrgVirtualNode> page(OrgVirtualNodeModel.Request.Query query, Pageable pageable) {
        Specification specification = OrgVirtualTreeQueryHelper.querySpecification((OrgVirtualNodeModel.Request.Query)query);
        return this.orgVirtualNodeDao.findAll(specification, pageable, EntityGraphs.named((String)"OrgVirtualNode.graph"));
    }

    public List<OrgVirtualNode> list(OrgVirtualNodeModel.Request.Query query) {
        Specification specification = OrgVirtualTreeQueryHelper.querySpecification((OrgVirtualNodeModel.Request.Query)query);
        return this.orgVirtualNodeDao.findAll(specification);
    }

    public OrgVirtualTreeNode tree(Long typeId, Long tenantId) {
        List list = this.orgVirtualNodeDao.treeNodeList(tenantId, typeId);
        return this.buildTreeForPage(list);
    }

    private OrgVirtualTreeNode buildTreeForPage(List<OrgVirtualTreeNode> orgs) {
        Map<Long, OrgVirtualTreeNode> datas = orgs.stream().collect(Collectors.toMap(OrgVirtualTreeNode::getKey, org -> org));
        OrgVirtualTreeNode root = null;
        for (OrgVirtualTreeNode ele : orgs) {
            if (null != ele.getPid()) {
                OrgVirtualTreeNode parent = datas.get(ele.getPid());
                if (CollectionUtils.isEmpty((Collection)parent.getChildren())) {
                    Set children = Stream.of(ele).collect(Collectors.toSet());
                    parent.setChildren(children);
                    continue;
                }
                parent.getChildren().add(ele);
                continue;
            }
            root = ele;
        }
        return root;
    }

    @Transactional(rollbackFor={Exception.class})
    public OrgVirtualNode currentCreate(Long typeId, Long tenantId, Long orgVirtualId) {
        this.orgVirtualNodeTypeService.findByNodeTypeId(typeId);
        this.orgVirtualService.findByTenantIdAndId(tenantId, orgVirtualId);
        Optional optionalOrgVirtualTree = this.orgVirtualNodeDao.findByTenantIdAndNodeTypeIdAndParentIdIsNull(tenantId.longValue(), typeId.longValue());
        if (optionalOrgVirtualTree.isPresent()) {
            String message = "\u6839\u7ec4\u7ec7\u5df2\u5b58\u5728(" + ((OrgVirtualNode)optionalOrgVirtualTree.get()).getOrgVirtualId() + ")";
            log.info(message);
            throw new IllegalArgumentException(message);
        }
        OrgVirtualNode tree = new OrgVirtualNode();
        tree.setTenantId(tenantId);
        tree.setOrgVirtualId(orgVirtualId);
        tree.setNodeTypeId(typeId);
        tree.setParentId(null);
        tree = (OrgVirtualNode)this.orgVirtualNodeDao.save((Object)tree);
        tree.setParentIds(tree.getOrgVirtualNodeId() + "#");
        tree = (OrgVirtualNode)this.orgVirtualNodeDao.saveAndFlush((Object)tree);
        return tree;
    }

    @Transactional(rollbackFor={Exception.class})
    public OrgVirtualNode currentAppend(OrgVirtualNodeModel.Request.Append append) {
        OrgVirtualNode parent = this.findByTenantIdAndNodeId(append.getTenantId(), append.getParentId());
        this.orgVirtualService.findByTenantIdAndId(append.getTenantId(), parent.getOrgVirtualId());
        OrgVirtual current = this.orgVirtualService.findByTenantIdAndId(append.getTenantId(), append.getOrgVirtualId());
        if (1 != current.getStatus()) {
            String message = "\u8be5\u7ec4\u7ec7\u5df2\u7981\u7528(" + append.getOrgVirtualId() + ")";
            log.info(message);
            throw new IllegalArgumentException(message);
        }
        OrgVirtualNodeModel.Request.Query query = new OrgVirtualNodeModel.Request.Query();
        query.setOrgVirtualId(append.getOrgVirtualId());
        query.setTenantId(append.getTenantId());
        query.setTypeId(parent.getNodeTypeId());
        List<OrgVirtualNode> existList = this.list(query);
        if (!CollectionUtils.isEmpty(existList)) {
            String message = "\u8be5\u4e1a\u52a1\u7ec4\u7ec7\u5df2\u5173\u8054\u4e1a\u52a1\u7ec4\u7ec7\u6811(" + existList.get(0).getParentId() + ")";
            log.info(message);
            throw new IllegalArgumentException(message);
        }
        OrgVirtualNode tree = new OrgVirtualNode();
        tree.setTenantId(append.getTenantId());
        tree.setOrgVirtualId(append.getOrgVirtualId());
        tree.setNodeTypeId(parent.getNodeTypeId());
        tree.setParentId(parent.getOrgVirtualNodeId());
        tree = (OrgVirtualNode)this.orgVirtualNodeDao.save((Object)tree);
        tree.setParentIds(parent.getParentIds() + tree.getOrgVirtualNodeId() + "/");
        tree = (OrgVirtualNode)this.orgVirtualNodeDao.saveAndFlush((Object)tree);
        this.asyncOrgVirtualNodeUserService.autoBindParentUsers(append.getTenantId(), tree.getOrgVirtualNodeId());
        return tree;
    }

    public OrgVirtualNode findByTenantIdAndNodeId(Long tenantId, Long id) {
        return (OrgVirtualNode)this.orgVirtualNodeDao.findByTenantIdAndOrgVirtualNodeId(tenantId.longValue(), id.longValue()).orElseThrow(() -> new IllegalArgumentException("\u672a\u627e\u5230\u4e1a\u52a1\u7ec4\u7ec7\u6811\uff08" + id + ")"));
    }

    @Transactional(rollbackFor={Exception.class})
    public void currentDelete(Long tenantId, Long id) {
        OrgVirtualNode tree = this.findByTenantIdAndNodeId(tenantId, id);
        List list = this.orgVirtualNodeDao.findByTenantIdAndParentId(tenantId.longValue(), id.longValue());
        if (!CollectionUtils.isEmpty((Collection)list)) {
            String message = "\u8be5\u8282\u70b9(" + id + ")\u5305\u542b\u4e0b\u7ea7\u7ec4\u7ec7\uff0c\u4e0d\u80fd\u5220\u9664";
            log.info(message);
            throw new IllegalArgumentException(message);
        }
        List userRels = this.orgVirtualUserRelDao.findByOrgVirtualNodeId(id.longValue());
        if (!CollectionUtils.isEmpty((Collection)userRels)) {
            String message = "\u8be5\u8282\u70b9(" + id + ")\u5305\u542b\u4eba\u5458\uff0c\u4e0d\u80fd\u5220\u9664";
            log.info(message);
            throw new IllegalArgumentException(message);
        }
        this.orgVirtualNodeDao.delete((Object)tree);
    }

    @Transactional(rollbackFor={Exception.class})
    public void tenantDelete(Long tenantId, Long id, Long typeId, Long userId, Integer operationType) {
        Optional orgVirtualNode = Optional.empty();
        List<Long> userIds = null;
        if (operationType <= OperationType.VIRTUAL) {
            OrgVirtual virtual = this.orgVirtualService.findByTenantIdAndId(tenantId, id);
            if (virtual == null || 0 == virtual.getStatus()) {
                String message = "\u8be5\u7ec4\u7ec7(" + id + ") \u4e0d\u5b58\u5728";
                log.info(message);
                throw new IllegalArgumentException(message);
            }
            virtual.setStatus(Integer.valueOf(0));
            this.orgVirtualDao.saveAndFlush((Object)virtual);
            orgVirtualNode = this.orgVirtualNodeDao.findByNodeTypeIdAndOrgVirtualId(typeId.longValue(), id.longValue());
            if (!orgVirtualNode.isPresent()) {
                log.info("virtualId :{} \u67e5\u8be2 orgVirtualNode \u4e3a\u7a7a  \u8df3\u8fc7\u6267\u884c", (Object)id);
                return;
            }
            id = ((OrgVirtualNode)orgVirtualNode.get()).getOrgVirtualNodeId();
        }
        if (operationType <= OperationType.NODE) {
            if (!orgVirtualNode.isPresent() && !(orgVirtualNode = this.orgVirtualNodeDao.findByTenantIdAndOrgVirtualNodeId(tenantId.longValue(), id.longValue())).isPresent()) {
                log.info("nodeid :{} \u67e5\u8be2 orgVirtualNode \u4e3a\u7a7a  \u8df3\u8fc7\u6267\u884c", (Object)id);
                throw new IllegalArgumentException("\u8be5\u8282\u70b9(" + id + ") \u4e0d\u5b58\u5728");
            }
            List list = this.orgVirtualNodeDao.findByTenantIdAndParentId(tenantId.longValue(), id.longValue());
            if (!CollectionUtils.isEmpty((Collection)list)) {
                String message = "\u8be5\u7ec4\u7ec7\u6216\u8282\u70b9\u5305\u542b\u4e0b\u7ea7\u7ec4\u7ec7\uff0c\u4e0d\u80fd\u5220\u9664";
                log.info(message);
                throw new IllegalArgumentException(message);
            }
            this.orgVirtualNodeDao.deleteByNodeId(tenantId.longValue(), id.longValue());
            List orgVirtualNodeUserRels = this.orgVirtualUserRelDao.findByOrgVirtualNodeId(id.longValue());
            if (CollectionUtils.isEmpty((Collection)orgVirtualNodeUserRels)) {
                log.warn("nodeid :{} \u67e5\u8be2 orgVirtualNodeUserRels \u4e3a\u7a7a,\u8df3\u8fc7\u6267\u884c", (Object)id);
                return;
            }
            userIds = orgVirtualNodeUserRels.stream().map(OrgVirtualNodeUserRel::getUserId).collect(Collectors.toList());
        }
        if (operationType <= OperationType.NODE_USER_REL) {
            if (CollectionUtils.isEmpty(userIds)) {
                if (Objects.isNull(userId)) {
                    log.warn("id {} operationType {}  userId \u4e3a\u7a7a  \u8df3\u8fc7\u6267\u884c", (Object)id, (Object)operationType);
                    return;
                }
                userIds = Collections.singletonList(userId);
            }
            this.orgVirtualUserRelDao.deleteByUserIdsAndNodeId(tenantId.longValue(), userIds, id.longValue());
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void unbindUsers(long tenantId, Long nodeId, OrgVirtualNodeModel.Request.UnbindUsers unbindUsers) {
        List userIds = unbindUsers.getUserIds();
        if (CollectionUtils.isEmpty((Collection)userIds)) {
            String message = "\u53c2\u6570\u7f3a\u5c11\u7528\u6237id\u96c6\u5408";
            log.info(message);
            throw new IllegalArgumentException(message);
        }
        if (!CollectionUtils.isEmpty((Collection)userIds)) {
            this.orgVirtualUserRelDao.deleteByUserIdsAndNodeId(tenantId, userIds, nodeId.longValue());
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void bindUsers(long tenantId, Long nodeId, OrgVirtualNodeModel.Request.BindUsers bindUsers) {
        List userIds = bindUsers.getUserIds();
        if (CollectionUtils.isEmpty((Collection)userIds)) {
            String message = "\u53c2\u6570\u7f3a\u5c11\u7528\u6237id\u96c6\u5408";
            log.info(message);
            throw new IllegalArgumentException(message);
        }
        OrgVirtualNode orgVirtualNode = this.findByTenantIdAndNodeId(tenantId, nodeId);
        List existRels = this.orgVirtualUserRelDao.findByOrgVirtualNodeId(orgVirtualNode.getOrgVirtualNodeId().longValue());
        Set<OrgVirtualNodeUserRel> insertingRels = userIds.stream().filter(Objects::nonNull).filter(userId -> existRels.stream().map(OrgVirtualNodeUserRel::getUserId).noneMatch(relUserId -> relUserId.equals(userId))).map(userId -> {
            Optional userOptional = this.userDao.findById(userId);
            if (userOptional.isPresent()) {
                OrgVirtualNodeUserRel treeUserRel = new OrgVirtualNodeUserRel();
                treeUserRel.setTenantId(((User)userOptional.get()).getTenantId());
                treeUserRel.setOrgVirtualNodeId(nodeId);
                treeUserRel.setUserId(userId);
                treeUserRel.setTenantId(Long.valueOf(tenantId));
                treeUserRel.setControlFlag(Integer.valueOf(0));
                return treeUserRel;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        if (!insertingRels.isEmpty()) {
            insertingRels.forEach(arg_0 -> ((OrgVirtualUserRelDao)this.orgVirtualUserRelDao).saveAndFlush(arg_0));
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void bindAdminInfo(long tenantId, Long nodeId, OrgVirtualNodeModel.Request.BindAdminInfo bindAdminInfo) {
        if (Objects.isNull(bindAdminInfo) || CollectionUtils.isEmpty((Collection)bindAdminInfo.getAdmins())) {
            String message = "\u53c2\u6570\u7f3a\u5c11\u7ba1\u7406\u5458\u8bbe\u7f6e\u4fe1\u606f";
            log.info(message);
            throw new IllegalArgumentException(message);
        }
        OrgVirtualNode orgVirtualNode = this.findByTenantIdAndNodeId(tenantId, nodeId);
        List admins = bindAdminInfo.getAdmins();
        Map<Long, List<OrgVirtualNodeModel.Request.AdminInfo>> adminMap = admins.stream().filter(Objects::nonNull).filter(admin -> Objects.nonNull(admin.getUserId())).collect(Collectors.groupingBy(OrgVirtualNodeModel.Request.AdminInfo::getUserId));
        List existRels = this.orgVirtualUserRelDao.findByOrgVirtualNodeId(orgVirtualNode.getOrgVirtualNodeId().longValue());
        existRels.forEach(rel -> {
            if (adminMap.containsKey(rel.getUserId())) {
                rel.setAdminFlag(((OrgVirtualNodeModel.Request.AdminInfo)((List)adminMap.get(rel.getUserId())).get(0)).getSort());
            }
        });
        if (!existRels.isEmpty()) {
            this.orgVirtualUserRelDao.saveBatch((Iterable)existRels);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void markUserMainOrg(long tenantId, Long nodeId, OrgVirtualNodeModel.Request.BindUsers users) {
        if (Objects.isNull(users) || CollectionUtils.isEmpty((Collection)users.getUserIds())) {
            String message = "\u53c2\u6570\u7f3a\u5c11\u6709\u6548\u7684\u7528\u6237\u4fe1\u606f";
            log.info(message);
            throw new IllegalArgumentException(message);
        }
        OrgVirtualNode orgVirtualNode = this.findByTenantIdAndNodeId(tenantId, nodeId);
        Long typeId = orgVirtualNode.getNodeTypeId();
        List userIds = users.getUserIds().stream().filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(userIds)) {
            String message = "\u53c2\u6570\u7f3a\u5c11\u6709\u6548\u7684\u7528\u6237\u4fe1\u606f";
            log.info(message);
            throw new IllegalArgumentException(message);
        }
        this.orgVirtualUserRelDao.markMainOrg(nodeId.longValue(), tenantId, typeId.longValue(), userIds);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateControlScope(long tenantId, Long nodeId, OrgVirtualNodeModel.Request.UsersScope usersScope) {
        List userIds = usersScope.getUserIds();
        if (CollectionUtils.isEmpty((Collection)userIds)) {
            String message = "\u53c2\u6570\u7f3a\u5c11\u7528\u6237id\u96c6\u5408";
            log.info(message);
            throw new IllegalArgumentException(message);
        }
        int controlFlag = usersScope.getControlFlag();
        OrgVirtualNode node = this.findByTenantIdAndNodeId(tenantId, nodeId);
        userIds.forEach(userId -> {
            Optional optionalOrgVirtualNodeUserRel = this.orgVirtualUserRelDao.findByOrgVirtualNodeIdAndTenantIdAndUserId(nodeId.longValue(), tenantId, userId.longValue());
            if (!optionalOrgVirtualNodeUserRel.isPresent()) {
                return;
            }
            OrgVirtualNodeUserRel rel = (OrgVirtualNodeUserRel)optionalOrgVirtualNodeUserRel.get();
            if (controlFlag != rel.getControlFlag()) {
                switch (controlFlag) {
                    case 1: {
                        this.choiceSub(node, (Long)userId);
                        break;
                    }
                    case 0: {
                        this.unChoiceSub(node, (Long)userId);
                        break;
                    }
                }
                rel.setControlFlag(Integer.valueOf(controlFlag));
                this.orgVirtualUserRelDao.saveAndFlush((Object)rel);
            }
        });
    }

    public List<OrgVirtualNode> findSubByParentIds(OrgVirtualNode node) {
        OrgVirtualNodeModel.Request.Query query = new OrgVirtualNodeModel.Request.Query();
        query.setParentIds(node.getParentIds());
        query.setTenantId(node.getTenantId());
        query.setTypeId(node.getNodeTypeId());
        return this.list(query);
    }

    public void choiceSub(OrgVirtualNode node, Long userId) {
        List<OrgVirtualNode> nodes = this.findSubByParentIds(node);
        Set<OrgVirtualNodeUserRel> insertingRels = nodes.stream().filter(Objects::nonNull).map(orgVirtualNode -> {
            Optional rel = this.orgVirtualUserRelDao.findByOrgVirtualNodeIdAndUserId(orgVirtualNode.getOrgVirtualNodeId().longValue(), userId.longValue());
            if (!rel.isPresent()) {
                OrgVirtualNodeUserRel treeUserRel = new OrgVirtualNodeUserRel();
                treeUserRel.setTenantId(node.getTenantId());
                treeUserRel.setOrgVirtualNodeId(orgVirtualNode.getOrgVirtualNodeId());
                treeUserRel.setUserId(userId);
                treeUserRel.setTenantId(node.getTenantId());
                treeUserRel.setControlFlag(Integer.valueOf(1));
                return treeUserRel;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        if (!insertingRels.isEmpty()) {
            insertingRels.forEach(arg_0 -> ((OrgVirtualUserRelDao)this.orgVirtualUserRelDao).saveAndFlush(arg_0));
        }
    }

    public void unChoiceSub(OrgVirtualNode node, Long userId) {
        List<OrgVirtualNode> nodes = this.findSubByParentIds(node);
        nodes.stream().filter(orgVirtualNode -> !orgVirtualNode.getOrgVirtualNodeId().equals(node.getOrgVirtualNodeId())).forEach(orgVirtualNode -> this.orgVirtualUserRelDao.deleteByTenantIdAndUserIdAndOrgVirtualNodeId(orgVirtualNode.getTenantId().longValue(), userId.longValue(), orgVirtualNode.getOrgVirtualNodeId().longValue()));
    }

    public Page<OrgVirtualNodeUserRel> currentBindedTrees(OrgVirtualNodeModel.Request.BindedUsers query, Pageable currentPageable) {
        Specification specification = OrgVirtualNodeUserRelQueryHelper.querySpecification((OrgVirtualNodeModel.Request.BindedUsers)query);
        return this.orgVirtualUserRelDao.findAll(specification, currentPageable, EntityGraphs.named((String)"OrgVirtualNodeUserRel.graph"));
    }

    public List<User> currentBindedAdminInfo(OrgVirtualNodeModel.Request.BindedUsers query, Integer adminFlag, Boolean isNodeId, Long typeId) {
        List re;
        if (!isNodeId.booleanValue()) {
            Long virtualId = query.getOrgVirtualNodeId();
            Optional optionalOrgVirtualNode = this.orgVirtualNodeDao.findByNodeTypeIdAndOrgVirtualIdAndTenantId(query.getTenantId().longValue(), typeId.longValue(), virtualId.longValue());
            if (!optionalOrgVirtualNode.isPresent()) {
                String message = "\u65e0\u6548\u7684\u865a\u62df\u7ec4\u7ec7id: " + virtualId;
                log.info(message);
                throw new IllegalArgumentException(message);
            }
            query.setOrgVirtualNodeId(((OrgVirtualNode)optionalOrgVirtualNode.get()).getOrgVirtualNodeId());
        }
        if (CollectionUtils.isEmpty((Collection)(re = this.orgVirtualUserRelDao.findByOrgVirtualNodeIdAndAdminFlag(query.getOrgVirtualNodeId().longValue(), adminFlag)))) {
            return Collections.emptyList();
        }
        return re.stream().map(rel -> {
            try {
                User user = rel.getUser();
                user.setAppResources(null);
                user.setAccount(null);
                user.setTenant(null);
                return user;
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5f02\u5e38{}\uff0cuserid {}", (Object)e, (Object)rel.getUserId());
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<OrgVirtualNodeModel.Response.ExcelExportModel> listNodeToExcel(OrgVirtualNodeModel.Request.ExcelExportQuery query) {
        List list = this.orgVirtualNodeDao.treeNodeList(query.getTenantId(), query.getTypeId());
        return this.buildFlatList(list);
    }

    public List<OrgVirtualNodeModel.Response.ExcelExportModel> listNodeRelAccountToExcel(OrgVirtualNodeModel.Request.ExcelExportQuery query) {
        List list = this.orgVirtualNodeDao.listNodeRelAccount(query.getTenantId(), query.getTypeId());
        for (OrgVirtualNodeModel.Response.ExcelExportModel model : list) {
            if (null != model.getControlFlag()) {
                model.setControlFlagValue(1 == model.getControlFlag() ? "\u5f53\u524d\u7ec4\u7ec7\u53ca\u4e0b\u7ea7\u7ec4\u7ec7" : "\u5f53\u524d\u7ec4\u7ec7");
            }
            if (null == model.getAdminFlag()) continue;
            model.setAdminFlagValue(model.getAdminFlag().compareTo(0) > 0 ? "\u662f" : "\u5426");
        }
        return list;
    }

    private List<OrgVirtualNodeModel.Response.ExcelExportModel> buildFlatList(List<OrgVirtualTreeNode> orgs) {
        Map<Long, OrgVirtualTreeNode> datas = orgs.stream().collect(Collectors.toMap(OrgVirtualTreeNode::getKey, org -> org));
        ArrayList<OrgVirtualNodeModel.Response.ExcelExportModel> list = new ArrayList<OrgVirtualNodeModel.Response.ExcelExportModel>();
        for (OrgVirtualTreeNode ele : orgs) {
            OrgVirtualTreeNode parent;
            OrgVirtualNodeModel.Response.ExcelExportModel model = new OrgVirtualNodeModel.Response.ExcelExportModel();
            model.setOrgCode(ele.getOrgCode());
            model.setOrgName(ele.getOrgName());
            if (null != ele.getPid() && null != (parent = datas.get(ele.getPid()))) {
                model.setParentOrgCode(parent.getOrgCode());
                model.setParentOrgName(parent.getOrgName());
            }
            list.add(model);
        }
        return list;
    }

    @Transactional(rollbackFor={Exception.class})
    public String importSave(OrgVirtualNodeImportDto dto, Long tenantId, Long typeId) {
        OrgVirtual orgVirtual;
        ArrayList<String> errMsg = new ArrayList<String>();
        ExcelValidator.validate(dto);
        if (StringUtils.isNotBlank((CharSequence)dto.getValidatedMessage())) {
            errMsg.add(dto.getValidatedMessage());
        }
        if (null == (orgVirtual = this.orgVirtualService.findByTenantIdAndOrgCode(tenantId, dto.getOrgCode()))) {
            errMsg.add("\u4e0d\u5b58\u5728\u7684\u4e1a\u52a1\u7ec4\u7ec7[" + dto.getOrgCode() + "]");
        }
        OrgVirtual parentOrg = null;
        if ("\u65b0\u5efa".equals(dto.getAction()) && StringUtils.isNotBlank((CharSequence)dto.getParentOrgCode()) && null == (parentOrg = this.orgVirtualService.findByTenantIdAndOrgCode(tenantId, dto.getParentOrgCode()))) {
            errMsg.add("\u4e0d\u5b58\u5728\u7684\u4e0a\u7ea7\u4e1a\u52a1\u7ec4\u7ec7[" + dto.getParentOrgCode() + "]");
        }
        if (!CollectionUtils.isEmpty(errMsg)) {
            return String.join((CharSequence)";", errMsg);
        }
        switch (dto.getAction()) {
            case "\u65b0\u5efa": {
                try {
                    this.importBuildNode(tenantId, typeId, orgVirtual, parentOrg);
                }
                catch (Exception ex) {
                    errMsg.add(ex.getMessage());
                }
                break;
            }
            case "\u5220\u9664": {
                try {
                    this.importRemoveNode(tenantId, typeId, orgVirtual);
                }
                catch (Exception ex) {
                    errMsg.add(ex.getMessage());
                }
                break;
            }
        }
        if (!CollectionUtils.isEmpty(errMsg)) {
            return String.join((CharSequence)";", errMsg);
        }
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public void importRemoveNode(Long tenantId, long typeId, OrgVirtual orgVirtual) {
        if (orgVirtual == null) {
            return;
        }
        Optional temp = this.orgVirtualNodeDao.findByNodeTypeIdAndOrgVirtualId(typeId, orgVirtual.getOrgVirtualId().longValue());
        if (!temp.isPresent()) {
            String message = "\u4e0d\u5b58\u5728\u7684\u4e1a\u52a1\u7ec4\u7ec7[" + orgVirtual.getOrgCode() + "]";
            log.info(message);
            throw new IllegalArgumentException(message);
        }
        this.currentDelete(tenantId, ((OrgVirtualNode)temp.get()).getOrgVirtualNodeId());
    }

    @Transactional(rollbackFor={Exception.class})
    public void importBuildNode(Long tenantId, long typeId, OrgVirtual orgVirtual, OrgVirtual parentOrg) {
        if (null == parentOrg) {
            this.currentCreate(typeId, tenantId, orgVirtual.getOrgVirtualId());
        } else {
            Optional temp = this.orgVirtualNodeDao.findByNodeTypeIdAndOrgVirtualId(typeId, parentOrg.getOrgVirtualId().longValue());
            if (!temp.isPresent()) {
                String message = "\u4e0d\u5b58\u5728\u7684\u4e0a\u7ea7\u4e1a\u52a1\u7ec4\u7ec7[" + orgVirtual.getOrgCode() + "]";
                log.info(message);
                throw new IllegalArgumentException(message);
            }
            OrgVirtualNodeModel.Request.Append append = new OrgVirtualNodeModel.Request.Append();
            append.setOrgVirtualId(orgVirtual.getOrgVirtualId());
            append.setTenantId(tenantId);
            append.setParentId(((OrgVirtualNode)temp.get()).getOrgVirtualNodeId());
            this.currentAppend(append);
        }
    }

    public List<OrgVirtualModel.Response.Model> listByUserId(Long typeId, Long userId, Long tenantId) {
        return this.orgVirtualNodeDao.listByUserId(typeId, userId, tenantId);
    }

    public List<OrgVirtualModel.Response.Model> listByNodeId(Long nodeId, Long tenantId, TreeModel.Scope scope) {
        OrgVirtualNode node = (OrgVirtualNode)this.orgVirtualNodeDao.findByTenantIdAndOrgVirtualNodeId(tenantId.longValue(), nodeId.longValue()).orElseThrow(() -> new IllegalArgumentException("\u672a\u627e\u5230\u4e1a\u52a1\u7ec4\u7ec7\u6811\uff08" + nodeId + ")"));
        return this.orgVirtualNodeDao.listByNodeId(node, scope);
    }

    public List<OrgVirtualModel.Response.Model> listByKeys(Long tenantId, TreeModel.Scope scope, Integer nodeTypeId, boolean byId, Set<String> keySet) {
        List models = this.orgVirtualNodeDao.listByKeys(tenantId, nodeTypeId, byId, keySet);
        if (TreeModel.Scope.SELF.equals((Object)scope)) {
            return models;
        }
        for (OrgVirtualModel.Response.Model model : models) {
            OrgVirtualNode node = new OrgVirtualNode();
            node.setNodeTypeId(model.getNodeTypeId());
            node.setOrgVirtualNodeId(model.getOrgVirtualNodeId());
            node.setParentId(model.getParentId());
            node.setParentIds(model.getParentIds());
            node.setTenantId(model.getTenantId());
            List list = this.orgVirtualNodeDao.listByNodeId(node, scope);
            list = list.stream().filter(m -> !m.getOrgVirtualNodeId().equals(model.getOrgVirtualNodeId())).collect(Collectors.toList());
            switch (scope) {
                case PARENTS: {
                    model.setParents(list);
                    break;
                }
                case CHILDREN: {
                    model.setChildren(list);
                    break;
                }
            }
        }
        return models;
    }

    public OrgVirtualModel.Response.Model treeByNodeId(Long nodeId, Long tenantId, TreeModel.Scope scope) {
        List<OrgVirtualModel.Response.Model> list = this.listByNodeId(nodeId, tenantId, scope);
        return this.buildTree(list);
    }

    private OrgVirtualModel.Response.Model buildTree(List<OrgVirtualModel.Response.Model> orgs) {
        if (CollectionUtils.isEmpty(orgs)) {
            return null;
        }
        Map<Long, OrgVirtualModel.Response.Model> datas = orgs.stream().collect(Collectors.toMap(OrgVirtualModel.Response.Model::getOrgVirtualNodeId, org -> org));
        OrgVirtualModel.Response.Model root = orgs.get(0);
        for (OrgVirtualModel.Response.Model ele : orgs) {
            int level = StringHelp.getCount((String)ele.getParentIds(), (String)"/") + 1;
            ele.setLevel(Integer.valueOf(level));
            if (null == datas.get(ele.getParentId()) && ele.getParentIds().endsWith(ele.getOrgVirtualNodeId() + "/")) continue;
            if (null != ele.getParentId()) {
                OrgVirtualModel.Response.Model parent = datas.get(ele.getParentId());
                if (CollectionUtils.isEmpty((Collection)parent.getChildren())) {
                    Set children = Stream.of(ele).collect(Collectors.toSet());
                    parent.setChildren(children);
                    continue;
                }
                parent.getChildren().add(ele);
                continue;
            }
            root = ele;
        }
        return root;
    }
}

