/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.org.virtual.service;

import com.google.common.collect.Lists;
import com.xforceplus.api.model.OrgVirtualNodeModel;
import com.xforceplus.business.excel.ExcelValidator;
import com.xforceplus.business.org.virtual.dto.OrgVirtualNodeRelUserImportDto;
import com.xforceplus.business.org.virtual.service.OrgVirtualNodeService;
import com.xforceplus.business.tenant.service.TenantService;
import com.xforceplus.business.tenant.service.UserService;
import com.xforceplus.dao.OrgVirtualNodeDao;
import com.xforceplus.entity.Tenant;
import com.xforceplus.entity.User;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class OrgVirtualNodeUserService {
    private static final Logger logger = LoggerFactory.getLogger(OrgVirtualNodeUserService.class);
    private final OrgVirtualNodeDao orgVirtualNodeDao;
    @Resource
    private OrgVirtualNodeService orgVirtualNodeService;
    @Resource
    private UserService userService;
    @Resource
    private TenantService tenantService;

    public OrgVirtualNodeUserService(OrgVirtualNodeDao orgVirtualNodeDao) {
        this.orgVirtualNodeDao = orgVirtualNodeDao;
    }

    @Transactional(rollbackFor={Exception.class})
    public String importSave(OrgVirtualNodeRelUserImportDto dto, Long tenantId, Long typeId) {
        Optional optionalNodeId;
        ArrayList<String> errMsg = new ArrayList<String>();
        ExcelValidator.validate(dto);
        if (StringUtils.isNotBlank((CharSequence)dto.getValidatedMessage())) {
            errMsg.add(dto.getValidatedMessage());
        }
        if (!(optionalNodeId = this.orgVirtualNodeDao.findByNodeTypeIdAndOrgCodeAndTenantId(tenantId.longValue(), typeId.longValue(), dto.getOrgCode())).isPresent()) {
            errMsg.add("\u4e0d\u5b58\u5728\u7684\u4e1a\u52a1\u7ec4\u7ec7[" + dto.getOrgCode() + "]");
        }
        Tenant tenant = this.tenantService.findById(tenantId);
        String username = dto.getUsername();
        String tenantUsername = this.userService.getDomainAccountName(username, tenant.getTenantCode());
        Optional<User> userOptional = this.userService.findByTenantIdAndUsername(tenantId, tenantUsername);
        if (!userOptional.isPresent() && !(userOptional = this.userService.findByTenantIdAndUsername(tenantId, username)).isPresent()) {
            errMsg.add("\u4e0d\u5b58\u5728\u7684\u8d26\u53f7[" + dto.getUsername() + "]");
        }
        if (!CollectionUtils.isEmpty(errMsg)) {
            return String.join((CharSequence)";", errMsg);
        }
        if (userOptional.isPresent()) {
            User user = userOptional.get();
            if ("\u7ed1\u5b9a".equals(dto.getAction())) {
                OrgVirtualNodeModel.Request.BindUsers bindUsers = new OrgVirtualNodeModel.Request.BindUsers();
                bindUsers.setUserIds((List)Lists.newArrayList((Object[])new Long[]{user.getId()}));
                optionalNodeId.ifPresent(nodeId -> this.orgVirtualNodeService.bindUsers(tenantId, (Long)nodeId, bindUsers));
                if ("\u5f53\u524d\u7ec4\u7ec7\u53ca\u4e0b\u7ea7\u7ec4\u7ec7".equals(dto.getControlFlag())) {
                    OrgVirtualNodeModel.Request.UsersScope usersScope = new OrgVirtualNodeModel.Request.UsersScope();
                    usersScope.setControlFlag(1);
                    usersScope.setUserIds((List)Lists.newArrayList((Object[])new Long[]{user.getId()}));
                    optionalNodeId.ifPresent(nodeId -> this.orgVirtualNodeService.updateControlScope(tenantId, (Long)nodeId, usersScope));
                }
                if ("1".equals(dto.getAdminFlag())) {
                    OrgVirtualNodeModel.Request.BindAdminInfo bindAdminInfo = new OrgVirtualNodeModel.Request.BindAdminInfo();
                    OrgVirtualNodeModel.Request.AdminInfo adminInfo = new OrgVirtualNodeModel.Request.AdminInfo();
                    adminInfo.setUserId(user.getId());
                    adminInfo.setSort(Integer.valueOf(1));
                    bindAdminInfo.setAdmins((List)Lists.newArrayList((Object[])new OrgVirtualNodeModel.Request.AdminInfo[]{adminInfo}));
                    optionalNodeId.ifPresent(nodeId -> this.orgVirtualNodeService.bindAdminInfo(tenantId, (Long)nodeId, bindAdminInfo));
                }
            } else if ("\u89e3\u7ed1".equals(dto.getAction())) {
                OrgVirtualNodeModel.Request.UnbindUsers unbindUsers = new OrgVirtualNodeModel.Request.UnbindUsers();
                unbindUsers.setUserIds((List)Lists.newArrayList((Object[])new Long[]{user.getId()}));
                optionalNodeId.ifPresent(nodeId -> this.orgVirtualNodeService.unbindUsers(tenantId, (Long)nodeId, unbindUsers));
            }
        }
        return null;
    }
}

