/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.org.virtual.service;

import com.xforceplus.api.model.OrgVirtualOrgStructRelModel;
import com.xforceplus.business.excel.ExcelValidator;
import com.xforceplus.business.org.virtual.dto.OrgVirtualOrgStructImportDto;
import com.xforceplus.dao.OrgStructDao;
import com.xforceplus.dao.OrgVirtualDao;
import com.xforceplus.dao.OrgVirtualOrgStructDao;
import com.xforceplus.entity.OrgStruct;
import com.xforceplus.entity.OrgVirtual;
import com.xforceplus.entity.OrgVirtualOrgStructRel;
import com.xforceplus.query.OrgVirtualOrgStructRelQueryHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class OrgVirtualOrgStructService {
    private static final Logger log = LoggerFactory.getLogger(OrgVirtualOrgStructService.class);
    @Autowired
    private OrgVirtualOrgStructDao orgVirtualOrgStructDao;
    @Autowired
    private OrgVirtualDao orgVirtualDao;
    @Autowired
    private OrgStructDao orgStructDao;

    public Page<OrgVirtualOrgStructRel> page(OrgVirtualOrgStructRelModel.Request.Query query, Pageable pageable) {
        Specification specification = OrgVirtualOrgStructRelQueryHelper.querySpecification((OrgVirtualOrgStructRelModel.Request.Query)query);
        return this.orgVirtualOrgStructDao.findAll(specification, pageable);
    }

    public Boolean saveAllAndFlush(List<OrgVirtualOrgStructRel> list) {
        this.orgVirtualOrgStructDao.saveAllAndFlush(list);
        return true;
    }

    @Transactional(rollbackFor={Exception.class})
    public Boolean relate(OrgVirtualOrgStructRelModel.Request.Relate model) {
        this.validOrg(model.getTenantId(), model.getOrgStructs());
        if (Objects.isNull(model.getOrgVirtualId())) {
            throw new IllegalArgumentException("\u4e1a\u52a1\u7ec4\u7ec7id\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        this.orgVirtualOrgStructDao.deleteByTenantIdAndOrgVirtualId(model.getTenantId().longValue(), model.getOrgVirtualId().longValue());
        ArrayList<OrgVirtualOrgStructRel> list = new ArrayList<OrgVirtualOrgStructRel>();
        model.getOrgStructs().forEach(orgStructSimple -> {
            OrgVirtualOrgStructRel rel = new OrgVirtualOrgStructRel();
            rel.setTenantId(model.getTenantId());
            rel.setOrgVirtualId(model.getOrgVirtualId());
            rel.setOrgStructId(orgStructSimple.getOrgStructId());
            rel.setOrgStructName(orgStructSimple.getOrgStructName());
            rel.setCreateTime(new Date());
            rel.setUpdateTime(new Date());
            list.add(rel);
        });
        return this.saveAllAndFlush(list);
    }

    private void validOrg(Long tenantId, List<OrgVirtualOrgStructRelModel.Request.OrgStructSimple> orgStructs) {
        if (CollectionUtils.isEmpty(orgStructs)) {
            throw new IllegalArgumentException("\u884c\u653f\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        orgStructs.forEach(orgStructSimple -> {
            if (Objects.isNull(orgStructSimple.getOrgStructId())) {
                throw new IllegalArgumentException("\u884c\u653f\u7ec4\u7ec7id\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            Long orgStructId = this.orgStructDao.findOrgIdByTenantIdAndOrgId(tenantId.longValue(), orgStructSimple.getOrgStructId().longValue());
            if (Objects.isNull(orgStructId)) {
                throw new IllegalArgumentException("\u672a\u627e\u5230\u7ec4\u7ec7\u5b9e\u4f53(tenantId:" + tenantId + ", orgId:" + orgStructSimple.getOrgStructId());
            }
        });
    }

    @Transactional(rollbackFor={Exception.class})
    public String importSave(OrgVirtualOrgStructImportDto dto, Long tenantId) {
        Optional orgVirtualOpt;
        ArrayList<String> errMsg = new ArrayList<String>();
        ExcelValidator.validate(dto);
        if (StringUtils.isNotBlank((CharSequence)dto.getValidatedMessage())) {
            errMsg.add(dto.getValidatedMessage());
        }
        OrgStruct orgStruct = null;
        if (StringUtils.isNotBlank((CharSequence)dto.getOrgStructCode())) {
            List orgStructs = this.orgStructDao.findByTenantIdAndOrgCode(tenantId.longValue(), dto.getOrgStructCode());
            if (CollectionUtils.isEmpty((Collection)orgStructs)) {
                errMsg.add("\u4e0d\u5b58\u5728\u7684\u7ec4\u7ec7[" + dto.getOrgStructCode() + "]");
            } else {
                orgStruct = (OrgStruct)orgStructs.get(0);
                switch (orgStruct.getStatus()) {
                    case 0: {
                        errMsg.add("\u8be5\u7ec4\u7ec7\u672a\u542f\u7528[" + dto.getOrgStructCode() + "]");
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        errMsg.add("\u8be5\u7ec4\u7ec7\u5df2\u7981\u7528[" + dto.getOrgStructCode() + "]");
                        break;
                    }
                }
            }
        }
        if (!(orgVirtualOpt = this.orgVirtualDao.findByTenantIdAndOrgCode(tenantId.longValue(), dto.getOrgVirtualCode())).isPresent()) {
            errMsg.add("\u4e0d\u5b58\u5728\u7684\u4e1a\u52a1\u7ec4\u7ec7[" + dto.getOrgVirtualCode() + "]");
        }
        if (!CollectionUtils.isEmpty(errMsg)) {
            return String.join((CharSequence)";", errMsg);
        }
        if ("\u65b0\u589e".equals(dto.getAction())) {
            OrgVirtualOrgStructRelModel.Request.Relate model = new OrgVirtualOrgStructRelModel.Request.Relate();
            model.setTenantId(tenantId);
            OrgVirtualOrgStructRelModel.Request.OrgStructSimple orgStructSimple = new OrgVirtualOrgStructRelModel.Request.OrgStructSimple();
            orgStructSimple.setOrgStructId(orgStruct.getOrgId());
            orgStructSimple.setOrgStructName(orgStruct.getOrgName());
            model.setOrgStructs(Arrays.asList(orgStructSimple));
            model.setOrgVirtualId(((OrgVirtual)orgVirtualOpt.get()).getOrgVirtualId());
            try {
                this.relate(model);
            }
            catch (Exception e) {
                errMsg.add(e.getMessage());
            }
        }
        if (!CollectionUtils.isEmpty(errMsg)) {
            return String.join((CharSequence)";", errMsg);
        }
        return null;
    }

    public List<OrgVirtualOrgStructRelModel.Response.ExcelExportModel> listToExcel(OrgVirtualOrgStructRelModel.Request.ExcelExportQuery excelQuery) {
        OrgVirtualOrgStructRelModel.Request.Query query = new OrgVirtualOrgStructRelModel.Request.Query();
        BeanUtils.copyProperties((Object)excelQuery, (Object)query);
        Specification specification = OrgVirtualOrgStructRelQueryHelper.querySpecification((OrgVirtualOrgStructRelModel.Request.Query)query);
        List list = this.orgVirtualOrgStructDao.findAll(specification);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            ArrayList<OrgVirtualOrgStructRelModel.Response.ExcelExportModel> ret = new ArrayList<OrgVirtualOrgStructRelModel.Response.ExcelExportModel>();
            for (OrgVirtualOrgStructRel rel : list) {
                OrgVirtualOrgStructRelModel.Response.ExcelExportModel model = new OrgVirtualOrgStructRelModel.Response.ExcelExportModel();
                BeanUtils.copyProperties((Object)rel, (Object)model);
                ret.add(model);
            }
            return ret;
        }
        return null;
    }

    @Async(value="threadPoolExecutor")
    public void asyncRelateParentOrgVirtual(OrgStruct orgStruct) {
        try {
            Long parentOrgId = orgStruct.getParentId();
            if (Objects.nonNull(parentOrgId)) {
                OrgVirtualOrgStructRelModel.Request.Query query = new OrgVirtualOrgStructRelModel.Request.Query();
                query.setTenantId(orgStruct.getTenantId());
                query.setOrgStructId(parentOrgId);
                Specification specification = OrgVirtualOrgStructRelQueryHelper.querySpecification((OrgVirtualOrgStructRelModel.Request.Query)query);
                List rels = this.orgVirtualOrgStructDao.findAll(specification);
                if (!CollectionUtils.isEmpty((Collection)rels)) {
                    ArrayList<OrgVirtualOrgStructRel> list = new ArrayList<OrgVirtualOrgStructRel>();
                    for (OrgVirtualOrgStructRel rel : rels) {
                        OrgVirtualOrgStructRel oo = new OrgVirtualOrgStructRel();
                        oo.setOrgStructId(orgStruct.getOrgId());
                        oo.setTenantId(orgStruct.getTenantId());
                        oo.setOrgVirtualId(rel.getOrgVirtualId());
                        oo.setOrgStructName(orgStruct.getOrgName());
                        oo.setCreateTime(new Date());
                        oo.setUpdateTime(new Date());
                        list.add(oo);
                    }
                    this.orgVirtualOrgStructDao.saveAllAndFlush(list);
                }
            }
        }
        catch (Exception e) {
            log.error("error relate parent org virtual", (Object)e.getMessage());
        }
    }
}

