/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.org.virtual.service;

import com.xforceplus.api.model.OrgVirtualModel;
import com.xforceplus.business.excel.ExcelValidator;
import com.xforceplus.business.org.virtual.dto.OrgVirtualImportDto;
import com.xforceplus.business.tenant.service.OrgService;
import com.xforceplus.dao.OrgVirtualCustomizedDao;
import com.xforceplus.dao.OrgVirtualDao;
import com.xforceplus.dao.OrgVirtualNodeDao;
import com.xforceplus.entity.OrgStruct;
import com.xforceplus.entity.OrgVirtual;
import com.xforceplus.query.OrgVirtualQueryHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class OrgVirtualService {
    private static final Logger log = LoggerFactory.getLogger(OrgVirtualService.class);
    private final OrgVirtualDao orgVirtualDao;
    private final OrgVirtualCustomizedDao customizedOrgVirtualDao;
    private final OrgService orgService;
    private final OrgVirtualNodeDao orgVirtualNodeDao;
    private static final Integer ORG_VIRTUAL_DISABLE = 0;

    public OrgVirtualService(OrgVirtualDao orgVirtualDao, OrgVirtualCustomizedDao customizedOrgVirtualDao, OrgService orgService, OrgVirtualNodeDao orgVirtualNodeDao) {
        this.orgVirtualDao = orgVirtualDao;
        this.customizedOrgVirtualDao = customizedOrgVirtualDao;
        this.orgService = orgService;
        this.orgVirtualNodeDao = orgVirtualNodeDao;
    }

    public Page<OrgVirtual> page(OrgVirtualModel.Request.Query query, Pageable pageable) {
        Specification specification = OrgVirtualQueryHelper.querySpecification((OrgVirtualModel.Request.Query)query);
        return this.orgVirtualDao.findAll(specification, pageable);
    }

    public OrgVirtual findByTenantIdAndId(Long tenantId, Long virtualId) {
        return (OrgVirtual)this.orgVirtualDao.findByTenantIdAndOrgVirtualId(tenantId.longValue(), virtualId.longValue()).orElseThrow(() -> new IllegalArgumentException("\u672a\u627e\u5230\u4e1a\u52a1\u7ec4\u7ec7\uff08" + virtualId + ")"));
    }

    public OrgVirtual findByTenantIdAndOrgCode(Long tenantId, String orgCode) {
        return this.orgVirtualDao.findByTenantIdAndOrgCode(tenantId.longValue(), orgCode).orElse(null);
    }

    @Transactional(rollbackFor={Exception.class})
    public OrgVirtual create(OrgVirtualModel.Request.Create model) {
        this.validOrg((OrgVirtualModel.Request.Save)model);
        Optional temp = this.orgVirtualDao.findByTenantIdAndOrgCode(model.getTenantId().longValue(), model.getOrgCode());
        if (temp.isPresent()) {
            throw new IllegalArgumentException("\u5df2\u5b58\u5728\u4e1a\u52a1\u7ec4\u7ec7\u4ee3\u7801(" + model.getOrgCode() + ")");
        }
        OrgVirtual orgVirtual = new OrgVirtual();
        BeanUtils.copyProperties((Object)model, (Object)orgVirtual);
        return (OrgVirtual)this.orgVirtualDao.saveAndFlush((Object)orgVirtual);
    }

    @Transactional(rollbackFor={Exception.class})
    public OrgVirtual update(OrgVirtualModel.Request.Update model) {
        OrgVirtual orgVirtual = this.findByTenantIdAndId(model.getTenantId(), model.getOrgVirtualId());
        this.validOrg((OrgVirtualModel.Request.Save)model);
        if (model.getStatus() != null) {
            List orgVirtualNodeList;
            if (ORG_VIRTUAL_DISABLE.equals(model.getStatus()) && !CollectionUtils.isEmpty((Collection)(orgVirtualNodeList = this.orgVirtualNodeDao.findByTenantIdAndOrgVirtualId(model.getTenantId().longValue(), model.getOrgVirtualId().longValue())))) {
                throw new IllegalArgumentException("\u8be5\u4e1a\u52a1\u7ec4\u7ec7\u5df2\u5173\u8054\u7ec4\u7ec7\u6811\uff0c\u4e0d\u5141\u8bb8\u7981\u7528(" + model.getOrgVirtualId() + ")");
            }
            orgVirtual.setStatus(model.getStatus());
        }
        orgVirtual.setOrgName(model.getOrgName());
        orgVirtual.setOrgDesc(model.getOrgDesc());
        orgVirtual.setOrgStructId(model.getOrgStructId());
        orgVirtual.setShortName(model.getShortName());
        return (OrgVirtual)this.orgVirtualDao.saveAndFlush((Object)orgVirtual);
    }

    private void validOrg(OrgVirtualModel.Request.Save save) {
        if (null != save.getOrgStructId()) {
            this.orgService.findByTenantIdAndId(save.getTenantId(), save.getOrgStructId());
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public OrgVirtual currentEnable(Long tenantId, Long orgVirtualId) {
        OrgVirtual orgVirtual = this.findByTenantIdAndId(tenantId, orgVirtualId);
        orgVirtual.setStatus(Integer.valueOf(1));
        orgVirtual = (OrgVirtual)this.orgVirtualDao.saveAndFlush((Object)orgVirtual);
        return orgVirtual;
    }

    @Transactional(rollbackFor={Exception.class})
    public OrgVirtual currentDisable(Long tenantId, Long orgVirtualId) {
        OrgVirtual orgVirtual = this.findByTenantIdAndId(tenantId, orgVirtualId);
        List trees = this.orgVirtualNodeDao.findByTenantIdAndOrgVirtualId(tenantId.longValue(), orgVirtualId.longValue());
        if (!CollectionUtils.isEmpty((Collection)trees)) {
            throw new IllegalArgumentException("\u8be5\u4e1a\u52a1\u7ec4\u7ec7\u5df2\u5173\u8054\u7ec4\u7ec7\u6811\uff0c\u4e0d\u5141\u8bb8\u7981\u7528(" + orgVirtualId + ")");
        }
        orgVirtual.setStatus(Integer.valueOf(0));
        orgVirtual = (OrgVirtual)this.orgVirtualDao.saveAndFlush((Object)orgVirtual);
        return orgVirtual;
    }

    public OrgVirtual currentInfo(Long tenantId, Long orgVirtualId) {
        return this.findByTenantIdAndId(tenantId, orgVirtualId);
    }

    public List<OrgVirtualModel.Response.ExcelExportModel> listToExcel(OrgVirtualModel.Request.ExcelExportQuery query) {
        return this.customizedOrgVirtualDao.listToExcel(query);
    }

    @Transactional(rollbackFor={Exception.class})
    public String importSave(OrgVirtualImportDto dto, Long tenantId) {
        ArrayList<String> errMsg = new ArrayList<String>();
        ExcelValidator.validate(dto);
        if (StringUtils.isNotBlank((CharSequence)dto.getValidatedMessage())) {
            errMsg.add(dto.getValidatedMessage());
        }
        Long orgId = null;
        if (StringUtils.isNotBlank((CharSequence)dto.getOrgStructCode())) {
            List<OrgStruct> orgStructs = this.orgService.findByTenantIdAndOrgCode(tenantId, dto.getOrgStructCode());
            if (CollectionUtils.isEmpty(orgStructs)) {
                errMsg.add("\u4e0d\u5b58\u5728\u7684\u7ec4\u7ec7[" + dto.getOrgStructCode() + "]");
            } else {
                OrgStruct orgStruct = orgStructs.get(0);
                switch (orgStruct.getStatus()) {
                    case 0: {
                        errMsg.add("\u8be5\u7ec4\u7ec7\u672a\u542f\u7528[" + dto.getOrgStructCode() + "]");
                        break;
                    }
                    case 1: {
                        orgId = orgStruct.getOrgId();
                        break;
                    }
                    case 2: {
                        errMsg.add("\u8be5\u7ec4\u7ec7\u5df2\u7981\u7528[" + dto.getOrgStructCode() + "]");
                        break;
                    }
                }
            }
        }
        if (!CollectionUtils.isEmpty(errMsg)) {
            return String.join((CharSequence)";", errMsg);
        }
        if ("\u65b0\u5efa".equals(dto.getAction())) {
            OrgVirtualModel.Request.Create model = new OrgVirtualModel.Request.Create();
            model.setTenantId(tenantId);
            model.setOrgCode(dto.getOrgCode());
            model.setShortName(dto.getShortName());
            model.setOrgDesc(dto.getOrgDesc());
            model.setStatus(dto.getStatus());
            model.setOrgName(dto.getOrgName());
            model.setOrgStructId(orgId);
            try {
                this.create(model);
            }
            catch (Exception e) {
                errMsg.add(e.getMessage());
            }
        } else if ("\u4fee\u6539".equals(dto.getAction())) {
            Optional optionalOrgVirtual = this.orgVirtualDao.findByTenantIdAndOrgCode(tenantId.longValue(), dto.getOrgCode());
            if (optionalOrgVirtual.isPresent()) {
                List trees;
                boolean isAdd = true;
                OrgVirtual orgVirtual = (OrgVirtual)optionalOrgVirtual.get();
                if (dto.getStatus() == 0 && !CollectionUtils.isEmpty((Collection)(trees = this.orgVirtualNodeDao.findByTenantIdAndOrgVirtualId(tenantId.longValue(), orgVirtual.getOrgVirtualId().longValue())))) {
                    errMsg.add("\u8be5\u4e1a\u52a1\u7ec4\u7ec7\u5df2\u5173\u8054\u7ec4\u7ec7\u6811\uff0c\u4e0d\u5141\u8bb8\u7981\u7528");
                    isAdd = false;
                }
                if (isAdd) {
                    orgVirtual.setShortName(dto.getShortName());
                    orgVirtual.setOrgDesc(dto.getOrgDesc());
                    orgVirtual.setStatus(dto.getStatus());
                    orgVirtual.setOrgName(dto.getOrgName());
                    orgVirtual.setOrgCode(dto.getOrgCode());
                    orgVirtual.setOrgStructId(orgId);
                    this.orgVirtualDao.saveAndFlush((Object)orgVirtual);
                }
            } else {
                errMsg.add("\u4e0d\u5b58\u5728\u7684\u4e1a\u52a1\u7ec4\u7ec7[" + dto.getOrgCode() + "]");
            }
        }
        if (!CollectionUtils.isEmpty(errMsg)) {
            return String.join((CharSequence)";", errMsg);
        }
        return null;
    }
}

