/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.resource.controller;

import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.model.ServicePackageModel;
import com.xforceplus.api.tenant.resource.ServicePackageApi;
import com.xforceplus.bo.ResourceQueryBo;
import com.xforceplus.business.excel.QueryParam;
import com.xforceplus.business.excel.writer.ExcelConfigBusinessType;
import com.xforceplus.business.file.controller.vo.ImportFileRespVo;
import com.xforceplus.business.file.service.ExportFileService;
import com.xforceplus.business.file.service.ImportFileService;
import com.xforceplus.business.resource.service.ServicePackagePortService;
import com.xforceplus.business.resource.service.ServicePackageService;
import com.xforceplus.domain.TreeNode;
import com.xforceplus.domain.resource.view.ServicePackageView;
import com.xforceplus.domain.validation.ValidationGroup;
import com.xforceplus.entity.ExcelFileStore;
import com.xforceplus.entity.ServicePackage;
import com.xforceplus.tenant.core.exception.UnknownException;
import com.xforceplus.tenant.security.autoscan.annotation.AuthorizedDefinition;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.utils.BasePathUtils;
import com.xforceplus.utils.DownloadUtils;
import com.xforceplus.utils.excel.ServicePackageExcelUtils;
import com.xforceplus.utils.excel.ServicePackageWrapper;
import com.xforceplus.utils.filetransfer.FileTransferUtilsService;
import io.geewit.core.jackson.view.View;
import io.geewit.core.utils.reflection.BeanUtils;
import io.geewit.data.jpa.essential.domain.PageableFactory;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Controller;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import springfox.documentation.annotations.ApiIgnore;

@Api(value="\u670d\u52a1\u5305\u76f8\u5173\u63a5\u53e3", tags={"resources", "servicePackage"})
@Validated
@Controller
public class ServicePackageController
implements com.xforceplus.api.global.resource.ServicePackageApi,
ServicePackageApi {
    private static final Logger logger = LoggerFactory.getLogger(ServicePackageController.class);
    private final ServicePackageService servicePackageService;
    private final ServicePackagePortService servicePackagePortService;
    private final FileTransferUtilsService fileTransferUtilsService;
    private final ExportFileService exportFileService;
    private final ImportFileService importFileService;

    public ServicePackageController(ServicePackageService servicePackageService, ServicePackagePortService servicePackagePortService, ExportFileService exportFileService, FileTransferUtilsService fileTransferUtilsService, ImportFileService importFileService) {
        this.servicePackageService = servicePackageService;
        this.servicePackagePortService = servicePackagePortService;
        this.fileTransferUtilsService = fileTransferUtilsService;
        this.exportFileService = exportFileService;
        this.importFileService = importFileService;
    }

    @AuthorizedDefinition(resources={"xforce:operation:service-package:read"})
    @JsonView(value={ServicePackageView.ServicePackageInfo.class})
    @ApiOperation(value="\u83b7\u53d6\u670d\u52a1\u5305\u5206\u9875", notes="\u901a\u8fc7\u5206\u9875\u53c2\u6570\uff0c\u83b7\u53d6\u670d\u52a1\u5305\u5206\u9875")
    public ResponseEntity<Page<ServicePackage>> page(@ApiParam(value="request") ServicePackageModel.Request.Query query, @ApiParam(value="pageable") Pageable pageable) {
        Pageable currentPageable = PageableFactory.ofDefaultSort((Pageable)pageable, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}));
        Set withExtendParams = Stream.of("appName").collect(Collectors.toSet());
        if (StringUtils.isNotBlank((CharSequence)query.getWithExtendParams())) {
            withExtendParams.addAll(Arrays.stream(StringUtils.split((String)query.getWithExtendParams(), (String)",")).collect(Collectors.toSet()));
        }
        query.setWithExtendParams(withExtendParams.stream().collect(Collectors.joining(",")));
        Page<ServicePackage> result = this.servicePackageService.page(query, currentPageable);
        return ResponseEntity.ok(result);
    }

    @AuthorizedDefinition(resources={"xforce:operation:service-package:read"})
    @JsonView(value={View.Page.class})
    @ApiIgnore
    @ApiOperation(value="\u83b7\u53d6\u670d\u52a1\u5305\u5217\u8868", notes="\u901a\u8fc7\u53c2\u6570\uff0c\u83b7\u53d6\u670d\u52a1\u5305\u5217\u8868")
    @ResponseBody
    @RequestMapping(name="\u670d\u52a1\u5305\u5206\u9875\u5217\u8868", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/packages/list"}, method={RequestMethod.GET})
    public ResponseEntity<List<ServicePackage>> list(@ApiParam(value="request") ServicePackageModel.Request.Query query, @ApiParam(value="sort") Sort sort) {
        if (sort.stream().noneMatch(order -> "createTime".equals(order.getProperty()))) {
            sort = Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}).and(sort);
        }
        Set withExtendParams = Stream.of("appName").collect(Collectors.toSet());
        if (StringUtils.isNotBlank((CharSequence)query.getWithExtendParams())) {
            withExtendParams.addAll(Arrays.stream(StringUtils.split((String)query.getWithExtendParams(), (String)",")).collect(Collectors.toSet()));
        }
        query.setWithExtendParams(withExtendParams.stream().collect(Collectors.joining(",")));
        List<ServicePackage> result = this.servicePackageService.list(query, sort);
        return ResponseEntity.ok(result);
    }

    @AuthorizedDefinition(resources={"xforce:operation:service-package:save"})
    @ApiOperation(value="\u65b0\u5efa\u670d\u52a1\u5305")
    public ResponseEntity<ServicePackage> create(@ApiParam(value="model", required=true) ServicePackageModel.Request.Save model) {
        ServicePackage result = this.servicePackageService.create(model);
        return ResponseEntity.ok((Object)result);
    }

    @AuthorizedDefinition(resources={"xforce:operation:service-package:save"})
    @JsonView(value={ServicePackageView.ServicePackageInfo.class})
    @ApiOperation(value="\u6839\u636eid\u66f4\u65b0\u670d\u52a1\u5305")
    public ResponseEntity<ServicePackage> update(@ApiParam(value="id", required=true) long id, @ApiParam(value="model", required=true) @Validated(value={ValidationGroup.OnUpdate.class}) ServicePackageModel.Request.Save model) {
        ServicePackage result = this.servicePackageService.update(id, model);
        return ResponseEntity.ok((Object)result);
    }

    @AuthorizedDefinition(resources={"xforce:operation:service-package:read"})
    @JsonView(value={ServicePackageView.ServicePackageInfo.class})
    @ApiOperation(value="\u83b7\u53d6\u670d\u52a1\u5305\u8be6\u60c5")
    public ResponseEntity<ServicePackage> info(@ApiParam(value="id", required=true) long id) {
        ServicePackage result = this.servicePackageService.findById(id);
        return ResponseEntity.ok((Object)result);
    }

    @AuthorizedDefinition(resources={"xforce:operation:service-package:save"})
    @ApiOperation(value="\u6839\u636eid\u66f4\u65b0\u670d\u52a1\u5305\u72b6\u6001")
    public ResponseEntity<String> updateStatus(@ApiParam(value="id", required=true) long id, @ApiParam(value="status", required=true) int status) {
        this.servicePackageService.updateStatus(id, status);
        return ResponseEntity.ok((Object)"\u66f4\u65b0\u6210\u529f");
    }

    public ResponseEntity<Map<Long, Boolean>> validResourcesetsBound(long id, String resourcesetIds) {
        HashSet<Long> resourcesetIdSet = new HashSet<Long>();
        for (String resourcesetIdStr : StringUtils.split((String)resourcesetIds, (String)",")) {
            try {
                Long resourcesetId = Long.parseLong(resourcesetIdStr);
                resourcesetIdSet.add(resourcesetId);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        Map<Long, Boolean> result = this.servicePackageService.validResourcesetsBound(id, resourcesetIdSet);
        return ResponseEntity.ok(result);
    }

    @AuthorizedDefinition(resources={"xforce:operation:service-package:save"})
    @ApiOperation(value="\u6839\u636eid\u5220\u9664\u670d\u52a1\u5305")
    public ResponseEntity<String> delete(@ApiParam(value="id", required=true) long id) {
        this.servicePackageService.deleteById(id);
        return ResponseEntity.ok((Object)"\u5220\u9664\u6210\u529f");
    }

    @Deprecated
    @AuthorizedDefinition(resources={"xforce:operation:service-package:save"})
    @ApiOperation(value="\u5bfc\u51fa\u670d\u52a1\u5305\u5217\u8868", notes="\u5bfc\u51fa\u670d\u52a1\u5305\u5217\u8868")
    @RequestMapping(name="\u5bfc\u51fa\u670d\u52a1\u5305\u5217\u8868", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/packages/export"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Long> export(@RequestBody List<String> servicePackageIds, HttpServletRequest request) {
        if (servicePackageIds == null || servicePackageIds.size() <= 0) {
            throw new IllegalArgumentException("id\u8bb0\u5f55\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        List<Long> list = servicePackageIds.stream().map(Long::valueOf).collect(Collectors.toList());
        ServicePackageWrapper servicePackageWrapper = this.servicePackagePortService.getExportData(list);
        String filePath = BasePathUtils.ensureFilePath(request);
        ServicePackageExcelUtils.writeV2007(filePath, servicePackageWrapper);
        try {
            Long fileId = this.fileTransferUtilsService.upload(filePath);
            ResponseEntity responseEntity = ResponseEntity.ok((Object)fileId);
            this.deleteFile(filePath);
            return responseEntity;
        }
        catch (Exception e) {
            this.deleteFile(filePath);
            logger.error("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            throw new UnknownException("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\u3002");
        }
    }

    @AuthorizedDefinition(resources={"xforce:operation:service-package:save"})
    @ApiOperation(value="\u5f02\u6b65\u5bfc\u51fa\u670d\u52a1\u5305\u5217\u8868", notes="\u5f02\u6b65\u5bfc\u51fa\u670d\u52a1\u5305\u5217\u8868")
    @RequestMapping(name="\u5f02\u6b65\u5bfc\u51fa\u670d\u52a1\u5305\u5217\u8868", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/packages/async/export"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<ImportFileRespVo> asyncExport(@ApiParam(value="request") @RequestBody ServicePackageModel.Request.Query query, @ApiParam(value="sort") Sort sort) {
        if (ArrayUtils.isEmpty((Object[])query.getSheets())) {
            throw new UnknownException("\u8bf7\u9009\u62e9SheetName");
        }
        QueryParam queryParam = QueryParam.builder().param("P_QUERY", query).param("P_SORT", sort).build();
        ResourceQueryBo queryBo = new ResourceQueryBo();
        BeanUtils.copyProperties((Object)query, (Object)queryBo);
        ExcelFileStore excelFileStore = this.exportFileService.asyncExcelExport(queryParam.params(), ExcelConfigBusinessType.SERVICE_PACKAGE_EXCEL_FILE);
        ImportFileRespVo respVo = new ImportFileRespVo();
        respVo.setId(excelFileStore.getId());
        respVo.setBusinessType(ExcelConfigBusinessType.SERVICE_PACKAGE_EXCEL_FILE.getBusinessName());
        return ResponseEntity.ok((Object)respVo);
    }

    @AuthorizedDefinition(resources={"xforce:operation:service-package:save"})
    @ApiOperation(value="\u5f02\u6b65\u5bfc\u5165\u670d\u52a1\u5305\u5217\u8868", notes="\u5f02\u6b65\u5bfc\u5165\u670d\u52a1\u5305\u5217\u8868")
    @RequestMapping(name="\u5f02\u6b65\u5bfc\u5165\u670d\u52a1\u5305\u5217\u8868", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/packages/async/import"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<ImportFileRespVo> asyncImport(@RequestParam(name="file", required=false) MultipartFile file) {
        Long tenantId = 0L;
        Long userId = 0L;
        if (null != UserInfoHolder.get()) {
            tenantId = UserInfoHolder.get().getTenantId();
            userId = UserInfoHolder.get().getId();
        }
        ExcelFileStore excelFileStore = this.importFileService.create(file, ExcelConfigBusinessType.SERVICE_PACKAGE_EXCEL_FILE, userId, tenantId);
        ImportFileRespVo respVo = new ImportFileRespVo();
        respVo.setBusinessType(ExcelConfigBusinessType.SERVICE_PACKAGE_EXCEL_FILE.name());
        respVo.setFileId(excelFileStore.getSourceFileId());
        respVo.setId(excelFileStore.getId());
        return ResponseEntity.ok((Object)respVo);
    }

    @AuthorizedDefinition(resources={"xforce:operation:service-package:save"})
    @ApiOperation(value="\u5bfc\u5165\u670d\u52a1\u5305\u5217\u8868", notes="\u5bfc\u5165\u670d\u52a1\u5305\u5217\u8868")
    @RequestMapping(name="\u5bfc\u5165\u670d\u52a1\u5305\u5217\u8868", value={"${xforce.tenant.service.url.prefix:/api}/global${xforce.tenant.service.version:}/packages/import"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Long> importData(@RequestParam(name="file", required=false) MultipartFile file, HttpServletRequest request) {
        if (file == null) {
            throw new UnknownException("\u8bf7\u9009\u62e9\u5bfc\u5165\u6587\u4ef6\u3002");
        }
        long size = file.getSize() / 0x100000L;
        if (size >= 15L) {
            throw new UnknownException("\u5bfc\u5165\u6587\u4ef6\u4e0d\u80fd\u8d85\u8fc715M");
        }
        String filePath = BasePathUtils.ensureFilePath(request);
        this.saveFileToLocal(file, filePath);
        ServicePackageWrapper servicePackageWrapper = ServicePackageExcelUtils.extract(filePath);
        ServicePackageWrapper result = this.servicePackagePortService.saveData(servicePackageWrapper);
        Long fileId = null;
        if (CollectionUtils.isNotEmpty(result.getServicePackages()) || CollectionUtils.isNotEmpty(result.getResourcesets())) {
            String filePath2 = BasePathUtils.ensureFilePath(request);
            result.setSkipReason(false);
            ServicePackageExcelUtils.writeV2007(filePath2, result);
            try {
                fileId = this.fileTransferUtilsService.upload(filePath2);
                this.deleteFile(filePath2);
            }
            catch (Exception e) {
                this.deleteFile(filePath);
                this.deleteFile(filePath2);
                logger.error("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25", (Throwable)e);
                throw new UnknownException("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\u3002");
            }
        }
        ResponseEntity responseEntity = ResponseEntity.ok(fileId);
        this.deleteFile(filePath);
        return responseEntity;
    }

    @AuthorizedDefinition(resources={"xforce:operation:service-package:read"})
    @ApiOperation(value="\u4e0b\u8f7d\u6587\u4ef6", notes="\u4e0b\u8f7d\u6587\u4ef6")
    @RequestMapping(name="\u4e0b\u8f7d\u6587\u4ef6", value={"/api/global/packages/file/{fileId}"}, method={RequestMethod.GET})
    public void download(@PathVariable String fileId, HttpServletRequest request, HttpServletResponse response) {
        String filePath;
        if (StringUtils.equals((CharSequence)"template", (CharSequence)fileId)) {
            filePath = BasePathUtils.getTemplatePath(request, "servicepackage.xlsx");
        } else {
            filePath = BasePathUtils.ensureFilePath(request);
            try {
                this.fileTransferUtilsService.download(filePath, Long.valueOf(fileId));
            }
            catch (Exception e) {
                this.deleteFile(filePath);
                logger.error("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25", (Throwable)e);
                throw new UnknownException("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25\u3002");
            }
        }
        DownloadUtils.fileToDownload(response, filePath, "servicepackage.xlsx");
        this.deleteFile(filePath);
    }

    @AuthorizedDefinition(resources={"xforce:operation:service-package:read"})
    @JsonView(value={ServicePackageView.ServicePackageInfo.class})
    @ApiOperation(value="\u83b7\u53d6\u79df\u6237\u76f8\u5173\u7684\u670d\u52a1\u5305\u5206\u9875", notes="\u901a\u8fc7\u5206\u9875\u53c2\u6570\uff0c\u83b7\u53d6\u79df\u6237\u76f8\u5173\u7684\u670d\u52a1\u5305\u5206\u9875")
    public ResponseEntity<Page<ServicePackage>> page(long tenantId, ServicePackageModel.Request.Query query, Pageable pageable) {
        Set withExtendParams = Stream.of("appName").collect(Collectors.toSet());
        if (StringUtils.isNotBlank((CharSequence)query.getWithExtendParams())) {
            withExtendParams.addAll(Arrays.stream(StringUtils.split((String)query.getWithExtendParams(), (String)",")).collect(Collectors.toSet()));
        }
        query.setWithExtendParams(withExtendParams.stream().collect(Collectors.joining(",")));
        Page<ServicePackage> result = this.servicePackageService.page(tenantId, query, pageable);
        return ResponseEntity.ok(result);
    }

    @JsonView(value={ServicePackageView.ServicePackageInfo.class})
    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u79df\u6237\u76f8\u5173\u7684\u670d\u52a1\u5305\u5206\u9875", notes="\u901a\u8fc7\u5206\u9875\u53c2\u6570\uff0c\u83b7\u53d6\u79df\u6237\u76f8\u5173\u7684\u670d\u52a1\u5305\u5206\u9875")
    @ResponseBody
    @RequestMapping(name="\u83b7\u53d6\u5f53\u524d\u79df\u6237\u76f8\u5173\u7684\u670d\u52a1\u5305\u5206\u9875", value={"/api/current/packages"}, method={RequestMethod.GET})
    public ResponseEntity<Page<ServicePackage>> currentPage(ServicePackageModel.Request.Query query, Pageable pageable) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        Page<ServicePackage> result = this.servicePackageService.page(authorizedUser.getTenantId(), query, pageable);
        return ResponseEntity.ok(result);
    }

    private void deleteFile(String filePath) {
        File file = new File(filePath);
        if (file.exists()) {
            boolean deleteResult = file.delete();
            logger.info("\u5220\u9664\u6587\u4ef6\u7ed3\u679c:{}", (Object)deleteResult);
        }
    }

    private void saveFileToLocal(MultipartFile file, String basePath) {
        File newFile = new File(basePath);
        try {
            file.transferTo(newFile);
        }
        catch (IOException e) {
            logger.error("\u5bfc\u5165\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            throw new UnknownException("\u5bfc\u5165\u6587\u4ef6\u5931\u8d25");
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u79df\u6237\u76f8\u5173\u7684\u670d\u52a1\u5305-\u529f\u80fd\u96c6-\u8d44\u6e90\u7801-tree", notes="\u83b7\u53d6\u5f53\u524d\u79df\u6237\u76f8\u5173\u7684\u670d\u52a1\u5305-\u529f\u80fd\u96c6-\u8d44\u6e90\u7801-tree")
    @ResponseBody
    @RequestMapping(name="\u83b7\u53d6\u5f53\u524d\u79df\u6237\u76f8\u5173\u7684\u670d\u52a1\u5305-\u529f\u80fd\u96c6-\u8d44\u6e90\u7801-tree", value={"/api/current/packages/tree"}, method={RequestMethod.GET})
    public ResponseEntity<List<TreeNode>> currentTree(ServicePackageModel.Request.Query query) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        List<TreeNode> result = this.servicePackageService.tree(authorizedUser.getTenantId(), query);
        return ResponseEntity.ok(result);
    }
}

