/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.resource.service;

import com.xforceplus.api.model.ResourceModel;
import com.xforceplus.api.model.ResourcesetModel;
import com.xforceplus.bo.ResourceQueryBo;
import com.xforceplus.dao.AppDao;
import com.xforceplus.dao.ResourceApiRelDao;
import com.xforceplus.dao.ResourceCustomizedDao;
import com.xforceplus.dao.ResourceDao;
import com.xforceplus.dao.ResourceExtendDao;
import com.xforceplus.dao.ResourcesetDao;
import com.xforceplus.dao.ResourcesetResourceRelDao;
import com.xforceplus.dao.ServiceApiDao;
import com.xforceplus.dto.resource.ResourceDTO;
import com.xforceplus.dto.resource.ResourceServiceApiDTO;
import com.xforceplus.dto.resource.ServiceApiRouterDTO;
import com.xforceplus.dto.resource.ServicePackageDTO;
import com.xforceplus.entity.App;
import com.xforceplus.entity.Resource;
import com.xforceplus.entity.ResourceApiRel;
import com.xforceplus.query.ResourceQueryHelper;
import com.xforceplus.query.ResourcesetQueryHelper;
import io.geewit.core.utils.reflection.BeanUtils;
import io.geewit.data.jpa.essential.domain.EntityGraphs;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ResourceService {
    private static final Logger logger = LoggerFactory.getLogger(ResourceService.class);
    private final ResourceDao resourceDao;
    private final ResourcesetDao resourcesetDao;
    private final ResourcesetResourceRelDao resourcesetResourceRelDao;
    private final ResourceApiRelDao resourceApiRelDao;
    private final ServiceApiDao serviceApiDao;
    private final RedisTemplate redisTemplate;
    @Autowired
    private ResourceExtendDao resourceExtendDao;
    @Autowired
    private ResourceCustomizedDao resourceCustomizedDao;
    @Autowired
    private AppDao appDao;

    public ResourceService(ResourceDao resourceDao, ResourcesetDao resourcesetDao, ResourcesetResourceRelDao resourcesetResourceRelDao, ResourceApiRelDao resourceApiRelDao, ServiceApiDao serviceApiDao, RedisTemplate redisTemplate) {
        this.resourceDao = resourceDao;
        this.resourcesetDao = resourcesetDao;
        this.resourcesetResourceRelDao = resourcesetResourceRelDao;
        this.resourceApiRelDao = resourceApiRelDao;
        this.serviceApiDao = serviceApiDao;
        this.redisTemplate = redisTemplate;
    }

    public Page<Resource> page(ResourceModel.Request.Query query, Pageable pageable) {
        Page page;
        if (query.isTupleSelection()) {
            page = this.resourceCustomizedDao.findAttributes(query, pageable);
        } else {
            Specification specification = ResourceQueryHelper.querySpecification((ResourceModel.Request.Query)query);
            page = this.resourceDao.findAll(specification, pageable, EntityGraphs.named((String)"Resource.graph"));
        }
        this.fillResourceExtensions(query, (Iterable<Resource>)page);
        return page;
    }

    public List<Resource> list(ResourceModel.Request.Query query, Sort sort) {
        List list;
        if (query.isTupleSelection()) {
            list = this.resourceCustomizedDao.findAttributes(query, sort);
        } else {
            Specification specification = ResourceQueryHelper.querySpecification((ResourceModel.Request.Query)query);
            list = this.resourceDao.findAll(specification, sort, EntityGraphs.named((String)"Resource.graph"));
        }
        this.fillResourceExtensions(query, list);
        return list;
    }

    private void fillResourceExtensions(ResourceModel.Request.Query query, Iterable<Resource> resources) {
        if (resources == null || resources.iterator() == null || !resources.iterator().hasNext()) {
            return;
        }
        boolean isFlat = query.isFlat();
        boolean needParentName = false;
        boolean needAppName = false;
        if (StringUtils.isNotBlank((CharSequence)query.getWithExtendParams())) {
            String[] withExtendParams;
            for (String string : withExtendParams = StringUtils.split((String)query.getWithExtendParams(), (String)",")) {
                if ("parentName".equalsIgnoreCase(string)) {
                    needParentName = true;
                    break;
                }
                if (!"appName".equalsIgnoreCase(string)) continue;
                needAppName = true;
                break;
            }
        }
        if (!isFlat || needParentName || needAppName) {
            HashMap<Object, Object> resourceNameMap = null;
            if (needParentName) {
                resourceNameMap = new HashMap<Object, Object>();
            }
            Map<Long, String> appNameMap = null;
            HashSet<Long> appIds = new HashSet<Long>();
            for (Resource resource : resources) {
                if (resourceNameMap != null) {
                    resourceNameMap.put(resource.getResourceId(), resource.getResourceName());
                }
                if (!isFlat) {
                    List list = this.resourceDao.findByParentId(resource.getResourceId().longValue());
                    if (CollectionUtils.isEmpty((Collection)list)) {
                        resource.setChildren(null);
                    } else {
                        resource.setChildren(list);
                    }
                }
                appIds.add(resource.getAppId());
            }
            if (needAppName) {
                List apps = this.appDao.findAppsByAppIds(appIds);
                appNameMap = apps.stream().collect(Collectors.toMap(App::getAppId, App::getAppName));
            }
            if (resourceNameMap != null || appNameMap != null) {
                HashSet<Long> selectingResourceIds = null;
                if (resourceNameMap != null) {
                    selectingResourceIds = new HashSet<Long>();
                }
                for (Resource resource : resources) {
                    if (appNameMap != null) {
                        resource.setAppName(appNameMap.get(resource.getAppId()));
                    }
                    if (resourceNameMap == null || resource.getParentName() != null || resource.getParentId() == null || resource.getParentId() <= 0L) continue;
                    if (resourceNameMap.containsKey(resource.getParentId())) {
                        resource.setParentName((String)resourceNameMap.get(resource.getParentId()));
                        continue;
                    }
                    selectingResourceIds.add(resource.getParentId());
                }
                if (resourceNameMap != null) {
                    if (!selectingResourceIds.isEmpty()) {
                        List list = this.resourceDao.findResourceNamePairsByResourceIds(selectingResourceIds);
                        for (Pair pair : list) {
                            resourceNameMap.put(pair.getLeft(), pair.getRight());
                        }
                    }
                    for (Resource resource : resources) {
                        if (resource.getParentName() != null || resource.getParentId() == null || resource.getParentId() <= 0L || !resourceNameMap.containsKey(resource.getParentId())) continue;
                        resource.setParentName((String)resourceNameMap.get(resource.getParentId()));
                    }
                }
            }
        }
    }

    public List<Resource> list(Specification<Resource> specification, Sort sort) {
        return this.resourceDao.findAll(specification, sort, EntityGraphs.named((String)"Resource.graph"));
    }

    public Optional<Resource> findOne(ResourceModel.Request.Query query) {
        Specification specification = ResourceQueryHelper.querySpecification((ResourceModel.Request.Query)query);
        return this.resourceDao.findOne(specification);
    }

    public long count(ResourceModel.Request.Query query) {
        Specification specification = ResourceQueryHelper.querySpecification((ResourceModel.Request.Query)query);
        return this.resourceDao.count(specification);
    }

    @Transactional(rollbackFor={Exception.class})
    public Resource save(ResourceModel.Request.Save model) {
        if (null == model.getIsServicePackage()) {
            model.setIsServicePackage(Boolean.valueOf(true));
        }
        Resource entity = new Resource();
        BeanUtils.copyProperties((Object)model, (Object)entity);
        entity.setResourceType(Integer.valueOf(1));
        return (Resource)this.resourceDao.saveAndFlush((Object)entity);
    }

    @Transactional(rollbackFor={Exception.class})
    public Resource update(Resource resource) {
        this.resourceDao.saveAndFlush((Object)resource);
        return resource;
    }

    @Transactional(rollbackFor={Exception.class})
    public Resource update(long resourceId, ResourceModel.Request.Save model) {
        Resource existEntity = this.findById(resourceId);
        if (StringUtils.isBlank((CharSequence)model.getResourceName())) {
            model.setResourceName(null);
        }
        if (StringUtils.isBlank((CharSequence)model.getResourceCode())) {
            model.setResourceCode(null);
        }
        BeanUtils.copyProperties((Object)model, (Object)existEntity);
        existEntity = (Resource)this.resourceDao.saveAndFlush((Object)existEntity);
        return existEntity;
    }

    public Resource findById(long resourceId) {
        ResourceModel.Request.Query query = new ResourceModel.Request.Query();
        query.setResourceId(Long.valueOf(resourceId));
        Optional<Resource> resourceOptional = this.findOne(query);
        return resourceOptional.orElseThrow(() -> new IllegalArgumentException("\u672a\u627e\u5230\u8d44\u6e90\u7801(" + resourceId + ")"));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteById(long resourceId) {
        Resource resource = this.findById(resourceId);
        ResourcesetModel.Request.Query query = new ResourcesetModel.Request.Query();
        query.setResourceId(Long.valueOf(resourceId));
        Specification specification = ResourcesetQueryHelper.querySpecification((ResourcesetModel.Request.Query)query);
        long resourcesets = this.resourcesetDao.count(specification);
        if (resourcesets > 0L) {
            throw new IllegalArgumentException("\u8be5\u8d44\u6e90\u7801(" + resourceId + ")\u5df2\u7ecf\u5173\u8054\u529f\u80fd\u96c6\u5408\u4e0d\u80fd\u5220\u9664");
        }
        ResourceModel.Request.Query resourceQuery = new ResourceModel.Request.Query();
        resourceQuery.setParentId(Long.valueOf(resourceId));
        Specification resourceSspecification = ResourceQueryHelper.querySpecification((ResourceModel.Request.Query)resourceQuery);
        long resourceChildrenCount = this.resourceDao.count(resourceSspecification);
        if (resourceChildrenCount > 0L) {
            throw new IllegalArgumentException("\u5df2\u7ecf\u521b\u5efa\u5b50\u8d44\u6e90\u7801");
        }
        this.resourceDao.deleteById(resource.getResourceId());
        this.resourcesetResourceRelDao.deleteByResourceId(resourceId);
    }

    @Transactional(rollbackFor={Exception.class})
    public Resource append(long parentId, ResourceModel.Request.Save model) {
        Resource parent = this.findById(parentId);
        if (null == model.getIsServicePackage()) {
            model.setIsServicePackage(Boolean.valueOf(true));
        }
        model.setAppId(parent.getAppId());
        Resource entity = new Resource();
        BeanUtils.copyProperties((Object)model, (Object)entity);
        entity.setParentId(Long.valueOf(parentId));
        entity = (Resource)this.resourceDao.saveAndFlush((Object)entity);
        return entity;
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateStatus(long id, int status) {
        int result = this.resourceDao.updateStatus(id, status);
        if (result <= 0) {
            throw new IllegalArgumentException("\u627e\u4e0d\u5230\u8d44\u6e90\u7801(" + id + ")\u5b9e\u4f53");
        }
    }

    public List<Resource> listByServiceApiId(long serviceApiId) {
        ResourceModel.Request.Query query = new ResourceModel.Request.Query();
        query.setServiceApiId(Long.valueOf(serviceApiId));
        query.setStatus(Integer.valueOf(1));
        return this.list(query, Sort.unsorted());
    }

    @Transactional(rollbackFor={Exception.class})
    public void bindApis(long resourceId, ResourceModel.Request.BindApis bindApis) {
        Resource resource = this.findById(resourceId);
        this.bindApis(resource, bindApis);
    }

    public void bindApis(Resource resource, ResourceModel.Request.BindApis bindApis) {
        if (bindApis == null) {
            return;
        }
        List apiIds = bindApis.getApiIds();
        if (CollectionUtils.isEmpty((Collection)apiIds)) {
            return;
        }
        logger.info("apiIds :{}", (Object)apiIds.stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.joining(",")));
        List existRels = this.resourceApiRelDao.findByResourceId(resource.getResourceId());
        logger.info("exist api-resource-rels.size:{} ", (Object)existRels.size());
        Set<ResourceApiRel> insertingRels = apiIds.stream().filter(serviceApiId -> existRels.stream().map(ResourceApiRel::getServiceApiId).noneMatch(existId -> existId.equals(serviceApiId))).map(serviceApiId -> {
            Optional serviceApiOptional = this.serviceApiDao.findById(serviceApiId);
            if (serviceApiOptional.isPresent()) {
                ResourceApiRel rel = new ResourceApiRel();
                rel.setResourceId(resource.getResourceId());
                rel.setServiceApiId(serviceApiId);
                return rel;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        this.bindApis(insertingRels);
        if (bindApis.isOverwrite()) {
            existRels.stream().filter(rel -> apiIds.stream().noneMatch(apiId -> apiId.equals(rel.getServiceApiId()))).forEach(rel -> {
                logger.info("deleting Resource-Api-Rel record, {}", rel);
                try {
                    this.resourceApiRelDao.deleteById(rel.getId());
                }
                catch (Exception e) {
                    logger.warn(e.getMessage(), (Throwable)e);
                }
            });
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void bindApis(Collection<ResourceApiRel> rels) {
        if (!rels.isEmpty()) {
            for (ResourceApiRel rel : rels) {
                this.resourceApiRelDao.saveAndFlush((Object)rel);
            }
        }
    }

    public List<Resource> listByResourcesetId(long resourcesetId, Integer status) {
        ResourceModel.Request.Query query = new ResourceModel.Request.Query();
        query.setResourcesetId(Long.valueOf(resourcesetId));
        query.setStatus(status);
        return this.list(query, Sort.unsorted());
    }

    public Page<ResourceDTO> pagingBy(Pageable pageable, ResourceQueryBo queryBo) {
        return this.resourceExtendDao.pagingBy(pageable, queryBo);
    }

    public Page<ResourceServiceApiDTO> pagingByServiceApi(Pageable pageable, ResourceQueryBo queryBo) {
        return this.resourceExtendDao.pagingByServiceApi(pageable, queryBo);
    }

    public List<ServiceApiRouterDTO> findRouteList() {
        return this.resourceExtendDao.findRouteAll();
    }

    public Optional<Resource> findByAppIdResourceCode(Long appId, String resourceCode) {
        List resourceList = this.resourceDao.findByAppIdAndResourceCode(appId.longValue(), resourceCode);
        if (resourceList.isEmpty()) {
            return Optional.empty();
        }
        if (resourceList.size() > 1) {
            throw new IllegalArgumentException("\u3010" + appId + "\u3011,\u3010" + resourceCode + "\u3011\u8d44\u6e90\u7801\u6570\u636e\u5b58\u5728\u4e0d\u552f\u4e00\u8bb0\u5f55");
        }
        return Optional.of(resourceList.get(0));
    }

    public List<Resource> listByRoleId(long roleId, Set<String> attributes) {
        ResourceModel.Request.Query query = new ResourceModel.Request.Query();
        query.setRoleId(Long.valueOf(roleId));
        query.setStatus(Integer.valueOf(1));
        query.setAttributes(attributes);
        return this.list(query, Sort.unsorted());
    }

    public List<Resource> listByResourcesetIds(Collection<Long> resourcesetIds) {
        if (resourcesetIds == null || resourcesetIds.isEmpty()) {
            return Collections.emptyList();
        }
        ResourceModel.Request.Query query = new ResourceModel.Request.Query();
        query.setResourcesetIds(resourcesetIds);
        query.setStatus(Integer.valueOf(1));
        return this.list(query, Sort.unsorted());
    }

    public List<Resource> listByResourcesetIds(Collection<Long> resourcesetIds, Set<String> attributes) {
        if (resourcesetIds == null || resourcesetIds.isEmpty()) {
            return Collections.emptyList();
        }
        ResourceModel.Request.Query query = new ResourceModel.Request.Query();
        query.setResourcesetIds(resourcesetIds);
        query.setAttributes(attributes);
        query.setStatus(Integer.valueOf(1));
        return this.list(query, Sort.unsorted());
    }

    public List<ResourceDTO> getUserRoleResourceCode(Long userId) {
        return this.resourceExtendDao.getUserRoleResourceCode(userId);
    }

    public List<ResourceDTO> getUserCompanyResourceCode(Long userId, Long appId) {
        List servicePackageDTOList = this.resourceExtendDao.getServicePackIdByUserIdAndAppId(userId, appId);
        if (CollectionUtils.isNotEmpty((Collection)servicePackageDTOList)) {
            List servicePackageIdList = servicePackageDTOList.stream().map(ServicePackageDTO::getServicePackageId).collect(Collectors.toList());
            return this.resourceExtendDao.getUserCompanyResourceByPackageIdList(servicePackageIdList);
        }
        return Collections.emptyList();
    }

    public List<Resource> listByRoleIds(Collection<Long> roleIds) {
        if (roleIds == null || roleIds.isEmpty()) {
            return Collections.emptyList();
        }
        List resourcesetIds = this.resourcesetDao.findResourcesetIdsByRoleIds(roleIds);
        return this.listByResourcesetIds(resourcesetIds);
    }

    public List<Resource> listByRoleIds(Collection<Long> roleIds, Set<String> attributes) {
        if (roleIds == null || roleIds.isEmpty()) {
            return Collections.emptyList();
        }
        List resourcesetIds = this.resourcesetDao.findResourcesetIdsByRoleIds(roleIds);
        return this.listByResourcesetIds(resourcesetIds, attributes);
    }

    public List<Resource> listByPackageIds(Collection<Long> packageIds) {
        if (packageIds == null || packageIds.isEmpty()) {
            return Collections.emptyList();
        }
        List resourcesetIds = this.resourcesetDao.findResourcesetIdsByPackageIds(packageIds);
        List<Resource> resources = this.listByResourcesetIds(resourcesetIds);
        return resources;
    }

    public List<Resource> listByPackageIds(Collection<Long> packageIds, Set<String> attributes) {
        if (packageIds == null || packageIds.isEmpty()) {
            return Collections.emptyList();
        }
        List resourcesetIds = this.resourcesetDao.findResourcesetIdsByPackageIds(packageIds);
        List<Resource> resources = this.listByResourcesetIds(resourcesetIds, attributes);
        return resources;
    }
}

