/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.resource.service;

import com.xforceplus.api.model.ResourcesetModel;
import com.xforceplus.bo.ResourceSetQueryBo;
import com.xforceplus.business.resource.service.ResourceService;
import com.xforceplus.dao.AppDao;
import com.xforceplus.dao.ResourceDao;
import com.xforceplus.dao.ResourceSetExtendDao;
import com.xforceplus.dao.ResourcesetDao;
import com.xforceplus.dao.ResourcesetResourceRelDao;
import com.xforceplus.dao.ServiceResourcesetRelDao;
import com.xforceplus.domain.resource.ResourcesetDto;
import com.xforceplus.dto.resource.ResourceSetDTO;
import com.xforceplus.dto.resource.ResourceSetResourceDTO;
import com.xforceplus.entity.Resource;
import com.xforceplus.entity.Resourceset;
import com.xforceplus.entity.ResourcesetResourceRel;
import com.xforceplus.query.ResourcesetQueryHelper;
import io.geewit.core.utils.reflection.BeanUtils;
import io.geewit.data.jpa.essential.domain.EntityGraphs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ResourcesetService {
    private static final Logger log = LoggerFactory.getLogger(ResourcesetService.class);
    private static final Logger logger = LoggerFactory.getLogger(ResourcesetService.class);
    private final ResourcesetResourceRelDao resourcesetResourceRelDao;
    private final ResourcesetDao resourcesetDao;
    private final ResourceDao resourceDao;
    private final AppDao appDao;
    private final ResourceService resourceService;
    private final ServiceResourcesetRelDao serviceResourcesetRelDao;
    private final ResourceSetExtendDao resourceSetExtendDao;

    public ResourcesetService(ResourcesetDao resourcesetDao, ResourcesetResourceRelDao resourcesetResourceRelDao, ResourceDao resourceDao, AppDao appDao, ResourceService resourceService, ServiceResourcesetRelDao serviceResourcesetRelDao, ResourceSetExtendDao resourceSetExtendDao) {
        this.resourcesetDao = resourcesetDao;
        this.resourcesetResourceRelDao = resourcesetResourceRelDao;
        this.resourceDao = resourceDao;
        this.appDao = appDao;
        this.resourceService = resourceService;
        this.serviceResourcesetRelDao = serviceResourcesetRelDao;
        this.resourceSetExtendDao = resourceSetExtendDao;
    }

    public Page<Resourceset> page(ResourcesetModel.Request.Query query, Pageable pageable) {
        Specification specification = ResourcesetQueryHelper.querySpecification((ResourcesetModel.Request.Query)query);
        return this.resourcesetDao.findAll(specification, pageable, EntityGraphs.named((String)"Resourceset.graph"));
    }

    public List<Resourceset> list(ResourcesetModel.Request.Query query, Sort sort) {
        Specification specification = ResourcesetQueryHelper.querySpecification((ResourcesetModel.Request.Query)query);
        List list = this.resourcesetDao.findAll(specification, sort);
        for (Resourceset resourceset : list) {
            List<Resource> resources = this.resourceService.listByResourcesetId(resourceset.getResourcesetId(), query.getStatus());
            resourceset.setResources(new HashSet<Resource>(resources));
        }
        return list;
    }

    public Page<Resourceset> page(Specification<Resourceset> specification, Pageable pageable) {
        pageable.getSort().and(Sort.by((String[])new String[]{"create_time"}).ascending());
        return this.resourcesetDao.findAll(specification, pageable, EntityGraphs.named((String)"Resourceset.graph"));
    }

    public long count(ResourcesetModel.Request.Query query) {
        Specification specification = ResourcesetQueryHelper.querySpecification((ResourcesetModel.Request.Query)query);
        return this.resourcesetDao.count(specification);
    }

    public Optional<Resourceset> findOne(ResourcesetModel.Request.Query query) {
        Specification specification = ResourcesetQueryHelper.queryOneSpecification((ResourcesetModel.Request.Query)query);
        return this.resourcesetDao.findOne(specification);
    }

    public long countOne(ResourcesetModel.Request.Query query) {
        Specification specification = ResourcesetQueryHelper.queryOneSpecification((ResourcesetModel.Request.Query)query);
        return this.resourcesetDao.count(specification);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Transactional(rollbackFor={Exception.class})
    public Resourceset create(ResourcesetModel.Request.Create model) {
        long count;
        ResourcesetModel.Request.Query query;
        if (null == model.getValidatedAppId() || model.getValidatedAppId().booleanValue()) {
            if (model.getAppId() == null || model.getAppId() <= 0L) throw new IllegalArgumentException("\u65e0\u6548\u7684\u53c2\u6570");
            if (!this.appDao.existsById((Object)model.getAppId())) {
                throw new IllegalArgumentException("\u65e0\u6548\u7684appId");
            }
        } else {
            model.setAppId(Long.valueOf(0L));
        }
        if (StringUtils.isNotBlank((CharSequence)model.getResourcesetName())) {
            query = new ResourcesetModel.Request.Query();
            query.setResourcesetNameEqual(model.getResourcesetName());
            query.setAppId(model.getAppId());
            query.setRoleId(model.getRoleId());
            count = this.count(query);
            if (count > 0L) {
                String message = "\u5df2\u7ecf\u5b58\u5728\u8be5\u529f\u80fd\u96c6\u540d\u79f0(" + model.getResourcesetName() + ")";
                logger.warn(message);
                throw new IllegalArgumentException(message);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)model.getResourcesetCode())) {
            query = new ResourcesetModel.Request.Query();
            query.setResourcesetCode(model.getResourcesetCode());
            query.setRoleId(model.getRoleId());
            count = this.countOne(query);
            if (count > 0L) {
                String message = "\u5df2\u7ecf\u5b58\u5728\u8be5\u529f\u80fd\u96c6\u4ee3\u7801(" + model.getResourcesetCode() + ")";
                logger.warn(message);
                throw new IllegalArgumentException(message);
            }
        }
        Resourceset entity = new Resourceset();
        BeanUtils.copyProperties((Object)model, (Object)entity);
        entity = (Resourceset)this.resourcesetDao.saveAndFlush((Object)entity);
        if (model.getBindResources() == null) return entity;
        this.bindResources(entity, model.getBindResources());
        return entity;
    }

    @Transactional(rollbackFor={Exception.class})
    public <T extends ResourcesetDto> Resourceset save(T model) {
        Resourceset entity = new Resourceset();
        BeanUtils.copyProperties(model, (Object)entity, (String[])((String[])Stream.of("roleResourcesetRels", "resourcesetResourceRels", "serviceResourcesetRels", "resources", "app").toArray(String[]::new)));
        entity = (Resourceset)this.resourcesetDao.saveAndFlush((Object)entity);
        return entity;
    }

    @Transactional(rollbackFor={Exception.class})
    public Resourceset update(long resourcesetId, ResourcesetModel.Request.Save model) {
        long count;
        Resourceset existEntity = this.findById(resourcesetId);
        if (model.getAppId() != null && model.getAppId() > 0L) {
            if (!existEntity.getAppId().equals(model.getAppId()) && !this.appDao.existsById((Object)model.getAppId())) {
                throw new IllegalArgumentException("\u65e0\u6548\u7684\u53c2\u6570");
            }
        } else {
            model.setAppId(null);
        }
        if (StringUtils.isNotBlank((CharSequence)model.getResourcesetCode())) {
            if (!model.getResourcesetCode().equals(existEntity.getResourcesetCode()) && (count = this.resourcesetDao.countByNotCurrentResourcesetIdAndCode(resourcesetId, model.getResourcesetCode())) > 0L) {
                throw new IllegalArgumentException("\u5df2\u5b58\u5728\u8be5\u529f\u80fd\u96c6\u4ee3\u7801");
            }
        } else {
            model.setResourcesetCode(null);
        }
        if (StringUtils.isNotBlank((CharSequence)model.getResourcesetName())) {
            if (!model.getResourcesetName().equals(existEntity.getResourcesetName()) && (count = this.resourcesetDao.countByNotCurrentResourcesetIdAndName(resourcesetId, model.getResourcesetName())) > 0L) {
                throw new IllegalArgumentException("\u5df2\u5b58\u5728\u8be5\u529f\u80fd\u96c6\u540d\u79f0");
            }
        } else {
            model.setResourcesetName(null);
        }
        BeanUtils.copyProperties((Object)model, (Object)existEntity);
        existEntity = (Resourceset)this.resourcesetDao.saveAndFlush((Object)existEntity);
        if (model.getBindResources() != null) {
            this.bindResources(existEntity, model.getBindResources());
        }
        return existEntity;
    }

    public Resourceset findById(Long resourcesetId) {
        Resourceset resourceset = (Resourceset)this.resourcesetDao.findById((Object)resourcesetId).orElseThrow(() -> new IllegalArgumentException("\u672a\u627e\u5230\u529f\u80fd\u96c6"));
        List<Resource> resources = this.resourceService.listByResourcesetId(resourcesetId, null);
        resourceset.setResources(resources.stream().filter(Objects::nonNull).collect(Collectors.toSet()));
        return resourceset;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteById(long resourcesetId) {
        Resourceset resourceset = this.findById(resourcesetId);
        if (resourceset.getStatus() != null && resourceset.getStatus() == 1) {
            throw new IllegalArgumentException("\u7981\u7528\u7684\u529f\u80fd\u96c6\u624d\u53ef\u4ee5\u88ab\u5220\u9664");
        }
        long count = this.serviceResourcesetRelDao.countByResourcesetId(resourcesetId);
        if (count > 0L) {
            throw new IllegalArgumentException("\u8be5\u529f\u80fd\u96c6\u5df2\u7ecf\u88ab\u670d\u52a1\u5305\u7ed1\u5b9a\u8fc7\u4e0d\u80fd\u5220\u9664");
        }
        this.resourcesetDao.deleteById(resourceset.getResourcesetId());
        this.resourcesetResourceRelDao.deleteByResourcesetId(resourcesetId);
        this.serviceResourcesetRelDao.deleteByResourcesetId(resourcesetId);
    }

    public List<Resourceset> list(Specification<Resourceset> specification, Sort sort) {
        return this.resourcesetDao.findAll(specification, sort);
    }

    @Transactional(rollbackFor={Exception.class})
    public void unbindResources(Long resourceSetId, Long resourceId) {
        List rels = this.resourcesetResourceRelDao.findByResourcesetIdAndResourceId(resourceSetId.longValue(), resourceId.longValue());
        if (CollectionUtils.isEmpty((Collection)rels)) {
            throw new IllegalArgumentException("\u529f\u80fd\u96c6\u4e0e\u8d44\u6e90\u8d44\u6e90\u7801\u672a\u7ed1\u5b9a");
        }
        try {
            this.resourcesetResourceRelDao.deleteById(((ResourcesetResourceRel)rels.get(0)).getId());
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void bindResources(Resourceset resourceset, ResourcesetModel.Request.BindResources bindResources) {
        if (bindResources == null || CollectionUtils.isEmpty((Collection)bindResources.getResourceIds())) {
            this.resourcesetResourceRelDao.deleteByResourcesetId(resourceset.getResourcesetId().longValue());
        } else {
            List bindResourceIds = bindResources.getResourceIds();
            logger.info("bindResourceIds = " + bindResourceIds.stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.joining(",")));
            List rels = this.resourcesetResourceRelDao.findByResourcesetId(resourceset.getResourcesetId().longValue());
            logger.info("exist resourceset-resource-rels.size = " + rels.size());
            Set<ResourcesetResourceRel> insertingRels = bindResourceIds.stream().filter(Objects::nonNull).filter(resourceId -> rels.stream().map(ResourcesetResourceRel::getResourceId).noneMatch(resourceDtoId -> resourceDtoId.equals(resourceId))).map(resourceId -> {
                Optional resourceOptional = this.resourceDao.findById(resourceId);
                if (resourceOptional.isPresent()) {
                    ResourcesetResourceRel rel = new ResourcesetResourceRel();
                    rel.setResourcesetId(resourceset.getResourcesetId());
                    rel.setResourceId(resourceId);
                    return rel;
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.toSet());
            this.bindResources(insertingRels);
            if (bindResources.isOverwrite()) {
                rels.stream().filter(resource -> bindResourceIds.stream().noneMatch(resourceId -> resourceId.equals(resource.getResourceId()))).forEach(rel -> {
                    logger.info("deleting Resourceset-Resource-Rel record, {}", rel);
                    try {
                        this.resourcesetResourceRelDao.deleteById(rel.getId());
                    }
                    catch (Exception e) {
                        logger.warn(e.getMessage(), (Throwable)e);
                    }
                });
            }
        }
    }

    public void bindResources(Collection<ResourcesetResourceRel> rels) {
        if (!CollectionUtils.isEmpty(rels)) {
            this.resourcesetResourceRelDao.saveAllAndFlush(rels);
        }
    }

    public boolean saveResourceRel(final Long resourcesetId, final Long resourceId, String operateUserName) {
        List list = this.resourcesetResourceRelDao.findAll((Specification)new Specification<ResourcesetResourceRel>(){

            public Predicate toPredicate(Root<ResourcesetResourceRel> root, CriteriaQuery<?> query, CriteriaBuilder builder) {
                ArrayList<Predicate> predicates = new ArrayList<Predicate>();
                predicates.add(builder.equal((Expression)root.get("resourcesetId"), (Object)resourcesetId));
                predicates.add(builder.equal((Expression)root.get("resourceId"), (Object)resourceId));
                if (!predicates.isEmpty()) {
                    query.where((Predicate[])predicates.stream().toArray(Predicate[]::new));
                }
                return query.getRestriction();
            }
        });
        if (list.isEmpty()) {
            ResourcesetResourceRel resourcesetResourceRel = new ResourcesetResourceRel();
            resourcesetResourceRel.setResourcesetId(resourcesetId);
            resourcesetResourceRel.setResourceId(resourceId);
            resourcesetResourceRel.setCreateUserName(operateUserName);
            this.resourcesetResourceRelDao.saveAndFlush((Object)resourcesetResourceRel);
            return false;
        }
        return true;
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateStatus(long resourcesetId, int status) {
        Resourceset existEntity = this.findById(resourcesetId);
        existEntity.setStatus(Integer.valueOf(status));
        this.resourcesetDao.saveAndFlush((Object)existEntity);
    }

    public List<Resourceset> listByRoleId(long roleId) {
        ResourcesetModel.Request.Query query = new ResourcesetModel.Request.Query();
        query.setRoleId(Long.valueOf(roleId));
        query.setStatus(Integer.valueOf(1));
        Specification specification = ResourcesetQueryHelper.querySpecification((ResourcesetModel.Request.Query)query);
        List resourcesets = this.resourcesetDao.findAll(specification);
        return resourcesets;
    }

    public List<Resourceset> listByServicePackageId(long servicePackageId, Integer status) {
        ResourcesetModel.Request.Query query = new ResourcesetModel.Request.Query();
        query.setServicePackageId(Long.valueOf(servicePackageId));
        query.setStatus(status);
        Specification specification = ResourcesetQueryHelper.querySpecification((ResourcesetModel.Request.Query)query);
        List resourcesets = this.resourcesetDao.findAll(specification);
        return resourcesets;
    }

    public List<Resourceset> listByServicePackageIds(Collection<Long> packageIds) {
        ResourcesetModel.Request.Query query = new ResourcesetModel.Request.Query();
        query.setPackageIds(new HashSet<Long>(packageIds));
        query.setStatus(Integer.valueOf(1));
        Specification specification = ResourcesetQueryHelper.querySpecification((ResourcesetModel.Request.Query)query);
        List resourcesets = this.resourcesetDao.findAll(specification);
        return resourcesets;
    }

    public Map<Long, List<Resourceset>> mapByServicePackageIds(Collection<Long> packageIds) {
        ResourcesetModel.Request.Query query = new ResourcesetModel.Request.Query();
        query.setPackageIds(new HashSet<Long>(packageIds));
        query.setStatus(Integer.valueOf(1));
        query.setAttributes(Stream.of("packageId").collect(Collectors.toSet()));
        List resourcesets = this.resourcesetDao.findAttributes(query, Sort.unsorted());
        Map<Long, List<Resourceset>> map = resourcesets.stream().collect(Collectors.groupingBy(Resourceset::getPackageId));
        return map;
    }

    public Page<ResourceSetDTO> pagingBy(Pageable pageable, ResourceSetQueryBo queryBo) {
        return this.resourceSetExtendDao.pagingBy(pageable, queryBo);
    }

    public Page<ResourceSetResourceDTO> pagingByResource(Pageable pageable, ResourceSetQueryBo queryBo) {
        return this.resourceSetExtendDao.pagingByResource(pageable, queryBo);
    }

    public Optional<Resourceset> findByResourceSetCode(String resourceSetCode) {
        List resourceSetList = this.resourcesetDao.findByCode(resourceSetCode);
        if (CollectionUtils.isEmpty((Collection)resourceSetList)) {
            return Optional.empty();
        }
        if (resourceSetList.size() > 1) {
            throw new IllegalArgumentException("\u3010" + resourceSetCode + "\u3011\u529f\u80fd\u96c6\u6570\u636e\u5b58\u5728\u4e0d\u552f\u4e00\u8bb0\u5f55");
        }
        return Optional.of(resourceSetList.get(0));
    }
}

