/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.resource.service;

import com.xforceplus.api.model.ServiceApiModel;
import com.xforceplus.business.resource.service.ResourceService;
import com.xforceplus.dao.ResourceApiRelDao;
import com.xforceplus.dao.ResourceDao;
import com.xforceplus.dao.ServiceApiDao;
import com.xforceplus.dao.ServiceApiExtendDao;
import com.xforceplus.domain.resource.RequestUri;
import com.xforceplus.domain.resource.RequestUriAuthz;
import com.xforceplus.dto.resource.ServiceApiResourceCodeVo;
import com.xforceplus.entity.Resource;
import com.xforceplus.entity.ResourceApiRel;
import com.xforceplus.entity.ServiceApi;
import com.xforceplus.query.ServiceApiQueryHelper;
import io.geewit.core.utils.reflection.BeanUtils;
import io.geewit.data.jpa.essential.domain.EntityGraphs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMethod;

@Service
public class ServiceApiService {
    private static final Logger logger = LoggerFactory.getLogger(ServiceApiService.class);
    private final ServiceApiDao serviceApiDao;
    private final ResourceApiRelDao resourceApiRelDao;
    private final ResourceService resourceService;
    private final ResourceDao resourceDao;
    private final ServiceApiExtendDao serviceApiExtendDao;

    public ServiceApiService(ServiceApiDao serviceApiDao, ResourceApiRelDao resourceApiRelDao, ResourceService resourceService, ResourceDao resourceDao, ServiceApiExtendDao serviceApiExtendDao) {
        this.serviceApiDao = serviceApiDao;
        this.resourceApiRelDao = resourceApiRelDao;
        this.resourceService = resourceService;
        this.resourceDao = resourceDao;
        this.serviceApiExtendDao = serviceApiExtendDao;
    }

    public Page<ServiceApi> page(ServiceApiModel.Request.Query query, Pageable pageable) {
        Specification specification = ServiceApiQueryHelper.querySpecification((ServiceApiModel.Request.Query)query);
        return this.serviceApiDao.findAll(specification, pageable, EntityGraphs.named((String)"ServiceApi.graph"));
    }

    public Page<ServiceApi> page(Specification<ServiceApi> specification, Pageable pageable) {
        return this.serviceApiDao.findAll(specification, pageable);
    }

    public List<ServiceApi> list(ServiceApiModel.Request.Query query, Sort sort) {
        Specification specification = ServiceApiQueryHelper.querySpecification((ServiceApiModel.Request.Query)query);
        List list = this.serviceApiDao.findAll(specification, sort);
        return list;
    }

    public List<ServiceApi> list(Specification<ServiceApi> specification, Sort sort) {
        return this.serviceApiDao.findAll(specification, sort);
    }

    public long count(ServiceApiModel.Request.Query query) {
        Specification specification = ServiceApiQueryHelper.querySpecification((ServiceApiModel.Request.Query)query);
        return this.serviceApiDao.count(specification);
    }

    @Transactional(rollbackFor={Exception.class})
    public ServiceApi save(ServiceApiModel.Request.Save model) {
        ServiceApi entity = new ServiceApi();
        BeanUtils.copyProperties((Object)model, (Object)entity);
        entity = (ServiceApi)this.serviceApiDao.saveAndFlush((Object)entity);
        this.bindResources(entity, model.getBindResources());
        return entity;
    }

    @Transactional(rollbackFor={Exception.class})
    public ServiceApi update(long id, ServiceApiModel.Request.Update model) {
        ServiceApi existEntity = this.findById(id);
        if (StringUtils.isBlank((CharSequence)model.getServiceApiName())) {
            model.setServiceApiName(null);
        }
        if (StringUtils.isBlank((CharSequence)model.getServiceApiPath())) {
            model.setServiceApiPath(null);
        }
        if (StringUtils.isBlank((CharSequence)model.getServiceApiUrl())) {
            model.setServiceApiUrl(null);
        }
        BeanUtils.copyProperties((Object)model, (Object)existEntity);
        existEntity = (ServiceApi)this.serviceApiDao.saveAndFlush((Object)existEntity);
        this.bindResources(existEntity, model.getBindResources());
        return existEntity;
    }

    public Optional<ServiceApi> findByRouteIdApiUrlMethod(Long routeId, String serviceApiUrl, RequestMethod requestMethod) {
        List serviceApis = this.serviceApiDao.findByRouteIdAndServiceApiUrlAndRequestMethod(routeId, serviceApiUrl, requestMethod);
        if (CollectionUtils.isEmpty((Collection)serviceApis)) {
            return Optional.empty();
        }
        if (serviceApis.size() > 1) {
            throw new IllegalArgumentException("\u8def\u5f84ID:[" + routeId + "], Path:[" + serviceApiUrl + "], RequestMethod:[" + requestMethod.name() + "]\u4e0d\u552f\u4e00\u6570\u636e\uff0c\u8bf7\u5148\u4fee\u6b63\u6570\u636e");
        }
        return Optional.of(serviceApis.get(0));
    }

    public ServiceApi findById(Long id) {
        return (ServiceApi)this.serviceApiDao.findById((Object)id).orElseThrow(() -> new IllegalArgumentException("\u672a\u627e\u5230\u5b9e\u4f53"));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteById(long id) {
        Optional optionalServiceApi = this.serviceApiDao.findById((Object)id);
        if (!optionalServiceApi.isPresent()) {
            String message = "\u4e0d\u5b58\u5728id:" + id + "\u7684\u670d\u52a1\u63a5\u53e3";
            throw new IllegalArgumentException(message);
        }
        long countRel = this.resourceApiRelDao.countByServiceApiId(id);
        if (countRel > 0L) {
            throw new IllegalArgumentException("\u8be5\u670d\u52a1\u63a5\u53e3(" + id + ")\u5df2\u7ecf\u5173\u8054\u8d44\u6e90\u7801\u4e0d\u80fd\u5220\u9664");
        }
        this.serviceApiDao.deleteById(Long.valueOf(id));
        this.resourceApiRelDao.deleteByServiceApiId(id);
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean saveResourceApiRel(final Long resourceId, final Long serviceApiId, String operateUserName) {
        List rels = this.resourceApiRelDao.findAll((Specification)new Specification<ResourceApiRel>(){

            public Predicate toPredicate(Root<ResourceApiRel> root, CriteriaQuery<?> query, CriteriaBuilder builder) {
                List predicates = Stream.of(builder.equal((Expression)root.get("serviceApiId"), (Object)serviceApiId), builder.equal((Expression)root.get("resourceId"), (Object)resourceId)).collect(Collectors.toList());
                if (!predicates.isEmpty()) {
                    query.where((Predicate[])predicates.stream().toArray(Predicate[]::new));
                }
                return query.getRestriction();
            }
        });
        if (rels.isEmpty()) {
            ResourceApiRel resourceApiRel = new ResourceApiRel();
            resourceApiRel.setResourceId(resourceId);
            resourceApiRel.setServiceApiId(serviceApiId);
            resourceApiRel.setCreateUserName(operateUserName);
            this.resourceApiRelDao.saveAndFlush((Object)resourceApiRel);
            return true;
        }
        return false;
    }

    @Transactional(rollbackFor={Exception.class})
    public void bindResources(long id, ServiceApiModel.Request.BindResources bindResources) {
        ServiceApi serviceApi = this.findById(id);
        this.bindResources(serviceApi, bindResources);
    }

    @Transactional(rollbackFor={Exception.class})
    public void bindResources(ServiceApi serviceApi, ServiceApiModel.Request.BindResources bindResources) {
        if (bindResources == null) {
            return;
        }
        List resourceIds = bindResources.getResourceIds();
        if (resourceIds == null) {
            return;
        }
        logger.info("resourceIds = " + resourceIds.stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.joining(",")));
        List existRels = this.resourceApiRelDao.findByServiceApiId(serviceApi.getServiceApiId());
        logger.info("exist api-resource-rels.size = " + existRels.size());
        Set<ResourceApiRel> insertingRels = resourceIds.stream().filter(resourceId -> existRels.stream().map(ResourceApiRel::getResourceId).noneMatch(existId -> existId.equals(resourceId))).map(resourceId -> {
            Optional resourceOptional = this.resourceDao.findById(resourceId);
            if (resourceOptional.isPresent()) {
                ResourceApiRel rel = new ResourceApiRel();
                rel.setResourceId(resourceId);
                rel.setServiceApiId(serviceApi.getServiceApiId());
                return rel;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        this.bindResources(insertingRels);
        if (bindResources.isOverwrite()) {
            existRels.stream().filter(rel -> resourceIds.stream().noneMatch(resourceId -> resourceId.equals(rel.getResourceId()))).forEach(rel -> {
                logger.info("deleting Resource-Api-Rel record, {}", rel);
                this.resourceApiRelDao.deleteById(rel.getId());
            });
        }
    }

    public List<ResourceApiRel> findResourceApiRelByServiceApiId(Long serviceApiId) {
        return this.resourceApiRelDao.findByServiceApiId(serviceApiId);
    }

    public List<ResourceApiRel> findResourceApiRelByResourceId(Long resoruceId) {
        return this.resourceApiRelDao.findByResourceId(resoruceId);
    }

    @Transactional(rollbackFor={Exception.class})
    public void bindResources(Collection<ResourceApiRel> rels) {
        if (!rels.isEmpty()) {
            rels.forEach(arg_0 -> ((ResourceApiRelDao)this.resourceApiRelDao).saveAndFlush(arg_0));
        }
    }

    public List<ServiceApi> findByRouteId(long routeId) {
        ServiceApiModel.Request.Query query = new ServiceApiModel.Request.Query();
        query.setRouteId(Long.valueOf(routeId));
        Specification specification = ServiceApiQueryHelper.querySpecification((ServiceApiModel.Request.Query)query);
        return this.serviceApiDao.findAll(specification);
    }

    public Map<RequestUri, RequestUriAuthz> getRequestUriAndResourceCodesMapByRouteId(long routeId) {
        List<ServiceApi> serviceApis = this.findByRouteId(routeId);
        HashMap<RequestUri, RequestUriAuthz> map = new HashMap<RequestUri, RequestUriAuthz>();
        for (ServiceApi serviceApi : serviceApis) {
            RequestUri requestUri = new RequestUri(serviceApi.getServiceApiUrl(), serviceApi.getRequestMethod());
            List<Resource> resources = this.resourceService.listByServiceApiId(serviceApi.getServiceApiId());
            Set resourceCodes = resources.stream().map(Resource::getResourceCode).filter(Objects::nonNull).collect(Collectors.toSet());
            RequestUriAuthz requestUriAuthz = new RequestUriAuthz(resourceCodes, serviceApi.getSkipAuthentication(), serviceApi.getSkipAuthorization());
            map.put(requestUri, requestUriAuthz);
        }
        return map;
    }

    public List<ServiceApi> findAllSkipAuthorizationServiceApi() {
        return this.serviceApiDao.findBySkipAuthorizationEqualsAndStatusEquals(Boolean.valueOf(true), Integer.valueOf(1));
    }

    public List<ServiceApi> findServiceApiUrlsByResourceCode(String resourceCode) {
        if (StringUtils.isBlank((CharSequence)resourceCode)) {
            return new ArrayList<ServiceApi>();
        }
        return this.serviceApiDao.findServiceApiUrlsByResourceCode(resourceCode);
    }

    @Transactional(rollbackFor={Exception.class})
    public void unbindServiceApiResourceRel(long serviceApiId, long resourceId) {
        this.resourceApiRelDao.deleteByServiceApiIdAndResourceId(serviceApiId, resourceId);
    }

    public Map<String, List<ServiceApiResourceCodeVo>> getExactServiceApiResourceMap() {
        List serviceApiLists = this.serviceApiExtendDao.getExactServiceApiResourceList();
        HashMap<String, List<ServiceApiResourceCodeVo>> map = new HashMap<String, List<ServiceApiResourceCodeVo>>(serviceApiLists.size());
        for (ServiceApiResourceCodeVo item : serviceApiLists) {
            ArrayList<ServiceApiResourceCodeVo> listValue = (ArrayList<ServiceApiResourceCodeVo>)map.get(item.getServiceApiUrl());
            if (listValue == null) {
                listValue = new ArrayList<ServiceApiResourceCodeVo>();
                map.put(item.getServiceApiUrl(), listValue);
            }
            listValue.add(item);
        }
        return map;
    }

    public List<ServiceApiResourceCodeVo> getPathVariableServiceApiResourceList() {
        return this.serviceApiExtendDao.getPathVariableServiceApiResourceList();
    }
}

