/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.resource.service;

import com.xforceplus.business.resource.service.ResourceService;
import com.xforceplus.business.resource.service.ServicePackageService;
import com.xforceplus.dao.AppDao;
import com.xforceplus.dao.ResourceDao;
import com.xforceplus.dao.ResourcesetDao;
import com.xforceplus.dao.ServicePackageDao;
import com.xforceplus.dao.ServiceResourcesetRelDao;
import com.xforceplus.domain.resource.ResourcesetExtendDto;
import com.xforceplus.domain.resource.ServicePackageExtendDto;
import com.xforceplus.entity.Resource;
import com.xforceplus.entity.Resourceset;
import com.xforceplus.entity.ServicePackage;
import com.xforceplus.entity.ServiceResourcesetRel;
import com.xforceplus.tenant.core.exception.UnknownException;
import com.xforceplus.utils.excel.QueryUtils;
import com.xforceplus.utils.excel.ServicePackageWrapper;
import io.geewit.core.utils.reflection.BeanUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class ServicePackagePortService {
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private ServicePackageService servicePackageService;
    @Autowired
    private ServiceResourcesetRelDao serviceResourcesetRelDao;
    @Autowired
    private ResourcesetDao resourcesetDao;
    @Autowired
    private ResourceDao resourceDao;
    @Autowired
    private ServicePackageDao servicePackageDao;
    @Autowired
    private AppDao appDao;
    private String operateUserName = "\u624b\u52a8\u5bfc\u5165";

    public ServicePackageWrapper getExportData(List<Long> servicePackageIds) {
        Specification specification = QueryUtils.getSpecification("servicePackageId", servicePackageIds);
        List<ServicePackage> servicePackageList = this.servicePackageService.list((Specification<ServicePackage>)specification, Sort.unsorted());
        if (servicePackageList == null || servicePackageList.size() <= 0) {
            throw new UnknownException("\u6240\u9009id\u8bb0\u5f55\u4e0d\u5b58\u5728\u3002");
        }
        ArrayList<ServicePackageExtendDto> servicePackageExtendDtoList = new ArrayList<ServicePackageExtendDto>(servicePackageList.size());
        for (ServicePackage servicePackage : servicePackageList) {
            ServicePackageExtendDto servicePackageExtendDto = new ServicePackageExtendDto();
            BeanUtils.copyProperties((Object)servicePackage, (Object)servicePackageExtendDto);
            servicePackageExtendDtoList.add(servicePackageExtendDto);
        }
        ServicePackageWrapper result = new ServicePackageWrapper();
        result.setServicePackages(servicePackageExtendDtoList);
        if (CollectionUtils.isEmpty(servicePackageExtendDtoList)) {
            return result;
        }
        List existServicePackageIds = servicePackageExtendDtoList.stream().map(p -> p.getServicePackageId()).collect(Collectors.toList());
        Specification specification2 = QueryUtils.getSpecification("servicePackageId", existServicePackageIds);
        List serviceResourcesetRels = this.serviceResourcesetRelDao.findAll(specification2, Sort.unsorted());
        if (CollectionUtils.isEmpty((Collection)serviceResourcesetRels)) {
            return result;
        }
        ArrayList<ResourcesetExtendDto> resourcesetExtendDtoList = new ArrayList<ResourcesetExtendDto>(serviceResourcesetRels.size());
        Map<Long, Integer> servicePackageIdAndIndex = this.getServicePackageIdAndIndex(result.getServicePackages());
        for (ServiceResourcesetRel item : serviceResourcesetRels) {
            ResourcesetExtendDto resourcesetExtendDto = new ResourcesetExtendDto();
            Optional optional = this.resourcesetDao.findById((Object)item.getResourcesetId());
            if (!optional.isPresent()) continue;
            Resourceset resourceset = (Resourceset)optional.get();
            resourcesetExtendDto.setResourcesetName(resourceset.getResourcesetName());
            resourcesetExtendDto.setAppId(resourceset.getAppId());
            if (resourceset.getResourceId() != null && resourceset.getResourceId() > 0L) {
                Optional resourceOptional = this.resourceDao.findById((Object)resourceset.getResourceId());
                resourceOptional.ifPresent(resource -> resourcesetExtendDto.setRelResourceCode(resource.getResourceCode()));
            }
            Integer index = servicePackageIdAndIndex.get(item.getServicePackageId());
            resourcesetExtendDto.setRelServicePackageIndex(Integer.valueOf(index + 1));
            resourcesetExtendDtoList.add(resourcesetExtendDto);
        }
        result.setResourcesets(resourcesetExtendDtoList);
        return result;
    }

    private Map<Long, Integer> getServicePackageIdAndIndex(List<ServicePackageExtendDto> servicePackages) {
        if (servicePackages == null || servicePackages.size() <= 0) {
            return new HashMap<Long, Integer>();
        }
        HashMap<Long, Integer> map = new HashMap<Long, Integer>(servicePackages.size());
        for (int i = 0; i < servicePackages.size(); ++i) {
            ServicePackageExtendDto servicePackageExtendDto = servicePackages.get(i);
            if (servicePackageExtendDto.getServicePackageId() == null || servicePackageExtendDto.getServicePackageId() <= 0L) continue;
            map.put(servicePackageExtendDto.getServicePackageId(), i);
        }
        return map;
    }

    public ServicePackageWrapper saveData(ServicePackageWrapper wrapper) {
        ServicePackageWrapper result = new ServicePackageWrapper();
        List<ServicePackageExtendDto> servicePackageExtendDtoList = wrapper.getServicePackages();
        List<ServicePackageExtendDto> existServicePackageList = this.saveServicePackage(servicePackageExtendDtoList);
        List<ResourcesetExtendDto> existRels = this.saveResourcesetRel(servicePackageExtendDtoList, wrapper.getResourcesets());
        result.setServicePackages(existServicePackageList);
        result.setResourcesets(existRels);
        return result;
    }

    private List<ResourcesetExtendDto> saveResourcesetRel(List<ServicePackageExtendDto> servicePackageExtendDtoList, List<ResourcesetExtendDto> resourcesets) {
        ArrayList<ResourcesetExtendDto> extendDtoList = new ArrayList<ResourcesetExtendDto>();
        for (ResourcesetExtendDto item : resourcesets) {
            if (null == item.getAppId() || !this.appDao.existsById((Object)item.getAppId())) {
                item.setReason("\u65e0\u6548\u7684appId\u3002");
                extendDtoList.add(item);
                continue;
            }
            Resourceset resourceset = this.getOldResourceset(item.getResourcesetName(), item.getAppId(), item.getRelResourceCode());
            if (resourceset == null) {
                item.setReason("\u76f8\u5173\u529f\u80fd\u96c6\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u5bfc\u5165\u529f\u80fd\u96c6\u3002");
                extendDtoList.add(item);
                continue;
            }
            ServicePackageExtendDto servicePackageExtendDto = servicePackageExtendDtoList.get(item.getRelServicePackageIndex() - 1);
            boolean exists = this.servicePackageService.saveResourcesetRel(servicePackageExtendDto.getServicePackageId(), resourceset.getResourcesetId(), this.operateUserName);
            if (!exists) continue;
            item.setReason("\u670d\u52a1\u5305\u548c\u529f\u80fd\u96c6\u5df2\u7ecf\u5173\u8054\u3002");
            extendDtoList.add(item);
        }
        return extendDtoList;
    }

    private Resourceset getOldResourceset(final String resourcesetName, final Long appId, String relResourceCode) {
        List list = this.resourcesetDao.findAll((Specification)new Specification<Resourceset>(){

            public Predicate toPredicate(Root<Resourceset> root, CriteriaQuery<?> query, CriteriaBuilder builder) {
                ArrayList<Predicate> predicates = new ArrayList<Predicate>();
                predicates.add(builder.equal((Expression)root.get("resourcesetName"), (Object)resourcesetName));
                if (appId != null && appId > 0L) {
                    predicates.add(builder.equal((Expression)root.get("appId"), (Object)appId));
                }
                if (!predicates.isEmpty()) {
                    query.where((Predicate[])predicates.stream().toArray(Predicate[]::new));
                }
                return query.getRestriction();
            }
        });
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        Resourceset oldResourceset = null;
        for (Resourceset resourceset : list) {
            Resource resource;
            Optional optionalResource;
            if (StringUtils.isBlank((CharSequence)relResourceCode)) {
                if (resourceset.getResourceId() != null && resourceset.getResourceId() > 0L) continue;
                oldResourceset = resourceset;
                break;
            }
            if (resourceset.getResourceId() == null || resourceset.getResourceId() <= 0L || !(optionalResource = this.resourceDao.findById((Object)resourceset.getResourceId())).isPresent() || !StringUtils.equals((CharSequence)relResourceCode, (CharSequence)(resource = (Resource)optionalResource.get()).getResourceCode())) continue;
            oldResourceset = resourceset;
            break;
        }
        return oldResourceset;
    }

    public List<ServicePackageExtendDto> saveServicePackage(List<ServicePackageExtendDto> servicePackageExtendDtoList) {
        ArrayList<ServicePackageExtendDto> exists = new ArrayList<ServicePackageExtendDto>();
        for (final ServicePackageExtendDto servicePackageExtendDto : servicePackageExtendDtoList) {
            if (null == servicePackageExtendDto.getAppId() || !this.appDao.existsById((Object)servicePackageExtendDto.getAppId())) {
                servicePackageExtendDto.setReason("\u65e0\u6548\u7684appId\u3002");
                exists.add(servicePackageExtendDto);
                continue;
            }
            List list = this.servicePackageDao.findAll((Specification)new Specification<ServicePackage>(){

                public Predicate toPredicate(Root<ServicePackage> root, CriteriaQuery<?> query, CriteriaBuilder builder) {
                    ArrayList<Predicate> predicates = new ArrayList<Predicate>();
                    predicates.add(builder.equal((Expression)root.get("servicePackageName"), (Object)servicePackageExtendDto.getServicePackageName()));
                    if (servicePackageExtendDto.getAppId() != null && servicePackageExtendDto.getAppId() > 0L) {
                        predicates.add(builder.equal((Expression)root.get("appId"), (Object)servicePackageExtendDto.getAppId()));
                    }
                    if (!predicates.isEmpty()) {
                        query.where((Predicate[])predicates.stream().toArray(Predicate[]::new));
                    }
                    return query.getRestriction();
                }
            });
            ServicePackage oldServicePackage = null;
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                oldServicePackage = (ServicePackage)list.get(0);
            }
            if (oldServicePackage == null) {
                ServicePackage servicePackage = new ServicePackage();
                BeanUtils.copyProperties((Object)servicePackageExtendDto, (Object)servicePackage);
                oldServicePackage = (ServicePackage)this.servicePackageDao.saveAndFlush((Object)servicePackage);
            } else {
                servicePackageExtendDto.setReason("\u8be5\u670d\u52a1\u5305\u5df2\u7ecf\u5b58\u5728\u3002");
                exists.add(servicePackageExtendDto);
            }
            servicePackageExtendDto.setServicePackageId(oldServicePackage.getServicePackageId());
        }
        return exists;
    }
}

