/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.resource.service;

import com.google.common.base.Joiner;
import com.xforceplus.api.model.ServicePackageModel;
import com.xforceplus.bo.ServicePackageQueryBo;
import com.xforceplus.business.resource.service.ResourcesetService;
import com.xforceplus.dao.AppDao;
import com.xforceplus.dao.CompanyServiceRelDao;
import com.xforceplus.dao.ResourcesetDao;
import com.xforceplus.dao.RoleResourcesetRelDao;
import com.xforceplus.dao.ServicePackageDao;
import com.xforceplus.dao.ServicePackageExtendDao;
import com.xforceplus.dao.ServiceResourcesetRelDao;
import com.xforceplus.domain.TreeNode;
import com.xforceplus.dto.resource.ServicePackageDTO;
import com.xforceplus.dto.resource.ServicePackageResourceSetDTO;
import com.xforceplus.entity.App;
import com.xforceplus.entity.CompanyServiceRel;
import com.xforceplus.entity.Resourceset;
import com.xforceplus.entity.ServicePackage;
import com.xforceplus.entity.ServiceResourcesetRel;
import com.xforceplus.query.ServicePackageQueryHelper;
import io.geewit.core.utils.reflection.BeanUtils;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ServicePackageService {
    private static final Logger logger = LoggerFactory.getLogger(ServicePackageService.class);
    private final ServiceResourcesetRelDao serviceResourcesetRelDao;
    private final ServicePackageDao servicePackageDao;
    private final ResourcesetDao resourcesetDao;
    private final CompanyServiceRelDao companyServiceRelDao;
    private final ResourcesetService resourcesetService;
    private final ServicePackageExtendDao servicePackageExtendDao;
    private final RoleResourcesetRelDao roleResourcesetRelDao;
    private final AppDao appDao;

    public ServicePackageService(ServicePackageDao servicePackageDao, ServiceResourcesetRelDao serviceResourcesetRelDao, ResourcesetDao resourcesetDao, CompanyServiceRelDao companyServiceRelDao, ResourcesetService resourcesetService, ServicePackageExtendDao servicePackageExtendDao, RoleResourcesetRelDao roleResourcesetRelDao, AppDao appDao) {
        this.servicePackageDao = servicePackageDao;
        this.serviceResourcesetRelDao = serviceResourcesetRelDao;
        this.resourcesetDao = resourcesetDao;
        this.companyServiceRelDao = companyServiceRelDao;
        this.resourcesetService = resourcesetService;
        this.servicePackageExtendDao = servicePackageExtendDao;
        this.roleResourcesetRelDao = roleResourcesetRelDao;
        this.appDao = appDao;
    }

    public Page<ServicePackage> page(ServicePackageModel.Request.Query query, Pageable pageable) {
        Specification specification = ServicePackageQueryHelper.querySpecification((ServicePackageModel.Request.Query)query);
        Page page = this.servicePackageDao.findAll(specification, pageable);
        for (ServicePackage servicePackage : page) {
            List<Resourceset> resourcesets = this.resourcesetService.listByServicePackageId(servicePackage.getServicePackageId(), query.getStatus());
            servicePackage.setResourcesets(new HashSet<Resourceset>(resourcesets));
        }
        this.fillServicePackageExtensions(query, (Iterable<ServicePackage>)page);
        return page;
    }

    public List<ServicePackage> list(Specification<ServicePackage> specification, Sort sort) {
        return this.servicePackageDao.findAll(specification, sort);
    }

    public List<ServicePackage> list(ServicePackageModel.Request.Query query, Sort sort) {
        Specification specification = ServicePackageQueryHelper.querySpecification((ServicePackageModel.Request.Query)query);
        List list = this.servicePackageDao.findAll(specification, sort);
        this.fillServicePackageExtensions(query, list);
        return list;
    }

    private void fillServicePackageExtensions(ServicePackageModel.Request.Query query, Iterable<ServicePackage> servicePackages) {
        if (servicePackages == null || servicePackages.iterator() == null || !servicePackages.iterator().hasNext()) {
            return;
        }
        boolean needAppName = false;
        boolean needResourcesets = false;
        if (StringUtils.isNotBlank((CharSequence)query.getWithExtendParams())) {
            String[] withExtendParams = StringUtils.split((String)query.getWithExtendParams(), (String)",");
            for (String withExtendParam : withExtendParams) {
                if ("appName".equalsIgnoreCase(withExtendParam)) {
                    needAppName = true;
                    break;
                }
                if (!"resourcesets".equalsIgnoreCase(withExtendParam)) continue;
                needResourcesets = true;
                break;
            }
        }
        if (needAppName || needResourcesets) {
            Map<Object, Object> appNameMap;
            if (needAppName) {
                HashSet<Long> appIds = new HashSet<Long>();
                for (ServicePackage servicePackage : servicePackages) {
                    appIds.add(servicePackage.getAppId());
                }
                List apps = this.appDao.findAppsByAppIds(appIds);
                appNameMap = apps.stream().collect(Collectors.toMap(App::getAppId, App::getAppName));
            } else {
                appNameMap = Collections.emptyMap();
            }
            if (needResourcesets) {
                Set set = StreamSupport.stream(servicePackages.spliterator(), false).map(ServicePackage::getServicePackageId).collect(Collectors.toSet());
            }
            for (ServicePackage servicePackage : servicePackages) {
                List<Resourceset> resourcesets;
                if (appNameMap != null && !appNameMap.isEmpty()) {
                    servicePackage.setAppName((String)appNameMap.get(servicePackage.getAppId()));
                }
                if (!needResourcesets || (resourcesets = this.resourcesetService.listByServicePackageId(servicePackage.getServicePackageId(), 1)) == null || resourcesets.isEmpty()) continue;
                servicePackage.setResourcesets(new HashSet<Resourceset>(resourcesets));
            }
        }
    }

    public Optional<ServicePackage> findOne(ServicePackageModel.Request.Query query) {
        Specification specification = ServicePackageQueryHelper.queryOneSpecification((ServicePackageModel.Request.Query)query);
        return this.servicePackageDao.findOne(specification);
    }

    public long count(ServicePackageModel.Request.Query query) {
        Specification specification = ServicePackageQueryHelper.queryOneSpecification((ServicePackageModel.Request.Query)query);
        return this.servicePackageDao.count(specification);
    }

    @Transactional(rollbackFor={Exception.class})
    public ServicePackage create(ServicePackageModel.Request.Save model) {
        ServicePackage entity = new ServicePackage();
        BeanUtils.copyProperties((Object)model, (Object)entity);
        entity = (ServicePackage)this.servicePackageDao.saveAndFlush((Object)entity);
        if (model.getBindResourceSets() != null) {
            this.bindResourceSets(entity, model.getBindResourceSets());
        }
        return entity;
    }

    @Transactional(rollbackFor={Exception.class})
    public ServicePackage update(long servicePackageId, ServicePackageModel.Request.Save model) {
        ServicePackage existEntity = this.findById(servicePackageId);
        if (StringUtils.isBlank((CharSequence)model.getServicePackageCode())) {
            model.setServicePackageCode(null);
        }
        if (StringUtils.isBlank((CharSequence)model.getServicePackageName())) {
            model.setServicePackageName(null);
        }
        BeanUtils.copyProperties((Object)model, (Object)existEntity);
        existEntity = (ServicePackage)this.servicePackageDao.saveAndFlush((Object)existEntity);
        if (model.getBindResourceSets() != null) {
            this.bindResourceSets(existEntity, model.getBindResourceSets());
        }
        return existEntity;
    }

    @Transactional(rollbackFor={Exception.class})
    public void unBindResourceSets(Long servicePackageId, Long resourceSetId) {
        List rels = this.serviceResourcesetRelDao.findByServicePackageIdAndResourcesetId(servicePackageId.longValue(), resourceSetId.longValue());
        if (CollectionUtils.isEmpty((Collection)rels)) {
            throw new IllegalArgumentException("\u670d\u52a1\u5305\u4e0e\u529f\u80fd\u672a\u7ed1\u5b9a");
        }
        try {
            this.serviceResourcesetRelDao.delete(rels.get(0));
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("\u89e3\u7ed1\u6570\u636e\u5931\u8d25");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void bindResourceSets(ServicePackage servicePackage, ServicePackageModel.Request.BindResourceSets bindResourceSets) {
        if (bindResourceSets == null) {
            return;
        }
        List bindResourcesetIds = bindResourceSets.getResourcesetIds();
        if (bindResourcesetIds == null) {
            return;
        }
        logger.info("bindResourcesetIds = " + bindResourcesetIds.stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.joining(",")));
        List rels = this.serviceResourcesetRelDao.findByServicePackageId(servicePackage.getServicePackageId().longValue());
        logger.info("exist sericepackage-resourceset-rels.size = " + rels.size());
        List<ServiceResourcesetRel> insertingRels = bindResourcesetIds.stream().filter(Objects::nonNull).filter(resourcesetId -> rels.stream().map(ServiceResourcesetRel::getResourcesetId).noneMatch(resourcesetDtoId -> resourcesetDtoId.equals(resourcesetId))).map(resourcesetId -> {
            Optional resourceOptional = this.resourcesetDao.findById(resourcesetId);
            if (resourceOptional.isPresent()) {
                ServiceResourcesetRel rel = new ServiceResourcesetRel();
                rel.setResourcesetId(resourcesetId);
                rel.setServicePackageId(servicePackage.getServicePackageId());
                return rel;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        this.bindResourceSets(insertingRels);
        if (bindResourceSets.isOverwrite()) {
            rels.stream().filter(rel -> !bindResourcesetIds.contains(rel.getResourcesetId())).forEach(rel -> {
                logger.info("deleting Service-Resourceset-Rel record, {}", rel);
                try {
                    this.serviceResourcesetRelDao.deleteById(rel.getId());
                }
                catch (Exception e) {
                    logger.warn(e.getMessage(), (Throwable)e);
                }
            });
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void bindResourceSets(Collection<ServiceResourcesetRel> rels) {
        if (!CollectionUtils.isEmpty(rels)) {
            rels.forEach(arg_0 -> ((ServiceResourcesetRelDao)this.serviceResourcesetRelDao).saveAndFlush(arg_0));
        }
    }

    public ServicePackage findById(long servicePackageId) {
        ServicePackage servicePackage = (ServicePackage)this.servicePackageDao.findById((Object)servicePackageId).orElseThrow(() -> new IllegalArgumentException("\u672a\u627e\u5230\u5b9e\u4f53"));
        if (servicePackage != null) {
            List<Resourceset> resourcesets = this.resourcesetService.listByServicePackageId(servicePackageId, null);
            servicePackage.setResourcesets(resourcesets.stream().filter(Objects::nonNull).collect(Collectors.toSet()));
        }
        return servicePackage;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteById(long servicePackageId) {
        Optional optionalServicePackage = this.servicePackageDao.findOne((Specification & Serializable)(root, query1, builder) -> builder.equal((Expression)root.get("servicePackageId"), (Object)servicePackageId));
        if (!optionalServicePackage.isPresent()) {
            throw new IllegalArgumentException("\u9519\u8bef\u7684\u670d\u52a1\u5305id");
        }
        ServicePackage servicePackage = (ServicePackage)optionalServicePackage.get();
        if (servicePackage.getStatus() != null && servicePackage.getStatus() == 1) {
            throw new IllegalArgumentException("\u7981\u7528\u7684\u670d\u52a1\u5305\u624d\u53ef\u4ee5\u88ab\u5220\u9664");
        }
        long count = this.companyServiceRelDao.countByServicePackageId(servicePackageId);
        if (count > 0L) {
            throw new IllegalArgumentException("\u8be5\u670d\u52a1\u5305\u5df2\u7ecf\u7ed1\u5b9a\u8fc7\u516c\u53f8\u670d\u52a1\u5305\u4e0d\u80fd\u5220\u9664");
        }
        try {
            this.servicePackageDao.deleteById(Long.valueOf(servicePackageId));
            this.serviceResourcesetRelDao.deleteByPackageId(servicePackageId);
            this.companyServiceRelDao.deleteByPackageId(servicePackageId);
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateStatus(long servicePackageId, int status) {
        Optional optionalServicePackage = this.servicePackageDao.findById((Object)servicePackageId);
        if (!optionalServicePackage.isPresent()) {
            throw new IllegalArgumentException("\u9519\u8bef\u7684\u670d\u52a1\u5305id");
        }
        ServicePackage servicePackage = (ServicePackage)optionalServicePackage.get();
        servicePackage.setStatus(Integer.valueOf(status));
        this.servicePackageDao.saveAndFlush((Object)servicePackage);
    }

    public boolean saveResourcesetRel(final Long servicePackageId, final Long resourcesetId, String operateUserName) {
        List list = this.serviceResourcesetRelDao.findAll((Specification)new Specification<ServiceResourcesetRel>(){

            public Predicate toPredicate(Root<ServiceResourcesetRel> root, CriteriaQuery<?> query, CriteriaBuilder builder) {
                ArrayList<Predicate> predicates = new ArrayList<Predicate>();
                predicates.add(builder.equal((Expression)root.get("servicePackageId"), (Object)servicePackageId));
                predicates.add(builder.equal((Expression)root.get("resourcesetId"), (Object)resourcesetId));
                if (!predicates.isEmpty()) {
                    query.where((Predicate[])predicates.stream().toArray(Predicate[]::new));
                }
                return query.getRestriction();
            }
        });
        if (list.isEmpty()) {
            ServiceResourcesetRel serviceResourcesetRel = new ServiceResourcesetRel();
            serviceResourcesetRel.setServicePackageId(servicePackageId);
            serviceResourcesetRel.setResourcesetId(resourcesetId);
            serviceResourcesetRel.setCreateUserName(operateUserName);
            this.serviceResourcesetRelDao.saveAndFlush((Object)serviceResourcesetRel);
            return false;
        }
        return true;
    }

    public Page<ServicePackage> page(long tenantId, ServicePackageModel.Request.Query query, Pageable pageable) {
        query.setTenantId(Long.valueOf(tenantId));
        Specification specification = ServicePackageQueryHelper.querySpecification((ServicePackageModel.Request.Query)query);
        Page page = this.servicePackageDao.findAll(specification, pageable);
        for (ServicePackage servicePackage : page) {
            List<Resourceset> resourcesets = this.resourcesetService.listByServicePackageId(servicePackage.getServicePackageId(), query.getStatus());
            servicePackage.setResourcesets(new HashSet<Resourceset>(resourcesets));
        }
        this.fillServicePackageExtensions(query, (Iterable<ServicePackage>)page);
        return page;
    }

    public List<ServicePackage> listByTenantIdAndCompanyId(long tenantId, long companyId) {
        ServicePackageModel.Request.Query query = new ServicePackageModel.Request.Query();
        query.setTenantId(Long.valueOf(tenantId));
        query.setCompanyId(Long.valueOf(companyId));
        query.setStatus(Integer.valueOf(1));
        Specification specification = ServicePackageQueryHelper.querySpecification((ServicePackageModel.Request.Query)query);
        List packages = this.servicePackageDao.findAll(specification);
        return packages;
    }

    public Page<ServicePackageResourceSetDTO> pagingByResourceSet(Pageable pageable, ServicePackageQueryBo queryBo) {
        return this.servicePackageExtendDao.pagingByResourceSet(pageable, queryBo);
    }

    public Page<ServicePackageDTO> pagingBy(Pageable pageable, ServicePackageQueryBo queryBo) {
        return this.servicePackageExtendDao.pagingBy(pageable, queryBo);
    }

    public List<TreeNode> tree(Long tenantId, ServicePackageModel.Request.Query query) {
        List packageNodes = this.servicePackageDao.treePackageNodeList(tenantId, query);
        if (CollectionUtils.isEmpty((Collection)packageNodes)) {
            return Collections.emptyList();
        }
        List packageIds = packageNodes.stream().map(node -> node.getKey()).collect(Collectors.toList());
        List resourcesetNodes = this.servicePackageDao.treeResourcesetNodeList(packageIds);
        if (CollectionUtils.isEmpty((Collection)resourcesetNodes)) {
            return Collections.emptyList();
        }
        Set resourcesetIds = resourcesetNodes.stream().map(pack -> pack.getKey()).collect(Collectors.toSet());
        List resourceNodes = this.servicePackageDao.treeResourceNodeList(resourcesetIds);
        if (CollectionUtils.isEmpty((Collection)resourceNodes)) {
            return Collections.emptyList();
        }
        int treeNodeSize = packageNodes.size() + resourcesetNodes.size() + resourceNodes.size();
        List<TreeNode> treeNodes = new ArrayList<TreeNode>(treeNodeSize);
        treeNodes.addAll(packageNodes);
        treeNodes.addAll(resourcesetNodes);
        treeNodes.addAll(resourceNodes);
        treeNodes = this.markResoruceTreeRecursiveCall(treeNodes, "PG_0", "");
        return treeNodes;
    }

    private List<TreeNode> markResoruceTreeRecursiveCall(List<TreeNode> treeNodes, String parentKey, String parentPath) {
        if (CollectionUtils.isEmpty(treeNodes)) {
            return Collections.emptyList();
        }
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        for (TreeNode treeNode : treeNodes) {
            String targetPath;
            if (!parentKey.equals(treeNode.getParentKey())) continue;
            if ("RESOURCE".equals(treeNode.getType())) {
                targetPath = this.setResourcePath(parentPath, treeNode.getId());
                treeNode.setPath(targetPath);
                nodes.add(treeNode);
                continue;
            }
            targetPath = this.setResourcePath(parentPath, treeNode.getId());
            List<TreeNode> children = this.markResoruceTreeRecursiveCall(treeNodes, treeNode.getId(), targetPath);
            treeNode.setChildren(children);
            treeNode.setPath(targetPath);
            if ("SERVICE_PACKAGE".equals(treeNode.getType()) && CollectionUtils.isEmpty(children)) continue;
            nodes.add(treeNode);
        }
        nodes.sort(Comparator.comparing(TreeNode::getId));
        return nodes;
    }

    private List<TreeNode> markResoruceTree(List<TreeNode> packageNodes, Map<String, Set<TreeNode>> resourceSetNodeMap, Map<String, Set<TreeNode>> resourceMap) {
        if (CollectionUtils.isEmpty(packageNodes)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(packageNodes.size());
        for (TreeNode packageNode : packageNodes) {
            if (!resourceSetNodeMap.containsKey(packageNode.getId())) continue;
            String targetPath = this.setResourcePath("", packageNode.getId());
            packageNode.setPath(targetPath);
            Set<TreeNode> resourceSetNodesSource = resourceSetNodeMap.get(packageNode.getId());
            ArrayList<TreeNode> resourceSetNodes = new ArrayList<TreeNode>(resourceSetNodesSource.size());
            for (TreeNode resourceSetNode : resourceSetNodesSource) {
                String resourceSetPath = this.setResourcePath(targetPath, resourceSetNode.getId());
                Set<TreeNode> resoureNodes = resourceMap.get(resourceSetNode.getId());
                List<TreeNode> resourceNodeList = this.setResources(resoureNodes, resourceSetPath);
                resourceSetNode.setChildren(resourceNodeList);
                resourceSetNode.setPath(resourceSetPath);
                resourceSetNodes.add(resourceSetNode);
            }
            resourceSetNodes.sort(Comparator.comparing(TreeNode::getId));
            packageNode.setChildren(resourceSetNodes);
            treeNodes.add(packageNode);
        }
        return treeNodes;
    }

    private List<TreeNode> setResources(Set<TreeNode> treeNodes, String resourceSetPath) {
        if (CollectionUtils.isEmpty(treeNodes)) {
            return Collections.EMPTY_LIST;
        }
        List<TreeNode> list = treeNodes.stream().map(e -> {
            this.setResourcePath(resourceSetPath, e.getId());
            return e;
        }).sorted(Comparator.comparing(TreeNode::getId)).collect(Collectors.toList());
        return list;
    }

    private String setResourcePath(String path, String id) {
        return Joiner.on((String)"||").skipNulls().join((Object)path, (Object)id, new Object[0]);
    }

    public Optional<ServicePackage> findByServicePackageCode(String servicePackageCode) {
        List servicePackageList = this.servicePackageDao.findByServicePackageCode(servicePackageCode);
        if (CollectionUtils.isEmpty((Collection)servicePackageList)) {
            return Optional.empty();
        }
        if (servicePackageList.size() > 1) {
            throw new IllegalArgumentException("\u3010" + servicePackageCode + "\u3011\u4ea7\u54c1\u670d\u52a1\u5305\u6570\u636e\u5b58\u5728\u4e0d\u552f\u4e00\u8bb0\u5f55");
        }
        return Optional.of(servicePackageList.get(0));
    }

    public Map<Long, List<ServicePackage>> listByTenantId(Long tenantId) {
        if (tenantId == null && tenantId <= 0L) {
            throw new IllegalArgumentException("\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a\u6216\u4e0d\u5927\u4e8e0");
        }
        List rels = this.companyServiceRelDao.findRelsByTenantId(tenantId.longValue());
        HashMap<Long, List<ServicePackage>> companyPackagesMap = new HashMap<Long, List<ServicePackage>>();
        for (CompanyServiceRel rel : rels) {
            List companyPackages = companyPackagesMap.getOrDefault(rel.getCompanyId(), new ArrayList());
            companyPackages.add(rel.getServicePackage());
            companyPackagesMap.put(rel.getCompanyId(), companyPackages);
        }
        return companyPackagesMap;
    }

    public Map<Long, Boolean> validResourcesetsBound(long packageId, Set<Long> resourcesetIdSet) {
        List existRresourcesetIds = this.serviceResourcesetRelDao.findResourcesetIdByServicePackageId(packageId);
        Set deletingResourcesetIds = resourcesetIdSet.stream().filter(id -> existRresourcesetIds.stream().noneMatch(existId -> id.equals(existId))).collect(Collectors.toSet());
        List pairs = this.roleResourcesetRelDao.countResourcesetsWereBoundByRole(packageId, deletingResourcesetIds);
        Map<Long, Boolean> validation = pairs.stream().collect(Collectors.toMap(pair -> ((BigInteger)pair.get("resourcesetId")).longValue(), pair -> ((BigInteger)pair.get("cnt")).longValue() > 0L));
        return validation;
    }
}

