/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.settle.service;

import com.xforceplus.api.model.OrgModel;
import com.xforceplus.api.model.SettleFlowModel;
import com.xforceplus.api.model.SettleFlowPackageModel;
import com.xforceplus.business.company.service.CompanyService;
import com.xforceplus.business.settle.service.SettleTemplateService;
import com.xforceplus.business.tenant.service.OrgService;
import com.xforceplus.dao.ServiceResourcesetRelDao;
import com.xforceplus.dao.SettleFlowDao;
import com.xforceplus.dao.SettleFlowPackageDao;
import com.xforceplus.dao.SettleFlowTemplateRelDao;
import com.xforceplus.dao.SettleServiceDao;
import com.xforceplus.dao.SettleStepDao;
import com.xforceplus.dao.SettleTemplateAttributeDao;
import com.xforceplus.dao.SettleTemplateDao;
import com.xforceplus.dao.SettleTemplateServiceRelDao;
import com.xforceplus.entity.Company;
import com.xforceplus.entity.OrgStruct;
import com.xforceplus.entity.ServiceResourcesetRel;
import com.xforceplus.entity.SettleFlow;
import com.xforceplus.entity.SettleFlowPackage;
import com.xforceplus.entity.SettleStep;
import com.xforceplus.entity.SettleTemplate;
import com.xforceplus.query.SettleFlowPackageQueryHelper;
import com.xforceplus.query.SettleFlowQueryHelper;
import com.xforceplus.tenant.security.core.domain.OrgType;
import io.geewit.data.jpa.essential.domain.EntityGraphs;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SettleFlowService {
    private static final Logger logger = LoggerFactory.getLogger(SettleFlowService.class);
    private final SettleFlowDao flowDao;
    private final SettleTemplateService templateService;
    private final SettleFlowPackageDao settleFlowPackageDao;
    private final OrgService orgService;
    private final CompanyService companyService;
    private final ServiceResourcesetRelDao serviceResourcesetRelDao;
    private final SettleStepDao settleStepDao;
    @Resource
    private SettleTemplateDao templateDao;
    @Resource
    private SettleFlowTemplateRelDao flowTemplateRelDao;
    @Resource
    private SettleServiceDao serviceDao;
    @Resource
    private SettleTemplateServiceRelDao templateServiceRelDao;
    @Resource
    private SettleTemplateAttributeDao templateAttributeDao;

    public SettleFlowService(SettleFlowDao flowDao, SettleTemplateService templateService, OrgService orgService, CompanyService companyService, ServiceResourcesetRelDao serviceResourcesetRelDao, SettleStepDao settleStepDao, SettleFlowPackageDao settleFlowPackageDao) {
        this.flowDao = flowDao;
        this.templateService = templateService;
        this.orgService = orgService;
        this.companyService = companyService;
        this.serviceResourcesetRelDao = serviceResourcesetRelDao;
        this.settleFlowPackageDao = settleFlowPackageDao;
        this.settleStepDao = settleStepDao;
    }

    public Page<SettleFlow> page(SettleFlowModel.Request.Query query, Pageable pageable) {
        Specification specification = SettleFlowQueryHelper.querySpecification((SettleFlowModel.Request.Query)query);
        Page page = this.flowDao.findAll(specification, pageable, EntityGraphs.named((String)"SettleFlowPackage.graph"));
        return page;
    }

    public SettleFlow findByTenantId(Long tenantId) {
        return (SettleFlow)this.flowDao.findByTenantId(tenantId.longValue()).orElseThrow(() -> new IllegalArgumentException("\u672a\u627e\u5230\u5165\u9a7b\u9875\u9762\u6d41"));
    }

    public SettleFlow findById(String flowId) {
        SettleFlow flow;
        try {
            long id = Long.parseLong(flowId);
            flow = this.findByFlowId(id);
        }
        catch (NumberFormatException e) {
            String message = e.getMessage() + ", value: " + flowId;
            logger.warn(message);
            flow = this.findByFlowCode(flowId);
        }
        List packageIds = this.flowDao.findPackageIdsByFlowId(flow.getFlowId().longValue());
        flow.setPackageIds(packageIds);
        return flow;
    }

    public SettleFlow findByFlowId(long flowId) {
        SettleFlow flow = (SettleFlow)this.flowDao.findById((Object)flowId).orElseThrow(() -> new IllegalArgumentException("\u672a\u627e\u5230\u5165\u9a7b\u9875\u9762\u6d41"));
        List<SettleTemplate> templates = this.templateService.findByFlowId(flow.getFlowId());
        flow.setTemplates(templates);
        return flow;
    }

    public SettleFlow findByFlowCode(String flowCode) {
        SettleFlow flow = (SettleFlow)this.flowDao.findByFlowCode(flowCode).orElseThrow(() -> new IllegalArgumentException("\u672a\u627e\u5230\u5165\u9a7b\u9875\u9762\u6d41"));
        List<SettleTemplate> templates = this.templateService.findByFlowId(flow.getFlowId());
        flow.setTemplates(templates);
        return flow;
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(String flowId) {
        SettleFlow flow = this.findById(flowId);
        if (flow == null) {
            return;
        }
        List templateIds = this.templateDao.findTemplateIdByFlowId(flow.getFlowId().longValue());
        for (Long templateId : templateIds) {
            this.templateDao.deleteById(templateId);
            this.templateAttributeDao.deleteByTemplateId(templateId.longValue());
            List serviceIds = this.templateServiceRelDao.findServiceIdByTemplateId(templateId.longValue());
            this.templateServiceRelDao.deleteByTemplateId(templateId.longValue());
            for (Long serviceId : serviceIds) {
                this.serviceDao.deleteById(serviceId);
            }
        }
        this.flowTemplateRelDao.deleteByFlowId(flow.getFlowId().longValue());
        this.flowDao.deleteById(flow.getFlowId());
    }

    public SettleStep getStep(String taxNum, String flowId) {
        SettleFlow flow;
        try {
            long id = Long.parseLong(flowId);
            flow = this.findByFlowId(id);
        }
        catch (NumberFormatException e) {
            String message = e.getMessage() + ", value: " + flowId;
            logger.warn(message);
            flow = this.findByFlowCode(flowId);
        }
        if (null == flow) {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u5165\u9a7b\u9875\u9762\u6d41");
        }
        List settleSteps = this.settleStepDao.findByTaxNumAndFlowId(taxNum, flow.getFlowId().longValue());
        if (CollectionUtils.isEmpty((Collection)settleSteps) || settleSteps.size() > 1) {
            throw new IllegalArgumentException("\u5f53\u524d\u6d41\u7a0b\u7a0e\u53f7\u4e3a\u7a7a\u6216\u8005\u6682\u65f6\u4e0d\u652f\u6301\u91cd\u590d\u7684\u7a0e\u53f7");
        }
        return (SettleStep)settleSteps.get(0);
    }

    private Long findServicePackage(Long flowId) {
        List flowServicePackages = this.settleFlowPackageDao.findByFlowId(flowId.longValue());
        if (CollectionUtils.isEmpty((Collection)flowServicePackages)) {
            throw new IllegalArgumentException("\u6d41\u7a0b\u672a\u67e5\u8be2\u5230\u516c\u53f8\u670d\u52a1\u5305");
        }
        return ((SettleFlowPackage)flowServicePackages.get(0)).getPackageId();
    }

    private OrgStruct findOrgs(String taxNum) {
        List<Company> company = this.companyService.findByTaxNum(taxNum);
        if (CollectionUtils.isEmpty(company)) {
            throw new IllegalArgumentException("\u7a0e\u53f7\u672a\u67e5\u8be2\u5230\u516c\u53f8");
        }
        Long companyId = company.get(0).getCompanyId();
        OrgModel.Request.Query query = new OrgModel.Request.Query();
        query.setCompanyId(companyId);
        query.setStatus(Integer.valueOf(1));
        query.setOrgType(String.valueOf(OrgType.COMPANY.value()));
        List<OrgStruct> orgs = this.orgService.list(query, Sort.unsorted());
        if (CollectionUtils.isEmpty(orgs)) {
            throw new IllegalArgumentException("\u7a0e\u53f7\u672a\u67e5\u8be2\u5230\u7ec4\u7ec7");
        }
        return orgs.get(0);
    }

    public Page<SettleFlowPackage> packages(SettleFlowPackageModel.Request.Query query, Pageable pageable) {
        Specification specification = SettleFlowPackageQueryHelper.querySpecification((SettleFlowPackageModel.Request.Query)query);
        return this.settleFlowPackageDao.findAll(specification, pageable);
    }

    public List<SettleFlowPackage> packageList(SettleFlowPackageModel.Request.Query query, Sort sort) {
        Specification specification = SettleFlowPackageQueryHelper.querySpecification((SettleFlowPackageModel.Request.Query)query);
        return this.settleFlowPackageDao.findAll(specification, sort);
    }

    public Page<SettleStep> taxNum(String flowId, Long tenantId, Pageable pageable) {
        SettleFlow flow;
        try {
            long id = Long.parseLong(flowId);
            flow = this.findByFlowId(id);
        }
        catch (NumberFormatException e) {
            String message = e.getMessage() + ", value: " + flowId;
            logger.warn(message);
            flow = this.findByFlowCode(flowId);
        }
        if (null == flow) {
            throw new IllegalArgumentException("\u5165\u4f4f\u6d41\u7a0b\u4e0d\u5b58\u5728 ");
        }
        Specification & Serializable query = (Specification & Serializable)(root, criteriaQuery, builder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            predicates.add(builder.equal((Expression)root.get("tenantId"), (Object)tenantId));
            criteriaQuery.where((Predicate[])predicates.stream().toArray(Predicate[]::new));
            return criteriaQuery.getRestriction();
        };
        return this.settleStepDao.findAll((Specification)query, pageable);
    }

    public List<Long> findResourceByPackage(List<SettleFlowPackage> content) {
        Set servicePackageIds = content.stream().map(SettleFlowPackage::getPackageId).collect(Collectors.toSet());
        Specification & Serializable query = (Specification & Serializable)(root, criteriaQuery, builder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (servicePackageIds.size() == 1) {
                predicates.add(builder.equal((Expression)root.get("servicePackageId"), servicePackageIds.stream().findFirst().get()));
            } else {
                predicates.add(root.get("servicePackageId").in((Collection)servicePackageIds));
            }
            criteriaQuery.where((Predicate[])predicates.stream().toArray(Predicate[]::new));
            return criteriaQuery.getRestriction();
        };
        List serviceResourceset = this.serviceResourcesetRelDao.findAll((Specification)query);
        if (CollectionUtils.isEmpty((Collection)serviceResourceset)) {
            return new ArrayList<Long>();
        }
        return serviceResourceset.stream().map(ServiceResourcesetRel::getResourcesetId).collect(Collectors.toList());
    }
}

