/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.business.tenant.controller;

import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.current.user.GradingRoleApi;
import com.xforceplus.api.model.RoleModel;
import com.xforceplus.api.model.UserModel;
import com.xforceplus.business.common.controller.AbstractController;
import com.xforceplus.business.tenant.service.GradingRoleService;
import com.xforceplus.domain.tenant.GradingRoleDTO;
import com.xforceplus.domain.tenant.GradingRoleOrg;
import com.xforceplus.entity.Resourceset;
import com.xforceplus.entity.Role;
import com.xforceplus.entity.User;
import com.xforceplus.exception.AccessDeniedException;
import com.xforceplus.tenant.security.autoscan.annotation.AuthorizedDefinition;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.tenant.security.core.domain.view.RoleView;
import com.xforceplus.tenant.security.core.domain.view.UserView;
import io.geewit.data.jpa.essential.domain.PageableFactory;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Controller;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;

@Api(value="\u5206\u7ea7\u89d2\u8272\u7ba1\u7406", tags={"\u5206\u7ea7\u89d2\u8272\u7ba1\u7406"})
@Controller
@Validated
public class GradingRoleController
extends AbstractController
implements GradingRoleApi {
    @Autowired
    private GradingRoleService gradingRoleService;

    @AuthorizedDefinition(resources={"xforce:ucenter:roleclass:read"})
    @ApiOperation(value="\u5f53\u524d\u7528\u6237\u7684\u5206\u7ea7\u7ba1\u7406\u89d2\u8272\u5206\u9875", tags={"role"})
    public ResponseEntity<Page<GradingRoleDTO>> currentPage(RoleModel.Request.Query query, Pageable pageable) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        if (!authorizedUser.isAdmin() && !authorizedUser.isGradingManager()) {
            throw new AccessDeniedException("\u64cd\u4f5c\u53d7\u9650\uff0c\u8bf7\u786e\u4fdd\u6709\u6743\u9650\u64cd\u4f5c\uff01");
        }
        if (!authorizedUser.isAdmin() && authorizedUser.isGradingManager()) {
            query.setUserId(authorizedUser.getId());
        }
        Pageable currentPageable = PageableFactory.ofDefaultSort((Pageable)pageable, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}));
        query.setTenantId(authorizedUser.getTenantId());
        Page<GradingRoleDTO> page = this.gradingRoleService.page(query, currentPageable);
        return ResponseEntity.ok(page);
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:roleclass:save"})
    @ApiOperation(value="\u65b0\u589e\u5206\u7ea7\u7ba1\u7406\u89d2\u8272", tags={"role"})
    public ResponseEntity<Role> currentCreate(@ApiParam(value="model", required=true) RoleModel.Request.GradingRoleCreate model) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        if (!authorizedUser.isAdmin()) {
            throw new AccessDeniedException("\u64cd\u4f5c\u53d7\u9650\uff0c\u8bf7\u786e\u4fdd\u6709\u6743\u9650\u64cd\u4f5c\uff01");
        }
        model.setType(Integer.valueOf(1));
        model.setTenantId(authorizedUser.getTenantId());
        Role result = this.gradingRoleService.create(model);
        return ResponseEntity.ok((Object)result);
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:roleclass:read"})
    @ApiOperation(value="\u5206\u7ea7\u7ba1\u7406\u89d2\u8272\u8be6\u60c5", tags={"role"})
    @JsonView(value={RoleView.RoleInfo.class})
    public ResponseEntity<GradingRoleDTO> currentInfo(Long roleId) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        if (!authorizedUser.isAdmin() && !authorizedUser.isGradingManager()) {
            throw new AccessDeniedException("\u64cd\u4f5c\u53d7\u9650\uff0c\u8bf7\u786e\u4fdd\u6709\u6743\u9650\u64cd\u4f5c\uff01");
        }
        GradingRoleDTO result = this.gradingRoleService.findByRoleId(roleId);
        return ResponseEntity.ok((Object)result);
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:roleclass:save"})
    @ApiOperation(value="\u5206\u7ea7\u7ba1\u7406\u89d2\u8272\u7f16\u8f91", tags={"role"})
    @JsonView(value={RoleView.RoleInfo.class})
    public ResponseEntity<GradingRoleDTO> currentUpdate(Long roleId, RoleModel.Request.Update model) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        if (!authorizedUser.isAdmin()) {
            throw new AccessDeniedException("\u64cd\u4f5c\u53d7\u9650\uff0c\u8bf7\u786e\u4fdd\u6709\u6743\u9650\u64cd\u4f5c\uff01");
        }
        long tenantId = authorizedUser.getTenantId();
        GradingRoleDTO result = this.gradingRoleService.updateByTenantId(tenantId, roleId, model);
        return ResponseEntity.ok((Object)result);
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:roleclass:save"})
    @ApiOperation(value="\u542f\u7528\u5206\u7ea7\u89d2\u8272", tags={"role"})
    public ResponseEntity<String> currentEnable(@PathVariable(value="roleId") Long roleId) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        if (!authorizedUser.isAdmin()) {
            throw new AccessDeniedException("\u64cd\u4f5c\u53d7\u9650\uff0c\u8bf7\u786e\u4fdd\u6709\u6743\u9650\u64cd\u4f5c\uff01");
        }
        this.roleService.findByRoleId(authorizedUser.getTenantId(), roleId);
        this.gradingRoleService.enable(roleId);
        return ResponseEntity.ok((Object)"\u542f\u7528\u6210\u529f");
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:roleclass:save"})
    @ApiOperation(value="\u7981\u7528\u5206\u7ea7\u89d2\u8272", tags={"role"})
    public ResponseEntity<String> currentDisable(@PathVariable(value="roleId") Long roleId) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        if (!authorizedUser.isAdmin()) {
            throw new AccessDeniedException("\u64cd\u4f5c\u53d7\u9650\uff0c\u8bf7\u786e\u4fdd\u6709\u6743\u9650\u64cd\u4f5c\uff01");
        }
        this.gradingRoleService.disable(authorizedUser.getTenantId(), roleId);
        return ResponseEntity.ok((Object)"\u7981\u7528\u6210\u529f");
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:roleclass:save"})
    @ApiOperation(value="\u5206\u7ea7\u7ba1\u7406\u89d2\u8272\u5220\u9664", tags={"role"})
    public ResponseEntity<String> currentDelete(Long roleId) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        if (!authorizedUser.isAdmin()) {
            throw new AccessDeniedException("\u64cd\u4f5c\u53d7\u9650\uff0c\u8bf7\u786e\u4fdd\u6709\u6743\u9650\u64cd\u4f5c\uff01");
        }
        long tenantId = authorizedUser.getTenantId();
        this.gradingRoleService.deleteByTenantIdAndId(tenantId, roleId);
        return ResponseEntity.ok((Object)"\u5220\u9664\u6210\u529f");
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:roleclass:read"})
    @ApiOperation(value="\u5206\u7ea7\u7ba1\u7406\u89d2\u8272\u5df2\u7ed1\u5b9a\u7684\u7528\u6237\u5206\u9875\u5217\u8868", tags={"role"})
    @JsonView(value={UserView.UserInfo.class})
    public ResponseEntity<Page<User>> currentBindedUsers(Long roleId, UserModel.Request.Query query, Pageable pageable) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        if (!authorizedUser.isAdmin()) {
            throw new AccessDeniedException("\u64cd\u4f5c\u53d7\u9650\uff0c\u8bf7\u786e\u4fdd\u6709\u6743\u9650\u64cd\u4f5c\uff01");
        }
        long tenantId = authorizedUser.getTenantId();
        query.setTenantId(Long.valueOf(tenantId));
        query.setRoleId(roleId);
        Pageable currentPageable = PageableFactory.ofDefaultSort((Pageable)pageable, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}));
        Page<User> result = this.userService.page(query, currentPageable);
        return ResponseEntity.ok(result);
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:roleclass:save"})
    @ApiOperation(value="\u5206\u7ea7\u7ba1\u7406\u89d2\u8272\u7ed1\u5b9a\u7528\u6237", tags={"role"})
    public ResponseEntity<String> currentBindRoles(Long roleId, RoleModel.Request.BindUsers bindUsers) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        if (!authorizedUser.isAdmin()) {
            throw new AccessDeniedException("\u64cd\u4f5c\u53d7\u9650\uff0c\u8bf7\u786e\u4fdd\u6709\u6743\u9650\u64cd\u4f5c\uff01");
        }
        long tenantId = authorizedUser.getTenantId();
        this.gradingRoleService.bindUsers(tenantId, roleId, bindUsers);
        return ResponseEntity.ok((Object)"\u7ed1\u5b9a\u6210\u529f");
    }

    @AuthorizedDefinition(resources={"xforce:ucenter:roleclass:save"})
    @ApiOperation(value="\u5206\u7ea7\u7ba1\u7406\u89d2\u8272\u89e3\u7ed1\u7528\u6237", tags={"role"})
    public ResponseEntity<String> currentUnbindRoles(Long roleId, RoleModel.Request.UnbindUsers unbindUsers) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        if (!authorizedUser.isAdmin()) {
            throw new AccessDeniedException("\u64cd\u4f5c\u53d7\u9650\uff0c\u8bf7\u786e\u4fdd\u6709\u6743\u9650\u64cd\u4f5c\uff01");
        }
        long tenantId = authorizedUser.getTenantId();
        this.roleService.unbindUsers(tenantId, roleId, unbindUsers);
        return ResponseEntity.ok((Object)"\u53cd\u7ed1\u5b9a\u6210\u529f");
    }

    @ApiOperation(value="\u83b7\u53d6\u5206\u7ea7\u7ba1\u7406\u89d2\u8272\u7684\u7ec4\u7ec7\u8303\u56f4", tags={"role"})
    @AuthorizedDefinition(resources={"xforce:ucenter:roleclass:read"})
    public ResponseEntity<List<GradingRoleOrg>> currentBindedOrgs(Long roleId) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        if (!authorizedUser.isAdmin() && !authorizedUser.isGradingManager()) {
            throw new AccessDeniedException("\u64cd\u4f5c\u53d7\u9650\uff0c\u8bf7\u786e\u4fdd\u6709\u6743\u9650\u64cd\u4f5c\uff01");
        }
        return ResponseEntity.ok(this.gradingRoleService.findBindedOrgsByRoleId(roleId));
    }

    @ApiOperation(value="\u66f4\u65b0\u5206\u7ea7\u7ba1\u7406\u89d2\u8272\u7684\u7ec4\u7ec7\u8303\u56f4", tags={"role"})
    @AuthorizedDefinition(resources={"xforce:ucenter:roleclass:save"})
    public ResponseEntity<String> currentBindOrgs(Long roleId, RoleModel.Request.BindOrgs bindOrgs) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        if (!authorizedUser.isAdmin()) {
            throw new AccessDeniedException("\u64cd\u4f5c\u53d7\u9650\uff0c\u8bf7\u786e\u4fdd\u6709\u6743\u9650\u64cd\u4f5c\uff01");
        }
        this.gradingRoleService.saveGradingRoleOrgs(roleId, bindOrgs);
        return ResponseEntity.ok((Object)"\u64cd\u4f5c\u6210\u529f");
    }

    @ApiOperation(value="\u83b7\u53d6\u5206\u7ea7\u7ba1\u7406\u89d2\u8272\u7684\u529f\u80fd\u96c6\u5217\u8868", tags={"role"})
    @AuthorizedDefinition(resources={"xforce:ucenter:roleclass:read"})
    public ResponseEntity<List<Resourceset>> currentBindedResourcesets(Long roleId) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        if (!authorizedUser.isAdmin() && !authorizedUser.isGradingManager()) {
            throw new AccessDeniedException("\u64cd\u4f5c\u53d7\u9650\uff0c\u8bf7\u786e\u4fdd\u6709\u6743\u9650\u64cd\u4f5c\uff01");
        }
        return ResponseEntity.ok(this.gradingRoleService.findBindedResourcesetsByRoleId(roleId));
    }

    @ApiOperation(value="\u66f4\u65b0\u5206\u7ea7\u7ba1\u7406\u89d2\u8272\u7684\u529f\u80fd\u96c6", tags={"role"})
    @AuthorizedDefinition(resources={"xforce:ucenter:roleclass:save"})
    public ResponseEntity<String> currentBindResourcesets(Long roleId, RoleModel.Request.BindResourceSets bindResourceSets) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        if (!authorizedUser.isAdmin()) {
            throw new AccessDeniedException("\u64cd\u4f5c\u53d7\u9650\uff0c\u8bf7\u786e\u4fdd\u6709\u6743\u9650\u64cd\u4f5c\uff01");
        }
        this.gradingRoleService.saveGradingRoleResourcesets(roleId, bindResourceSets);
        return ResponseEntity.ok((Object)"\u64cd\u4f5c\u6210\u529f");
    }
}

